c
c
      subroutine m_contin (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     titlea,
     +                     newdat)
c
c action: analysis of a contingency table
c author: w.g.bardsley, university of manchester, u.k.
c         10/02/2006 derived from m_mvnor1
c         14/06/2014 increased npmin from 21 to 100
c
c Note: all arguments are input/unchanged except for newdat
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  titlea*(*)
      logical    newdat
c
c local allocatable arrays
c
      integer, allocatable :: nobs(:,:)
      double precision, allocatable :: p(:), pred(:,:), x(:)
c
c locals
c
      integer    ierr, nin, npmax, npmin
      parameter (nin = 3, npmin = 100)
      character  line*100
      character  fname*1
      logical    supply
      parameter (supply = .true.)
      external   contin, putfat
      intrinsic  max
c
c check
c
      if (ncol.lt.2 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate workspaces (ncmax > ncol, nrmax > nrow)
c
      ierr = 0
      if (allocated(nobs)) deallocate(nobs, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(p)) deallocate(p, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(pred)) deallocate(pred, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      npmax = max(ncmax, npmin, nrmax)
      allocate(nobs(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(p(npmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(pred(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(x(npmax), stat = ierr)
      if (ierr.ne.0) return
c
c call contin for calculations
c
      call contin (ncmax, ncol, nin, nobs, nout, npmax, nrmax, nrow,
     +             a, p, pred, x,
     +             fname, titlea,
     +             newdat, supply)
c
c deallocate workspaces
c
      deallocate(nobs, stat = ierr)
      deallocate(p, stat = ierr)
      deallocate(pred, stat = ierr)
      deallocate(x, stat = ierr)
c
c format statements
c
  100 format ('Must have no. rows >= 2 and no. columns >= 2')
      end
c
c
