c
c
      subroutine m_coxreg (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     fnamea, titlea,
     +                     newdat)
c
c action: Cox regression
c author: w.g.bardsley, university of manchester, u.k.
c         14/02/2006 derived from m_contin ***Note: a(nrmax,ncmax + 7)
c         05/07/2010 made sure nwmax >= 4*nrmax + 4
c
c Note: all arguments are input/unchanged except for newdat
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax + 7)
      character  fnamea*(*), titlea*(*)
      logical    newdat
c
c local allocatable arrays
c
      integer, allocatable :: ic(:), isi(:), iwk(:)
      double precision, allocatable :: b(:), cov(:), omega(:), res(:),
     +                                 sc(:), se(:), t(:), tp(:),
     +                                 wk(:), z(:,:)
c
c locals
c
      integer    ierr, nin, nwmax
      parameter (nin = 3)
      character  line*100
      logical    supply
      parameter (supply = .true.)
      external   coxreg, putfat
      intrinsic  max
c
c check
c
      if (ncol.lt.4 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate workspaces (ncmax > ncol, nrmax > nrow)
c
      ierr = 0
      if (allocated(ic)) deallocate(ic, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(isi)) deallocate(isi, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(iwk)) deallocate(iwk, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(cov)) deallocate(cov, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(omega)) deallocate(omega, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(res)) deallocate(res, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(sc)) deallocate(sc, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(se)) deallocate(se, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(t)) deallocate(t, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(tp)) deallocate(tp, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(wk)) deallocate(wk, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(z)) deallocate(z, stat = ierr)
      if (ierr.ne.0) return
      nwmax = max(ncmax*(ncmax + 9)/2 + nrmax, 4*nrmax + 4)
      allocate(ic(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(isi(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(iwk(2*nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(b(ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(cov(ncmax*(ncmax + 1)/2), stat = ierr)
      if (ierr.ne.0) return
      allocate(omega(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(res(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(sc(ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(se(ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(t(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(tp(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(wk(nwmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(z(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
c
c call coxreg for calculations
c
      call coxreg (ic, isi, iwk, ncmax, ncol, nin, nout, nrmax, nrow,
     +             nwmax,
     +             b, cov, omega, res, sc, se, a, t, tp, wk, z,
     +             fnamea, titlea,
     +             newdat, supply)
c
c deallocate workspaces
c
      deallocate(ic, stat = ierr)
      deallocate(isi, stat = ierr)
      deallocate(iwk, stat = ierr)
      deallocate(b, stat = ierr)
      deallocate(cov, stat = ierr)
      deallocate(omega, stat = ierr)
      deallocate(res, stat = ierr)
      deallocate(sc, stat = ierr)
      deallocate(se, stat = ierr)
      deallocate(t, stat = ierr)
      deallocate(tp, stat = ierr)
      deallocate(wk, stat = ierr)
      deallocate(z, stat = ierr)
c
c format statements
c
  100 format ('Must have no. rows >= 2 and no. columns >= 4')
      end
c
c
