c
c
      subroutine m_cross1 (ncmax, ncol, nout, nrmax, nrow, 
     +                     a,
     +                     fname, title,
     +                     newdat)
c
c action: front end to call cross1 from m_matone
c author: w.g.bardsley, university of manchester, u.k., 15/06/2009
c
c         Note: a n by 2 matrix a is supplied from file = fname with
c               a title, then vectors x and y are created and passed
c               to cross1 for analysis
c         
      implicit none
c
c arguments
c      
      integer,             intent (in)  :: ncmax, ncol, nout, nrmax, 
     +                                     nrow
      double precision,    intent (in)  :: a(nrmax,ncmax)
      character (len = *), intent (in)  :: fname, title
      logical,             intent (out) :: newdat
c
c allocatable
c       
      double precision, allocatable :: x(:), y(:)
c
c locals
c    
      integer    i, ierr, n
      integer    numdec, numhlp, numopt, numsta, numtxt
      parameter (numopt = 5, numhlp = 21, numsta = 11,
     +           numtxt = numsta + numopt - 1) 
      integer    numbld(numhlp)
      character  chop80*80, temp1*80, temp2*80, text(numhlp)*100,
     +           trim80*80, word8*8
      logical    done, repeet
      external   cross1, lstbox, trim80, chop80, triml1, patch2, revpro
      data       numbld / numhlp*0 /
c
c check
c      
      newdat = .false.
      if (ncol.ne.2 .or. nrow.le.4) return
c
c allocate and create vectors x and y
c        
      ierr = 0
      if (allocated(x)) deallocate(x, stat = ierr)  
      if (ierr.ne.0) return  
      if (allocated(y)) deallocate(y, stat = ierr)  
      if (ierr.ne.0) return  

      n = nrow
      allocate(x(n), stat = ierr)
      if (ierr.ne.0) return  
      allocate(y(n), stat = ierr)
      if (ierr.ne.0) return
            
      do i = 1, n
         x(i) = a(i,1)
         y(i) = a(i,2)
      enddo   

      temp1 = trim80(fname)
      temp2 = chop80(title)
      write (word8,'(i8)') n
      call triml1 (word8)
c
c main loop
c      
      numdec = 1
      done = .false.
      repeet = .true.
      do while (repeet)
         write (text,100) temp1, temp2, word8
         if (.not.done) then
            done = .true.
            write (nout,'(a)') ' '
            do i = 1, 9
               write (nout,'(a)') text(i)
            enddo
         endif      
         numbld(1) = 4
         numbld(4) = 1
         numbld(7) = 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         numbld(4) = 0
         numbld(7) = 0        
         if (numdec.eq.1) then
c
c call cross1
c           
            call cross1 (n, nout,
     +                   x, y)
         elseif (numdec.eq.2) then
c
c results
c         
            call revpro (nout)
         elseif (numdec.eq.3) then
c
c help
c         
            write (text,200)
            numbld(1) = 1
            call patch2 (numbld, numhlp,
     +                   text)
            numbld(1) = 0             
         elseif (numdec.eq.4) then
c
c new data
c         
            newdat = .true.
            repeet = .false.
         else
c
c cancel
c           
            newdat = .false.
            repeet = .false.
         endif         
         numdec = 3
      enddo
c
c deallocate
c      
      deallocate(x, stat = ierr)
      deallocate(y, stat = ierr)
c
c format statements
c      
  100 format (
     + 'Auto-correlation and Cross-correlation'
     +/
     +/'Current file:'
     +/a
     +/
     +/'Current title:'
     +/a
     +/
     +/'Current sample size =',1x,a
     +/
     +/'Analyse for selected lags'
     +/'Results'
     +/'Help'
     +/'Data: New/Edit/Transform/View'          
     +/'Quit ... Exit these correlation options')
  200 format (
     + 'Auto-correlation and Cross-correlation matrices'     
     +/
     +/'First of all note that definitions differ between authors and'
     +/'this procedure follows the protocol of NAG routine G13DMF.'
     +/
     +/'We suppose a n by 2 matrix containing a X-series in column 1'
     +/'and a Y-series in column 2.'
     +/
     +/'First a standard analysis with lag m = 0 is conducted to obtain'
     +/'X-mean, Y_mean, X_var, and Y_var.'
     +/
     +/'Then (for lags m = 1, 2, ..., k) a set of 2 by 2 matrices are'
     +/'calculated with`c(1,1) = auto-correlation for X'
     +/'               `c(1,2) = cross-correlation X with Y-lagged'   
     +/'               `c(2,1) = cross-correlation Y with X-lagged' 
     +/'               `c(2,2) = auto-correlation for Y'
     +/'using sqrt(X_var*Y_var) as divisor (see the reference manual).'
     +/
     +/'Then, using 1/sqrt(n) as an approximation for the std. dev.,'
     +/'approximate p-values are listed and the maximum off-diagonal'
     +/'|c(i,j)| as a function of lags m is calculated.')    
      end
c
c
