c
c
      subroutine m_dmat00 (nout, nz,
     +                     z,
     +                     title,
     +                     newdat)
c
c action: front end to dmat00
c author: w.g.bardsley, university of manchester, u.k., 06/02/2006
c         12/07/2006 increased workspace for scaling options
c         09/02/2016 made l1, liwk, lwk kind = 7      
c
c   nout: (input/unchanged) preconnected unit for results
c     nz: (input/unchanged) sample size
c      z: (input/unchanged) sample
c  title: (input/unchanged) data title
c newdat: (output) .true. if new data requested
c
      implicit  none
c
c arguments
c
      integer    nout, nz
      double precision z(nz)
      character  title*(*)
      logical    newdat
c
c local allocatable workspace
c
      integer, allocatable :: iwk(:)
c
c locals
c
      integer (kind = 7) l1, liwk, lwk
      integer    ierr, ncmax, n, ndmax, nrmax, nrow
      integer    ndim, nin
      parameter (ndim = 10, nin = 3)
      double precision root
      double precision one, two, eight
      parameter (one = 1.0d+00, two = 2.0d+00, eight = 8.0d+00)
      character  fname*1
      logical    supply
      parameter (supply = .true.)
      external   dmat00
      intrinsic  nint, sqrt, dble, max
c
c check nz then calculate n
c
      if (nz.lt.2) return
      root = (one + sqrt(one + eight*dble(nz)))/two
      n = nint(root)
c
c define parameters for dmat00
c
      ndmax = nz
      nrow = n
      nrmax = nrow
      ncmax = ndim
      
c      liwk = max(5*n, n*(n - 1)/2 + n*ndim + 5)
c      lwk = max(n + n*(n + 17)/2 - 1, 2*n*(n - 1), 15*n*ndim)

      l1 = n
      liwk = max(5*l1, l1*(l1 - 1)/2 + l1*ndim + 5)
      lwk = max(l1 + l1*(l1 + 17)/2 - 1, 2*l1*(l1 - 1), 15*l1*ndim)
      fname = ' '
c
c allocate workspace
c
      ierr = 0
      if (allocated(iwk)) deallocate(iwk, stat = ierr)
      if (ierr.ne.0) return
      allocate (iwk(liwk), stat = ierr)
      if (ierr.ne.0) return
c
c call to dmat00
c
      call dmat00 (iwk, liwk, lwk, ncmax, ndmax, nin, nout, nrmax,
     +             nrow,
     +             z,
     +             fname, title,
     +             newdat, supply)
c
c deallocate workspace
c
      deallocate(iwk, stat = ierr)
      end
c
c
