c
c
      subroutine m_exactp (nout, nx,
     +                     x,
     +                     title)
c
c action: Poisson tests
c author: w.g.bardsley, university of manchester, u.k.
c         30/01/2006 derived from EXACTP
c   nout: (input/unchanged) preconnected unit for results
c     nx: (input/unchanged) sample size
c      x: (input/unchanged) sample
c  title: (input/unchanged) data title
c
      implicit   none
c
c arguments
c          
      integer    nout, nx  
      double precision x(nx)
      character  title*(*)
c
c local allocatable workspaces
c      
      integer, allocatable :: iw1(:), iw2(:)
      double precision, allocatable :: w(:)
c
c Locals
c      
      integer    i, ierr, liw, lw, nmax, ntotal
      integer    isend, nin
      parameter (isend = 1, nin = 3)
      double precision xsum
      double precision zero
      parameter (zero = 0.0d+00)
      character  line*100
      character  fname*1
      parameter (fname = ' ')
      external   exactp, putfat
      intrinsic  nint, max
c
c check sample size
c      
      if (nx.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif   
c
c check sample and calculate the sum
c      
      xsum = zero
      do i = 1, nx 
         if (x(i).lt.zero) then
            write (line,200) i
            call putfat (line)
            return
         endif
         xsum = xsum + x(i)   
      enddo  
      ntotal = nint(xsum) + 1
      ierr = 0
      if (allocated(iw1)) deallocate(iw1, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(iw2)) deallocate(iw2, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w)) deallocate(w, stat = ierr)
      if (ierr.ne.0) return
      lw = max(nx,ntotal) + 1  
      liw = lw
      nmax = nx
c
c allocate workspaces
c      
      allocate(iw1(liw), stat = ierr)  
      if (ierr.ne.0) return
      allocate(iw2(liw), stat = ierr)  
      if (ierr.ne.0) return
      allocate(w(lw), stat = ierr)  
      if (ierr.ne.0) return        
c
c call exactp for calculations
c        
      call exactp (isend, iw1, iw2, liw, lw, nx, nin, nout, nmax,
     +             x, w,
     +             fname, title)
c
c dealocate workspaces
c         
      deallocate(iw1, stat = ierr)
      deallocate(iw2, stat = ierr)
      deallocate(w, stat = ierr)
c
c format statements
c      
  100 format ('Sample size too small')
  200 format ('Sample value',i6,1x,' < 0')
      end
c
c    