c
c
      subroutine m_fitone (isend, ncol, nin, nrow,
     +                     fnamea, titlea)
c
c action: locate a curve fitting file
c author: w.g.bardsley, university of manchester, u.k.
c         05/10/2007 derived from m_matone
c         05/02/2008 added showit to the call to fitone
c         13/04/2015 added calcurve and corrected for isend =< 35 instead of 16
c
c   isend: (input/unchanged) as follows:
c           isend = 1: gcfit ... growth curves
c           isend = 2: gcfit ... survival curves
c           isend = 3: mmfit ... standard mode
c           isend = 4: mmfit ... hot/cold mode
c           isend = 5: hlfit ... standard mode
c           isend = 6: hlfit ... hot/cold mode
c           isend = 7: exfit ... standard
c           isend = 8: exfit ... concave down
c           isend = 9: exfit ... up/down  
c           isend = 10: exfit ... down/up
c           isend = 11: sffit
c           isend = 12: rffit
c           isend = 13: spline data
c           isend = 14: average
c           isend = 15: compare.tf1
c           isend = 16: compare.tf2
c           isend = 17: major axis/orthogonal line (simple)
c           isend = 18: least squares line (comprehensive)
c           isend = 19: reduced major axis line (comprehensive)
c           isend = 20: major axis/orthogonal line (comprehensive)
c           isend = 21: fit a line/calibrate (simple)
c           isend = 22: fit a line/calibrate (advanced)
c           isend = 23: fit a polynomial/calibrate (x,y)
c           isend = 24: fit a polynomial/calibrate (g(x),f(y))
c           isend = 25: multilinear regression
c           isend = 26: robust regression
c           isend = 27: L_1 norm regression 
c           isend = 28: L_infinity norm regression 
c           isend = 29: regression on ranks  
c           isend = 30: orthogonal rotation
c           isend = 31: Kendall concordance
c           isend = 32: trinomial plot
c           isend = 33: survival analysis 
c           isend = 34: average  
c           isend = 35: calcurve 
c
c    ncol: (input/output) column size   
c     nin: (input/unchanged) unconnected unit for data input
c    nout: (input/unchanged) preconnected unit for results
c    nrow: (input/output) row size
c  fnamea: (input/output) data file name
c  titlea: (input/output) data title
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: isend, nin 
      integer,             intent (inout) :: ncol, nrow
      character (len = *), intent (inout) :: fnamea, titlea
c
c locals
c
      integer    ncol1, nrow1
      integer    nitems
      parameter (nitems = 35)
      integer    ncsav(nitems), nrsav(nitems)
      character  no_data*30, no_file*30, sim256*1024
      parameter (no_data = 'No data',
     +           no_file = 'No file')
      character  header(nitems)*80, tfiles(nitems)*15
      logical    abort
      logical    showit(nitems), show_now 
      external   isitmf, fitone, sim256
      save       ncsav, nrsav, header, tfiles, showit
      data       showit / nitems*.true. /
      data       ncsav /  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     +                    3,  3,  3,  2,  3,  3,  3,  3,  3,  3, 
     +                    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
     +                    3,  3,  3,  2,  2  / 
      data       nrsav / 33,  6, 30, 36, 30, 36, 30, 20, 12, 12,
     +                   30, 20, 40, 15, 40, 40, 40, 40, 40, 40,  
     +                   40, 40, 18, 18, 13,  8, 13, 13, 20, 10,
     +                    3,  4, 20, 15, 40  /          
      data       header /
     +'Fitting growth curve models',                 !1
     +'Fitting survival curve models',               !2
     +'Fitting Michaelis-Menten (standard mode)',    !3
     +'Fitting Michaelis-Menten (isotope mode)',     !4
     +'Fitting H/L affinity sites (standard mode)',  !5
     +'Fitting H/L affinity sites (isotope mode)',   !6 
     +'Fiting exponentials (monotonic decline)',     !7
     +'Fitting exponentials (monotonic increase)',   !8 
     +'Fitting exponentials (up-down profile)',      !9
     +'Fitting exponentials (down-up profile)',      !10
     +'Fitting cooperative saturation functions',    !11
     +'Fitting positive rational functions',         !12
     +'Fitting spline functions',                    !13
     +'Trapezoidal area and time above thresholds',  !14
     +'Compare: Spline smoothing file (reference)',  !15
     +'Compare: Spline smoothing file (comparison)', !16
     +'Major axis/orthogonal line (simple)',         !17
     +'Least squares line (advanced)',               !18
     +'Reduced major axis line (advanced)',          !19 
     +'Major axis/orthogonal line (advanced)',       !20 
     +'Fit a line/calibrate (simple)',               !21
     +'Fit a line/calibrate (advanced)',             !22
     +'Fit a polynomial/calibrate (x,y)',            !23
     +'Fit a polynomial/calibrate (g(x),f(y))',      !24
     +'Multilinear regression',                      !25
     +'Robust regression (M-estimates)',             !26
     +'L_1 norm regression',                         !27
     +'L_infinity norm regression',                  !28
     +'Regression on ranks',                         !29
     +'Orthogonal rotation',                         !30
     +'Kendall concordance',                         !31      
     +'Trinomial confidence regions',                !32
     +'Analyse one sample of survival times',        !33
     +'Trapezoidal area and time above thresholds',  !34
     +'Cubic spline calibration analysis' /          !35
       data      tfiles /
     +'gcfit.tf2',     !1  
     +'weibull.tf1',   !2
     +'mmfit.tf4',     !3
     +'hotcold.tf1',   !4
     +'hlfit.tf4',     !5
     +'hotcold.tf1',   !6
     +'exfit.tf4',     !7
     +'exfit.tf7',     !8
     +'exfit.tf5',     !9 
     +'exfit.tf6',     !10
     +'sffit.tf4',     !11
     +'rffit.tf6',     !12
     +'compare.tf1',   !13
     +'average.tf1',   !14
     +'compare.tf1',   !15
     +'compare.tf2',   !16
     +'line.tf1',      !17
     +'line.tf1',      !18
     +'line.tf1',      !19
     +'line.tf1',      !20 
     +'line.tf1',      !21
     +'line.tf1',      !22
     +'polnom.tf1',    !23
     +'polnom.tf1',    !24
     +'linfit.tf2',    !25
     +'g02haf.tf1',    !26
     +'linfit.tf2',    !27
     +'linfit.tf2',    !28
     +'g08raf.tf1',    !29
     +'g03baf.tf1',    !30    
     +'g08daf.tf1',    !31   
     +'trinom.tf1',    !32
     +'survive.tf2',   !33 
     +'average.tf1',   !34
     +'calcurve.tf2' / !35
c
c check isend 
c 
      if (isend.lt.1 .or. isend.gt.35) return
c
c Install defaults if ncol or nrow =< 0
c  
      if (ncol.le.0 .or. nrow.le.0) then         
         fnamea = sim256 (tfiles(isend))
         ncol = ncsav(isend)
         nrow = nrsav(isend)
      endif   
c
c check if dimensions correspond
c
         ncol1 = 0
         nrow1 = 0
         if (ncol.gt.0 .and. nrow.gt.0) call isitmf (ncol1, nrow1,
     +                                               fnamea)
c
c initialise if dimensions do not correspond
c
         if (ncol1.le.0 .or. nrow1.le.0 .or.
     +       ncol1.ne.ncol .or. nrow1.ne.nrow) then
            ncol = 0
            nrow = 0
            fnamea = no_file
            titlea = no_data
         else
            open (unit = nin, file = fnamea)
            read (nin,'(a)') titlea
            close (unit = nin)   
         endif
c
c choose a file
c
         show_now = showit(isend)
         call fitone (ncol, nin, nrow,
     +                fnamea, header(isend), tfiles(isend), titlea,
     +                abort, show_now)
         showit(isend) = show_now
         if (abort) then
            fnamea = no_file
            titlea = no_data
            ncol = 0
            nrow = 0
         endif   
      end
c
c        
      
                            