C
C
       SUBROUTINE M_GLMINI (MTYPE, NIN, NOUT)
C
C ACTION: Front end to initialise simfit GLM
C AUTHOR: W.G.Bardsley, University of manchester, U.K.
C         12/04/2006 derived from GLMINI
C         21/05/2006 deleted Y from call to GLMDAT 
C         23/11/2006 introduced SIMDIR, INTENTS, and new test file names
C         25/01/2007 allowed for L = 0 from SIMDIR
C         25/07/2007 replaced SIMDIR by DEMDIR
C         13/10/2007 replaced DEMDIR by SIM256
C         09/05/2013 replaced GLMCOX by M_COXREG until GLMCOX is updated
C         24/12/2014 corrected code to alter defaults as GLMDAT changes NCOLS and 
C                    re-defined all survival tests files to cox.tf1      
C
C  MTYPE: (input/unchanged) controls interface in GLMSIM as follows:
C          MTYPE = 1: all options
C          MTYPE = 2; just the survival options
C          MTYPE = 3: just the logistic regression options
C    NIN: (input/unchanged) unconnectedd unit for data input
C   NOUT: (input/unchanged) preconnected unit for results
C
      IMPLICIT   NONE
C
C Arguments
C
       INTEGER, INTENT (IN) :: MTYPE, NIN, NOUT
C
C Local allocatable arrays
C
      INTEGER, ALLOCATABLE :: ISX(:), IWK(:)
      DOUBLE PRECISION, ALLOCATABLE :: A1(:,:), A2(:,:), B(:), COV(:),
     +                                 SE(:), T(:), V(:,:), WK(:),
     +                                 WT(:), Y(:)
C
C Locals
C
      INTEGER    NCMAX, NRMAX
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NSTART = 15)
      INTEGER    NCADD, NRADD
      PARAMETER (NCADD = 3, NRADD = 2)
      INTEGER    NUMBLD(30), NUMPOS(10)
      INTEGER    I, IPRINT, ISEND, LTYPE, MAXIT, NCOLS, NF, NROWS, NTYPE
      INTEGER    ICOUNT, IERR, JSEND, KSEND, NCTEMP, NRTEMP 
      INTEGER    I1, I2, I3, I4, LIWK, LWK, M, N
      INTEGER    NCT(12), NRT(12)
      INTEGER    NCSAV(12), NRSAV(12)
      DOUBLE PRECISION AFIX, EPS, SFIX, TOL
      DOUBLE PRECISION ZERO, ONE, EPS1, TOL1
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, EPS1 = 1.0D-06,
     +           TOL1 = 5.0D-05)
      CHARACTER (LEN = 10) D10(2), FORMGR
      CHARACTER (LEN = 12) I12, FORM12   
      CHARACTER  HEADER(12)*40, TFILE(12)*20
      CHARACTER  FSAV(12)*1024, TSAV(12)*80
      CHARACTER  FNAME1*1024, FNAME2*1024, TITLE1*80, TITLE2*80
      CHARACTER  CHOP60*60, LINE*100, TEXT(30)*100, TRIM60*60
      CHARACTER  CIFER1*40, CIFER2*40, ERROR*40, LINK*40, WORD4(2)*4
      CHARACTER  SIM256*1024
      CHARACTER (LEN = 80) TRIM80, WORD80_1, WORD80_2 
      CHARACTER  BLANK*1, NONE*4
      PARAMETER (BLANK = ' ', NONE = 'None')
      LOGICAL    NEWDAT
      LOGICAL    ISTOP, OFFVEC, SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      LOGICAL    AGAIN, FIRST, READY, REPEET
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   FORM12, FORMGR
      EXTERNAL   GLMDAT, GLMCON, GLMFIT, GLMADV, PUTFAT, LBOX01, REVPRO,
     +           TRIM60, CHOP60, GLMSIM, GLMWEI, GLMSTR, MAT5IN,
     +           MAT2IN, PUTWAR, SIM256, TRIM80, ISITMF
      EXTERNAL   M_COXREG
      INTRINSIC  ABS, MAX
      SAVE       FIRST
      SAVE       NCSAV, NRSAV
      SAVE       FSAV, TSAV
      SAVE       ICOUNT, LTYPE, MAXIT, NTYPE
      SAVE       AFIX, EPS, SFIX, TOL
      DATA       FIRST / .TRUE. /
      DATA       ICOUNT, IPRINT, LTYPE, MAXIT, NTYPE / 0, 0, 2, 20, 1 /
      DATA       AFIX, EPS, SFIX, TOL / ONE, EPS1, ZERO, TOL1 /
      DATA       NUMBLD / 1*1, 29*0 /
      DATA       NUMPOS / 10*1 /
      DATA       NCT / 3, 4, 10,  3, 4,  5,  4,  6,  6,  6,  6, 5 /
      DATA       NRT / 5, 3, 15, 10, 5, 39, 10, 33, 33, 33, 33, 7 /
      DATA       HEADER / 'GLM...normal error (G02GAF)',
     +                    'GLM...binomial error (G02GBF)',
     +                    'GLM...Poisson error (G02GCF)',
     +                    'GLM...Gamma error (G02GDF)',
     +                    'Logistic regression',
     +                    'Binary logistic regression',
     +                    'Polynomial logistic regression',
     +                    'Exponential survival',
     +                    'Weibull survival',
     +                    'Extreme value survival',
     +                    'Cox regression',
     +                    'Stratified logistic regression' /
      DATA       TFILE  / 'g02gaf.tf1',
     +                    'g02gbf.tf1',
     +                    'g02gcf.tf1',
     +                    'g02gdf.tf1',
     +                    'logistic.tf3',
     +                    'logistic.tf1',
     +                    'ld50.tf2',
     +                    'cox.tf1',
     +                    'cox.tf1',
     +                    'cox.tf1',
     +                    'cox.tf1',
     +                    'g11caf.tf1' /
C
C Initialise the files
C
      IF (FIRST) THEN
         FIRST = .FALSE.   
         DO I = 1, 12  
            FSAV(I) = SIM256(TFILE(I))
            TSAV(I) = HEADER(I)
            NCSAV(I) = NCT(I)
            NRSAV(I) = NRT(I)
         ENDDO
      ENDIF

C
C Deallocate the workspaces
C
      IERR = 0
      IF (ALLOCATED(ISX)) DEALLOCATE(ISX, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(IWK)) DEALLOCATE(IWK, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(A2)) DEALLOCATE(A2, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(COV)) DEALLOCATE(COV, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(SE)) DEALLOCATE(SE, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(T)) DEALLOCATE(T, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(WK)) DEALLOCATE(WK, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(WT)) DEALLOCATE(WT, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Start of the outer loop
C
      NF = NOUT
      REPEET = .TRUE.
      DO WHILE (REPEET)
C
C----------------------------------------------------------------------
C
      READY = .FALSE.
      FNAME1 = NONE
      FNAME2 = NONE
      TITLE1 = NONE
      TITLE2 = NONE
C
C Call GLMSIM to set the pattern as follows:
C
C     JSEND = 0: done
C     JSEND = 1: advanced GLM
C     JSEND = 2: simple logistic GLM
C     JSEND = 3: simple binary logistic GLM
C     JSEND = 4: simple polynomial GLM
C     JSEND = 5: simple exponential survival GLM
C     JSEND = 6: Weibull survival GLM
C     JSEND = 7: extreme value survival GLM
C     JSEND = 8: Cox regression
C     JSEND = 9: Conditional stratified logistic
C
      CLOSE (UNIT = NIN)
      CALL GLMSIM (JSEND, MTYPE, NIN, NF)
      CLOSE (UNIT = NIN)
      IF (JSEND.LE.0) RETURN
C
C--------------------------------------------------------------------
C
      AGAIN = .TRUE.
      IF (JSEND.EQ.1) THEN
C
C**********************************************************************
C Advanced GLM procedure ..............................................
C**********************************************************************
C
         ISEND = 1
         CALL GLMCON (IPRINT, ISEND, JSEND, LTYPE, MAXIT, NTYPE,
     +                AFIX, EPS, SFIX, TOL)
         WORD4(1) = BLANK
         WORD4(2) = BLANK
         DO WHILE (AGAIN)
           IF (NTYPE.EQ.2) THEN
               CIFER1 = BLANK
            ELSE
               WRITE (CIFER1,100) AFIX
            ENDIF
            CIFER2 = BLANK
            IF (NTYPE.EQ.1) THEN
               ERROR = 'Normal'
               IF (ABS(SFIX).LE.EPS1) THEN
                  CIFER2  = 'Sigma^2 estimated'
               ELSE
                  WRITE (CIFER2,200) SFIX
               ENDIF
            ELSEIF (NTYPE.EQ.2) THEN
               ERROR = 'Binomial'
            ELSEIF (NTYPE.EQ.3) THEN
               ERROR = 'Poisson'
            ELSEIF (NTYPE.EQ.4) THEN
               ERROR = 'Gamma'
               IF (ABS(SFIX).LE.EPS1) THEN
                  CIFER2  = 'Scale factor estimated'
               ELSE
                  WRITE (CIFER2,300) SFIX
               ENDIF
            ENDIF
            IF (NTYPE.EQ.2) THEN
               IF (LTYPE.EQ.1) THEN
                  LINK = 'Logistic'
               ELSEIF (LTYPE.EQ.2) THEN
                  LINK = 'Probit'
               ELSEIF (LTYPE.EQ.3) THEN
                  LINK = 'Complementary log-log'
               ENDIF
            ELSE
               IF (LTYPE.EQ.1) THEN
                  LINK = 'Exponent'
               ELSEIF (LTYPE.EQ.2) THEN
                  LINK = 'Identity'
               ELSEIF (LTYPE.EQ.3) THEN
                  LINK = 'Log'
               ELSEIF (LTYPE.EQ.4) THEN
                  LINK = 'Square root'
               ELSEIF (LTYPE.EQ.5) THEN
                  LINK = 'Reciprocal'
               ENDIF
            ENDIF
            I12 = FORM12(MAXIT)
            D10(1) = FORMGR(EPS)
            D10(2) = FORMGR(TOL)
            WRITE (TEXT,400) TRIM60(FNAME1), CHOP60(TITLE1),
     +                       TRIM60(FNAME2), CHOP60(TITLE2),
     +                       ERROR, LINK, I12, D10(1), D10(2),
     +                       CIFER1, CIFER2, WORD4(1), WORD4(2)
            NUMOPT = 10
            NTEXT = NSTART + NUMOPT - 1
            IF (READY) THEN
               NUMDEC = NUMOPT - 6
            ELSE   
               NUMDEC = NUMOPT - 5
            ENDIF   
            NUMBLD(7) = 1
            NUMBLD(8) = 1
            CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                   NUMOPT, NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            NUMBLD(7) = 0
            NUMBLD(8) = 0
            IF (NUMDEC.EQ.1) THEN
C
C Advanced...NUMDEC = 1: Deallocate the workspaces then get data
C
               IF (ALLOCATED(ISX)) DEALLOCATE(ISX, STAT = IERR)
               IF (ALLOCATED(IWK)) DEALLOCATE(IWK, STAT = IERR)
               IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
               IF (ALLOCATED(A2)) DEALLOCATE(A2, STAT = IERR)
               IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
               IF (ALLOCATED(COV)) DEALLOCATE(COV, STAT = IERR)
               IF (ALLOCATED(SE)) DEALLOCATE(SE, STAT = IERR)
               IF (ALLOCATED(T)) DEALLOCATE(T, STAT = IERR)
               IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
               IF (ALLOCATED(WK)) DEALLOCATE(WK, STAT = IERR)
               IF (ALLOCATED(WT)) DEALLOCATE(WT, STAT = IERR)
               IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
               CLOSE (UNIT = NIN)
               KSEND = NTYPE
               NCOLS = NCSAV(KSEND)
               NROWS = NRSAV(KSEND)
               FNAME1 = FSAV(KSEND)
               TITLE1 = TSAV(KSEND)
               CALL MAT5IN (NCOLS, NIN, NROWS,
     +                      FNAME1, HEADER(KSEND), TFILE(KSEND), TITLE1,
     +                      ISTOP)
               IF (.NOT.ISTOP) THEN
C
C NCMAX must include an extra column for fitting the mean
C
                  NCMAX = NCOLS + NCADD
C
C NRMAX may need extra rows for LAPACK
C
                  NRMAX = NROWS + NRADD
                  ALLOCATE (A1(NRMAX,NCMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE(T(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE(V(NRMAX,NCMAX + 8), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE(Y(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  CALL MAT2IN (NIN, NCMAX, NCOLS, NRMAX, NROWS,
     +                         A1,
     +                         FNAME1, TITLE1,
     +                         ISTOP)
                  IF (.NOT.ISTOP) THEN
                     CALL GLMDAT (JSEND, NCMAX, NCOLS, NIN, NRMAX,
     +                            NROWS,
     +                            A1, V, T, 
     +                            FNAME1, FNAME2, TITLE1, TITLE2,
     +                            ISTOP, OFFVEC, SUPPLY)
                  ENDIF
               ENDIF
               CLOSE (UNIT = NIN)
               IF (ISTOP) THEN
                  FNAME1 = NONE
                  FNAME2 = NONE
                  TITLE1 = NONE
                  TITLE2 = NONE
                  READY = .FALSE.
               ELSE
                  ALLOCATE (ISX(NCMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  DO I = 1, NCMAX
                     ISX(I) = 1
                  ENDDO
                  ALLOCATE (A2(NRMAX,NCMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE (B(NCMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE (COV(NCMAX*(NCMAX + 1)/2), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE (SE(NCMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  LWK = MAX(3*NRMAX,(NCMAX*NCMAX + 3*NCMAX + 22)/2)
                  ALLOCATE (WK(LWK), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE (WT(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  DO I = 1, NRMAX
                     WT(I) = ONE
                  ENDDO
C--------------------------------------------------------------------
C Note: GLMDAT changes NCOLS so correct before changing the defaults 
C                  
                  CALL ISITMF (NCTEMP, NRTEMP,
     +                         FNAME1)
                  IF (NCTEMP.GT.0 .AND. NRTEMP.GT.0) THEN                   
                     FSAV(KSEND) = FNAME1
                     TSAV(KSEND) = TITLE1
                     NCSAV(KSEND) = NCTEMP
                     NRSAV(KSEND) = NRTEMP
                  ENDIF
C--------------------------------------------------------------------                        
                  READY = .TRUE.
                  ICOUNT = ICOUNT + 1
                  WORD80_1 = TRIM80(FNAME1)
                  WORD80_2 = TRIM80(FNAME2)
                  WRITE (NF,500) ICOUNT, WORD80_1, TITLE1, WORD80_2,
     +                           TITLE2
               ENDIF
            ELSEIF (NUMDEC.EQ.2) THEN
C
C Advanced...NUMDEC = 2: choose errors and links
C            
               ISEND = 1
               CALL GLMCON (IPRINT, ISEND, JSEND, LTYPE, MAXIT, NTYPE,
     +                      AFIX, EPS, SFIX, TOL)
            ELSEIF (NUMDEC.EQ.3) THEN
C
C Advanced...NUMDEC = 3: control parameters
C            
               ISEND = 2
               CALL GLMCON (IPRINT, ISEND, JSEND, LTYPE, MAXIT, NTYPE,
     +                      AFIX, EPS, SFIX, TOL)
            ELSEIF (NUMDEC.EQ.4) THEN
C
C Advanced...NUMDEC = 4: fit
C            
               IF (.NOT.READY) THEN
                  CALL PUTFAT ('First input your data file')
               ELSE
                  IF (NTYPE.NE.KSEND) THEN
                     LINE =
     +              'Data were selected for'//BLANK//HEADER(KSEND)
                     CALL PUTWAR (LINE)
                  ENDIF
                  WRITE (NF,600) ERROR, LINK
                  CALL GLMFIT (IPRINT, ISX, JSEND, LTYPE, MAXIT, NCMAX,
     +                         NCOLS, NF, NRMAX, NROWS, NTYPE,
     +                         AFIX, A1, A2, B, COV, EPS, SE, SFIX, T,
     +                         TOL, V, WK, WT, Y,
     +                         FNAME1, TITLE1,
     +                         OFFVEC)
               ENDIF
            ELSEIF (NUMDEC.GE.5 .AND. NUMDEC.LE.8) THEN
C
C Advanced...NUMDEC= 5, 6, 7, 8: help
C            
               I = NUMDEC - 4
               CALL GLMADV (I)
            ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Advanced...NUMDEC = NUMOPT - 1: results
C            
               CALL REVPRO (NF)
            ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Advanced...NUMDEC = NUMOPT: cancel
C            
               AGAIN = .FALSE.
            ENDIF
         ENDDO
      ELSE
C
C*********************************************************************
C Simple GLM procedures ..............................................
C*********************************************************************
C
         KSEND = JSEND + 3
         IF (JSEND.EQ.2) THEN
            FNAME2 = 'None'
            TITLE2 = 'Logistic regression'
         ELSEIF (JSEND.EQ.3) THEN
            FNAME2 = 'None'
            TITLE2 = 'Binary logistic regression'
         ELSEIF (JSEND.EQ.4) THEN
            FNAME2 = 'None'
            TITLE2 = 'Polynomial logistic regression'
         ELSEIF (JSEND.EQ.5) THEN
            FNAME2 = 'log(t)'
            TITLE2 = 'Exponential survival'
         ELSEIF (JSEND.EQ.6) THEN
            FNAME2 = 'alpha*log(t)'
            TITLE2 = 'Weibull survival'
         ELSEIF (JSEND.EQ.7) THEN
            FNAME2 = 'alpha*t'
            TITLE2 = 'Extreme value survival'
         ELSEIF (JSEND.EQ.8) THEN
            FNAME2 = 'None'
            TITLE2 = 'Cox regression'
         ELSEIF (JSEND.EQ.9) THEN
            FNAME2 = 'None'
            TITLE2 = 'Binary logistic regression'
         ENDIF
         IF (JSEND.GE.2 .AND. JSEND.LE.4) THEN
            WORD4(1) = '(NA)'
            WORD4(2) = BLANK
            LTYPE = 1
            NTYPE = 2
         ELSEIF (JSEND.GE.5 .AND. JSEND.LT.8) THEN
            WORD4(1) = '(NA)'
            WORD4(2) = BLANK
            LTYPE = 3
            NTYPE = 3
         ELSEIF (JSEND.EQ.8) THEN
            WORD4(1) = '(NA)'
            WORD4(2) = BLANK
            LTYPE = 1
            NTYPE = 2
         ELSEIF (JSEND.EQ.9) THEN
            WORD4(1) = '(NA)'
            WORD4(2) = BLANK
            LTYPE = 1
            NTYPE = 2
         ENDIF
         DO WHILE (AGAIN)
           IF (NTYPE.EQ.2) THEN
               CIFER1 = BLANK
            ELSE
               WRITE (CIFER1,100) AFIX
            ENDIF
            CIFER2 = BLANK
            IF (NTYPE.EQ.1) THEN
               ERROR = 'Normal'
               IF (ABS(SFIX).LE.EPS1) THEN
                  CIFER2  = 'Sigma^2 estimated'
               ELSE
                  WRITE (CIFER2,200) SFIX
               ENDIF
            ELSEIF (NTYPE.EQ.2) THEN
               ERROR = 'Binomial'
            ELSEIF (NTYPE.EQ.3) THEN
               ERROR = 'Poisson'
            ELSEIF (NTYPE.EQ.4) THEN
               ERROR = 'Gamma'
               IF (ABS(SFIX).LE.EPS1) THEN
                  CIFER2  = 'Scale factor estimated'
               ELSE
                  WRITE (CIFER2,300) SFIX
               ENDIF
            ENDIF
            IF (NTYPE.EQ.2) THEN
               IF (LTYPE.EQ.1) THEN
                  LINK = 'Logistic'
               ELSEIF (LTYPE.EQ.2) THEN
                  LINK = 'Probit'
               ELSEIF (LTYPE.EQ.3) THEN
                  LINK = 'Complementary log-log'
               ENDIF
            ELSE
               IF (LTYPE.EQ.1) THEN
                  LINK = 'Exponent'
               ELSEIF (LTYPE.EQ.2) THEN
                  LINK = 'Identity'
               ELSEIF (LTYPE.EQ.3) THEN
                  LINK = 'Log'
               ELSEIF (LTYPE.EQ.4) THEN
                  LINK = 'Square root'
               ELSEIF (LTYPE.EQ.5) THEN
                  LINK = 'Reciprocal'
               ENDIF
            ENDIF
            I12 = FORM12(MAXIT)
            D10(1) = FORMGR(EPS)
            D10(2) = FORMGR(TOL)
            WRITE (TEXT,400) TRIM60(FNAME1), CHOP60(TITLE1),
     +                       TRIM60(FNAME2), CHOP60(TITLE2),
     +                       ERROR, LINK, I12, D10(1), D10(2),
     +                       CIFER1, CIFER2, WORD4(1), WORD4(2)
            NUMOPT = 10
            NTEXT = NSTART + NUMOPT - 1
            IF (READY) THEN
               NUMDEC = NUMOPT - 6
            ELSE
               NUMDEC = NUMOPT - 4
            ENDIF   
            NUMBLD(7) = 1
            NUMBLD(8) = 1
            CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                   NUMOPT, NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            NUMBLD(7) = 0
            NUMBLD(8) = 0
            IF (NUMDEC.EQ.1) THEN
C
C Simple...NUMDEC = 1: Deallocate the workspaces then get data
C
               IF (ALLOCATED(ISX)) DEALLOCATE(ISX, STAT = IERR)
               IF (ALLOCATED(IWK)) DEALLOCATE(IWK, STAT = IERR)
               IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
               IF (ALLOCATED(A2)) DEALLOCATE(A2, STAT = IERR)
               IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
               IF (ALLOCATED(COV)) DEALLOCATE(COV, STAT = IERR)
               IF (ALLOCATED(SE)) DEALLOCATE(SE, STAT = IERR)
               IF (ALLOCATED(T)) DEALLOCATE(T, STAT = IERR)
               IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
               IF (ALLOCATED(WK)) DEALLOCATE(WK, STAT = IERR)
               IF (ALLOCATED(WT)) DEALLOCATE(WT, STAT = IERR)
               IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
               CLOSE (UNIT = NIN)
               NCOLS = NCSAV(KSEND)
               NROWS = NRSAV(KSEND)
               FNAME1 = FSAV(KSEND)
               TITLE1 = TSAV(KSEND)
               CALL MAT5IN (NCOLS, NIN, NROWS,
     +                      FNAME1, HEADER(KSEND), TFILE(KSEND), TITLE1,
     +                      ISTOP)
               IF (.NOT.ISTOP) THEN
C
C NCMAX must include an extra column for the mean
C

                  NCMAX = NCOLS + NCADD
                  IF (JSEND.EQ.4) NCMAX = NCMAX + 5
C
C NRMAX may need extra rows for LAPACK
C
                  NRMAX = NROWS + NRADD
                  ALLOCATE (A1(NRMAX,NCMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE(T(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE(V(NRMAX,NCMAX + 8), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE(Y(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  CALL MAT2IN (NIN, NCMAX, NCOLS, NRMAX, NROWS,
     +                         A1,
     +                         FNAME1, TITLE1,
     +                         ISTOP)
                  IF (.NOT.ISTOP) THEN
                     CALL GLMDAT (JSEND, NCMAX, NCOLS, NIN, NRMAX,
     +                            NROWS,
     +                            A1, V, T, 
     +                            FNAME1, FNAME2, TITLE1, TITLE2,
     +                            ISTOP, OFFVEC, SUPPLY)
                  ENDIF
               ENDIF
C
C JSEND = 5: Offsets are returned in V(.,7) for exponential survival
C JSEND = 6: Log survival times are returned in T(.) for Weibull survival
C JSEND = 7: Survival times are returned in T(.) for extreme value survival
C
               CLOSE (UNIT = NIN)
               IF (ISTOP) THEN
                  FNAME1 = NONE
                  TITLE1 = NONE
                  READY = .FALSE.
               ELSE
                  ALLOCATE (ISX(NCMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  DO I = 1, NCMAX
                     ISX(I) = 1
                  ENDDO
                  LIWK = 7*NRMAX
                  ALLOCATE (IWK(LIWK), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE (A2(NRMAX,NCMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE (B(NCMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE (COV(NCMAX*(NCMAX + 1)/2), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE (SE(NCMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  LWK = MAX(3*NRMAX,(NCMAX*NCMAX + 9*NCMAX + 22)/2)
                  ALLOCATE (WK(LWK), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE (WT(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  DO I = 1, NRMAX
                     WT(I) = ONE
                  ENDDO
C--------------------------------------------------------------------
C Note: GLMDAT changes NCOLS so correct before changing the defaults 
C                  
                  CALL ISITMF (NCTEMP, NRTEMP,
     +                         FNAME1)
                  IF (NCTEMP.GT.0 .AND. NRTEMP.GT.0) THEN                   
                     FSAV(KSEND) = FNAME1
                     TSAV(KSEND) = TITLE1
                     NCSAV(KSEND) = NCTEMP
                     NRSAV(KSEND) = NRTEMP
                  ENDIF
C--------------------------------------------------------------------                     
                  IF (JSEND.EQ.4) THEN
C
C Suppress x^2, x^3, ..., x^6 for polynomial regression
C
                     ISX(1) = 1
                     DO I = 2, 6
                        ISX(I) = 0
                     ENDDO
                  ENDIF
                  READY = .TRUE.
                  ICOUNT = ICOUNT + 1
                  WORD80_1 = TRIM80(FNAME1)
                  WORD80_2 = TRIM80(FNAME2)
                  WRITE (NF,500) ICOUNT, WORD80_1, TITLE1, WORD80_2,
     +                           TITLE2
               ENDIF
            ELSEIF (NUMDEC.EQ.2) THEN
C
C Simple...NUMDEC = 2: not allowed
C            
               CALL PUTFAT ('Not allowed from simple interface')
            ELSEIF (NUMDEC.EQ.3) THEN
C
C Simple...NUMDEC = 3: configure
C            
               ISEND = 2
               CALL GLMCON (IPRINT, ISEND, JSEND, LTYPE, MAXIT,
     +                      NTYPE,
     +                      AFIX, EPS, SFIX, TOL)
            ELSEIF (NUMDEC.EQ.4) THEN
C
C Simple...NUMDEC = 4: fit
C            
               IF (.NOT.READY) THEN
                  CALL PUTFAT ('First input your data file')
               ELSE
                  IF (JSEND.GE.2 .AND. JSEND.LE.5) THEN
                     WRITE (NF,600) ERROR, LINK
                     CALL GLMFIT (IPRINT, ISX, JSEND, LTYPE, MAXIT,
     +                            NCMAX, NCOLS, NF, NRMAX, NROWS, NTYPE,
     +                            AFIX, A1, A2, B, COV, EPS, SE, SFIX,
     +                            T, TOL, V, WK, WT, Y,
     +                            FNAME1, TITLE1,
     +                            OFFVEC)
                  ELSEIF (JSEND.EQ.6 .OR. JSEND.EQ.7) THEN
                     IF (JSEND.EQ.6) THEN
                        WRITE (NF,700)
                     ELSE
                        WRITE (NF,800)
                     ENDIF
                     CALL GLMWEI (IPRINT, ISX, JSEND, MAXIT,
     +                            NCMAX, NCOLS, NF, NRMAX, NROWS,
     +                            AFIX, A1, A2, B, COV, EPS, SE,
     +                            T, TOL, V, WK, WT, Y,
     +                            FNAME1, TITLE1)
                  ELSEIF (JSEND.EQ.8) THEN
                     CALL M_COXREG (NCMAX, NCOLS, NF, NRMAX, NROWS,
     +                              V,
     +                              FNAME1, TITLE1,
     +                              NEWDAT)                   
C                     I1 = 1
C                     I2 = I1 + NRMAX
C                     I3 = I2 + MXN
C                     I4 = I3 + NRMAX
C                     I5 = I4 + NRMAX
C                     I6 = I5 + MXN
C                     I7 = I6 + MXN
C                     CALL GLMCOX (IWK(I1), IWK(I2), IPRINT, IWK(I3),
C     +                            IWK(I4), ISX, IWK(I5), LWK, MAXIT,
C     +                            MXN, IWK(I6), NCMAX, IWK(I7), NF, NIN,
C     +                            NRMAX, MXN,
C     +                            A1, A2, B, COV, SE, T, TOL, V, WK, WT,
C     +                            FNAME1, TITLE1)
                  ELSEIF (JSEND.EQ.9) THEN
                     M = NCOLS - 3
                     N = NROWS
                     I1 = 1
                     I2 = I1 + NRMAX
                     I3 = I2 + NRMAX
                     I4 = I3 + NRMAX
                     CALL GLMSTR (IWK(I1), IPRINT, IWK(I2),
     +                            ISX, LWK, M, MAXIT, IWK(I3), N,
     +                            IWK(I4), NF, NRMAX, NRMAX,
     +                            A1, B, COV, SE, TOL, WK, WT,
     +                            FNAME1, TITLE1)
                  ENDIF
               ENDIF
            ELSEIF (NUMDEC.GE.5 .AND. NUMDEC.LE.8) THEN
C
C Simple...NUMDEC = 5, 6, 7 or 8: help
C            
               I = NUMDEC - 4
               CALL GLMADV (I)
            ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Simple...NUMDEC = NUMOPT - 1: results
C            
               CALL REVPRO (NF)
            ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Simple...NUMDEC = NUMOPT: cancel
C            
               AGAIN = .FALSE.
            ENDIF
         ENDDO
      ENDIF
C
C----------------------------------------------------------------------
C
      ENDDO
      CLOSE (UNIT = NIN)
C
C End of the outer loop so deallocate
C
      DEALLOCATE(ISX, STAT = IERR)
      DEALLOCATE(IWK, STAT = IERR)
      DEALLOCATE(A1, STAT = IERR)
      DEALLOCATE(A2, STAT = IERR)
      DEALLOCATE(B, STAT = IERR)
      DEALLOCATE(COV, STAT = IERR)
      DEALLOCATE(SE, STAT = IERR)
      DEALLOCATE(T, STAT = IERR)
      DEALLOCATE(V, STAT = IERR)
      DEALLOCATE(WK, STAT = IERR)
      DEALLOCATE(WT, STAT = IERR)
      DEALLOCATE(Y, STAT = IERR)
C
C Format statements
C      
  100 FORMAT ('Exponent A =',1P,E9.2)
  200 FORMAT ('Sigma^2 =',1P,E9.2)
  300 FORMAT ('Scale factor =',1P,E9.2)
  400 FORMAT (
     + 'Generalized Linear Models'
     +/
     +/'File:',1X,A
     +/'Title:',1X,A
     +/'Offset:',1X,A
     +/'Detail:',1X,A
     +/'Error type assumed:',1X,A
     +/'Link type selected:',1X,A
     +/'MAXIT (iterations) =',1X,A
     +/'EPSI (SVD) =',1X,A
     +/'TOL (Convergence) =',1X,A
     +/A
     +/A
     +/
     +/'New data or the test file provided'
     +/'Select error and link types',1X,A
     +/'Configure control parameters',1X,A
     +/'Proceed to GLM fitting'
     +/'Help: GLM summary'
     +/'Help: simplified interface'
     +/'Help: data formats'
     +/'Help: view test files'
     +/'Results'
     +/'Quit ... Exit GLM options')
  500 FORMAT (
     +/' GLM analysis number',I3
     +/' File:',1X,A
     +/' Title:',1X,A
     +/' Offset:',1X,A
     +/' Details:',1X,A)
  600 FORMAT (
     +/'Error type:',1X,A
     +/'Link type:',1X,A)
  700 FORMAT (/'Fitting the Weibull survival model')
  800 FORMAT (/'Fitting the extreme value survival model')
      END
C
C
