c
c
      subroutine m_kernde (nout, nz,
     +                     z,
     +                     title,
     +                     newdat)
c
c action: call kernde
c author: w.g.bardsley, university of manchester, u.k., 29/02/2006
c         edited to make sure nrmax >= nbmax and npmax in call to kernde
c         Advice: make sure nrmax is consistent with nbmax and npmax 
c                 defined as parameters in kernde
c
c   nout: (input/unchanged) preconnected unit for results
c     nz: (input/unchanged) sample size
c      z: (input/unchanged) sample (copied into x before use)
c  title: (input/unchanged) data title
c newdat: (output) .tru.e if new data requested
c
      implicit   none
c
c arguments
c
      integer    nout, nz
      double precision z(nz)
      character  title*(*)
      logical    newdat
c
c local allocatable arrays
c
      double precision, allocatable :: fft(:), smooth(:), t(:), u(:),
     +                                 v(:), w(:), w1(:), x(:)
c
c locals
c
      integer    i, ierr, nrmax
      integer    nin, nbpmax
      parameter (nin = 3, nbpmax = 1000)
      character  line*100
      logical    supply
      parameter (supply = .true.)
      intrinsic  max
      external   putfat, kernde
c
c initialise newdat then check for NAG and sample size
c
      newdat = .false.
      if (nz.le.5) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate workspaces
c
      ierr = 0
      if (allocated(fft)) deallocate (fft, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(smooth)) deallocate (smooth, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(t)) deallocate (t, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(u)) deallocate (u, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(v)) deallocate (v, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w)) deallocate (w, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w1)) deallocate (w1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate (x, stat = ierr)
      if (ierr.ne.0) return
      nrmax = max(nbpmax,nz)
      allocate(fft(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(smooth(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(t(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(u(2*nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(v(2*nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(w(2*nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(w1(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(x(nrmax), stat = ierr)
      if (ierr.ne.0) return
      do i = 1, nz
        x(i) = z(i)
      enddo
c
c call to kernde
c
      call kernde (nz, nin, nout, nrmax,
     +             fft, smooth, t, u, v, w, w1, x,
     +             title,
     +             newdat, supply)
c
c deallocate workspaces
c
      deallocate(fft, stat = ierr)
      deallocate(smooth, stat = ierr)
      deallocate(t, stat = ierr)
      deallocate(u, stat = ierr)
      deallocate(v, stat = ierr)
      deallocate(w, stat = ierr)
      deallocate(w1, stat = ierr)
      deallocate(x, stat = ierr)
c
c format statement
c
  100 format ('Sample size must be > 5, and preferably >> 20')
      end
c
c
