C
C
      SUBROUTINE M_KS1SAM (ISEND, NOUT, NZ,
     +                     Z,
     +                     TITLEZ)
C
C ACTION : Kolmogorov-Smirnov one sample test
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          22/01/2006 derived from KS1SAM
C          28/01/2006 edited to accept Z from argument list
C          23/09/2007 added ISEND TO argument list and Bonferroni for NORMAL case
C          02/04/2020 increased dimension of PTITLE to 60
C          20/07/2021 added E_NUMBERS and E_FORMATS, etc. (but not all formats were changed)
C          19/07/2022 completed the format issue and sorted many outstanding problems in PDFFCN and CDFFCN
C          24/07/2022 added JSEND to remember previous option if called with ISEND = 0 and
C                     made NUMOPT (main menu) and NUMOPT1 (plotting menu) parameters to avoid confusion
C
C ISEND =  1: uniform
C          2: normal
C          3: gamma
C          4: beta
C          5: binomial
C          6: exponential
C          7: Poisson
C          8: lognormal
C          9: Weibull
C         10: t
C         11: chisquare
C         12: F  
C             otherwise distribution is chosen interactively
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: ISEND, NOUT, NZ
      DOUBLE PRECISION,    INTENT (IN) :: Z(NZ)
      CHARACTER (LEN = *), INTENT (IN) :: TITLEZ
C
C Local allocatable arrays
C
      INTEGER, ALLOCATABLE :: IC(:)
      DOUBLE PRECISION, ALLOCATABLE :: U(:), V(:), W(:), XGRAF(:),
     +                                 YGRAF(:)
C
C Locals
C
      INTEGER    I, ICOUNT, IERR, IFAIL, JSEND, NCHOP, NDIST, NGRAF1,
     +           NGRAF2, NSAV, NTYPE
      INTEGER    NDOFC, NDOFT, NDOFF1, NDOFF2, NMAX, NMAX2, NPTS
      INTEGER    NGRAF, NSWMAX
      PARAMETER (NGRAF = 2000, NSWMAX = 2000)
      INTEGER    ICOLOR, IX, IY, NUMTXT
      PARAMETER (IX = 4, IY = 4)
      INTEGER    NUMOPT, NUMOPT1
      PARAMETER (NUMOPT = 13, NUMOPT1 = 5) 
      INTEGER    NUMDEC, N0, N1, N2, NMIN, NUMPAR
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, NMIN = 3, NUMPAR = 2)
      INTEGER    NUMPOS(20)
      INTEGER    ILIM, KX, MAXIT, NX, NIT
      INTEGER    NUMBLD(30), NUMSTA
      PARAMETER (NUMSTA = 3) 
      PARAMETER (ILIM = 95, MAXIT = 500)
      DOUBLE PRECISION PAR(NUMPAR), STDERR(NUMPAR)
      DOUBLE PRECISION DUMMY
      DOUBLE PRECISION D1, Z1, P1
      DOUBLE PRECISION D2, Z2, P2
      DOUBLE PRECISION D3, Z3, P3
      DOUBLE PRECISION BETA, CORR, DEV, GAMMA, SEBETA, SEGAM, TOL
      DOUBLE PRECISION PBOT, PHAT, PTOP, ZBAR, ZCHOP, ZVAR
      DOUBLE PRECISION PL95(2), PU95(2), T95
      DOUBLE PRECISION CHIL95, CHIU95, PSAV, RTOL, XTOL, Y1, Y2
      DOUBLE PRECISION PW, SW
      DOUBLE PRECISION ONE, TWO, ZERO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION PNT001, PNT025, PNT975, PNT95
      PARAMETER (PNT001 = 0.001D+00, PNT025 = 0.025D+00,
     +           PNT975 = 0.975D+00, PNT95 = 0.95D+00)
      DOUBLE PRECISION X02AMF$, G01FCF$, G01FBF$
      CHARACTER  TITLE*80
      CHARACTER  DIST*2, DNAME*20, EST*1
      CHARACTER  PTYPE*100, PTYPE1*100, PTYPE2*100, PTYPE3*100
      CHARACTER  P1TYPE*23, P2TYPE*23, P3TYPE*23
      CHARACTER  PTITLE*60
      CHARACTER  ANSWER*40, CHOP80*80, LINE*100, TEXT(30)*100
      CHARACTER  TEMP(3)*100
      CHARACTER (LEN = 10) D10(4), FORMGR
      CHARACTER (LEN = 12) FORM12, WORD12, WN, WM
      CHARACTER (LEN = 13) D13(6), SHOWLJ 
      CHARACTER  BLANK*1, CENS*1
      PARAMETER (BLANK = ' ', CENS = 'N')
      LOGICAL    CALWTS, ESTIM, REPEET
      LOGICAL    E_FORMATS, E_NUMBERS
      EXTERNAL   E_FORMATS, FORM12, FORMGR, SHOWLJ
      EXTERNAL   PLEVEL, PUTIFA, PUTFAT, TABLE1, YESNO2, LSTBOX, LBOX02,
     +           GETDG2, GETD01, GETDGE, GETJGE, GETDL1, PHAT95,
     +           NXXBAR, PUTCAU, CHOP80
      EXTERNAL   CDFOUT, PDFOUT, HNPLOT
      EXTERNAL   G08CBF$, X02AMF$, G07BEF$, G01FCF$, G01FBF$,
     +           G07ABF$, G01DDF$
      INTRINSIC  DBLE, NINT, SQRT, EXP, ABS, LOG, TRIM
      SAVE       ICOUNT, JSEND, NSAV
      SAVE       NDOFC, NDOFT, NDOFF1, NDOFF2
      SAVE       PSAV
      DATA       ICOUNT, JSEND, NSAV / 0, 2, 10 /
      DATA       NDOFC, NDOFT, NDOFF1, NDOFF2 / 10, 10, 10, 10 /
      DATA       PSAV / 0.5D+00 /
      DATA       NUMPOS / 20*1 /
      DATA       NUMBLD / 30*0 /  
      IF (NZ.LT.NMIN) THEN
         RETURN
      ElSE
C
C Initialise
C
         RTOL = 1.0D+09*X02AMF$()
         XTOL = SQRT(RTOL)
         PAR(1) = ONE
         PAR(2) = ONE
         TITLE = CHOP80(TITLEZ)

         npts = nz
         nmax = npts
         if (nmax.lt.ngraf) nmax = ngraf
         nmax2 = 2*nmax

         ierr = 0
         if (allocated(ic)) deallocate(ic, stat = ierr)
         if (ierr.eq.0) allocate(ic(nmax), stat = ierr)
         if (ierr.ne.0) return

         do i = 1, nmax
            ic(i) = 0
         enddo     

         ierr = 0
         if (allocated(u)) deallocate(u, stat = ierr)
         if (ierr.eq.0) allocate(u(nmax2), stat = ierr)
         if (ierr.ne.0) return

         if (allocated(v)) deallocate(v, stat = ierr)
         if (ierr.eq.0) allocate(v(nmax2), stat = ierr)
         if (ierr.ne.0) return

         if (allocated(w)) deallocate(w, stat = ierr)
         if (ierr.eq.0) allocate(w(nmax2), stat = ierr)
         if (ierr.ne.0) return

         if (allocated(xgraf)) deallocate(xgraf, stat = ierr)
         if (ierr.eq.0) allocate(xgraf(ngraf), stat = ierr)
         if (ierr.ne.0) return

         if (allocated(ygraf)) deallocate(ygraf, stat = ierr)
         if (ierr.eq.0) allocate(ygraf(ngraf), stat = ierr)
         if (ierr.ne.0) return

      ENDIF
C
C Call NXXBAR for starting estimates and Poisson dispersion
C
      CALL NXXBAR (NZ, Z, ZBAR, ZVAR)
      IF (ZVAR.LE.RTOL) THEN
         deallocate (u, stat = ierr)
         deallocate (v, stat = ierr)
         deallocate (w, stat = ierr)
         deallocate (xgraf, stat = ierr)
         deallocate (ygraf, stat = ierr)
         CALL PUTFAT ('Singular data (all identical ?)')
         RETURN
      ENDIF
C
C Decide which distribution to use
C
      E_NUMBERS = E_FORMATS() 
      
      ICOLOR = 7
      IF (ISEND.GE.1 .AND. ISEND.LE.12) THEN
         NUMDEC = ISEND
         JSEND = ISEND
      ELSE   
         WRITE (TEXT,100)
         NUMDEC = JSEND
         NUMTXT = NUMSTA + NUMOPT - 1
         CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                TEXT)
         IF (NUMDEC.LT.NUMOPT) JSEND = NUMDEC 
      ENDIF
C
C Estimate parameters or set them by hand
C
      ESTIM = .TRUE.
      IF (NUMDEC.LE.9) THEN
         CALL YESNO2 (ICOLOR, IX, IY,
     +'Estimate parameters from the sample (otherwise input vales)',
     +                ESTIM)
      ENDIF
      IF (ESTIM) THEN
         EST = 'E'
         PTYPE = 'Parameters estimated from sample are:'
      ELSE
         PTYPE = 'Parameters fixed by user: are'
         EST = 'S'
      ENDIF
      IF (NUMDEC.EQ.8) THEN
         PTYPE3 = 'Parameters are for y = log(x) [base e]'
      ELSE
         PTYPE3 = BLANK
      ENDIF
      IF (NUMDEC.EQ.1) THEN
         DIST = 'U'
         DNAME = 'Uniform(A,B)'
         IF (.NOT.ESTIM) THEN
            PAR(1) = Z(1)
            PAR(2) = Z(1)
            DO I = 1, NZ
               IF (Z(I).LT.PAR(1)) PAR(1) = Z(I)
               IF (Z(I).GT.PAR(2)) PAR(2) = Z(I)
            ENDDO
            CALL GETDG2 (PAR(1), PAR(2), 'Parameters A, B')
         ENDIF
      ELSEIF (NUMDEC.EQ.2) THEN
         DIST = 'N'
         DNAME = 'Normal(mu,sigma^2)'
         IF (.NOT.ESTIM) THEN
            PAR(1) = ZBAR
            PAR(2) = SQRT(ZVAR)
            CALL GETD01 (PAR(1), 'The mean, mu')
            CALL GETDGE (PAR(2), ZERO,
     +                  'The standard deviation, sigma > 0')
            IF (PAR(2).LT.XTOL) PAR(2) = XTOL
            PAR(2) = PAR(2)**2
         ENDIF
      ELSEIF (NUMDEC.EQ.3) THEN
         DIST = 'G'
         DNAME = 'Gamma(alpha,beta)'
         IF (.NOT.ESTIM) THEN
            IF (ZBAR.LT.RTOL) THEN
               CALL PUTFAT ('Negative data')
               RETURN
            ENDIF
            PAR(2) = ZVAR/ZBAR
            PAR(1) = ZBAR/PAR(2)
            IF (PAR(1).LT.RTOL) PAR(1) = RTOL
            IF (PAR(2).LT.RTOL) PAR(2) = RTOL
            CALL GETDGE (PAR(1), RTOL, 'The parameter alpha > 0')
            CALL GETDGE (PAR(2), RTOL, 'The parameter beta > 0')
         ENDIF
      ELSEIF (NUMDEC.EQ.4) THEN
         DIST = 'BE'
         DNAME = 'Beta(r,s)'
         IF (.NOT.ESTIM) THEN
            IF (ZBAR.LT.RTOL) THEN
               CALL PUTFAT ('Negative data')
               RETURN
            ENDIF
            Y1 = ZBAR**2/ZVAR
            Y2 = ONE/ZBAR - ONE
            PAR(1) = ZBAR*(Y1*Y2 - ONE)
            PAR(2) = PAR(1)*Y2
            IF (PAR(1).LT.RTOL) PAR(1) = RTOL
            IF (PAR(2).LT.RTOL) PAR(2) = RTOL
            CALL GETDGE (PAR(1), RTOL, 'The parameter r > 0')
            CALL GETDGE (PAR(2), RTOL, 'The parameter s > 0')
         ENDIF
      ELSEIF (NUMDEC.EQ.5) THEN
         CALL GETJGE (NSAV, N1, 'The binomial parameter N > 0')
         PAR(1) = DBLE(NSAV)
         DIST = 'BI'
         DNAME = 'Binomial(N,p)'
         IF (.NOT.ESTIM) THEN
            CALL GETDL1 (ZERO, PSAV, ONE, 'The parameter p, 0 < p < 1')
            PAR(2) = PSAV
         ENDIF
      ELSEIF (NUMDEC.EQ.6) THEN
         DIST = 'E'
         DNAME = 'Exponential(lambda)'
         IF (.NOT.ESTIM) THEN
            IF (ZBAR.LT.RTOL) THEN
               CALL PUTFAT ('Negative data')
               RETURN
            ENDIF
            PAR(1) = ZBAR
            CALL GETDGE (PAR(1), RTOL,
     +     'The parameter A > 0 (Note: mean = A)')
         ENDIF
         PAR(2) = ZERO
      ELSEIF (NUMDEC.EQ.7) THEN
         DIST = 'P'
         DNAME = 'Poisson(mu)'
         IF (.NOT.ESTIM) THEN
            IF (ZBAR.LT.RTOL) THEN
               deallocate (u, stat = ierr)
               deallocate (v, stat = ierr)
               deallocate (w, stat = ierr)
               deallocate (xgraf, stat = ierr)
               deallocate (ygraf, stat = ierr)
               CALL PUTFAT ('Negative data')
               RETURN
            ENDIF
            PAR(1) = ZBAR
            CALL GETDGE (PAR(1), RTOL, 'The parameter mu > 0')
         ENDIF
      ELSEIF (NUMDEC.EQ.8) THEN
         DIST = 'L'
         DNAME = 'Lognorm(mu,sigma^2)'
         IF (.NOT.ESTIM) THEN
            DO I = 1, NZ
               IF (Z(I).LE.RTOL) THEN
                  deallocate (u, stat = ierr)
                  deallocate (v, stat = ierr)
                  deallocate (w, stat = ierr)
                  deallocate (xgraf, stat = ierr)
                  deallocate (ygraf, stat = ierr)
                  CALL PUTFAT ('Data nonpositive')
                  RETURN
               ENDIF
               U(I) = LOG(Z(I))
            ENDDO
            CALL NXXBAR (NZ,
     +                   U, PAR(1), PAR(2))
            IF (PAR(2).LT.RTOL) PAR(2) = RTOL
            PAR(2) = SQRT(PAR(2))
            CALL GETD01 (PAR(1), 'The mean, mu')
            CALL GETDGE (PAR(2), ZERO,
     +                  'The standard deviation, sigma > 0')
            IF (PAR(2).LT.XTOL) PAR(2) = XTOL
            PAR(2) = PAR(2)**2
         ENDIF
      ELSEIF (NUMDEC.EQ.9) THEN
         DIST = 'W'
         DNAME = 'Weibull(A,B)'
         IF (.NOT.ESTIM) THEN
            GAMMA = ONE
            CALL GETDGE (GAMMA, RTOL,
     +     'The parameter B (Note: B > 0, then A is estimated)')
         ELSE
            GAMMA = - ONE
         ENDIF
C
C Special code for Weibull
C
         EST = 'S'
         TOL = ZERO
         IFAIL = 0
         CALL G07BEF$(CENS, NZ, Z, IC, BETA, GAMMA, TOL, MAXIT, SEBETA,
     +                SEGAM, CORR, DEV, NIT, W, IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G07BEF/KS1SAM')
         IF (IFAIL.EQ.2) CALL PUTFAT ('Cannot have values =< 0')
         IF (IFAIL.NE.0) RETURN
         PAR(1) = (EXP(BETA))**(ONE/GAMMA)
         PAR(2) = GAMMA
      ELSEIF (NUMDEC.EQ.10) THEN
C
C t
C
         DIST = 'T'
         DNAME = 't(N)'
         CALL GETJGE (NDOFT, N2, 'The degrees of freedom N > 1')
         PAR(1) = DBLE(NDOFT)
      ELSEIF (NUMDEC.EQ.11) THEN
C
C chi-square
C
         DIST = 'C'
         DNAME = 'chi-square(N)'
         CALL GETJGE (NDOFC, N2, 'The degrees of freedom N > 1')
         PAR(1) = DBLE(NDOFC)
      ELSEIF (NUMDEC.EQ.12) THEN
C
C F
C
         DIST = 'F'
         DNAME = 'F(N,M)'
         CALL GETJGE (NDOFF1, N1, 'Numerator degrees of freedom N > 0')
         PAR(1) = DBLE(NDOFF1)
         CALL GETJGE (NDOFF2, N1,
     +               'Denominator degrees of freedom M > 0')
         PAR(2) = DBLE(NDOFF2)
      ELSE
         deallocate (u, stat = ierr)
         deallocate (v, stat = ierr)
         deallocate (w, stat = ierr)
         deallocate (xgraf, stat = ierr)
         deallocate (ygraf, stat = ierr)
         RETURN
      ENDIF
C
C Check for truncation if binomial/Poission
C
      IF (NUMDEC.EQ.5 .OR. NUMDEC.EQ.7) THEN
         NCHOP = N0
         DO I = N1, NZ
            IFAIL = NINT(Z(I))
            ZCHOP = DBLE(IFAIL)
            IF (ABS(Z(I) - ZCHOP).GE.PNT001) NCHOP = NCHOP + N1
         ENDDO
         IF (NCHOP.GT.N0) THEN
            WRITE (LINE,'(I6,A)') NCHOP, ' values truncated to integers'
            CALL PUTCAU (LINE)
         ENDIF
      ENDIF
C
C The KS tests
C
      IFAIL = 1
      NTYPE = 1
      CALL G08CBF$(NZ, Z, DIST, PAR, EST, NTYPE, D1, Z1, P1, U, IFAIL)
      IF (IFAIL.GT.4 .AND. IFAIL.LT.9) THEN
         deallocate (u, stat = ierr)
         deallocate (v, stat = ierr)
         deallocate (w, stat = ierr)
         deallocate (xgraf, stat = ierr)
         deallocate (ygraf, stat = ierr)
         CALL PUTFAT ('Data inconsistent with distribution selected')
         RETURN
      ENDIF
      CALL PUTIFA (IFAIL, NOUT, 'G08CBF/KS1SAM')
      IF (IFAIL.NE.0) RETURN
      IFAIL = 1
      NTYPE = 2
      CALL G08CBF$(NZ, Z, DIST, PAR, EST, NTYPE, D2, Z2, P2, U, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08CBF/KS1SAM')
      IF (IFAIL.NE.0) THEN
         deallocate (u, stat = ierr)
         deallocate (v, stat = ierr)
         deallocate (w, stat = ierr)
         deallocate (xgraf, stat = ierr)
         deallocate (ygraf, stat = ierr)
         RETURN
      ENDIF
      IFAIL = 1
      NTYPE = 3
      CALL G08CBF$(NZ, Z, DIST, PAR, EST, NTYPE, D3, Z3, P3, U, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08CBF/KS1SAM')
      IF (IFAIL.NE.0) THEN
         deallocate (u, stat = ierr)
         deallocate (v, stat = ierr)
         deallocate (w, stat = ierr)
         deallocate (xgraf, stat = ierr)
         deallocate (ygraf, stat = ierr)
         RETURN
      ENDIF
C
C Write the parameters to PTYPE1 and PTYPE2
C
C Uniform
C
      IF (NUMDEC.EQ.1) THEN
         D10(1) = FORMGR(PAR(1))
         D10(2) = FORMGR(PAR(2))
         IF (ESTIM) THEN
            WRITE (PTYPE1,101) TRIM(D10(1))
            WRITE (PTYPE2,102) D10(2)
         ELSE
            WRITE (PTYPE1,201) TRIM(D10(1))
            WRITE (PTYPE2,202) D10(2)
         ENDIF
      ELSEIF (NUMDEC.EQ.2) THEN
C
C Normal
C
         IF (ESTIM) THEN
            STDERR(1) = SQRT(PAR(2)/DBLE(NZ))
            IFAIL = 0
            T95 = G01FBF$('Lower-tail', PNT975, DBLE(NZ - 1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FBF/KS1SAM')
            PL95(1) = PAR(1) - T95*STDERR(1)
            PU95(1) = PAR(1) + T95*STDERR(1)
            IF (E_NUMBERS) THEN
               WRITE (PTYPE1,103) PAR(1), STDERR(1), PL95(1), PU95(1)
            ELSE
               D10(1) = FORMGR(PAR(1))
               D10(2) = FORMGR(STDERR(1))
               D10(3) = FORMGR(PL95(1))
               D10(4) = FORMGR(PU95(1)) 
               WRITE (PTYPE1,2103) TRIM(D10(1)), TRIM(D10(2)), 
     +                             TRIM(D10(3)), TRIM(D10(4))
            ENDIF   
            IFAIL = 0
            CHIL95 = G01FCF$(PNT025, DBLE(NZ - N1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/KS1SAM')
            IFAIL = 0
            CHIU95 = G01FCF$(PNT975, DBLE(NZ - N1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/KS1SAM')
            PL95(2) = (DBLE(NZ) - ONE)*PAR(2)/CHIU95
            PU95(2) = (DBLE(NZ) - ONE)*PAR(2)/CHIL95
            IF (E_NUMBERS) THEN
               WRITE (PTYPE2,104) SQRT(PAR(2)), PAR(2), PL95(2), PU95(2)
            ELSE
               DUMMY = SQRT(PAR(2))
               D10(1) = FORMGR(DUMMY)
               D10(2) = FORMGR(PAR(2))
               D10(3) = FORMGR(PL95(2))
               D10(4) = FORMGR(PU95(2))
               WRITE (PTYPE2,2104) TRIM(D10(1)), TRIM(D10(2)),
     +                             TRIM(D10(3)), TRIM(D10(4))               
            ENDIF   
         ELSE
            IF (E_NUMBERS) THEN
               WRITE (PTYPE1,203) PAR(1)
               WRITE (PTYPE2,204) SQRT(PAR(2))
            ELSE
               D10(1) = FORMGR(PAR(1))
               DUMMY = SQRT(PAR(2))
               D10(2) = FORMGR(DUMMY)
               WRITE (PTYPE1,2203) D10(1)
               WRITE (PTYPE2,2204) D10(2)
            ENDIF    
         ENDIF
         IF (NZ.LE.NSWMAX) THEN
C
C Shapiro-Wilks if NZ sufficiently small (U is now Z after sorting by G08CBF$)
C
            CALWTS = .TRUE.
            IFAIL = 1
            CALL G01DDF$(U, NZ, CALWTS, W, SW, PW, IFAIL)
            IF (IFAIL.NE.0) THEN
               deallocate (u, stat = ierr)
               deallocate (v, stat = ierr)
               deallocate (w, stat = ierr)
               deallocate (xgraf, stat = ierr)
               deallocate (ygraf, stat = ierr)
               CALL PUTIFA (IFAIL, NOUT, 'G01DDF/KS1SAM')
               RETURN
            ENDIF
            IF (PW.LT.0.005D+00) THEN
               ANSWER = 'Reject normality at 1% sig.level'
            ELSEIF (PW.LT.0.025D+00) THEN
               ANSWER = 'Reject normality at 5% sig.level'
            ELSE
               ANSWER = 'Tentatively accept normality'
            ENDIF
         ELSE
            SW = ZERO
            PW = ONE
            ANSWER = 'ERROR: sample size too large'
         ENDIF
      ELSEIF (NUMDEC.EQ.3) THEN
C
C Gamma
C        
         D10(1) = FORMGR(PAR(1))
         D10(2) = FORMGR(PAR(2)) 
         IF (ESTIM) THEN
            WRITE (PTYPE1,105) TRIM(D10(1))
            WRITE (PTYPE2,106) D10(2)
         ELSE
            WRITE (PTYPE1,205) TRIM(D10(1))
            WRITE (PTYPE2,206) D10(2)
         ENDIF
      ELSEIF (NUMDEC.EQ.4) THEN
C
C Beta
C
         D10(1) = FORMGR(PAR(1))
         D10(2) = FORMGR(PAR(2))   
         IF (ESTIM) THEN
            WRITE (PTYPE1,107) D10(1)
            WRITE (PTYPE2,108) D10(2)
         ELSE
            WRITE (PTYPE1,207) D10(1)
            WRITE (PTYPE2,208) D10(2)
         ENDIF
      ELSEIF (NUMDEC.EQ.5) THEN
C
C Binomial
C
         IF (ESTIM) THEN
            WORD12 = FORM12(NINT(PAR(1)))
            WRITE (PTYPE1,109) TRIM(WORD12)
            STDERR(2) = SQRT(PAR(2)*(ONE - PAR(2))/PAR(1))
            KX = NINT(DBLE(NZ)*PAR(1)*PAR(2))
            NX = NINT(DBLE(NZ)*PAR(1))
            CALL PHAT95 (ILIM, KX, NX, NOUT, PBOT, PHAT, PTOP)
            IF (E_NUMBERS) THEN
               WRITE (PTYPE2,110) PAR(2), STDERR(2), PBOT, PTOP
            ELSE
               D10(1) = FORMGR(PAR(2))
               D10(2) = FORMGR(STDERR(2))
               D10(3) = FORMGR(PBOT)
               D10(4) = FORMGR(PTOP) 
               WRITE (PTYPE2,2110) TRIM(D10(1)), TRIM(D10(2)),
     +                             TRIM(D10(3)), TRIM(D10(4))              
            ENDIF  
         ELSE
            WORD12 = FORM12(NINT(PAR(1)))
            D10(1) = FORMGR(PAR(2))
            WRITE (PTYPE1,209) TRIM(WORD12)
            WRITE (PTYPE2,210) D10(1)
         ENDIF
      ELSEIF (NUMDEC.EQ.6) THEN
C
C Exponential
C
         IF (ESTIM) THEN
            IF (E_NUMBERS) THEN
               WRITE (PTYPE1,111) PAR(1)
            ELSE
               D10(1) = FORMGR(PAR(1))
               WRITE (PTYPE1,2111) D10(1) 
            ENDIF  
         ELSE
            IF (E_NUMBERS) THEN
               WRITE (PTYPE1,211) PAR(1)
            ELSE
               D10(1) = FORMGR(PAR(1)) 
               WRITE (PTYPE1,2211) D10(1)
            ENDIF  
         ENDIF
         PTYPE2 = BLANK
      ELSEIF (NUMDEC.EQ.7) THEN
C
C Poisson
C
         IF (ESTIM) THEN
            IFAIL = 0
            CALL G07ABF$(NZ, PAR(1), PNT95, PL95(1), PU95(1), IFAIL)
            IF (E_NUMBERS) THEN
               WRITE (PTYPE1,113) PAR(1), PL95(1), PU95(1), ZVAR
            ELSE
               D10(1) = FORMGR(PAR(1))
               D10(2) = FORMGR(PL95(1))
               D10(3) = FORMGR(PU95(1))
               D10(4) = FORMGR(ZVAR)
               WRITE (PTYPE1,2113) TRIM(D10(1)), TRIM(D10(2)), 
     +                             TRIM(D10(3)), D10(4)
            ENDIF  
            IF (ZVAR.LT.PL95(1)) THEN
               WRITE (PTYPE2,114)
     +               'Sample variance < mean (Too uniform ?)'
            ELSEIF (ZVAR.GT.PU95(1)) THEN
               WRITE (PTYPE2,114)
     +              'Sample variance > mean (Too clustered ?)'
            ELSE
               WRITE (PTYPE2,114)
     +               'Sample variance consistent with mean'
            ENDIF
         ELSE
            IF (E_NUMBERS) THEN
               WRITE (PTYPE1,213) PAR(1)
               WRITE (PTYPE2,214) BLANK
            ELSE
               D10(1) = FORMGR(PAR(1))
               WRITE (PTYPE1,2213) D10(1) 
               WRITE (PTYPE2,214) BLANK
            ENDIF  
         ENDIF
      ELSEIF (NUMDEC.EQ.8) THEN
C
C Lognormal
C
         IF (ESTIM) THEN
            STDERR(1) = SQRT(PAR(2)/DBLE(NZ))
            IFAIL = 0
            T95 = G01FBF$('Lower-tail', PNT975, DBLE(NZ - N1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FBF/KS1SAM')
            PL95(1) = PAR(1) - T95*STDERR(1)
            PU95(1) = PAR(1) + T95*STDERR(1)
            IF (E_NUMBERS) THEN
               WRITE (PTYPE1,115) PAR(1), STDERR(1), PL95(1), PU95(1)
            ELSE
               D10(1) = FORMGR(PAR(1))
               D10(2) = FORMGR(STDERR(1))
               D10(3) = FORMGR(PL95(1))
               D10(4) = FORMGR(PU95(1))
               WRITE (PTYPE1,2115) TRIM(D10(1)), TRIM(D10(2)), 
     +                             TRIM(D10(3)), TRIM(D10(4))
            ENDIF  
            IFAIL = 0
            CHIL95 = G01FCF$(PNT025, DBLE(NZ - N1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/KS1SAM')
            IFAIL = 0
            CHIU95 = G01FCF$(PNT975, DBLE(NZ - N1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01FCF/KS1SAM')
            PL95(2) = (DBLE(NZ) - ONE)*PAR(2)/CHIU95
            PU95(2) = (DBLE(NZ) - ONE)*PAR(2)/CHIL95
            IF (E_NUMBERS) THEN
               WRITE (PTYPE2,116) SQRT(PAR(2)), PL95(2), PAR(2), PU95(2)
            ELSE
               DUMMY = SQRT(PAR(2))
               D10(1) = FORMGR(DUMMY)
               D10(2) = FORMGR(PL95(2))
               D10(3) = FORMGR(PAR(2))
               D10(4) = FORMGR(PU95(2))
               WRITE (PTYPE2,2116) TRIM(D10(1)), TRIM(D10(2)),
     +                             TRIM(D10(3)), TRIM(D10(4))                 
            ENDIF  
         ELSE
            IF (E_NUMBERS) THEN
               WRITE (PTYPE1,215) PAR(1)
               WRITE (PTYPE2,216) SQRT(PAR(2))
            ELSE
               D10(1) = FORMGR(PAR(1))
               DUMMY = SQRT(PAR(2))
               D10(2) = FORMGR(DUMMY)
               WRITE (PTYPE1,2215) D10(1)
               WRITE (PTYPE2,2216) D10(2) 
            ENDIF 
         ENDIF
      ELSEIF (NUMDEC.EQ.9) THEN
C
C Weibull
C
        
         IF (ESTIM) THEN
            STDERR(1) = (ONE/GAMMA)*((EXP(BETA))**(ONE/GAMMA))*SEBETA
            STDERR(2) = SEGAM
            D10(1) = FORMGR(PAR(1))
            D10(2) = FORMGR(STDERR(1))  
            D10(3) = FORMGR(PAR(2))
            D10(4) = FORMGR(STDERR(2))
            WRITE (PTYPE1,117) TRIM(D10(1)), D10(2)
            WRITE (PTYPE2,118) TRIM(D10(3)), D10(4)
         ELSE
            STDERR(1) = (ONE/GAMMA)*((EXP(BETA))**(ONE/GAMMA))*SEBETA
            D10(1) = FORMGR(PAR(1))
            D10(2) = FORMGR(STDERR(1)) 
            WRITE (PTYPE1,217) D10(1)
            WRITE (PTYPE2,218) D10(2)
         ENDIF
      ELSEIF (NUMDEC.EQ.10) THEN
C
C t
C
         WORD12 = FORM12(NINT(PAR(1)))  
         WRITE (PTYPE1,109) TRIM(WORD12)
         WRITE (PTYPE2,112) BLANK
      ELSEIF (NUMDEC.EQ.11) THEN
C
C chi-square
C
         WORD12 = FORM12(NINT(PAR(1))) 
         WRITE (PTYPE1,109) TRIM(WORD12)
         WRITE (PTYPE2,112) BLANK
      ELSEIF (NUMDEC.EQ.12) THEN
C
C F
C
         WN = FORM12(NINT(PAR(1)))
         WM = FORM12(NINT(PAR(2)))
         WRITE (PTYPE1,109) TRIM(WN)
         WRITE (PTYPE2,219) TRIM(WM)
      ELSE
         deallocate (u, stat = ierr)
         deallocate (v, stat = ierr)
         deallocate (w, stat = ierr)
         deallocate (xgraf, stat = ierr)
         deallocate (ygraf, stat = ierr)
         RETURN
      ENDIF
C
C Output the results
C
      ICOUNT = ICOUNT + N1
      CALL PLEVEL (P1, P1TYPE)
      CALL PLEVEL (P2, P2TYPE)
      CALL PLEVEL (P3, P3TYPE)
      WRITE (NOUT,'(A)') BLANK
      WRITE (NOUT,'(A)') '***'
      IF (E_NUMBERS) THEN
         WRITE (NOUT,300) ICOUNT, DNAME, TITLE, PTYPE, PTYPE1, PTYPE2,
     +                    PTYPE3, NZ, D1, Z1, P1,
     +                    P1TYPE, D2, Z2, P2, P2TYPE, D3, Z3, P3, P3TYPE
         WRITE (TEXT,350) ICOUNT, DNAME, CHOP80(TITLE), CHOP80(PTYPE),
     +                    CHOP80(PTYPE1), CHOP80(PTYPE2),
     +                    CHOP80(PTYPE3), NZ, D1, Z1, P1,
     +                    P1TYPE, D2, Z2, P2, P2TYPE, D3, Z3, P3, P3TYPE
      ELSE
          WORD12 = FORM12(NZ)
          D13(1) = SHOWLJ(D1)
          D13(2) = SHOWLJ(Z1)
          D13(3) = SHOWLJ(D2)
          D13(4) = SHOWLJ(Z2)
          D13(5) = SHOWLJ(D3)
          D13(6) = SHOWLJ(Z3)
          WRITE (NOUT,305) ICOUNT, DNAME, TITLE, PTYPE, PTYPE1, PTYPE2,
     +                     PTYPE3, TRIM(WORD12),
     +                     D13(1), D13(2), P1, P1TYPE,
     +                     D13(3), D13(4), P2, P2TYPE,
     +                     D13(5), D13(6), P3, P3TYPE
          WRITE (TEXT,355) ICOUNT, DNAME, CHOP80(TITLE), CHOP80(PTYPE),
     +                    CHOP80(PTYPE1), CHOP80(PTYPE2),
     +                    CHOP80(PTYPE3), TRIM(WORD12),
     +                    D13(1), D13(2), P1, P1TYPE,
     +                    D13(3), D13(4), P2, P2TYPE,
     +                    D13(5), D13(6), P3, P3TYPE 
      ENDIF  
      NUMTXT = 22
      IF (NUMDEC.EQ.2 .AND. NZ.LE.NSWMAX) THEN
C
C Shapiro-Wilks results if NZ sufficiently small
C
         IF (E_NUMBERS) THEN
            WRITE (NOUT,325) SW, PW, ANSWER
            WRITE (TEMP,375) SW, PW, ANSWER
         ELSE
            WRITE (NOUT,330) SW, PW, ANSWER
            WRITE (TEMP,380) SW, PW, ANSWER
         ENDIF  
         NUMTXT = NUMTXT + 1
         TEXT(NUMTXT) = TEMP(1)
         NUMTXT = NUMTXT + 1
         TEXT(NUMTXT) = TEMP(2)
         NUMTXT = NUMTXT + 1
         TEXT(NUMTXT) = TEMP(3)
      ENDIF
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.1  .OR. I.EQ.4  .OR. I.EQ.10 .OR. I.EQ.11 .OR.
     +       I.EQ.15 .OR. I.EQ.19 .OR. I.EQ.23) THEN
            ICOLOR = 4
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
C
C Prepare for plotting if necessary
C
      IF (NUMDEC.EQ.5 .OR. NUMDEC.EQ.7) THEN
C
C NGRAF1 points for the cdf but NGRAF2 not used in call to PDFOUT
C Use the extremes of the sorted sample to define NGRAF1
C
         NGRAF1 = NINT(TWO*(U(NZ) - U(1) + ONE))
         NGRAF2 = 1
      ELSE
C
C Plot just NGRAF1 = NGRAF2 = 120 points for the theoretical curves
C as follows: NGRAF1 points for the CDF and NGRAF2 for the PDF
C
         NGRAF1 = 120
         NGRAF2 = 120
      ENDIF
      IF (NGRAF1.GT.NGRAF) THEN
         NGRAF1 = NGRAF
         CALL PUTCAU ('Sample too large to plot all values')
      ENDIF
C
C Create plot titles
C      
      D10(1) = FORMGR(PAR(1))
      D10(2) = FORMGR(PAR(2))
     
      IF (NUMDEC.EQ.1) THEN
         WRITE (PTITLE,400) TRIM(D10(1)), D10(2)
      ELSEIF (NUMDEC.EQ.2) THEN
         IF (E_NUMBERS) THEN
            WRITE (PTITLE,500) PAR(1), SQRT(PAR(2))
         ELSE
            DUMMY = SQRT(PAR(2))
            D10(2) = FORMGR(DUMMY)
            WRITE (PTITLE,2500) TRIM(D10(1)), D10(2)
         ENDIF     
      ELSEIF (NUMDEC.EQ.3) THEN
         WRITE (PTITLE,600) TRIM(D10(1)), D10(2)
      ELSEIF (NUMDEC.EQ.4) THEN
         WRITE (PTITLE,700) TRIM(D10(1)), D10(2)
      ELSEIF (NUMDEC.EQ.5) THEN
         WORD12 = FORM12(NINT(PAR(1)))
         D10(1) = FORMGR(PAR(2))
         WRITE (PTITLE,800) TRIM(WORD12), TRIM(D10(1))
      ELSEIF (NUMDEC.EQ.6) THEN
         IF (E_NUMBERS) THEN
            WRITE (PTITLE,900) PAR(1)
         ELSE
            D10(1) = FORMGR(PAR(1))  
            WRITE (PTITLE,950) D10(1)
         ENDIF  
      ELSEIF (NUMDEC.EQ.7) THEN
         IF (E_NUMBERS) THEN
            WRITE (PTITLE,1000) PAR(1)
         ELSE
            D10(1) = FORMGR(PAR(1))
            WRITE (PTITLE,1050) D10(1)  
         ENDIF  
      ELSEIF (NUMDEC.EQ.8) THEN
         IF (E_NUMBERS) THEN
            WRITE (PTITLE,1100) PAR(1), SQRT(PAR(2))
         ELSE
            D10(1) = FORMGR(PAR(1))
            DUMMY = SQRT(PAR(2))
            D10(2) = FORMGR(DUMMY)
            WRITE (PTITLE,1150) TRIM(D10(1)), TRIM(D10(2)) 
         ENDIF  
      ELSEIF (NUMDEC.EQ.9) THEN
         WRITE (PTITLE,1200) TRIM(D10(1)), D10(2)
      ELSEIF (NUMDEC.EQ.10) THEN
         WORD12 = FORM12(NINT(PAR(1)))
         WRITE (PTITLE,1300) WORD12
      ELSEIF (NUMDEC.EQ.11) THEN
         WORD12 = FORM12(NINT(PAR(1)))
         WRITE (PTITLE,1400) WORD12
      ELSEIF (NUMDEC.EQ.12) THEN
         WN = FORM12(NINT(PAR(1)))
         WM = FORM12(NINT(PAR(2)))
         WRITE (PTITLE,1500) TRIM(WN), TRIM(WM)
      ENDIF
C
C Set NDIST = NUMDEC and plot if required
C
      IF (NZ.GT.2) THEN
         NDIST = NUMDEC
         REPEET = .TRUE.
         NUMDEC = 1
         WRITE (TEXT,1600)
      ELSE
         REPEET = .FALSE.
      ENDIF
C
C Plotting options
C
      DO WHILE (REPEET)
         ICOLOR = 7
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT1, NUMPOS, TEXT)
         IF (NUMDEC.EQ.1) THEN
C
C Plot CDF and sample CDF: U must be Z in ascending order
C
            CALL CDFOUT (NGRAF1, NZ, NDIST, NUMPAR,
     +                   PAR, U, XGRAF, V, YGRAF, W,
     +                   PTITLE)
            NUMDEC = 2
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Plot PDF and sample PDF: U must be Z in ascending order
C
            CALL PDFOUT (NDIST, NGRAF2, NMAX, NUMPAR, NZ,
     +                   PAR, XGRAF, V(1), V(NMAX + 1), YGRAF, W(1),
     +                   W(NMAX + 1), U)
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Half normal plot
C
            IFAIL = N1
            CALL HNPLOT (IFAIL, NZ, Z)
            NUMDEC = NUMOPT1
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Normal plot
C
            IFAIL = N2
            CALL HNPLOT (IFAIL, NZ, Z)
            NUMDEC = NUMOPT1
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Deallocate workspace
C
      deallocate (ic, stat = ierr)
      deallocate (u, stat = ierr)
      deallocate (v, stat = ierr)
      deallocate (w, stat = ierr)
      deallocate (xgraf, stat = ierr)
      deallocate (ygraf, stat = ierr)
C
C Format statements
C
  100 FORMAT (
     + 'Kolmogorov 1-sample test'
     +/ 
     +/'Uniform(A,B)         ` range = A to B, mean = (A + B)/2'
     +/'Normal(mu,sigma^2)   ` mean = mu'
     +/'Gamma(alpha,beta)    ` mean = alpha*beta'
     +/'Beta(r,s)            ` mean = r/(r + s)'
     +/'Binomial(N,p)        ` mean = Np'
     +/'Exponential          ` pdf = (1/A)*exp(-x/A), mean = A'
     +/'Poisson(mu)          ` mean = mu',
     +/'Lognormal(mu,sigma^2)` mean = mu',
     +/'Weibull(A,B)         ` cdf = 1-exp[(A*x)^B]'
     +/'t(N)                 ` N = degrees of freedom (DOF)'
     +/'Chi-square(N)        ` N = degrees of freedom (DOF)'
     +/'F(N,M)               ` N = numerator DOF, M = denominator DOF'
     +/'Quit                 ` Exit these options')
  101 FORMAT ('A =',1X,A)
  102 FORMAT ('B =',1X,A)
  103 FORMAT ('mu =',1P,E11.3,', se =',E11.3,', 95%cl = (',
     +E11.3,',',E11.3,')')
 2103 FORMAT ('mu =',1X,A,', se =',1X,A,', 95%cl = (',
     +A,',',A,')')   
  104 FORMAT ('sigma =',1P,E11.3,', sigma^2 =',E11.3,', 95%cl = (',
     +E9.3,',',E9.3,')')
 2104 FORMAT ('sigma =',1X,A,', sigma^2 =',1X,A,', 95%cl = (',
     +A,',',A,')')    
  105 FORMAT ('alpha =',1X,A)
  106 FORMAT ('beta =',1X,A)
  107 FORMAT ('r =',1X,A)
  108 FORMAT ('s =',1X,A)
  109 FORMAT ('N =',1X,A,' (Fixed)')
  110 FORMAT ('p =',F8.4,', s.e. =',F8.4,', 95% c.l. = (',
     +F8.4,',',F8.4,')')
 2110 FORMAT ('p =',1X,A,', s.e. =',1X,A,', 95% c.l. = (',
     +A,',',A,')')    
  111 FORMAT ('mean =',1P,E11.3)
 2111 FORMAT ('mean =',1X,A) 
  112 FORMAT (A)
  113 FORMAT ('mu =',1P,E11.3,
     +', 95% c.l. = (',E11.3,',',E11.3,'), sample variance =',1P,E11.3)
 2113 FORMAT ('mu =',1X,A,
     +', 95% c.l. = (',A,',',A,'), sample variance =',1X,A)    
  114 FORMAT (A)
  115 FORMAT ('mu =',1P,E11.3,', s.e. =',E11.3,', 95% c.l. = (',
     +E11.3,',',E11.3,')')
 2115 FORMAT ('mu =',1X,A,', s.e. =',1X,A,', 95% c.l. = (',
     +A,',',A,')')    
  116 FORMAT ('sigma =',1P,E11.3,', sigma^2 and 95%cl',
     +E11.3,' =<',E11.3,' =<',E11.3)
 2116 FORMAT ('sigma =',1X,A,', sigma^2 and 95%cl',
     +1X,A,' =<',A,' =<',A)    
  117 FORMAT ('A =',1X,A,', s.e. =',1X,A)
  118 FORMAT ('B =',1X,A,', s.e. =',1X,A)
  201 FORMAT ('A =',1X,A)
  202 FORMAT ('B =',1X,A)
  203 FORMAT ('mu =',1P,E11.3)
 2203 FORMAT ('mu =',1X,A) 
  204 FORMAT ('sigma =',1P,E11.3)
 2204 FORMAT ('sigma =',1X,A) 
  205 FORMAT ('alpha =',1X,A)
  206 FORMAT ('beta =',1X,A)
  207 FORMAT ('r =',1X,A)
  208 FORMAT ('s =',1X,A)
  209 FORMAT ('N =',1X,A,' (Fixed)')
  210 FORMAT ('p =',1X,A)
  211 FORMAT ('mean =',1P,E11.3)
 2211 FORMAT ('mean =',1X,A)  
C  212 FORMAT (A)
  213 FORMAT ('mu =',1P,E11.3)
 2213 FORMAT ('mu =',1X,A)
  214 FORMAT (A)
  215 FORMAT ('mu =',1P,E11.3)
 2215 FORMAT ('mu =',1X,A) 
  216 FORMAT ('sigma =',1P,E11.3)
 2216 FORMAT ('sigma =',1X,A) 
  217 FORMAT ('A =',1X,A)
  218 FORMAT ('B =',1X,A)
  219 FORMAT ('N =',1X,A,' (Fixed)')
  300 FORMAT (
     +/'Kolmogorov-Smirnov one sample test',I4,':',2X,A
     +/'--------------------------------------'
     +/'Data: ',A
     +/A
     +/A
     +/A
     +/A
     +/'NX = ',I6,', i.e. no. of x-values'
     +/'H0 = F(x) equals G(y) (x and theory are comparable) against'
     +/'H1 = F(x) not equal to G(y) (x and theory not comparable)'
     +/'D  =',1P,E13.5
     +/'z  =',1P,E13.5
     +/'p  =',0P,F8.4,4X,A
     +/'H2 = F(x) > G(y) (x tend to be smaller than theoretical)'
     +/'D  =',1P,E13.5
     +/'z  =',1P,E13.5
     +/'p  =',0P,F8.4,4X,A
     +/'H3 = F(x) < G(y) (x tend to be  larger than theoretical)'
     +/'D =',1P,E13.5
     +/'z =',1P,E13.5
     +/'p =',0P,F8.4,4X,A)
  305 FORMAT (
     +/'Kolmogorov-Smirnov one sample test',I4,':',2X,A
     +/'--------------------------------------'
     +/'Data: ',A
     +/A
     +/A
     +/A
     +/A
     +/'NX =',1X,A,', i.e. number of x-values'
     +/'H0 = F(x) equals G(y) (x and theory are comparable) against'
     +/'H1 = F(x) not equal to G(y) (x and theory not comparable)'
     +/'D  =',1X,A
     +/'z  =',1X,A
     +/'p  =',F8.4,4X,A
     +/'H2 = F(x) > G(y) (x tend to be smaller than theoretical)'
     +/'D  =',1X,A
     +/'z  =',1X,A
     +/'p  =',F8.4,4X,A
     +/'H3 = F(x) < G(y) (x tend to be  larger than theoretical)'
     +/'D =',1X,A
     +/'z =',1X,A
     +/'p =',F8.4,4X,A)     
  325 FORMAT (
     + 1X,'Shapiro-Wilks normality test (Note: Bonferroni n = 2):'
     +/1X,'W statistic =',1P,E13.5
     +/1X,'Sign. level =',0P,F8.4,5X,A)
  330 FORMAT (
     + 1X,'Shapiro-Wilks normality test (Note: Bonferroni n = 2):'
     +/1X,'W statistic =',F8.4
     +/1X,'Sign. level =',F8.4,5X,A)     
  350 FORMAT (
     + 'Kolmogorov-Smirnov one sample test',I4,':',2X,A
     +/
     +/'Data:'
     +/A
     +/A
     +/A
     +/A
     +/A
     +/'NX =',I6, ', i.e. no. of x-values'
     +/'H0 = F(x) equals G(y)(x and theory are comparable) against'
     +/'H1 = F(x) not equal to G(y)(x and theory not comparable)'
     +/'D  =',1P,E13.5
     +/'z  =',1P,E13.5
     +/'p  =',0P,F8.4,4X,A
     +/'H2 = F(x) > G(y) (x tend to be smaller than theoretical)'
     +/'D  =',1P,E13.5
     +/'z  =',1P,E13.5
     +/'p  =',0P,F8.4,4X,A
     +/'H3 = F(x) < G(y) (x tend to be  larger than theoretical)'
     +/'D  =',1P,E13.5
     +/'z  =',1P,E13.5
     +/'p  =',0P,F8.4,4X,A)
  355 FORMAT (
     + 'Kolmogorov-Smirnov one sample test',I4,':',2X,A
     +/
     +/'Data:'
     +/A
     +/A
     +/A
     +/A
     +/A
     +/'NX =',1X,A, ', i.e. number of x-values'
     +/'H0 = F(x) equals G(y)(x and theory are comparable) against'
     +/'H1 = F(x) not equal to G(y)(x and theory not comparable)'
     +/'D  =',1X,A
     +/'z  =',1X,A
     +/'p  =',F8.4,4X,A
     +/'H2 = F(x) > G(y) (x tend to be smaller than theoretical)'
     +/'D  =',1X,A
     +/'z  =',1X,A
     +/'p  =',F8.4,4X,A
     +/'H3 = F(x) < G(y) (x tend to be  larger than theoretical)'
     +/'D  =',1X,A
     +/'z  =',1X,A
     +/'p  =',F8.4,4X,A)     
  375 FORMAT (
     + 'Shapiro-Wilks normality test (Note: Bonferroni n = 2):'
     +/'W statistic =',1P,E13.5
     +/'Sign. level =',0P,F8.4,5X,A)
  380 FORMAT (
     + 'Shapiro-Wilks normality test (Note: Bonferroni n = 2):'
     +/'W statistic =',F8.4
     +/'Sign. level =',F8.4,5X,A)     
  400 FORMAT ('Uniform: A =',1X,A,', B =',1X,A)
  500 FORMAT ('Normal:mu =',1P,E10.2,',sigma =',E9.2)
 2500 FORMAT ('Normal:mu =',1X,A,',sigma =',1X,A) 
  600 FORMAT ('Gamma:alpha =',1X,A,',beta =',1X,A)
  700 FORMAT ('Beta: r =',1X,A,', s =',1X,A)
  800 FORMAT ('Binomial: N =',1X,A,', p =',1X,A)
  900 FORMAT ('Negative Exponential: mean =',1P,E10.2)
  950 FORMAT ('Negative Exponential: mean =',1X,A)
 1000 FORMAT ('Poisson: mu =',1P,E10.2)
 1050 FORMAT ('Poisson: mu =',1X,A)
 1100 FORMAT ('Lognorm:mu =',1P,E10.2,',sigma =',E9.2)
 1150 FORMAT ('Lognorm:mu =',1X,A,',sigma =',1X,A) 
 1200 FORMAT ('Weibull:A =',1X,A,',B =',1X,A)
 1300 FORMAT ('    t: N =',1X,A)
 1400 FORMAT ('    Chi-square: N =',1X,A)
 1500 FORMAT ('  F: N =',1X,A,', M =',1X,A)
 1600 FORMAT (
     + 'Plot cdf and sample cumulative'
     +/'Plot pdf and sample histogram'
     +/'Plot normal scores (half)'
     +/'Plot normal scores (full)'
     +/'Quit ... Exit these plotting options')
      END
C
C
