C
C
      SUBROUTINE M_KS2SAM (NOUT, NX, NY,
     +                     X, Y,
     +                     TITLEX, TITLEY)
C
C ACTION : Kolmogorov-Smirnov two sample test
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          28/01/2006 derived from KS2SAM  
C          21/07/2021 added E_NUMBERS and E_FORMATS, etc.   
C   
C          NOUT: (input/unchanged) preconnected unit for results
C            NX: (input/unchanged) sample size for X
C            NY: (input/unchanged) sample size for Y
C             X: (input/unchanged) sample X
C             Y: (input/unchanged) sample Y
C        TITLEX: (input/unchanged) title for X data
C        TITLEY: (input/unchanged) title for Y 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER    NOUT, NX, NY 
      DOUBLE PRECISION X(NX), Y(NY) 
      CHARACTER  TITLEX*(*), TITLEY*(*)
C
C Local allocatable arrays
C                         
      DOUBLE PRECISION, ALLOCATABLE :: U(:), V(:)
C
C Locals
C      
      INTEGER    I, ICOUNT, IERR, IFAIL, NMAX, NTYPE
      INTEGER    ICOLOR, NUMTXT
      PARAMETER (NUMTXT = 21) 
      DOUBLE PRECISION D1, Z1, P1
      DOUBLE PRECISION D2, Z2, P2
      DOUBLE PRECISION D3, Z3, P3
      CHARACTER (LEN = 12) I12(2), FORM12
      CHARACTER (LEN = 13) D13(6), SHOWLJ
      CHARACTER  P1TYPE*23, P2TYPE*23, P3TYPE*23
      CHARACTER  CHOP80*80, TEXT(30)*100
      LOGICAL    E_FORMATS, E_NUMBERS
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   PLEVEL, PUTIFA, TABLE1, CHOP80
      EXTERNAL   G08CDF$
      INTRINSIC  MAX
      SAVE       ICOUNT
      DATA       ICOUNT / 0 / 
C
C Check NX and NY
C      
      IF (NX.LT.2 .OR. NY.LT.2) RETURN
C
C Allocate workspaces
C   
      IERR = 0
      IF (ALLOCATED(U)) DEALLOCATE(U, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
      IF (IERR.NE.0) RETURN
      NMAX = MAX(NX,NY)
      ALLOCATE(U(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(V(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      WRITE (NOUT,'(A)') ' '  
      WRITE (NOUT,'(A)') '***'  
C
C Calculate
C       
      E_NUMBERS = E_FORMATS()
      IFAIL = 1
      NTYPE = 1
      CALL G08CDF$(NX, X, NY, Y, NTYPE, D1, Z1, P1, U, V, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08CDF/KS2SAM')
      IFAIL = 1
      NTYPE = 2
      CALL G08CDF$(NX, X, NY, Y, NTYPE, D2, Z2, P2, U, V, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08CDF/KS2SAM')
      IFAIL = 1
      NTYPE = 3
      CALL G08CDF$(NX, X, NY, Y, NTYPE, D3, Z3, P3, U, V, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08CDF/KS2SAM')
      IF (IFAIL.NE.0) THEN
         DEALLOCATE(U, STAT = IERR)
         DEALLOCATE(V, STAT = IERR)
         RETURN       
      ENDIF   
      ICOUNT = ICOUNT + 1
      CALL PLEVEL (P1, P1TYPE)
      CALL PLEVEL (P2, P2TYPE)
      CALL PLEVEL (P3, P3TYPE)
      IF (E_NUMBERS) THEN
         WRITE (NOUT,100) ICOUNT, TITLEX, TITLEY, NX, NY, D1, Z1, P1,
     +                    P1TYPE, D2, Z2, P2, P2TYPE, D3, Z3, P3, P3TYPE
         WRITE (TEXT,200) ICOUNT, CHOP80(TITLEX), CHOP80(TITLEY),
     +                    NX, NY,
     +                    D1, Z1, P1,
     +                    P1TYPE, D2, Z2, P2, P2TYPE, D3, Z3, P3, P3TYPE
      ELSE
         I12(1) = FORM12(NX)
         I12(2) = FORM12(NY)
         D13(1) = SHOWLJ(D1)
         D13(2) = SHOWLJ(Z1)
         D13(3) = SHOWLJ(D2)
         D13(4) = SHOWLJ(Z2)
         D13(5) = SHOWLJ(D3)
         D13(6) = SHOWLJ(Z3)
         WRITE (NOUT,150) ICOUNT, TITLEX, TITLEY, I12(1), I12(2),
     +                    D13(1), D13(2), P1, P1TYPE,
     +                    D13(3), D13(4), P2, P2TYPE,
     +                    D13(5), D13(6), P3, P3TYPE
         WRITE (TEXT,250) ICOUNT, CHOP80(TITLEX), CHOP80(TITLEY),
     +                    I12(1), I12(2),
     +                    D13(1), D13(2), P1, P1TYPE,
     +                    D13(3), D13(4), P2, P2TYPE,
     +                    D13(5), D13(6), P3, P3TYPE     
      ENDIF  
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.1 .OR. I.EQ.4  .OR. I.EQ.6 .OR. I.EQ.9 .OR.
     +       I.EQ.10 .OR. I.EQ.14 .OR. I.EQ.18) THEN
            ICOLOR = 4
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
C
C Deallocate workspaces
C                      
      DEALLOCATE(U, STAT = IERR)
      DEALLOCATE(V, STAT = IERR)
C
C Format statements
C      
  100 FORMAT (
     +/'Kolmogorov-Smirnov two sample test',I4
     +/'--------------------------------------'
     +/'X-data: ',A
     +/'Y-data: ',A
     +/'NX = ',I6,' Size of X-data'
     +/'NY = ',I6,' Size of Y-data'
     +/'H0 = F(x) is  equal to G(y) (x and y are comparable) against'
     +/'H1 = F(x) not equal to G(y) (x and y not comparable)'
     +/'D  =',1P,E13.5
     +/'z  =',1P,E13.5
     +/'p  =',0P,F8.4,4X,A
     +/'H2 = F(x) > G(y) (x tend to be smaller than y)'
     +/'D  =',1P,E13.5
     +/'z  =',1P,E13.5
     +/'p  =',0P,F8.4,4X,A
     +/'H3 = F(x) < G(y) (x tend to be  larger than y)'
     +/'D  =',1P,E13.5
     +/'z  =',1P,E13.5
     +/'p  =',0P,F8.4,4X,A)
  150 FORMAT (
     +/'Kolmogorov-Smirnov two sample test',I4
     +/'--------------------------------------'
     +/'X-data: ',A
     +/'Y-data: ',A
     +/'NX = ',A,' Size of X-data'
     +/'NY = ',A,' Size of Y-data'
     +/'H0 = F(x) is  equal to G(y) (x and y are comparable) against'
     +/'H1 = F(x) not equal to G(y) (x and y not comparable)'
     +/'D  =',1X,A
     +/'z  =',1X,A
     +/'p  =',F7.4,4X,A
     +/'H2 = F(x) > G(y) (x tend to be smaller than y)'
     +/'D  =',1X,A
     +/'z  =',1X,A
     +/'p  =',F7.4,4X,A
     +/'H3 = F(x) < G(y) (x tend to be  larger than y)'
     +/'D  =',1X,A
     +/'z  =',1X,A
     +/'p  =',F7.4,4X,A)     
  200 FORMAT (
     + 'Kolmogorov-Smirnov two sample test',I4
     +/
     +/'X-data:'
     +/A
     +/'Y-data:'
     +/A
     +/'NX = ',I6,' Size of X-data'
     +/'NY = ',I6,' Size of Y-data'
     +/'H0 = F(x) is  equal to G(y) (x and y are comparable) against'
     +/'H1 = F(x) not equal to G(y) (x and y not comparable)'
     +/'D  =',1P,E13.5
     +/'z  =',1P,E13.5
     +/'p  =',0P,F8.4,4X,A
     +/'H2 = F(x) > G(y) (x tend to be smaller than y)'
     +/'D  =',1P,E13.5
     +/'z  =',1P,E13.5
     +/'p  =',0P,F8.4,4X,A
     +/'H3 = F(x) < G(y) (x tend to be  larger than y)'
     +/'D  =',1P,E13.5
     +/'z  =',1P,E13.5
     +/'p  =',0P,F8.4,4X,A)
  250 FORMAT (
     + 'Kolmogorov-Smirnov two sample test',I4
     +/
     +/'X-data:'
     +/A
     +/'Y-data:'
     +/A
     +/'NX = ',A,' Size of X-data'
     +/'NY = ',A,' Size of Y-data'
     +/'H0 = F(x) is  equal to G(y) (x and y are comparable) against'
     +/'H1 = F(x) not equal to G(y) (x and y not comparable)'
     +/'D  =',1X,A
     +/'z  =',1X,A
     +/'p  =',F7.4,4X,A
     +/'H2 = F(x) > G(y) (x tend to be smaller than y)'
     +/'D  =',1X,A
     +/'z  =',1X,A
     +/'p  =',F7.4,4X,A
     +/'H3 = F(x) < G(y) (x tend to be  larger than y)'
     +/'D  =',1X,A
     +/'z  =',1X,A
     +/'p  =',F7.4,4X,A)     
      END
C
C
