c
c
      subroutine m_l1norm (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     fnamea, titlea)
c
c action: multilinear regression in the L_1 norm
c         20/07/2006 derived from m_linear
c
c Note: all arguments are input/unchanged
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  fnamea*(*), titlea*(*)
c
c local allocatable arrays
c
      integer, allocatable :: indx(:), isx(:)
      double precision, allocatable :: a2(:,:), b(:), res(:),
     +                                 theory(:), wk(:), x(:)
c
c locals
c
      integer    i, ierr, nwmax
      double precision zero
      parameter (zero = 0.0d+00)
      character  line*100
      external   l1norm, putfat
c
c check
c
      if (ncol.lt.3 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate workspaces
c
      ierr = 0
      if (allocated(indx)) deallocate(indx, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(isx)) deallocate(isx, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(a2)) deallocate(a2, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(res)) deallocate(res, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(theory)) deallocate(theory, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(wk)) deallocate(wk, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      allocate(indx(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(isx(ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(a2(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(b(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(res(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(theory(nrmax), stat = ierr)
      if (ierr.ne.0) return
      nwmax = 3*nrmax + 5*ncmax + ncmax*ncmax +
     +        (ncmax + 1)*(ncmax + 2)/2
      allocate(wk(nwmax))
      if (ierr.ne.0) return
      allocate(x(ncmax), stat = ierr)
      if (ierr.ne.0) return
      do i = 1, nrow
         if (a(i,ncol).lt.zero) then
            write (line,200) i
            call putfat (line)
            deallocate(indx, stat = ierr)
            deallocate(isx, stat = ierr)
            deallocate(a2, stat = ierr)
            deallocate(b, stat = ierr)
            deallocate(res, stat = ierr)
            deallocate(theory, stat = ierr)
            deallocate(wk, stat = ierr)
            deallocate(x, stat = ierr)
            return
         endif
      enddo
c
c call l1norm for calculations
c
      call l1norm (indx, isx, ncmax, ncol, nout, nrmax, nrow,
     +             a, a2, b, res, theory, wk, x,
     +             fnamea, titlea)
c
c deallocate workspaces
c
      deallocate(indx, stat = ierr)
      deallocate(isx, stat = ierr)
      deallocate(a2, stat = ierr)
      deallocate(b, stat = ierr)
      deallocate(res, stat = ierr)
      deallocate(theory, stat = ierr)
      deallocate(wk, stat = ierr)
      deallocate(x, stat = ierr)
c
c format statements
c
  100 format ('Must have no. columns >= 3 and no. rows >= 2')
  200 format ('s < 0 at data point',i6)
      end
c
c
