c
c
      subroutine m_ldlc50 (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     fnamea, titlea,
     +                     newdat)
c
c action: bioassay
c author: w.g.bardsley, university of manchester, u.k.
c         14/02/2006 derived from m_contin
c
c Note: all arguments are input/unchanged except for newdat
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  fnamea*(*), titlea*(*)
      logical    newdat
c
c local allocatable arrays
c
      double precision, allocatable :: b(:,:), t(:), x(:,:), y(:)
c
c locals
c
      integer    i, ierr, j, nin
      parameter (nin = 3)
      character  line*100
      logical    supply
      parameter (supply = .true.)
      external   ldlc50, putfat
c
c check
c
      if (ncol.lt.3 .or. ncol.gt.4 .or. nrow.lt.3) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate workspaces (ncmax > ncol, nrmax > nrow)
c
      ierr = 0
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(t)) deallocate(t, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y)) deallocate(y, stat = ierr)
      if (ierr.ne.0) return
      allocate(b(nrmax,4), stat = ierr)
      if (ierr.ne.0) return
      allocate(t(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(x(nrmax,1), stat = ierr)
      if (ierr.ne.0) return
      allocate(y(nrmax), stat = ierr)
      if (ierr.ne.0) return
c
c call ldlc50 for calculations
c
      do j = 1, ncol
         do i = 1, nrow
            b(i,j) = a(i,j)
         enddo
      enddo
      call ldlc50 (ncol, nin, nout, nrmax, nrow,
     +             b, t, x, y,
     +             fnamea, titlea,
     +             newdat, supply)
c
c deallocate workspaces
c
      deallocate(b, stat = ierr)
      deallocate(t, stat = ierr)
      deallocate(x, stat = ierr)
      deallocate(y, stat = ierr)
c
c format statements
c
  100 format ('Must have no. rows >= 3 and 3 =< no. columns =< 4')
      end
c
c
