c
c
      subroutine m_lufact (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     titlea)
c
c action: LU factorisation
c author: w.g.bardsley, university of manchester, u.k., 05/02/2006
c
c Note: all arguments are input/unchanged
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  titlea*(*)
c
c local allocatable arrays
c
      integer, allocatable :: nwork(:)
      double precision, allocatable :: b(:,:), w(:)
c
c locals
c
      integer    i, ierr, j, nin
      parameter (nin = 3)
      character  line*100
      logical    abort, disply, fileit, supply
      parameter (disply = .true., fileit = .true., supply = .true.)
      external   lufact, putfat
c
c check
c
      if (ncol.lt.2 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate workspaces
c
      ierr = 0
      if (allocated(nwork)) deallocate(nwork, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w)) deallocate(w, stat = ierr)
      if (ierr.ne.0) return
      allocate(nwork(2*nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(b(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(w(4*nrmax), stat = ierr)
      if (ierr.ne.0) return
c
c call lufact for calculations
c
      do j = 1, ncol
         do i = 1, nrow
            b(i,j) = a(i,j)
         enddo
      enddo
      call lufact (ncmax, ncol, nin, nout, nrmax, nrow, nwork,
     +             b, w,
     +             titlea,
     +             abort, disply, fileit, supply)
c
c deallocate workspaces
c
      deallocate(nwork, stat = ierr)
      deallocate(b, stat = ierr)
      deallocate(w, stat = ierr)
c
c format statements
c
  100 format ('Must have no. rows >= 2 and no. columns >= 2')
      end
c
c
