c
c
      subroutine m_matone (isend, ncol, nin, nout, nrow,
     +                     fnamea, titlea)
c
c action: install a matrix then call the program indicated by isend
c author: w.g.bardsley, university of manchester, u.k.
c         derived from m_vecone 05/02/2006
c         26/07/2006 added calls to subroutine m_matone_check
c         23/11/2006 added intents and introduced simdir 
c         25/01/2007 replaced simdir by sim256
c         20/08/2007 added m_kencon
c         22/09/2007 added m_trinom
c         02/10/2007 added m_surv01
c         12/10/2007 now allows mat4in to create temporary fnamea with new titlea
c         31/01/2008 introduced showit to limit repeat advice to users
c         09/08/2008 added call to m_ttest3, and fnamea in call to m_matexh
c         12/08/2008 added call to nprows 
c         16/06/2009 added call to m_cross1
c         10/05/2010 introduced NKLCFG to switch on/off the test file advice
c         30/04/2011 introduced call to TFILEQ
c         10/08/2011 introduced call to PSEUDI
c         24/06/2014 changed McNemar from 3 by 3 to 2 by 2
c         05/02/2017 added call to FDRMAT
c         05/06/2018 added INTER1 and INTER2
c
c   isend: (input/unchanged) as follows:
c           isend = 1: square matrix analysis
c           isend = 2: SVD
c           isend = 3: LU factors
c           isend = 4: QR factors
c           isend = 5: CH factors
c           isend = 6: exhaustive analysis of a matrix
c           isend = 7: multivariate normal matrix
c           isend = 8: contingency tables
c           isend = 9: McNeMar test  
c           isend = 10: Cochran Q test
c           isend = 11: Cox regression
c           isend = 12: Bioassay e.g. LD50
c           isend = 13: Analysis of proportions
c           isend = 14: Meta analysis
c           isend = 15: least squares line line (simple)
c           isend = 16: reduced major axis line (simple)
c           isend = 17: major axis/orthogonal line (simple)
c           isend = 18: least squares line (comprehensive)
c           isend = 19: reduced major axis line (comprehensive)
c           isend = 20: major axis/orthogonal line (comprehensive)
c           isend = 21: fit a line/calibrate (simple)
c           isend = 22: fit a line/calibrate (advanced)
c           isend = 23: fit a polynomial/calibrate (x,y)
c           isend = 24: fit a polynomial/calibrate (g(x),f(y))
c           isend = 25: multilinear regression
c           isend = 26: robust regression
c           isend = 27: L_1 norm regression 
c           isend = 28: L_infinity norm regression 
c           isend = 29: regression on ranks  
c           isend = 30: orthogonal rotation
c           isend = 31: Kendall concordance
c           isend = 32: trinomial plot
c           isend = 33: survival analysis  
c           isend = 34: row-wise t tests
c           isend = 35: row-wise Mann-Whitney/Kolmogorov-Smirnov tests
c           isend = 36: auto- and cross-correlation matrices
c           isend = 37: pseudo inverse 
c           isend = 38: false discovery rate for a matrix
c           isend = 39: smooth interpolation: single valued
c           isend = 40: smooth interpolation: parametric
c
c    ncol: (input/output) column size   
c     nin: (input/unchanged) unconnected unit for data input
c    nout: (input/unchanged) preconnected unit for results
c    nrow: (input/output) row size
c  fnamea: (input/output) data file name
c  titlea: (input/output) data title
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: isend, nin, nout 
      integer,             intent (inout) :: ncol, nrow
      character (len = *), intent (inout) :: fnamea, titlea
c
c Local allocatable array
c
      double precision, allocatable :: a(:,:)
c
c locals
c
      integer    ierr, jsend, ncmax, ncol1, nrmax, nrow1
      integer    ncadd, nradd
      integer    kval9, nklcfg
      integer    mark20, nitems, n1, n21
      parameter (mark20 = 20, nitems = 40, n1 = 1, n21 = 21)
      integer    ncsav(nitems), nrsav(nitems)
      character  no_data*30, no_file*30, sim256*1024
      parameter (no_data = 'No data',
     +           no_file = 'No file')
      character  header(nitems)*80, line*100, tfiles(nitems)*15,
     +           word15*15    
      logical    showit(nitems)  
      logical    abort, fixcol, fixrow, label, newdat, repeet
      parameter (fixcol = .false., fixrow = .false., label = .true.)
      external   isitmf, mat2in, mat3in, mat4in, chknag, sim256
      external   m_matrix, m_svdval, m_lufact, m_qrfact, m_chfact,
     +           m_matexh, m_mvnor1, m_contin, m_mcnmar, m_cochrq,
     +           m_coxreg, m_ldlc50, m_meta01, m_meta02, m_orthog,
     +           m_pol000, m_linear, m_rob003, m_l1norm, m_linorm,
     +           m_regran, m_orotat, m_kencon, m_trinom, m_surv01,
     +           m_ttest3, m_nprows, m_cross1     
      external   m_matone_check
      external   inter1, inter2
      external   nklcfg, tfileq, pseudi, fdrmat
      save       ncsav, nrsav, header, tfiles, showit
      data       showit / nitems*.true. /
      data       ncsav /  5,  4,  5,  5,  4,  8,  8,  2,  2,  6,
     +                    6,  3,  3,  3,  2,  2,  2,  2,  2,  2, 
     +                    3,  3,  3,  3,  6,  4,  6,  6,  5,  3,
     +                   10,  3,  3, 13, 13,  2,  5,  4,  2,  2  / 
      data       nrsav /  5,  6,  5,  7,  4, 12, 12,  2,  2,  8,
     +                   50, 10,  5, 16,  8, 25, 25, 25, 25, 25,  
     +                   40, 40, 18, 18, 13,  8, 13, 13, 20, 10,
     +                    3,  4, 20,  5,  5, 48,  6,  3, 11,  9  /          
      data       header /
     +'Square matrix analysis',                 !1
     +'Singular value decomposition',           !2
     +'LU factors',                             !3
     +'QR factors',                             !4
     +'Cholesky factors',                       !5
     +'Exhaustive analysis of a matrix',        !6 
     +'Multivariate normal analysis',           !7
     +'Analysis of contingency tables',         !8 
     +'McNeMar test',                           !9
     +'Cochran Q test',                         !10
     +'Cox regression',                         !11
     +'Bioassay, e.g. LD50',                    !12
     +'Analysis of proportions',                !13
     +'Meta Analysis',                          !14
     +'Least squares line (simple)',            !15
     +'Reduced major axis line (simple)',       !16
     +'Major axis/orthogonal line (simple)',    !17
     +'Least squares line (advanced)',          !18
     +'Reduced major axis line (advanced)',     !19 
     +'Major axis/orthogonal line (advanced)',  !20 
     +'Fit a line/calibrate (simple)',          !21
     +'Fit a line/calibrate (advanced)',        !22
     +'Fit a polynomial/calibrate (x,y)',       !23
     +'Fit a polynomial/calibrate (g(x),f(y))', !24
     +'Multilinear regression',                 !25
     +'Robust regression (M-estimates)',        !26
     +'L_1 norm regression',                    !27
     +'L_infinity norm regression',             !28
     +'Regression on ranks',                    !29
     +'Orthogonal rotation',                    !30
     +'Kendall concordance',                    !31      
     +'Trinomial confidence regions',           !32
     +'Analyse one sample of survival times',   !33
     +'Row-wise matrix t tests',                !34
     +'Row-wise nonparametric tests',           !35
     +'Auto- and cross-correlation matrices',   !36
     +'Pseudo inverse',                         !37
     +'False discovery rates',                  !38
     +'Smooth interpolation: y = f(x)',         !39
     +'Smooth interpolation: x(t), y(t)'     /  !40
       data      tfiles /
     +'matrix.tf1',    !1  
     +'f08kff.tf1',    !2
     +'matrix.tf1',    !3
     +'matrix.tf2',    !4
     +'matrix.tf3',    !5
     +'cluster.tf1',   !6
     +'cluster.tf1',   !7
     +'chisqd.tf4',    !8
     +'mcnemar.tf1',   !9 
     +'cochranq.tf1',  !10
     +'cox.tf4',       !11
     +'ld50.tf1',      !12
     +'binomial.tf3',  !13
     +'meta.tf1',      !14
     +'g02caf.tf1',    !15
     +'swarm.tf1',     !16
     +'swarm.tf1',     !17
     +'line.tf2',      !18
     +'swarm.tf1',     !19
     +'swarm.tf1',     !20 
     +'line.tf1',      !21
     +'line.tf1',      !22
     +'polnom.tf1',    !23
     +'polnom.tf1',    !24
     +'linfit.tf2',    !25
     +'g02haf.tf1',    !26
     +'linfit.tf2',    !27
     +'linfit.tf2',    !28
     +'g08raf.tf1',    !29
     +'g03baf.tf1',    !30    
     +'g08daf.tf1',    !31   
     +'trinom.tf1',    !32
     +'survive.tf2',   !33 
     +'ttest.tf6',     !34
     +'ttest.tf6',     !35
     +'g13dmf.tf1',    !36
     +'f01blf.tf1',    !37
     +'matrix_p.tf1',  !38
     +'j06caf.tf1',    !39
     +'j06ccf.tf1'   / !40
c
c check isend then initialise ncadd and nradd
c 
      if (isend.lt.1  .or. isend.gt.nitems) return
      if (isend.eq.26 .or. isend.eq.29) then
         call chknag (mark20,
     +                abort)
         if (abort) return
      endif           
      ncadd = 2
      nradd = 2   
c
c------------------------------------------------------------
c Start of code to access a matrix
c------------------------------------------------------------
c  
      if (ncol.le.0 .or. nrow.le.0) then         
         fnamea = sim256 (tfiles(isend))
         ncol = ncsav(isend)
         nrow = nrsav(isend)
      endif   
      repeet = .true.
      do while (repeet)
c
c Step 1: if ncol > 0 and nrow > 0 check if fname supplied is a current matrix file
c ======= isitmf returns ncol1 > 0 and nrow1 > 0 if fnamea is a vector file
c
         ncol1 = 0
         nrow1 = 0
         if (ncol.gt.0 .and. nrow.gt.0) call isitmf (ncol1, nrow1,
     +                                               fnamea)
c
c Step 2: if fnamea is not a matrix file of correct size try to open a file
c ======= mat3in selects a matrix file of size nrow1 > 0 by ncol1 > 0 if successful
c
         if (ncol1.le.0 .or. nrow1.le.0 .or.
     +       ncol1.ne.ncol .or. nrow1.ne.nrow) then
            ncol = 0
            nrow = 0
            fnamea = no_file
            titlea = no_data
            jsend = 3
            close (unit = nin)
            if (showit(isend)) then
               kval9 = nklcfg(n21)
               if (kval9.eq.n1) then
                  word15 = tfiles(isend)(1:15)
                  write (line,100) word15
                  call tfileq (line)
                  showit(isend) = .false.
               endif   
            endif   
            call mat3in (jsend, ncol1, nin, nrow1,
     +                   fnamea, titlea,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (abort) then
               ncol = 0
               nrow = 0
               fnamea = no_file
               titlea = no_data
               return
            endif
         endif
c
c Check if file is suitable
c            
         call m_matone_check (isend, ncol1, nrow1,
     +                        fnamea)
         if (ncol1.le.0 .or. nrow1.le.0) then
            ncol = 0
            nrow = 0
            fnamea = no_file
            titlea = no_data
            return
         endif   
c
c Step 3: we now have a matrix file of size nrow > 0 by ncol > 0 so allocate workspaces
c ======  if there is any error then ierr is nonzero and exit happens
c
         ncol = ncol1
         nrow = nrow1
         ierr = 0
         if (allocated(a)) deallocate(a, stat = ierr)
         if (ierr.ne.0) return
         ncmax = ncol + ncadd
         nrmax = nrow + nradd
         if (isend.eq.11) then 
            allocate(a(nrmax,ncmax + 7), stat = ierr)
         else   
            allocate(a(nrmax,ncmax), stat = ierr)
         endif   
         if (ierr.ne.0) return

c
c Step 4: read in the data consisting of nrow by ncol points from file fnamea
c ======= if an error occurs then workspaces are deallocated and exit occurs
c         otherwise fnamea and titlea are not changed from now on
c
         close (unit = nin)
         call mat2in (nin, ncmax, ncol, nrmax, nrow,
     +                a,
     +                fnamea, titlea,
     +                abort)
         close (unit = nin)
         if (abort) then
            deallocate (a, stat = ierr)
            ncol = 0
            nrow = 0
            fnamea = no_file
            titlea = no_data
            return
         endif
c
c Step 5: see what the user wants to do ... fnamea and titlea may change in mat4in
c ======= mat4in is the equivalent of vecone oferring as follows:
c         abort = .true. on return: deallocate workspaces then exit
c         newdat = .true. on return: try for a new data set
c         newdat = .false. on return: proceed with original or edited data
c         If the data are edited fname and titlea are changed
c
         call mat4in (ncmax, ncol, nrmax, nrow,
     +                a,
     +                fnamea, header(isend), titlea,
     +                abort, newdat)
         if (abort) then
c
c Option 1 on return from mat4in: Deallaocate then exit
c --------
c
            deallocate (a, stat = ierr)
            return
         elseif (newdat) then
c
c Option 2 on return from from mat4in: New data
c --------
c
            fnamea = no_file
            titlea = no_data
            ncol = 0
            nrow = 0
         else
c
c Option 3 on return from from mat4in: Proceed to analysis
c --------
c  
            ncol1 = ncol
            nrow1 = nrow
            newdat = .false. 
            if (isend.eq.1) then
               call m_matrix (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        titlea)
            elseif (isend.eq.2) then
               call m_svdval (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        titlea)
            elseif (isend.eq.3) then
               call m_lufact (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        titlea) 
            elseif (isend.eq.4) then
               call m_qrfact (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        titlea) 
            elseif (isend.eq.5) then
               call m_chfact (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        titlea) 
            elseif (isend.eq.6) then
               call m_matexh (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea) 
            elseif (isend.eq.7) then
               call m_mvnor1 (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        titlea,
     +                        newdat)
            elseif (isend.eq.8) then
               call m_contin (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        titlea,
     +                        newdat) 
            elseif (isend.eq.9) then
               call m_mcnmar (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        titlea,
     +                        newdat)
            elseif (isend.eq.10) then
               call m_cochrq (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        titlea)
            elseif (isend.eq.11) then
               call m_coxreg (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea,
     +                        newdat) 
            elseif (isend.eq.12) then
               call m_ldlc50 (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea,
     +                        newdat)
            elseif (isend.eq.13) then
               call m_meta01 (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea)
            elseif (isend.eq.14) then
               call m_meta02 (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea)
            elseif (isend.ge.15 .and. isend.le.20) then
               jsend = isend - 14
               call m_orthog (jsend, ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        titlea)
            elseif (isend.ge.21 .and. isend.le.24) then
               jsend = isend - 20
               call m_pol000 (jsend, ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea)
            elseif (isend.eq.25) then
               call m_linear (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea)
            elseif (isend.eq.26) then
               call m_rob003 (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea)
            elseif (isend.eq.27) then
               call m_l1norm (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea)  
            elseif (isend.eq.28) then
               call m_linorm (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea)  
            elseif (isend.eq.29) then
               call m_regran (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea,
     +                        newdat)
            elseif (isend.eq.30) then
               call m_orotat (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        titlea,
     +                        newdat)
            elseif (isend.eq.31) then
               call m_kencon (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea,
     +                        newdat)
            elseif (isend.eq.32) then
               call m_trinom (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea,
     +                        newdat)
            elseif (isend.eq.33) then
               call m_surv01 (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea)
            elseif (isend.eq.34) then
               call m_ttest3 (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea,
     +                        newdat)
            elseif (isend.eq.35) then
               call m_nprows (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea,
     +                        newdat)
            elseif (isend.eq.36) then
               call m_cross1 (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea,
     +                        newdat)
            elseif (isend.eq.37) then
               call pseudi (ncol1, nout, nrmax, nrow1,
     +                      a,
     +                      newdat) 
            elseif (isend.eq.38) then
               call fdrmat (ncol1, nout, nrmax, nrow1,
     +                      a,
     +                      titlea)   
            elseif (isend.eq.39) then
               call inter1 (ncol1, nrmax, nrow1,
     +                      a,
     +                      newdat) 
            elseif (isend.eq.40) then
               call inter2 (ncol1, nrmax, nrow1,
     +                      a,
     +                      newdat)                                                   
            endif
            if (.not.newdat) then
               deallocate(a, stat = ierr)
               return
            endif  
         endif
 
      enddo
c------------------------------------------------------------
c End of code to access a matrix
c------------------------------------------------------------
c
  100 format ('Now input a file formatted like',1x,a)
      end
c
c        
c------------------------------------------------------------
c
c
      subroutine m_matone_check (isend, ncol, nrow,
     +                           fname)
c
c action: check ncol and nrow depending upon isend
c author: bill.bardsley@manchester.ac.uk.,26/07/2006
c
c  isend: (input/unchanged) action required
c   ncol: (input/output)
c   nrow: (input/output) 
c  fname: (input/unchanged)
c
      implicit  none
c
c arguments
c          
      integer   isend, ncol, nrow
      character fname*(*)
c
c locals
c        
      integer   k 
      character line*100
      logical   abort
      external  putfat, vu2chk
c
c preliminary check
c      
      if (ncol.lt.2 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         ncol = 0
         nrow = 0  
         call vu2chk (fname)
         return
      endif  
c
c now checks depending on isend
c         
      abort = .false.     
      if (isend.eq.1 .or. isend.eq.5 .or. isend.eq.9) then
c
c square matrix requires n = m 
c      
         if (ncol.ne.nrow) then
            write (line,200)
            abort = .true.
         endif      
      elseif (isend.eq.7) then
c
c multivariate normal
c                    
         if (ncol.ge.nrow) then
            write (line,300)
            abort = .true.
         endif   
      elseif (isend.eq.10) then
c
c Cochran Q
c      
         if (ncol.lt.3 .or. nrow.lt.3) then
            write (line,400)
            abort = .true.
         endif                          
      elseif (isend.eq.12) then
c
c LD50
c     
         if (ncol.lt.3 .or. ncol.gt.4) then
            write (line,500)
            abort = .true.
         endif           
      elseif (isend.eq.13) then
c
c ANOVAP
c       
         if (ncol.lt.2 .or. ncol.gt.3) then
            write (line,600)
            abort = .true.
         endif                  
      elseif (isend.eq.14) then
c
c Meta Analysis
c              
                 
         k = 2*(nrow/2)
         if (ncol.lt.2 .or. ncol.gt.3 .or. k.ne.nrow) then
            write (line,700)
            abort = .true.
         endif 
      elseif (isend.ge.15 .and. isend.le.24) then 
c
c straight line fitting requires x, y, s
c      
         if (ncol.lt.2 .or. ncol.gt.3 .or. nrow.lt.3) then
            write (line,800)
            abort = .true.
         endif    
      elseif (isend.ge.25 .and. isend.le.28) then
c
c multilinear regression requires x1, x2, ..., xm, y, s
c      
         if (ncol.lt.3) then
            write (line,900)
            abort = .true.
         elseif (nrow.le.ncol - 2) then
            write (line,1000)
            abort = .true.
         endif 
      elseif (isend.eq.11 .or. isend.eq.29) then
c
c Cox and regression on ranks regression requires x1, x2, ..., xm, y, t, s
c      
         if (ncol.lt.4) then
            write (line,1100)
            abort = .true.
         elseif (nrow.le.ncol - 3) then
            write (line,1200)
            abort = .true.
         endif
      elseif (isend.eq.32) then
c
c trinomial confidence regions
c                  
         if (ncol.ne.3) then
            write (line,1300)
            abort = .true.
         endif  
      elseif (isend.eq.34 .or. isend.eq.35) then
c
c row-wise t tests
c          
         if (ncol.lt.4) then
            write (line,1400)
            abort = .true.
         endif 
      elseif (isend.eq.36) then   
c
c auto- and cross-correlation matrices
c            
      if (ncol.ne.2 .or. nrow.lt.4) then
            write (line,1500)
            abort = .true.
         endif 
      endif
      if (abort) then
         call putfat (line)
         call vu2chk (fname)
         ncol = 0
         nrow = 0
      endif                      
  100 format ('Must have no. rows > 1, and no. columns > 1')    
  200 format ('Must have no. rows = no. columns > 1')
  300 format ('Must have no. rows > no. columns')
  400 format ('Must have no. rows > 2, and no. columns > 2')
  500 format ('Must have either y,N,x, or else x,y,N,s format')
  600 format ('Must have either y,N, or else y,N,x format')
  700 format ('Must have k sets of y,N, or else y,N,x formats')
  800 format ('Must have x,y, or x,y,s format, and n > 2')
  900 format ('Must have >= 3 columns, formatted as x1,x2,...,xm,y,s')
 1000 format ('Must have no. rows > no. columns - 2')
 1100 format ('Must have >= 4 columns, formatted as x1,x2,...,xm,y,t,s')
 1200 format ('Must have no. rows > no. columns - 3')
 1300 format ('Must have 3 columns: x, y, and N = x + y + z')
 1400 format ('Must have at least 2 X and 2 Y values, i.e. ncols > 3')
 1500 format ('Must have no. rows > 4 and no. ncols = 2')
      end               
c
c
      
                            