c
c
      subroutine m_matrix (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     titlea)
c
c action: square matrix calculations
c author: w.g.bardsley, university of manchester, u.k., 05/02/2006
c
c Note: all arguments are input/unchanged
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  titlea*(*)
c
c local allocatable arrays
c
      integer, allocatable :: nwork(:)
      double precision, allocatable :: b(:,:), u(:), v(:), w(:)
c
c locals
c
      integer    ierr, nin
      parameter (nin = 3)
      double precision det
      character  line*100
      logical    abort, disply, fileit, supply
      parameter (disply = .true., fileit = .true., supply = .true.)
      external   matrix, putfat
c
c check
c
      if (ncol.lt.2 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
      if (ncol.ne.nrow) then
         write (line,200)
         call putfat (line)
         return
      endif
c
c allocate workspaces
c
      ierr = 0
      if (allocated(nwork)) deallocate(nwork, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(u)) deallocate(u, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(v)) deallocate(v, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w)) deallocate(w, stat = ierr)
      if (ierr.ne.0) return
      allocate(nwork(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(b(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(u(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(v(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(w(4*nrmax), stat = ierr)
      if (ierr.ne.0) return
c
c call matrix for calculations
c
      call matrix (ncmax, ncol, nin, nout, nrmax, nrow, nwork,
     +             a, b, det, u, v, w,
     +             titlea,
     +             abort, disply, fileit, supply)
c
c deallocate workspaces
c
      deallocate(nwork, stat = ierr)
      deallocate(b, stat = ierr)
      deallocate(u, stat = ierr)
      deallocate(v, stat = ierr)
      deallocate(w, stat = ierr)
c
c format statements
c
  100 format ('Must have no. rows >= 2 and no. columns >= 2')
  200 format ('Must have no. rows = no. columns')
      end
c
c
