C
C
      SUBROUTINE M_MATTWO (ISEND, NCOLA, NCOLB, NIN, NOUT, NROWA, NROWB,
     +                     FNAMEA, FNAMEB, TITLEA, TITLEB)
C
C ACTION : Analyse two matrices
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          25/02/2006 derived from M_MATVEC
C          02/08/2006 made NEWDAT an array         
C          23/11/2006 added INTENTS and introduced SIMDIR  
C          25/01/2007 replaced SIMDIR by SIM256 
C          06/03/2007 corrected dimensioning before call to MAT2IN
C          04/10/2007 replaced VIEWIT by VIEWER and added call to SURV02
C          02/08/2012 introduced NCOL_MIN, NROW_MIN
C          02/01/2017 added directed correlation
C
C         ISEND: (input/unchanged) as follows:
C                ISEND = 1: Matrix multiplication
C                ISEND = 2: Symmetric eigenvalue problem
C                ISEND = 3: Procrustes
C                ISEND = 4: Analyse two samples of survival times
C                ISEND = 5: Directed correlation 
C                ISEND = 6:
C                ISEND = 7:
C         NCOLA: (input/output) column dimension of matrix A
C         NCOLB: (input/output) column dimension of matrix B
C           NIN: (input/unchanged) unconnected unit for data input
C          NOUT: (input/unchanged) preconnected unit for results
C         NROWA: (input/output) row dimension of matrix A
C         NROWB: (input/output) row dimension of matrix A
C        FNAMEA: (input/output) file name for A data
C        FNAMEB: (input/output) file name for B data
C        TITLEA: (input/output) A-title
C        TITLEB: (input/output) B-title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND, NIN, NOUT   
      INTEGER,             INTENT (INOUT) :: NCOLA, NCOLB, NROWA, NROWB
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAMEA, FNAMEB,
     +                                       TITLEA, TITLEB

C
C Local allocatable workspaces
C
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:), B(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: A1(:,:), B1(:,:)
C
C Locals
C
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NSTART, NTEXT, NUMOPT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NSTART = 15,
     +           NUMOPT = 7)
      INTEGER    N0, N1, N2, N3, N4, N5, N8
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N8 = 8)
      INTEGER    NCMAX, NCMAXA, NCMAXB, NCOL, NRMAX, NRMAXA, NRMAXB,
     +           NROW
      INTEGER    NCOL_MIN, NROW_MIN
      INTEGER    NCADD, NRADD
      PARAMETER (NCADD = 2, NRADD = 2) 
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    I, IERR, J, JSEND
      INTEGER    ICOUNT(N3), LEN200, NWIDE
      CHARACTER (LEN = 1024) FNAME, SIM256
      CHARACTER (LEN = 100 ) LINE, TEXT(30)
      CHARACTER (LEN = 80  ) CHOP80, TITLE, TRIM80
      CHARACTER (LEN = 80  ) ATITLE, AFNAME, BTITLE, BFNAME
      CHARACTER (LEN = 60  ) NODATA
      CHARACTER (LEN = 50  ) HEADER(N5)
      CHARACTER (LEN = 40  ) ULINE, WORD40
      CHARACTER (LEN = 30  ) NOFILE, NREADY, READY, STATE
      CHARACTER (LEN = 12  ) FORM12, FORM12_NCOLA, FORM12_NROWA,
     +                       FORM12_NCOLB, FORM12_NROWB
      CHARACTER (LEN = 4   ) BLANK4, STAR4, OPTION(2)
      CHARACTER (LEN = 1   ) BLANK
      PARAMETER (BLANK = ' ',
     +           NODATA = '(...No data...)',
     +           NOFILE = 'No file',
     +           NREADY = '(..Not ready..)',
     +            READY = '(*** Ready ***)' )
      PARAMETER (BLANK4 = '    ', STAR4 = '****')
      PARAMETER (ULINE = '----------------------------------------')
      LOGICAL    ABORT, NEWDAT(2), REPEET
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      LOGICAL    LABEL
      PARAMETER (LABEL = .TRUE.)
      LOGICAL    FIXCOL, FIXROW
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   PUTADV, PUTFAT, LBOX01, CHOP80, PATCH1, MAT2IN, MAT3IN,
     +           ISITMF, MATMUL, SYMEIG, VIEWER, TRIM80, LEN200, 
     +           M_PROTAT, SIM256, SURV02, FORM12, DRCORR   
      SAVE       HEADER, ICOUNT
      DATA       ICOUNT / 0, 0, 0 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       HEADER /
     +'Matrix multiplication',
     +'Symmetric eigenvalue problem',
     +'Procrustes rotation',
     +'Analyse two samples of survival times',
     +'Directed correlation'  / 
C
C Check ISEND and assign NCOL_MIN and NROW_MIN
C     
      IF (ISEND.EQ.N1) THEN
C
C Matrix multiplication allowing for vectors
C        
         NCOL_MIN = 1
         NROW_MIN = 1
      ELSEIF (ISEND.EQ.N2) THEN
C
C Symmetric eigenvalue problem requires matrices
C      
         NCOL_MIN = 2
         NROW_MIN = 2
      ELSEIF (ISEND.EQ.N3) THEN
C
C Procrustes rotation requires matrices
C      
         NCOL_MIN = 2
         NROW_MIN = 2
      ELSEIF (ISEND.EQ.N4) THEN
C
C Survival times require 3 columns
C      
         NCOL_MIN = 3
         NROW_MIN = 2
      ELSEIF (ISEND.EQ.N5) THEN
C
C Directed correlation
C      
         NCOL_MIN = 1
         NROW_MIN = 2   
      ELSE
         RETURN
      ENDIF     
C
C Deallocate workspaces
C
      IERR = 0
      IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(B1)) DEALLOCATE(B1, STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Check input data using ISITMF and initialise
C                                            
      IF (NCOLA.LE.N0 .OR. NROWA.LE.N0) THEN
         IF (ISEND.LE.N2) THEN
            NCOLA = 4
            NROWA = 4
            FNAMEA = SIM256('matrix.tf4')
         ELSEIF (ISEND.EQ.N3) THEN
            NCOLA = 2
            NROWA = 3
            FNAMEA = SIM256('g03bcf.tf1')
         ELSEIF (ISEND.LE.N4) THEN
            NCOLA = 3
            NROWA = 18
            FNAMEA = SIM256('survive.tf3')   
         ELSEIF (ISEND.EQ.N5) THEN
            NCOLA = 3
            NROWA = 30
            FNAMEA = SIM256('matrix_a.tf1')   
         ENDIF      
      ENDIF
      IF (NCOLB.LE.N0 .OR. NROWB.LE.N0) THEN
         IF (ISEND.LE.N2) THEN
            NCOLB = 4
            NROWB = 4
            FNAMEB = SIM256('matrix.tf3')
         ELSEIF (ISEND.EQ.N3) THEN 
            NCOLB = 2
            NROWB = 3
            FNAMEB = SIM256('g03bcf.tf2')
         ELSEIF (ISEND.LE.N4) THEN
            NCOLB = 3
            NROWB = 12
            FNAMEB = SIM256('survive.tf4')
         ELSEIF (ISEND.EQ.N5) THEN  
            NCOLB = 4
            NROWB = 30
            FNAMEB = SIM256('matrix_b.tf1')      
         ENDIF   
      ENDIF
      IF (NCOLA.GE.NCOL_MIN .AND. NROWA.GE.NROW_MIN) THEN
         CALL ISITMF(I, J,
     +               FNAMEA)
         IF (I.EQ.NCOLA .AND. J.EQ.NROWA) THEN 
            NCMAXA = NCOLA
            NRMAXA = NROWA
            ALLOCATE(A(NRMAXA,NCMAXA), STAT = IERR)
            ABORT = .FALSE.
            IF (IERR.EQ.N0) THEN
               CLOSE (UNIT = NIN)
               CALL MAT2IN (NIN, NCMAXA, NCOLA, NRMAXA, NROWA,
     +                      A,
     +                      FNAMEA, TITLEA,
     +                      ABORT)
               CLOSE (UNIT = NIN)
            ENDIF
            IF (ABORT) THEN
               DEALLOCATE(A, STAT = IERR)
               NCOLA = N0
               NROWA = N0
               FNAMEA = NOFILE
               TITLEA = NODATA
            ENDIF
         ELSE
            NCOLA = N0
            NROWA = N0
            FNAMEA = NOFILE
            TITLEA = NODATA
         ENDIF
      ELSE
         NCOLA = N0
         NROWA = N0
         TITLEA = NODATA
      ENDIF
      ATITLE = CHOP80(TITLEA)
      AFNAME = TRIM80(FNAMEA)
      IF (NCOLB.GE.NCOL_MIN .AND. NROWB.GE.NROW_MIN) THEN
         CALL ISITMF(I, J,
     +               FNAMEB)
         IF (I.EQ.NCOLB .AND. J.EQ.NROWB) THEN
            NCMAXB = NCOLB
            NRMAXB = NROWB
            ALLOCATE(B(NRMAXB,NCMAXB), STAT = IERR)
            ABORT = .FALSE.
            IF (IERR.EQ.N0) THEN
               CLOSE (UNIT = NIN)
               CALL MAT2IN (NIN, NCMAXB, NCOLB, NRMAXB, NROWB,
     +                      B,
     +                      FNAMEB, TITLEB,
     +                      ABORT)
               CLOSE (UNIT = NIN)
            ENDIF
            IF (ABORT) THEN
               DEALLOCATE(B, STAT = IERR)
               NCOLB = N0
               NROWB = N0
               FNAMEB = NOFILE
               TITLEB = NODATA
            ENDIF
         ELSE
            NCOLB = N0
            NROWB = N0
            FNAMEB = NOFILE
            TITLEB = NODATA
         ENDIF
      ELSE
         NCOLB = N0
         NROWB = N0
         TITLEB = NODATA
      ENDIF
      BFNAME = TRIM80(FNAMEB)
      BTITLE = CHOP80(TITLEB)
C
C Main loop......................................................
C
      NWIDE = LEN200(HEADER(ISEND))
      DO I = N1, N2
         NEWDAT(I) = .FALSE.
      ENDDO
      REPEET = .TRUE.
      DO WHILE (REPEET)     
         IF (NEWDAT(1)) THEN
            NUMDEC = N1
         ELSEIF (NEWDAT(2)) THEN
            NUMDEC = N2
         ELSE      
            DO I = N1, N2
               OPTION(I) = BLANK4
            ENDDO
            IF (NCOLA.LT.NCOL_MIN .OR. NROWA.LT.NROW_MIN) THEN
               NUMDEC = N1
               OPTION(NUMDEC) = STAR4
               STATE = NREADY
            ELSEIF (NCOLB.LT.NCOL_MIN .OR. NROWB.LT.NROW_MIN) THEN
               NUMDEC = N2
               OPTION(NUMDEC) = STAR4
               STATE = NREADY
            ELSE
               NUMDEC = N3
               STATE = READY
            ENDIF
            FORM12_NCOLA = FORM12(NCOLA)
            FORM12_NCOLB = FORM12(NCOLB)
            FORM12_NROWA = FORM12(NROWA)
            FORM12_NROWB = FORM12(NROWB)
            WRITE (TEXT,100) HEADER(ISEND),
     +                       AFNAME, ATITLE, FORM12_NROWA, FORM12_NCOLA,
     +                       BFNAME, BTITLE, FORM12_NROWB, FORM12_NCOLB,
     +                      (OPTION(I), I = N1, N2), STATE
            NTEXT = NSTART + NUMOPT - N1
            NUMBLD(1) = N4
            NUMBLD(4) = N1
            NUMBLD(6) = N1
            NUMBLD(10) = N1
            NUMBLD(12) = N1
            CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                   NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            NUMBLD(1) = N0
            NUMBLD(4) = N0
            NUMBLD(6) = N0
            NUMBLD(10) = N0
            NUMBLD(12) = N0
         ENDIF   
         IF (NUMDEC.EQ.N3) THEN
           IF (ISEND.EQ.N2) THEN
              IF (NCOLA.LT.NCOL_MIN .OR. NCOLA.NE.NROWA .OR.
     +            NCOLB.LT.NCOL_MIN .OR. NCOLB.NE.NROWB .OR.
     +            NCOLA .NE. NCOLB) THEN
                  WRITE (LINE,500)
                  CALL PUTFAT (LINE)
                  NUMDEC = N0
               ENDIF 
            ELSEIF (ISEND.EQ.N3) THEN
               IF (NCOLA.NE.NCOLB .OR. NROWA.NE.NROWB) THEN
                  WRITE (LINE,600)
                  CALL PUTFAT (LINE)
                  NUMDEC = N0
               ENDIF
            ENDIF           
         ENDIF  
         IF (NUMDEC.EQ.N1) THEN
C
C NUMDEC = 1: Read in data matrix A
C ===========
C             
            NEWDAT(1) = .FALSE.
            WRITE (LINE,200)
            CALL PUTADV (LINE)
c
c -------------------------------
c start of code to input a matrix
c
            jsend = 3
            close (unit = nin)
            call mat3in (jsend, j, nin, i,
     +                   fname, title,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (.not.abort .and. i.ge.ncol_min .and. j.ge.nrow_min) then
               nrmax = i
               nrow = nrmax
               ncmax = j
               ncol = ncmax
               close (unit = nin)
               if (allocated(a)) deallocate(a, stat = ierr)
               if (ierr.eq.0) allocate(a(nrmax,ncmax), stat = ierr)
               if (ierr.eq.0) then
                  call mat2in (nin, ncmax, j, nrmax, i,
     +                         a,
     +                         fname, title,
     +                         abort)
                  close (unit = nin)
                  ncola = ncol
                  nrowa = nrow
                  fnamea = fname
                  titlea = title
                  afname = trim80(fname)
                  atitle = chop80(title)
               endif
            endif
c
c end of code to read in a matrix
c -------------------------------
c
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C NUMDEC = 2: Read in data matrix B
C ===========
C
            NEWDAT(2) = .FALSE.
            WRITE (LINE,300)
            CALL PUTADV (LINE)
c
c -------------------------------
c start of code to input a matrix
c
            jsend = 3
            close (unit = nin)
            call mat3in (jsend, j, nin, i,
     +                   fname, title,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (.not.abort .and. i.ge.ncol_min .and. j.ge.nrow_min) then
               nrmax = i
               nrow = nrmax
               ncmax = j
               ncol = ncmax
               close (unit = nin)
               if (allocated(b)) deallocate(b, stat = ierr)
               if (ierr.eq.0) allocate(b(nrmax,ncmax), stat = ierr)
               if (ierr.eq.0) then
                  call mat2in (nin, ncmax, j, nrmax, i,
     +                         b,
     +                         fname, title,
     +                         abort)
                  close (unit = nin)
                  ncolb = ncol
                  nrowb = nrow
                  fnameb = fname
                  titleb = title
                  bfname = trim80(fname)
                  btitle = chop80(title)
               endif
            endif
c
c end of code to read in a matrix
c -------------------------------
c
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C NUMDEC = 3: Analyse
C ===========
            IERR = 0
            IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
            IF (IERR.NE.0) RETURN
            IF (ALLOCATED(B1)) DEALLOCATE(B1, STAT = IERR)
            IF (IERR.NE.0) RETURN
C
C Overdimension the workspaces as required by the NAG routines
C
            NCMAXA = NCOLA + NCADD
            NCMAXB = NCOLB + NCADD
            NRMAXA = NROWA + NRADD
            NRMAXB = NROWB + NRADD
C
C Allocate global workspaces
C
            ALLOCATE(A1(NRMAXA,NCMAXA), STAT = IERR)
            IF (IERR.NE.0) RETURN
            ALLOCATE(B1(NRMAXB,NCMAXB), STAT = IERR)
            IF (IERR.NE.0) RETURN
C
C Make copies of A and B just in case they are changed by the calls
C
            DO J = N1, NCOLA
               DO I = N1, NROWA
                  A1(I,J) = A(I,J)
               ENDDO
            ENDDO
            DO J = N1, NCOLB
               DO I = N1, NROWB
                  B1(I,J) = B(I,J)
               ENDDO
            ENDDO
               
            IF (ISEND.EQ.N1) THEN
C
C Matrix multiplication
C
               ICOUNT(ISEND) = ICOUNT(ISEND) + N1
               WRITE (NOUT,'(A)') BLANK
               WRITE (WORD40,400) ICOUNT(ISEND)
               WRITE (NOUT,'(A)') HEADER(ISEND)(N1:NWIDE)//WORD40
               WRITE (NOUT,'(A)') ULINE(N1:NWIDE + N1)  
               DO I = N3, NSTART - N1
                  IF (I.NE.N8) WRITE (NOUT,'(A)') TEXT(I)
               ENDDO   
               CALL MATMUL (NCMAXA, NCMAXB, NCOLA, NCOLB, NIN, NOUT,
     +                      NRMAXA, NRMAXB, NROWA, NROWB,
     +                      A1, B1,
     +                      ATITLE, BTITLE,
     +                      NEWDAT, SUPPLY)
               IF (NEWDAT(1) .OR. NEWDAT(2)) THEN
                  REPEET = .TRUE.
               ELSE
                  REPEET = .FALSE.
               ENDIF
            ELSEIF (ISEND.EQ.N2) THEN
C
C Symmetric eigenvalue problem
C
               IF (NCOLA.LT.N2 .OR. NCOLA.NE.NROWA .OR.
     +             NCOLB.LT.N2 .OR. NCOLB.NE.NROWB .OR.
     +             NCOLA .NE. NCOLB) THEN
                  WRITE (LINE,500)
                  CALL PUTFAT (LINE)
               ELSE
                  ICOUNT(ISEND) = ICOUNT(ISEND) + N1
                  WRITE (NOUT,'(A)') BLANK
                  WRITE (WORD40,400) ICOUNT(ISEND)
                  WRITE (NOUT,'(A)') HEADER(ISEND)(N1:NWIDE)//WORD40
                  WRITE (NOUT,'(A)') ULINE(N1:NWIDE + N1)
                  DO I = N3, NSTART - N1
                     IF (I.NE.N8) WRITE (NOUT,'(A)') TEXT(I)
                  ENDDO                                                
                  CALL SYMEIG (NCMAXA, NCMAXB, NCOLA, NCOLB,
     +                         NIN, NOUT,
     +                         NRMAXA, NRMAXB, NROWA, NROWB,
     +                         A1, B1,
     +                         ATITLE, BTITLE,
     +                         NEWDAT, SUPPLY)
                  IF (NEWDAT(1) .OR. NEWDAT(2)) THEN
                     REPEET = .TRUE.
                  ELSE
                     REPEET = .FALSE.
                  ENDIF 
               ENDIF   
            ELSEIF (ISEND.EQ.N3) THEN
C
C Procrustes
C
               IF (NCOLA.LT.N2 .OR. NCOLA.NE.NCOLB .OR.
     +             NROWA.LT.N2 .OR. NROWA.NE.NROWB) THEN
                  WRITE (LINE,600)
                  CALL PUTFAT (LINE)
               ELSE
                  ICOUNT(ISEND) = ICOUNT(ISEND) + N1
                  WRITE (NOUT,'(A)') BLANK
                  WRITE (WORD40,400) ICOUNT(ISEND)
                  WRITE (NOUT,'(A)') HEADER(ISEND)(N1:NWIDE)//WORD40
                  WRITE (NOUT,'(A)') ULINE(N1:NWIDE + N1)
                  DO I = N3, NSTART - N1
                     IF (I.NE.N8) WRITE (NOUT,'(A)') TEXT(I)
                  ENDDO                                                
                  CALL M_PROTAT (NIN, NOUT, NCMAXA, NRMAXA,
     +                           A1, B1,
     +                           FNAMEA, FNAMEB,
     +                           NEWDAT)  
                  IF (NEWDAT(1) .OR. NEWDAT(2)) THEN
                     REPEET = .TRUE.
                  ELSE
                     REPEET = .FALSE.
                  ENDIF 
               ENDIF   
            ELSEIF (ISEND.EQ.N4) THEN
C
C Survival analysis
C
               IF (NCOLA.NE.3 .OR. NCOLB.NE.3) THEN
                  WRITE (LINE,700)
                  CALL PUTFAT (LINE)
               ELSE     
                  CALL SURV02 (NROWA, NROWB, NCMAXA, NCMAXB, NIN, NOUT,
     +                         NRMAXA, NRMAXB,
     +                         A1, B1, 
     +                         FNAMEA, FNAMEB, TITLEA, TITLEB,
     +                         SUPPLY) 
               ENDIF 
            ELSEIF (ISEND.EQ.N5) THEN
C
C Directed correlation
C            
               CALL DRCORR  (NCOLA, NCOLB, NOUT, NRMAXA, NRMAXB, 
     +                       NROWA, NROWB,
     +                       A1, B1,
     +                       TITLEA, TITLEB,
     +                       NEWDAT) 
               IF (NEWDAT(1) .OR. NEWDAT(2)) THEN
                  REPEET = .TRUE.
               ELSE
                  REPEET = .FALSE.
               ENDIF      
            ENDIF
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C NUMDEC = 4: View A
C ===========
C       
            IF (ALLOCATED(A) .AND. NCOLA.GT.N0 .AND. NROWA.GT.N0) THEN
               CALL VIEWER (N1,
     +                      FNAMEA, BLANK, BLANK)
            ELSE
               WRITE (LINE,200)
               CALL PUTFAT (LINE)
               NUMDEC = N1
            ENDIF  
        ELSEIF (NUMDEC.EQ.N5) THEN
C
C NUMDEC = 5: View B
C ===========
C       
            IF (ALLOCATED(B) .AND. NCOLB.GT.N0 .AND. NROWB.GT.N0) THEN
               CALL VIEWER (N1, 
     +                      FNAMEB, BLANK, BLANK)
            ELSE
               WRITE (LINE,300)
               CALL PUTFAT (LINE)
               NUMDEC = N1
            ENDIF              
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C NUMDEC = NUMOPT - 1: Help
C ====================
C
            WRITE (TEXT,1000)
            NTEXT = 20
            NUMBLD(1) = 1
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = 0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = NUMOPT: Exit
C =====================
C
            REPEET = .FALSE.
            CLOSE (UNIT = NIN)
            ABORT = .TRUE.
         ENDIF
      ENDDO
C
C End of main loop......................................................
C

C
C Deallocate workspace
C
      DEALLOCATE(A, STAT = IERR)
      DEALLOCATE(B, STAT = IERR)
      DEALLOCATE(A1, STAT = IERR)
      DEALLOCATE(B1, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     +A
     +/
     +/'Filename for current A-data matrix:' 
     +/A
     +/'Title for current A-data matrix:'
     +/A
     +/'Number of rows =',1x,a,'Number of columns =',1x,a
     +/
     +/'Filename for current B-data matrix:'
     +/A
     +/'Title For current B-data matrix:'
     +/A
     +/'Number of rows =',1x,a,'Number of columns =',1x,a
     +/
     +/'Input a new A-data matrix',1X,A
     +/'Input a new B-data matrix',1X,A
     +/'Analyse the current A,B data',1X,A
     +/'View current A-data file'
     +/'View current B-data file'
     +/'Help'
     +/'Quit ... Exit A/B data matrices options')
  200 FORMAT ('Now input the data matrix A')
  300 FORMAT ('Now input the data matrix B')
  400 FORMAT (': Analysis',I4)
  500 FORMAT ('A and B must be square and equal in size') 
  600 FORMAT ('A and B must have the same shape')
  700 FORMAT ('A and B must have three columns')
 1000 FORMAT (
     + 'Supplying two data samples for analysis'
     +/
     +/'The analytical procedure you have selected requires two samples'
     +/'as data matrices, with no missing values, that is'
     +/
     +/'Matrix A of size ma by na (where ma >= 1 and na >= 1), and'
     +/'Matrix B of size mb by nb (where mb >= 1 and nb >= 1).'
     +/
     +/'From this control you can input two data samples for each'
     +/'analysis or, if it is more convenient, maintain one sample'
     +/'as a reference sample and just renew the other data set.'
     +/
     +/'Note that some procedures impose restrictions on the overall'
     +/'dimensions of the matrices or on their properties, e.g. A and'
     +/'B must be symmetrical for the symmetric eigenvalue problem.'
     +/'You can input data from matrix type files, type values at'
     +/'the terminal, or paste in as tables from the clipboard, but'
     +/'you should always supply meaningful titles, to identify the'
     +/'results retrospectively from these titles as they are written'
     +/'to the results log file.')
      END
C
C
