C
C
      SUBROUTINE M_MATVEC (ISEND, NB, NCOL, NIN, NOUT, NROW,
     +                     FNAMEA, FNAMEB, TITLEA, TITLEB)
C
C ACTION : Analayse a matrix and vector
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          24/02/2006 derived from M_VECTWO
C          23/11/2006 added INTENTS and introduced SIMDIR
C          25/01/2007 replaced SIMDIR by SIM256    
C          06/03/2007 corrected dimensioning before calls to VEC2IN and MAT2IN
C
C         ISEND: (input/unchanged) as follows:
C                ISEND = 1: Ax = b nonsingular
C                ISEND = 2: Ax = b L1
C                ISEND = 3: Ax = b L2
C                ISEND = 4: Ax = b L-infinity
C                ISEND = 5: Evaluate quadratic forms
C                ISEND = 6:
C                ISEND = 7:
C            NB: (input/output) dimension of vector B
C          NCOL: (input/output) column dimension of matrix A
C           NIN: (input/unchanged) unconnected unit for data input
C          NOUT: (input/unchanged) preconnected unit for results
C          NROW: (input/output) row dimension of matrix A
C        FNAMEA: (input/output) file name for A data
C        FNAMEB: (input/output) file name for B data
C        TITLEA: (input/output) A-title
C        TITLEB: (input/output) B-title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND, NIN, NOUT
      INTEGER,             INTENT (INOUT) :: NB, NCOL, NROW
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAMEA, FNAMEB,
     +                                       TITLEA, TITLEB

C
C Local allocatable workspaces
C
      INTEGER, ALLOCATABLE :: NWORK(:)
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:), B(:)
      DOUBLE PRECISION, ALLOCATABLE :: A1(:,:), B1(:,:), RHS(:),
     +                                 U(:), V(:), W(:)
C
C Locals
C
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NSTART, NTEXT, NUMOPT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NSTART = 11,
     +           NUMOPT = 5)
      INTEGER    N0, N1, N2, N3, N5
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N5 = 5)
      INTEGER    NCMAX, NRMAX
      INTEGER    NCADD, NRADD
      PARAMETER (NCADD = 4, NRADD = 4)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    I, IERR, IRANK, ITER, J, JSEND, LWORK, NPTS
      DOUBLE PRECISION EL1N, RESMAX
      CHARACTER  FNAME*1024, LINE*100, TITLE*80, TITLE1*80
      CHARACTER  CHOP80*80, TEXT(30)*100
      CHARACTER  ATITLE*80, BTITLE*80
      CHARACTER  SIM256*1024, STATE*30
      CHARACTER (LEN = 12) FORM12, FORM12_NCOL, FORM12_NROW, FORM12_NB 
      CHARACTER  NODATA*60, NOFILE*30, NREADY*30, READY*30
      PARAMETER (NODATA = '(...No data...)',
     +           NOFILE = 'No file',
     +           NREADY = '(..Not ready..)',
     +            READY = '(*** Ready ***)' )
      CHARACTER  HEADER(7)*100, OPTION(2)*4
      CHARACTER  BLANK4*4, STAR4*4
      PARAMETER (BLANK4 = '    ', STAR4 = '****')
      LOGICAL    ABORT, NEWDAT, REPEET
      LOGICAL    DSPLAY, FILE, SUPPLY
      PARAMETER (DSPLAY = .TRUE., FILE = .TRUE., SUPPLY = .TRUE.)
      LOGICAL    LABEL
      PARAMETER (LABEL = .TRUE.)
      LOGICAL    FIXCOL, FIXROW
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   PUTADV, VEC2IN, VEC3IN, PUTFAT, LBOX01, CHOP80,
     +           PATCH1, ISITVF, MAT2IN, MAT3IN, ISITMF, AXEQB1,
     +           AXEQB2, AXEQB3, AXEQB4, EVALQF, SIM256, FORM12
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       HEADER /
     +'Ax = b, A nonsingular',
     +'Ax = b, L1-norm',
     +'Ax = b, L2-norm',
     +'Ax = b, L-infinity norm',
     +'Evaluate quadratic forms',
     +'...',
     +'...' /
      IF (ISEND.LT.N1 .OR. ISEND.GT.N5) RETURN
C
C Deallocate workspaces
C
      IERR = 0
      IF (ALLOCATED(NWORK)) DEALLOCATE(NWORK, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(B1)) DEALLOCATE(B1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(RHS)) DEALLOCATE(RHS, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(U)) DEALLOCATE(U, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Check input data using ISITVF and initialise 
C
      IF (NCOL.LE.N0 .OR. NROW.LE.N0) THEN
         IF (ISEND.EQ.N1) THEN
            NCOL = 5
            NROW = 5
            FNAMEA = SIM256('matrix.tf1')
         ELSEIF (ISEND.EQ.N5) THEN
            NCOL = 4
            NROW = 4
            FNAMEA = SIM256('matrix.tf3')
         ELSE
            NROW = 7
            NCOL = 5
            FNAMEA = SIM256('matrix.tf2')
         ENDIF
      ENDIF
      IF (NB.LE.N0) THEN
         IF (ISEND.EQ.N1) THEN
            NB = 5
            FNAMEB = SIM256('vector.tf1')
         ELSEIF (ISEND.EQ.N5) THEN
            NB = 4
            FNAMEB = SIM256('vector.tf3')
         ELSE
            NB = 7
            FNAMEB = SIM256('vector.tf2')
         ENDIF
      ENDIF
      IF (NB.GT.N1) THEN
         NPTS = N0
         CALL ISITVF(NPTS,
     +               FNAMEB)
         IF (NPTS.EQ.NB) THEN 
            NRMAX = NB
            ALLOCATE(B(NRMAX), STAT = IERR)
            ABORT = .FALSE.
            IF (IERR.EQ.N0) THEN
               CLOSE (UNIT = NIN)
               CALL VEC2IN (NIN, NRMAX, NB,
     +                      B,
     +                      FNAMEB, TITLEB,
     +                      ABORT)
               CLOSE (UNIT = NIN)
            ENDIF
            IF (ABORT) THEN
               DEALLOCATE(B, STAT = IERR)
               NB = N0
               FNAMEB = NOFILE
               TITLEB = NODATA
            ENDIF
         ELSE
            NB = N0
            FNAMEB = NOFILE
            TITLEB = NODATA
         ENDIF
      ELSE
         NB = N0
         FNAMEB = NOFILE
         TITLEB = NODATA
      ENDIF
      IF (NCOL.GT.N1 .AND. NROW.GT.N1) THEN
         CALL ISITMF(I, J,
     +               FNAMEA)
         IF (I.EQ.NCOL .AND. J.EQ.NROW) THEN
            NCMAX = NCOL
            NRMAX = NROW
            ALLOCATE(A(NRMAX,NCMAX), STAT = IERR)
            ABORT = .FALSE.
            IF (IERR.EQ.N0) THEN
               CLOSE (UNIT = NIN)
               CALL MAT2IN (NIN, NCMAX, NCOL, NRMAX, NROW,
     +                      A,
     +                      FNAMEA, TITLEA,
     +                      ABORT)
               CLOSE (UNIT = NIN)
            ENDIF
            IF (ABORT) THEN
               DEALLOCATE(A, STAT = IERR)
               NCOL = N0
               NROW = N0
               FNAMEA = NOFILE
               TITLEA = NODATA
            ENDIF
         ELSE
            NCOL = N0
            NROW = N0
            FNAMEA = NOFILE
            TITLEA = NODATA
         ENDIF
      ELSE
         NCOL = N0
         NROW = N0
         TITLEA = NODATA
      ENDIF
      ATITLE = CHOP80(TITLEA)
      BTITLE = CHOP80(TITLEB)
C
C Main loop......................................................
C
      NUMBLD(1) = 1
      REPEET = .TRUE.
      DO WHILE (REPEET)
         DO I = N1, N2
            OPTION(I) = BLANK4
         ENDDO
         IF (NCOL.LT.N2 .OR. NROW.LT.N2) THEN
            NUMDEC = N1
            OPTION(NUMDEC) = STAR4
            STATE = NREADY
         ELSEIF (NB.LT.N2) THEN
            NUMDEC = N2
            OPTION(NUMDEC) = STAR4
            STATE = NREADY
         ELSE
            IF (NB.EQ.NROW) THEN
               NUMDEC = N3
               STATE = READY
            ELSE
               NUMDEC = N2
               OPTION(NUMDEC) = STAR4
               STATE = NREADY
            ENDIF
         ENDIF
         FORM12_NCOL = FORM12(NCOL)
         FORM12_NROW = FORM12(NROW)
         FORM12_NB = FORM12(NB)
         WRITE (TEXT,100) HEADER(ISEND), ATITLE, FORM12_NROW,
     +                    FORM12_NCOL, BTITLE, FORM12_NB,
     +                   (OPTION(I), I = N1, N2), STATE
         NTEXT = NSTART + NUMOPT - N1
         NUMBLD(1) = 4
         NUMBLD(4) = 1
         NUMBLD(8) = 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(4) = 0
         NUMBLD(8) = 0
         IF (NUMDEC.EQ.N1) THEN
C
C NUMDEC = 1: Read in data matrix A
C ===========
C
            WRITE (LINE,200)
            CALL PUTADV (LINE)
c
c -------------------------------
c start of code to input a matrix
c
            jsend = 3
            close (unit = nin)
            call mat3in (jsend, j, nin, i,
     +                   fname, title,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (.not.abort .and. i.gt.1 .and. j.gt.1) then
               nrmax = i
               nrow = nrmax
               ncmax = j
               ncol = ncmax
               close (unit = nin)
               if (allocated(a)) deallocate(a, stat = ierr)
               if (ierr.eq.0) allocate(a(nrmax,ncmax), stat = ierr)
               if (ierr.eq.0) then
                  call mat2in (nin, ncmax, j, nrmax, i,
     +                         a,
     +                         fname, title,
     +                         abort)
                  close (unit = nin)
                  fnamea = fname
                  titlea = title
                  atitle = chop80(title)
               endif
c
c end of code to read in a matrix
c -------------------------------
c
            endif
c

         ELSEIF (NUMDEC.EQ.N2) THEN
C
C NUMDEC = 2: Read in data vector B
C ===========
C
            WRITE (LINE,300)
            CALL PUTADV (LINE)
c
c start of code to read in a vector
c ---------------------------------
c
            npts = 0
            fname = nofile
            title = nodata
            jsend = 3
            close (unit = nin)
            call vec3in (jsend, nin, npts,
     +                   fname, title,
     +                   abort, fixrow, label)
            close (unit = nin)
            if (.not.abort .and. npts.gt.n1) then
               if (allocated(b)) deallocate(b, stat = ierr) 
               nrmax = npts
               if (ierr.eq.0) allocate(b(nrmax), stat = ierr)
               abort = .true.
               if (ierr.eq.0) then
                  close (unit = nin)
                  call vec2in (nin, nrmax, npts,
     +                         b,
     +                         fname, title,
     +                         abort)
                  close (unit = nin)
                  nb = npts
                  fnameb = fname
                  titleb = title
                  btitle = chop80(title)
               endif
            endif
c
c end of code to read in a vector
c -------------------------------
c


         ELSEIF (NUMDEC.EQ.N3) THEN
C
C NUMDEC = 3: Analyse
C ===========
            IF (NB.NE.NROW) THEN
               WRITE (LINE,400)
               CALL PUTFAT (LINE)
            ELSEIF (NCOL.GT.NROW) THEN
               WRITE (LINE,500)
               CALL PUTFAT (LINE)
            ELSEIF (NROW.LT.N2) THEN
               WRITE (LINE, 600)
               CALL PUTFAT (LINE)
            ELSEIF (ISEND.EQ.1 .AND. NCOL.NE.NROW) THEN
               WRITE (LINE,700)
               CALL PUTFAT (LINE)
            ELSEIF (ISEND.EQ.5 .AND. NCOL.NE.NROW) THEN
               WRITE (LINE,700)
               CALL PUTFAT (LINE)   
            ELSE
               TITLE = TITLEA
               TITLE1 = TITLEB
               IERR = 0
               IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
               IF (IERR.NE.0) RETURN
               IF (ALLOCATED(RHS)) DEALLOCATE(RHS, STAT = IERR)
               IF (IERR.NE.0) RETURN
               IF (ALLOCATED(U)) DEALLOCATE(U, STAT = IERR)
               IF (IERR.NE.0) RETURN
C
C Overdimension the workspaces as required by the NAG routines
C
               NCMAX = NCOL + NCADD
               NRMAX = NROW + NRADD
C
C Allocate global workspaces
C
               ALLOCATE(A1(NRMAX,NCMAX), STAT = IERR)
               IF (IERR.NE.0) RETURN
               ALLOCATE(RHS(NRMAX), STAT = IERR)
               IF (IERR.NE.0) RETURN
               ALLOCATE(U(NRMAX), STAT = IERR)
               IF (IERR.NE.0) RETURN
C
C Make copies of A and B just in case they are changed by the calls
C
               DO J = 1, NCOL
                  DO I = 1, NROW
                     A1(I,J) = A(I,J)
                  ENDDO
               ENDDO
               DO I = 1, NROW
                  RHS(I) = B(I)
               ENDDO
               IF (ISEND.EQ.1) THEN
C
C Ax = b: A nonsingular
C
                  IF (ALLOCATED(NWORK)) DEALLOCATE(NWORK, STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE(NWORK(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  IF (ALLOCATED(B1)) DEALLOCATE(B1, STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE(B1(NRMAX,NCMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  CALL AXEQB1 (NCMAX, NCOL, NIN, NOUT, NRMAX, NROW,
     +                         NWORK,
     +                         A1, B1, U, RHS,
     +                         TITLE, TITLE1,
     +                         ABORT, DSPLAY, FILE, SUPPLY)
                  DEALLOCATE(NWORK, STAT = IERR)
                  DEALLOCATE(A1, STAT = IERR)
                  DEALLOCATE(B1, STAT = IERR)
                  DEALLOCATE(RHS, STAT = IERR)
                  DEALLOCATE(U, STAT = IERR)
               ELSEIF (ISEND.EQ.2) THEN
C
C Ax = b: L1 overdetermined
C
                  IF (ALLOCATED(NWORK)) DEALLOCATE(NWORK, STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE(NWORK(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  LWORK = 3*NRMAX + 5*NCMAX + NCMAX*NCMAX +
     +                    ((NCMAX + 1)*(NCMAX + 2))/2
                  ALLOCATE(W(LWORK), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  CALL AXEQB3 (NWORK, LWORK, NCMAX, NCOL, NIN, NOUT,
     +                         NRMAX, NROW,
     +                         A1, RHS, EL1N, W, U,
     +                         TITLE, TITLE1,
     +                         ABORT, DSPLAY, FILE, SUPPLY)
                  DEALLOCATE(NWORK, STAT = IERR)
                  DEALLOCATE(A1, STAT = IERR)
                  DEALLOCATE(RHS, STAT = IERR)
                  DEALLOCATE(W, STAT = IERR)
                  DEALLOCATE(U, STAT = IERR)
               ELSEIF (ISEND.EQ.3) THEN
C
C Ax = b: L2 overdetermined
C
                  IF (ALLOCATED(B1)) DEALLOCATE(B1, STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE(B1(NRMAX,NCMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE(V(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  LWORK = 5*NRMAX
                  ALLOCATE(W(LWORK), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  CALL AXEQB2 (IRANK, LWORK, NCMAX, NCOL, NIN, NOUT,
     +                         NRMAX, NROW,
     +                         A1, B1, U, V, RHS, W,
     +                         TITLE, TITLE1,
     +                         ABORT, DSPLAY, FILE, SUPPLY)
                  DEALLOCATE(A1, STAT = IERR)
                  DEALLOCATE(B1, STAT = IERR)
                  DEALLOCATE(RHS, STAT = IERR)
                  DEALLOCATE(U, STAT = IERR)
                  DEALLOCATE(V, STAT = IERR)
                  DEALLOCATE(W, STAT = IERR)
              ELSEIF (ISEND.EQ.4) THEN
C
C  Ax = b: L-infinity
C
                  IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  ALLOCATE(V(NRMAX), STAT = IERR)
                  IF (IERR.NE.0) RETURN
                  CALL AXEQB4 (IRANK, ITER, NCMAX, NCOL, NIN, NOUT,
     +                         NRMAX, NROW,
     +                         A1, RHS, U, RESMAX, V,
     +                         TITLE, TITLE1,
     +                         ABORT, DSPLAY, FILE, SUPPLY)
                  DEALLOCATE(A1, STAT = IERR)
                  DEALLOCATE(RHS, STAT = IERR)
                  DEALLOCATE(U, STAT = IERR)
                  DEALLOCATE(V, STAT = IERR)
               ELSEIF (ISEND.EQ.5) THEN
C
C Evaluate quadratic forms
C
                  CALL EVALQF (NCMAX, NCOL, NIN, NOUT, NRMAX, NROW, NB,
     +                         A1, RHS, U,
     +                         FNAMEA, FNAMEB, TITLEA, TITLEB,
     +                         NEWDAT, SUPPLY)
                  DEALLOCATE(A1, STAT = IERR)
                  DEALLOCATE(RHS, STAT = IERR)
                  DEALLOCATE(U, STAT = IERR)
                  IF (NEWDAT) THEN
                     REPEET = .TRUE.
                  ELSE
                     REPEET = .FALSE.
                  ENDIF
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C NUMDEC = NUMOPT - 1: Help
C ====================
C
            WRITE (TEXT,800)
            NTEXT = 20
            NUMBLD(1) = 1
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = 0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = NUMOPT: Exit
C =====================
C
            REPEET = .FALSE.
            CLOSE (UNIT = NIN)
            ABORT = .TRUE.
         ENDIF
      ENDDO
C
C End of main loop......................................................
C

C
C Deallocate workspace
C
      DEALLOCATE(NWORK, STAT = IERR)
      DEALLOCATE(A, STAT = IERR)
      DEALLOCATE(B, STAT = IERR)
      DEALLOCATE(A1, STAT = IERR)
      DEALLOCATE(B1, STAT = IERR)
      DEALLOCATE(RHS, STAT = IERR)
      DEALLOCATE(U, STAT = IERR)
      DEALLOCATE(V, STAT = IERR)
      DEALLOCATE(W, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     + A
     +/
     +/'Title for current A-data matrix:'
     +/A
     +/'Number of rows =',1x,a,'Number of columns =',1x,a
     +/
     +/'Title For current B-data vector:'
     +/A
     +/'Number of rows =',1x,a
     +/
     +/'Input a new A-data matrix',1X,A
     +/'Input a new B-data vector',1X,A
     +/'Analyse the current A,B data',1X,A
     +/'Help'
     +/'Quit ... Exit A/B data matrices options')
  200 FORMAT ('Now input the data matrix A')
  300 FORMAT ('Now input the data vector b')
  400 FORMAT ('Must have vector length = no. matrix rows (k = n)')
  500 FORMAT ('Must have no. of rows >= no. of columns')
  600 FORMAT ('Insuficient data, must have n >= 2')
  700 FORMAT ('Must have no. of rows = no. columns')
  800 FORMAT (
     + 'Supplying two data samples for analysis'
     +/
     +/'The analytical procedure you have selected requires two samples'
     +/'as a matrix and a vector, with no missing values, that is'
     +/
     +/'Matrix A of size n by m (where n > 1 and m > 1), and'
     +/'Vector b with sample size k (where k > 1 and k = n).'
     +/
     +/'From this control you can input two data samples for each'
     +/'analysis or, if it is more convenient, maintain one sample'
     +/'as a reference sample and just renew the other data set.'
     +/
     +/'Note that some procedures (e.g. Ax = b) require square non-'
     +/'singular matrices, i.e. n = m, while others require over-'
     +/'determined systems (n > m) and, always of course n = k.'
     +/'You can input data from vector/matrix files, type values at'
     +/'the terminal, or paste in as columns from the clipboard, but'
     +/'you should always supply meaningful titles, to identify the'
     +/'results retrospectively from these titles as they are written'
     +/'to the results log file.')
      END
C
C
