c
c
      subroutine m_mcnmar (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     titlea,
     +                     newdat)
c
c action: McNemar analysis of a contingency table
c author: w.g.bardsley, university of manchester, u.k.
c         10/02/2006 derived from m_mvnor1
c
c Note: all arguments are input/unchanged except for newdat
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  titlea*(*)
      logical    newdat
c
c local allocatable arrays
c
      integer, allocatable :: nobs(:,:)
      double precision, allocatable :: x(:)
c
c locals
c
      integer    ierr, nin
      parameter (nin = 3)
      character  line*100
      character  fname*1
      logical    supply
      parameter (supply = .true.)
      external   mcnmar, putfat
c
c check
c
      if (ncol.lt.2 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate workspaces (ncmax > ncol, nrmax > nrow)
c
      ierr = 0
      if (allocated(nobs)) deallocate(nobs, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      allocate(nobs(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(x(nrmax), stat = ierr)
      if (ierr.ne.0) return
c
c call mcnmar for calculations
c
      call mcnmar (ncmax, ncol, nin, nobs, nout, nrmax, nrow,
     +             a, x,
     +             fname, titlea,
     +             newdat, supply)
c
c deallocate workspaces
c
      deallocate(nobs, stat = ierr)
      deallocate(x, stat = ierr)
c
c format statements
c
  100 format ('Must have no. rows >= 2 and no. columns >= 2')
      end
c
c
