c
c
      subroutine m_meta02 (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     fnamea, titlea)
c
c action: meta analysis
c author: w.g.bardsley, university of manchester, u.k.
c         10/02/2006 derived from m_meta01
c
c Note: all arguments are input/unchanged except for a
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  fnamea*(*), titlea*(*)
c
c local allocatable arrays
c
      integer, allocatable :: nobs(:,:), ntemp(:,:)
      double precision, allocatable :: atemp(:,:), pbot(:), pbot1(:),
     +                                 phat(:), phat1(:), ptop(:),
     +                                 ptop1(:), t(:), t1(:), x(:)
c
c locals
c
      integer    i, j
      integer    ierr, ilim, nin, ngraf
      parameter (nin = 3)
      character  line*100
      logical    supply
      parameter (supply = .true.)
      external   meta02, putfat
      data       ilim / 95 /
c
c check
c
      if (ncol.lt.2 .or. ncol.gt. 4 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
      i = nrow/2
      j = 2*i
      if (j.ne.nrow) then
         write (line,200)
         call putfat (line)
         return
      endif
c
c allocate workspaces (ncmax > ncol, nrmax > nrow)
c
      ierr = 0
      if (allocated(nobs)) deallocate(nobs, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(ntemp)) deallocate(ntemp, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(atemp)) deallocate(atemp, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(pbot)) deallocate(pbot, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(pbot1)) deallocate(pbot1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(phat)) deallocate(phat, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(phat1)) deallocate(phat1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(ptop)) deallocate(ptop, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(ptop1)) deallocate(ptop1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(t)) deallocate(t, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(t1)) deallocate(t1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      ngraf = 2*nrmax
      allocate(nobs(nrmax,3), stat = ierr)
      if (ierr.ne.0) return
      allocate(ntemp(nrmax,3), stat = ierr)
      if (ierr.ne.0) return
      allocate(atemp(nrmax,4), stat = ierr)
      if (ierr.ne.0) return
      allocate(pbot(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(pbot1(ngraf), stat = ierr)
      if (ierr.ne.0) return
      allocate(phat(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(phat1(ngraf), stat = ierr)
      if (ierr.ne.0) return
      allocate(ptop(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(ptop1(ngraf), stat = ierr)
      if (ierr.ne.0) return
      allocate(t(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(t1(ngraf), stat = ierr)
      if (ierr.ne.0) return
      allocate(x(nrmax), stat = ierr)
      if (ierr.ne.0) return
c
c call meta01 for calculations after copying a into atemp
c
      do j = 1, ncol
         do i = 1, nrow
            atemp(i,j) = a(i,j)
         enddo
      enddo
      call meta02 (ilim, ncol, ngraf, nin, nobs, nout, nrmax, nrow,
     +             ntemp,
     +             a, atemp, pbot, pbot1, phat, phat1, ptop, ptop1,
     +             t, t1, x,
     +             fnamea, titlea,
     +             supply)
c
c deallocate workspaces
c
      deallocate(nobs, stat = ierr)
      deallocate(ntemp, stat = ierr)
      deallocate(atemp, stat = ierr)
      deallocate(pbot, stat = ierr)
      deallocate(pbot1, stat = ierr)
      deallocate(phat, stat = ierr)
      deallocate(phat1, stat = ierr)
      deallocate(ptop, stat = ierr)
      deallocate(ptop1, stat = ierr)
      deallocate(t, stat = ierr)
      deallocate(t1, stat = ierr)
      deallocate(x, stat = ierr)
c
c format statements
c
  100 format ('Must have no. rows >= 2 and 2 =< no. columns =< 4')
  200 format ('Must have even number of rows for meta analysis')
      end
c
c
