c
c
      subroutine m_mmoodd (nout, nx, ny,
     +                     x1, y1,
     +                     xtitle, ytitle)
c
c action: front end to mmoodd
c author: w.g.bardsley, university of manchester, u.k., 20/08/2007
c
      implicit none
c
c arguments
c
      integer,             intent (in) :: nout, nx, ny
      double precision,    intent (in) :: x1(nx), y1(ny)
      character (len = *), intent (in) :: xtitle, ytitle  
c
c locall allocatable arrays
c 
      double precision, allocatable :: u(:), v(:), x(:), y(:)
c
c locals
c
      integer    i, ierr, nmax
      integer    nin
      parameter (nin = 3)
      logical    supply
      parameter (supply = .true.) 
      external   mmoodd
      intrinsic  max
      if (nx.lt.1 .or. ny.lt.1) return
      ierr = 0
      if (allocated(u)) deallocate(u, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(v)) deallocate(v, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y)) deallocate(y, stat = ierr)
      if (ierr.ne.0) return  
      nmax = max(nx, ny)
      allocate(u(2*nmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(v(2*nmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(x(nmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(y(nmax), stat = ierr)
      if (ierr.ne.0) return 
      do i = 1, nx
         x(i) = x1(i)
      enddo
      do i = 1, ny
         y(i) = y1(i)
      enddo          
      call mmoodd (nin, nmax, nout, nx, ny,
     +             x, y, u, v,
     +             xtitle, ytitle,
     +             supply) 
      deallocate(u, stat = ierr)
      deallocate(v, stat = ierr)
      deallocate(x, stat = ierr)
      deallocate(y, stat = ierr)
      end
c
c