c
c
      subroutine m_mvnor1 (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     titlea,
     +                     newdat)
c
c action: analysis of a multivariate normal matrix
c author: w.g.bardsley, university of manchester, u.k., 05/02/2006
c         10/02/2006 added newdat to argument list
c
c Note: all arguments are input/unchanged except for newdat
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  titlea*(*)
      logical    newdat
c
c local allocatable arrays
c
      double precision, allocatable :: b(:,:), w1(:), w2(:)
c
c locals
c
      integer    ierr, nin, nsmall
      parameter (nin = 3, nsmall = 1)
      character  line*100
      character  fname*1, fsav(nsmall)*1, tsav(nsmall)*1
      logical    supply
      parameter (supply = .true.)
      external   mvnor1, putfat
c
c check
c
      if (ncol.lt.2 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate workspaces
c
      ierr = 0
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w1)) deallocate(w1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w2)) deallocate(w2, stat = ierr)
      if (ierr.ne.0) return
      allocate(b(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(w1(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(w2(nrmax), stat = ierr)
      if (ierr.ne.0) return
c
c call mvnor1 for calculations
c
      call mvnor1 (ncmax, ncol, nin, nout, nrmax, nrow,
     +             nsmall,
     +             a, b, w1, w2,
     +             fname, fsav, titlea, tsav,
     +             newdat, supply)
c
c deallocate workspaces
c
      deallocate(b, stat = ierr)
      deallocate(w1, stat = ierr)
      deallocate(w2, stat = ierr)
c
c format statements
c
  100 format ('Must have no. rows >= 2 and no. columns >= 2')
      end
c
c
