c
c
      subroutine m_mvstat (isend, ncol, nin, nout, nrow,
     +                     fnamea, titlea)
c
c action: install a matrix then call the program indicated by isend
c author: w.g.bardsley, university of manchester, u.k.
c         derived from m_vecone 05/02/2006
c         21/06/2006 increased lwk from 2*nrmax to nrmax + nrmax*(nrmax + 17)/2 - 1
c                    and also increased liwk for scaling options 
c         12/07/2006 further increases in lwk and liwk for scaling options
c         28/07/2006 added m_mvstat_check 
c         01/08/2006 added m_orotat
c         28/08/2006 added m_biplot
c         31/10/2006 changed several test files and added intents
c         23/11/2006 introduced simdir
c         25/01/2007 replaced simdir by sim256
c         07/03/2007 alternative user prompt for factor analysis (isend = 12)
c         12/10/2007 now allows mat4in to change fnamea and titlea
c         31/01/2008 introduced showit to limit repeat advice about test files
c         23/03/2008 added calls to puterr to flag allocation/deallocation errors 
c         10/05/2010 introduced NKLCFG to switch on/off the test file advice
c         17/08/2010 added manovg for MANOVA plotting
c         15/04/2011 decreased ncadd and nradd and allocated individually
c         30/04/2011 introduced call to TFILEQ
c         08/02/2017 added l1, l2 and ltemp for the kind = 7 problem in calls to CLUST1 and CLUST3
c                    and increased nwmax for call to cvr000 for call to g03acf$
c
c   isend: (input/unchanged) as follows:
c           isend =  1: Pearson correlation 
c           isend =  2: Nonparametric correlation 
c           isend =  3: Partial correlations
c           isend =  4: Canonical correlations
c           isend =  5: Cluster analysis and dendrograms
c           isend =  6: Distance matrix and scaling
c           isend =  7: K-means clustering 
c           isend =  8: Principal components
c           isend =  9: MANOVA  
c           isend = 10: Canonical variates 
c           isend = 11: Discriminant analysis
c           isend = 12: Factor analysis
c           isend = 13: orthogonal rotation 
c           isend = 14: biplot
c           isend = 15: manova plotting
c
c    ncol: (input/output) column size   
c     nin: (input/unchanged) unconnected unit for data input
c    nout: (input/unchanged) preconnected unit for results
c    nrow: (input/output) row size
c  fnamea: (input/output) data file name
c  titlea: (input/output) data title
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: isend, nin, nout 
      integer,             intent (inout) :: ncol, nrow
      character (len = *), intent (inout) :: fnamea, titlea
c
c Local allocatable arrays
c
      integer,          allocatable :: iwork(:), jwork(:)
      double precision, allocatable :: a(:,:), w(:)
c
c locals
c
      integer   (kind = 7) liwk, lwk, nwmax, nwmin
      integer   (kind = 7) l1, l2
      integer    ltemp
      integer    ierr, itype, jsend, ncmax, ncol1, nrmax, nrow1
      integer    ncadd, nradd
      integer    kval9, nklcfg
      integer    ngraf, nitems, nsmall, ntemp, n1, n21
      parameter (ngraf = 1000, nitems = 15, nsmall = 1,
     +           ntemp = 3, n1 = 1, n21 = 21)
      integer    ndim
      parameter (ndim = 10)
      integer    ncsav(nitems), nrsav(nitems)
      character  no_data*30, no_file*30, tfiles(nitems)*15
      character  fsav(nsmall)*1, tsav(nsmall)*1
      parameter (no_data = 'No data',
     +           no_file = 'No file')
      character  header(nitems)*80, line*100, sim256*1024, word15*15  
      logical    showit(nitems)       
      logical    abort, fixcol, fixrow, label, newdat, repeet, supply
      parameter (fixcol = .false., fixrow = .false., label = .true.,
     +           supply = .true.)
      external   isitmf, mat2in, mat3in, mat4in, sim256, puterr
      external   m_orotat
      external   xycorr, npcorr, cacorr, corrpa, clust1, clust3, clust2,
     +           pca001, manova, cvr000, grp000, fact01, m_mvstat_check,
     +           m_biplot, manovg
      external   nklcfg, tfileq
      intrinsic  max
      save       header, ncsav, nrsav, showit
      data       showit / nitems*.true. /
      data       ncsav  /  3,  3,  3,  4,  3,  8,  5,  3,  6,  4,
     +                     3,  9,  3,  9,  3 /
      data       nrsav  /  5,  9, 15,  9,  5, 12, 20, 10, 10,  9,
     +                    21,  9, 10,  8,  21 /
      data       header /
     +'Pearson correlation',                    !1
     +'Nonparameteric correlation',             !2
     +'Partial correlation',                    !3
     +'Canonical correlation',                  !4
     +'Cluster analysis and dendrograms',       !5
     +'Distance matrix and scaling',            !6 
     +'K-means clustering',                     !7
     +'Principal components',                   !8 
     +'MANOVA',                                 !9
     +'Canonical variates',                     !10
     +'Discriminant analysis',                  !11
     +'Factor analysis',                        !12 
     +'Orthogonal rotation',                    !13
     +'Biplot',                                 !14
     +'Group plots' /                           !15  
      data       tfiles /
     +'g02baf.tf1',          !1 
     +'g02bnf.tf1',          !2 
     +'g02byf.tf1',          !3
     +'g03adf.tf1',          !4
     +'g03ecf.tf1',          !5
     +'cluster.tf1',         !6 
     +'g03eff.tf1',          !7
     +'g03aaf.tf1',          !8 
     +'manova1.tf1',         !9
     +'g03acf.tf1',          !10
     +'g03daf.tf1',          !11
     +'g03caf.tf1',          !12  
     +'g03baf.tf1',          !13
     +'houses.tf1',          !14
     +'manova1.tf2' /        !15      
c
c check isend then initialise ncadd and nradd
c 
      if (isend.lt.1 .or. isend.gt.15) return
c
c define ncadd to add a few extra columns just to be safe
c                 
      ncadd = 1
      if (isend.eq.10) then
c
c define nradd to append extra rows for comparison data in cvr000
c      
         nradd = 100
       else
c
c define nradd to add a few extra rows just to be safe
c       
         nradd = 1
       endif        
c
c------------------------------------------------------------
c Start of code to access a matrix
c------------------------------------------------------------
c 
      if (ncol.le.0 .or. nrow.le.0) then
         fnamea = sim256(tfiles(isend))
         ncol = ncsav(isend)
         nrow = nrsav(isend)
      endif   
      repeet = .true.
      do while (repeet)
c
c Step 1: if ncol > 0 and nrow > 0 check if fname supplied is a current vector file
c ======= isitmf returns ncol1 > 0 and nrow1 > 0 if fnamea is a vector file
c
         ncol1 = 0
         nrow1 = 0
         if (ncol.gt.0 .and. nrow.gt.0) call isitmf (ncol1, nrow1,
     +                                               fnamea)
c
c Step 2: if fnamea is not a matrix file of correct size try to open a file
c ======= mat3in selects a matrix file of size nrow1 > 0 by ncol1 > 0 if successful
c
         if (ncol1.le.0 .or. nrow1.le.0 .or.
     +       ncol1.ne.ncol .or. nrow1.ne.nrow) then
            ncol = 0
            nrow = 0
            fnamea = no_file
            titlea = no_data
            jsend = 3
            close (unit = nin)
            if (showit(isend)) then
               kval9 = nklcfg(n21)
               if (kval9.eq.n1) then
                  word15 = tfiles(isend)(1:15) 
                  if (isend.eq.12) then
                     write (line,100) word15
                  else 
                     write (line,200) word15  
                  endif  
                  call tfileq (line) 
                  showit(isend) = .false.
               endif   
            endif   
            call mat3in (jsend, ncol1, nin, nrow1,
     +                   fnamea, titlea,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (abort) then
               ncol = 0
               nrow = 0
               fnamea = no_file
               titlea = no_data
               return
            endif
         endif                       
c
c check if file is suitable
c         
         call m_mvstat_check (isend, ncol1, nrow1,
     +                        fnamea)    
         if (ncol1.le.0 .or. nrow1.le.0) return
c
c Step 3: we now have a matrix file of size nrow > 0 by ncol > 0 so allocate workspaces
c ======  if there is any error then ierr is nonzero and exit happens
c
         ncol = ncol1
         nrow = nrow1
         ierr = 0
         if (allocated(a)) deallocate(a, stat = ierr)
         call puterr (ierr, 'D, M_MVSTAT matrix a')  
         if (ierr.ne.0) return
         ncmax = ncol + ncadd
         if (isend.eq.5 .or. isend.eq.6) then
            if (ncmax.lt.ndim) ncmax = ndim
         endif     
         nrmax = nrow + nradd
         if (isend.eq.11) then 
            allocate(a(nrmax,ncmax + 7), stat = ierr)
         else   
            allocate(a(nrmax,ncmax), stat = ierr)
         endif   
         call puterr (ierr, 'A, M_MVSTAT matrix a')
         if (ierr.ne.0) return
        
c
c Step 4: read in the data consisting of nrow by ncol points from file fnamea
c ======= if an error occurs then workspaces are deallocated and exit occurs
c         otherwise fnamea and titlea are not changed from now on
c
         close (unit = nin)
         call mat2in (nin, ncmax, ncol, nrmax, nrow,
     +                a,
     +                fnamea, titlea,
     +                abort)
         close (unit = nin)
         if (abort) then
            ierr = 0
            if (allocated(a)) deallocate (a, stat = ierr)
            call puterr (ierr, 'D, M_MVSTAT matrix a')
            ncol = 0
            nrow = 0
            fnamea = no_file
            titlea = no_data
            return
         endif
c
c Step 5: see what the user wants to do ... fnamea and titlea may change in mat4in
c ======= mat4in is the equivalent of vecone oferring as follows:
c         abort = .true. on return: deallocate workspaces then exit
c         newdat = .true. on return: try for a new data set
c         newdat = .false. on return: proceed with original or edited data
c         If the data are edited fnamea and titlea are changed
c
         call mat4in (ncmax, ncol, nrmax, nrow,
     +                a,
     +                fnamea, header(isend), titlea,
     +                abort, newdat)
         if (abort) then
c
c Option 1 on return from mat4in: Deallocate then exit
c --------
c
            ierr = 0
            if (allocated(a)) deallocate (a, stat = ierr)
            call puterr (ierr, 'D, M_MVSTAT matrix a')
            return
         elseif (newdat) then
c
c Option 2 on return from from mat4in: New data
c --------
c
            fnamea = no_file
            titlea = no_data
            ncol = 0
            nrow = 0
         else
c
c Option 3 on return from from mat4in: Proceed to analysis
c --------
c  
  
            ncol1 = ncol
            nrow1 = nrow
            newdat = .false. 
            if (isend.eq.1) then
c
c isend = 1: correlation
c              
               call xycorr (ncmax, ncol1, nout, ntemp, nrmax, nrow1,
     +                      nsmall,
     +                      a,
     +                      fnamea, fsav, titlea, tsav,
     +                      newdat, supply)
            elseif (isend.eq.2) then
c
c isend = 2: nonparametric correlation (requires iwork and jwork)
c            
               ierr = 0 
               if (allocated(iwork)) deallocate(iwork, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/NPCORR vector iwork')  
                  return
               endif   
               if (allocated(jwork)) deallocate(jwork, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/NPCORR vector jwork')  
                  return
               endif  
                
c               liwk = nrmax  
c               allocate(iwork(liwk), stat = ierr)  
               ltemp = nrmax 
               allocate(iwork(ltemp), stat = ierr)
               
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/NPCORR vector iwork') 
                  return
               endif
               
c              allocate(jwork(liwk), stat = ierr)  
               allocate(jwork(ltemp), stat = ierr)
               
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/NPCORR vector jwork')
                 return
               endif              
               call npcorr (iwork, jwork, ncmax, ncol1, nout, ntemp,
     +                      nrmax, nrow1, nsmall,
     +                      a,
     +                      fnamea, fsav, titlea, tsav,
     +                      newdat, supply)
            elseif (isend.eq.3) then
c
c isend = 3: partial correlation
c            
               call corrpa (ncmax, ncol1, ntemp, nout, nrmax, nrow1,
     +                      a,
     +                      fnamea, titlea,
     +                      newdat) 
            elseif (isend.eq.4) then
c
c isend = 4: canonical correlation
c            
               call cacorr (ncmax, ncol1, nout, ntemp, nrmax, nrow1,
     +                      nsmall,
     +                      a,
     +                      fnamea, fsav, titlea, tsav,
     +                      newdat, supply)
           
            elseif (isend.eq.5) then
c
c isend = 5: distance matrix and dendrogram (requires iwork and w)
c            
               ierr = 0 
               if (allocated(iwork)) deallocate(iwork, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/CLUST1 vector iwork')  
                  return
               endif
               
c               liwk = 5*nrmax  
c               allocate(iwork(liwk), stat = ierr)  
               ltemp = 5*nrmax  
               allocate(iwork(ltemp), stat = ierr)
               
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/CLUST1 vector iwork') 
                  return
               endif   
               if (allocated(w)) deallocate(w, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/CLUST1 vector w')   
                  return
               endif
               
c               nwmax = nrmax*(nrmax - 1)/2  
               l1 = nrmax
               nwmax = l1*(l1 - 1)/2
               
               allocate(w(nwmax), stat = ierr)  
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/CLUST1 vector w')
                  return
               endif                  
               call clust1 (iwork, ncmax, ncol1, nwmax, ntemp, nout,
     +                      nrmax, nrow1, nsmall,
     +                      a, w,
     +                      fnamea, fsav, titlea, tsav,
     +                      newdat, supply) 
            elseif (isend.eq.6) then
c
c isend = 6: distance matrix and scaling
c            
               ierr = 0 
               if (allocated(iwork)) deallocate(iwork, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/CLUST3 vector iwork')  
                  return
               endif
               
c               liwk = nrmax*(nrmax - 1)/2 + nrmax*ndim + 5  
               l1 = nrmax
               liwk = l1*(l1 - 1)/2 + l1*ndim + 5
               
               allocate(iwork(liwk), stat = ierr)  
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/CLUST3 vector iwork') 
                  return
               endif
               
c               lwk = max(nrmax + nrmax*(nrmax + 17)/2 + 1,
c     +                   15*nrmax*ndim,
c     +                   2*nrmax*(nrmax - 1))
               l1 = nrmax 
               lwk = max(l1 + l1*(l1 + 17)/2 + 1,
     +                   15*l1*ndim,
     +                   2*l1*(l1 - 1))
     
               if (allocated(w)) deallocate(w, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/CLUST3 vector w')   
                  return
               endif
               
c               nwmax = nrmax*(nrmax - 1)/2  
               l1 = nrmax
               nwmax = l1*(l1 - 1)/2
               allocate(w(nwmax), stat = ierr)
               
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/CLUST3 vector w')
                  return
               endif                  
               call clust3 (iwork, liwk, lwk, ncmax, ncol1, nwmax, 
     +                      ntemp, nout, nrmax, nrow1, nsmall,
     +                      a, w,
     +                      fnamea, fsav, titlea, tsav,
     +                      newdat, supply)
            elseif (isend.eq.7) then
c
c isend = 7: K means clustering
c            
               ierr = 0 
               if (allocated(iwork)) deallocate(iwork, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/CLUST2 vector iwork')  
                  return
               endif
               
c               liwk = 5*nrmax  
c               allocate(iwork(liwk), stat = ierr)  
               ltemp = 5*nrmax  
               allocate(iwork(ltemp), stat = ierr)
               
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/CLUST2 vector iwork') 
                  return
               endif 
               if (allocated(jwork)) deallocate(jwork, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/CLUST2 vector jwork')  
                  return
               endif
               
c               liwk = nrmax  
c               allocate(jwork(liwk), stat = ierr)  
               ltemp = nrmax
               allocate(jwork(ltemp), stat = ierr)
               
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/CLUST2 vector jwork') 
                  return
               endif     
               if (allocated(w)) deallocate(w, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/CLUST2 vector w')   
                  return
               endif
               
c               nwmax = 3*nrmax  
c               allocate(w(nwmax), stat = ierr)  
               ltemp = 3*nrmax  
               allocate(w(ltemp), stat = ierr)
               
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/CLUST2 vector w')
                  return
               endif                  
               call clust2 (iwork(1), iwork(nrmax + 1), ncmax, ncol1,
     +                      jwork, ntemp, nout, nrmax, nrow1, nsmall,
     +                      a, w,
     +                      fnamea, fsav, titlea, tsav,
     +                      newdat, supply) 
            elseif (isend.eq.8) then
c
c isend = 8: principal components
c            
               if (allocated(w)) deallocate(w, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/PCA001 vector w')   
                  return
               endif   
               nwmax = 2*nrmax  
               allocate(w(nwmax), stat = ierr)  
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/PCA001 vector w')
                  return
               endif                  
               call pca001 (ncmax, ncol1, ntemp, nout, nrmax, nrow1,
     +                      nsmall,
     +                      a, w,
     +                      fnamea, fsav, titlea, tsav,
     +                      newdat, supply) 
            elseif (isend.eq.9) then
c
c isend = 9: MANOVA
c            
               ierr = 0 
               if (allocated(iwork)) deallocate(iwork, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/MANOVA vector iwork')  
                  return
               endif
               
c               liwk = nrmax  
c               allocate(iwork(liwk), stat = ierr)  
               ltemp = nrmax  
               allocate(iwork(ltemp), stat = ierr)
               
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/MANOVA vector iwork') 
                  return
               endif 
               if (allocated(w)) deallocate(w, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/MANOVA vector w')   
                  return
               endif
               
c               nwmax = nrmax*(ncmax + 1)  
               l1 = nrmax
               l2 = ncmax   
               nwmax = l1*(l2 + 1)  
               allocate(w(nwmax), stat = ierr)
               
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/MANOVA vector w')
                  return
               endif                  
               call manova (iwork, ncmax, ncol1, ntemp, nout, nrmax,
     +                      nrow1, 
     +                      a, w,
     +                      fnamea, titlea, 
     +                      newdat, supply)
            elseif (isend.eq.10) then
c
c isend = 10: canonical variates
c            
               ierr = 0 
               if (allocated(iwork)) deallocate(iwork, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/CVR000 vector iwork')  
                  return
               endif
               
c               liwk = nrmax  
c               allocate(iwork(liwk), stat = ierr)  
               ltemp = nrmax  
               allocate(iwork(ltemp), stat = ierr)
               
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/CVR000 vector iwork') 
                  return
               endif 
               if (allocated(w)) deallocate(w, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/CVR000 vector w')   
                  return
               endif
               
c               nwmin = ncmax*ncmax + 5*(ncmax - 1)  
c               nwmax = nrmax*ncmax +
c     +                 max(5*(ncmax - 1) + nrmax*(ncmax + 1), nrmax)
               l1 = nrmax
               l2 = ncmax 
               nwmin = l2*l2 + 5*(l2 - 1)  
               nwmax = l1*l2 +
     +                 max(5*(l2 - 1) + l1*(l2 + 1), l1)
               if (nwmax.lt.nwmin) nwmax = nwmin  
               nwmax = nwmax + l1*l2  
               allocate(w(nwmax), stat = ierr)
               
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/MANOVA vector w')
                  return
               endif                    
               call cvr000 (iwork, ncmax, ncol1, ngraf, ntemp, nout, 
     +                      nrmax, nrow1, nwmax,  
     +                      a, w,
     +                      fnamea, titlea, 
     +                      newdat, supply) 
            elseif (isend.eq.11) then
c
c isend = 11: discriminant analysis
c            
               ierr = 0 
               if (allocated(iwork)) deallocate(iwork, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/GRP000 vector iwork')  
                  return
               endif
               
c               liwk = nrmax  
c               allocate(iwork(liwk), stat = ierr)  
               ltemp = nrmax  
               allocate(iwork(ltemp), stat = ierr)
               
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/GRP000 vector iwork') 
                  return
               endif 
               if (allocated(w)) deallocate(w, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/GRP000 vector w')   
                  return
               endif
               
c               nwmax = nrmax*(ncmax + 1)
               l1 = nrmax
               l2 = ncmax
               nwmax = l1*(l2 + 1)
               allocate(w(nwmax), stat = ierr)
               
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/GRP000 vector w')
                  return
               endif             
               call grp000 (iwork, ncmax, ncol1, ntemp, nout, nrmax,
     +                      nrow1,   
     +                      a, w,
     +                      fnamea, titlea, 
     +                      newdat, supply) 
            elseif (isend.eq.12) then
c
c isend = 12: factor analysis
            
               if (allocated(w)) deallocate(w, stat = ierr)
               if (ierr.ne.0) then  
                  call puterr (ierr, 'D, M_MVSTAT/FACT01 vector w')   
                  return
               endif
               
c               nwmax = max((5*ncmax*ncmax + 33*ncmax - 4)/2,
c     +                     nrmax*ncmax + 7*ncmax + ncmax*(ncmax - 1)/2)  
                l1 = nrmax
                l2 = ncmax
                nwmax = max((5*l2*l2 + 33*l2 - 4)/2,
     +                     l1*l2 + 7*l2 + l2*(l2 - 1)/2)   
               allocate(w(nwmax), stat = ierr)
               
               if (ierr.ne.0) then
                  call puterr (ierr, 'A, M_MVSTAT/FACT01 vector w')
                  return
               endif           
               call fact01 (ncmax, ncol1, nout, nrmax, nrow1, nwmax,   
     +                      a, w,
     +                      fnamea, titlea, 
     +                      newdat) 
            elseif (isend.eq.13) then
c
c isend = 13: rotation
c            
               call m_orotat (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        titlea,
     +                        newdat)                                                                                                   
            elseif (isend.eq.14) then
c
c isend = 14: biplots
c            
               call m_biplot (ncmax, ncol1, nout, nrmax, nrow1,
     +                        a,
     +                        fnamea, titlea,
     +                        newdat)  
            elseif (isend.eq.15) then
               ierr = 0
               if (allocated(a)) deallocate(a, stat = ierr)
               call puterr (ierr, 'D, M_MVSTAT/MANOVAG matrix a') 
               itype = 1             
               call manovg (itype,
     +                      fnamea,
     +                      newdat)                             
            endif
c
c deallocate additional integer workspace
c            
            ierr = 0
            if (allocated(iwork)) deallocate(iwork, stat = ierr)
            call puterr (ierr, 'D, M_MVSTAT/CLEANUP vector iwork')
            ierr = 0
            if (allocated(jwork)) deallocate(jwork, stat = ierr)
            call puterr (ierr, 'D, M_MVSTAT/CLEANUP vector jwork')
c
c deallocate additional double precision workspace
c              
            ierr = 0 
            if (allocated(w)) deallocate(w, stat = ierr)
            call puterr (ierr, 'D, M_MVSTAT/CLEANUP vector w') 
            if (.not.newdat) then
               ierr = 0
               if (allocated(a)) deallocate(a, stat = ierr)
               call puterr (ierr, 'D, M_MVSTAT/CLEANUP matrix a')
               return
            endif  
         endif
 
      enddo
c------------------------------------------------------------
c End of code to access a matrix
c------------------------------------------------------------
c
 
  100 format (
     +'Now input a multivariate data file or a correlation matrix like',
     +1x,a) 
  200 format (
     +'Now input a file formatted like',1x,a)         
      end
c
c
c-------------------------------------------------------------
c
c
      subroutine m_mvstat_check (isend, ncol, nrow,
     +                           fname)
     
c
c action: check m_mvstat data file
c aothor: bill.bardsley@manchester.ac.uk., 28/07/2006
c
      implicit none
c
c arguments
c          
      integer isend, ncol, nrow
      character fname*(*)   
c
c local allocatable arrays
c
      integer, allocatable :: ivec(:), nreps(:)       
c                         
c locals
c                   
      integer    i, ierr, ios, j, k, n, nerr, ncol1, nin, nline, nmax,
     +           nmin, nrow1, ntype, nvar
      double precision temp1, temp2, test
      double precision epsi, one
      parameter (epsi = 1.0d-03, one = 1.0d+00) 
      character  line*100
      logical    abort
      external   putfat, vu2chk, putadv, vecerr, vecord, getnou
      intrinsic  nint, dble, abs
c
c preliminary check
c       
      if (ncol.lt.2 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         call vu2chk (fname)
         ncol = 0
         nrow = 0
         return
      endif     
c
c individual cases
c                 
      abort = .false.
      if (isend.eq.1 .or. isend.eq.2) then  
c
c correlation
c      
         if (nrow.lt.ncol) then
            write (line,200)
            call putadv (line)
         endif   
      elseif (isend.eq.4 .or. isend.eq.8) then
c
c partial correlation and principal components
c      
         if (nrow.lt.ncol) then
            write (line,300)
            abort = .true.
         endif   
      elseif ((isend.ge.9 .and. isend.le.11) .or. isend.eq.15) then 
c
c MANOVA: (1) open file and check title and header
c      
         call getnou (nin)
         open (unit = nin, file = fname, iostat = ios)
         if (ios.ne.0) then
            write (line,400)
            abort = .true.
         endif  
         if (ios.eq.0) then 
            read (nin,'(a)',iostat=ios) line
            if (ios.ne.0) then
               write (line,500)
               abort = .true.
            endif   
         endif   
         if (ios.eq.0) then
            read (nin,*,iostat=ios) i, j
            if (ios.ne.0 .or. i.ne.nrow .or. j.ne.ncol) then
               ios = - 1
               write (line,600)
               abort = .true.
            endif
         endif 
c
c MANOVA: (2) check column 1 are integers (starting at 1 if isend .ne. 15)
c      
         if (ios.eq.0) then
            n = nrow
            nmin = 1
            nmax = n   
            ierr = 0         
            if (allocated(ivec)) deallocate(ivec, stat = ierr) 
            if (ierr.ne.0) return  
            allocate (ivec(n), stat = ierr) 
            if (ierr.ne.0) return  
            do i = 1, n
               j = i + 2 
               if (ios.eq.0) then
                  read (nin,*,iostat=ios) temp1,
     +                                   (temp2, k = 1, ncol - 1)                    
                  if (i.eq.1 .and. ios.eq.0) then
                     if (isend.eq.15) then
                        ivec(1) = nint(temp1)
                        temp2 = dble(ivec(1))
                     else  
                        ivec(1) = 1 
                        temp2 = one 
                     endif   
                     if (abs(temp1 - temp2).gt.epsi) then
                        ios = - 1
                        if (isend.eq.15) then
                           write (line,800) i, j
                        else   
                           write (line,700)
                        endif   
                        abort = .true.  
                     endif   
                  endif    
                  if (i.gt.1 .and. ios.eq.0) then
                     ivec(i) = nint(temp1)
                     temp2 = dble(ivec(i))
                     test = abs(temp1 - temp2)
                     if (test.gt.epsi) then
                       ios = - 1
                       write (line,800) i, j
                       abort = .true.
                     endif 
                     if (isend.ne.15 .and. ivec(i).lt.ivec(i - 1)) then
                        write (line,800) i, j
                        abort = .true.
                     endif  
                  endif    
               elseif (.not.abort) then
                  abort = .true. 
                  write (line,900) j  
               endif 
            enddo 
         endif          
         close (unit = nin) 
c
c MANOVA: (3) check for increasing integers and big enough groups
c      
         if (ios.eq.0) then
            if (allocated(nreps)) deallocate(nreps, stat = ierr)
            allocate (nreps(n), stat = ierr)
            call vecord (ivec, n, nerr, nline, nmax, nmin, nreps, ntype)
            ncol1 = 1
            nrow1 = nline 
            call vecerr (ncol1, nerr, nmax, nmin, nrow1,
     +                   fname,
     +                   abort)
            if (abort) then
               ncol = 0
               nrow = 0
               return
            elseif (ntype.lt.2) then
               write (line,1000)
               abort = .true. 
            else 
               nvar = ncol - 1
               do i = 1, ntype  
                  if (.not.abort) then
                     if (nreps(i).lt.nvar) then
                        write (line,1100) i, nreps(i), nvar
                        abort = .true.
                     endif
                  endif
               enddo 
            endif                
         endif
         if (allocated(ivec)) deallocate(ivec, stat = ierr)
         if (allocated(nreps)) deallocate(nreps, stat = ierr)
      endif   
c
c action if abort = .true.
c      
      if (abort) then
         call putfat (line)
         call vu2chk (fname)
         ncol = 0
         nrow = 0
      endif   
c
c format statements
c               
  100 format ('Must have no. rows > 1 and no. columns > 1')      
  200 format ('Full analysis requires no. rows >= no. columns')
  300 format ('Must have no. rows > no. columns')
  400 format ('Failure to open file')
  500 format ('Failure to read title off file at line 1')
  600 format ('Failure to read nrow and ncol off file at line 2')
  700 format ('A(1,1) must be equal to 1 to indicate start of group 1')
  800 format ('Column 1 not an integer or out of order at row',i6,
     +        ', i.e. line',i6)
  900 format ('File not formatted correctly at line',i6)
 1000 format ('Must have at least 2 groups')
 1100 format (
     +'Group',i4,1x,',has only',i6,1x,'values but no. variables =',i6) 
      end
c
c      
           