C
C
      SUBROUTINE M_MWUTST (NOUT, NX, NY,
     +                     X, Y,
     +                     TITLEX, TITLEY)
C
C ACTION : Mann-Whitney U test
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          28/01/2006 derived from MWUTST using LWMIN to control EXACT
C          22/07/2021 added E_NUMBERS and E_FORMATS, etc.
C
C          NOUT: (input/unchanged) preconnected unit for output
C            NX: (input/unchanged) X-dimension
C            NY: (input/unchanged) Y-dimension
C             X: (input/unchanged) X-data
C             Y: (input/unchanged) Y-data
C        TITLEX: (input/unchanged) X-title
C        TITLEY: (input/unchanged) Y-title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NOUT, NX, NY
      DOUBLE PRECISION X(NX), Y(NY)
      CHARACTER  TITLEX*(*), TITLEY*(*)
C
C Local allocatable workspace
C
      INTEGER, ALLOCATABLE :: IWRK(:)
      DOUBLE PRECISION, ALLOCATABLE :: RANKS(:), WRK(:)
C
C Locals
C
      INTEGER    I, ICOUNT, IERR, IFAIL, KWRK, LWRK, N, NMAX, NSUM
      INTEGER    ICOLOR, LWMIN, NUMTXT
      PARAMETER (NUMTXT = 18, LWMIN = 5000)
      DOUBLE PRECISION PROB, P1, P2, P3, U1, U2, U3, Z1
      DOUBLE PRECISION DNX, DNY, S, UL, UNORL, UNORU, UU
      DOUBLE PRECISION S15ABF$
      DOUBLE PRECISION PNT5, EPSI
      PARAMETER (PNT5 = 0.5D+00, EPSI = 1.0D-10)
      CHARACTER (LEN = 12) I12(2), FORM12
      CHARACTER (LEN = 13) D13(2), SHOWLJ
      CHARACTER  TAIL*1
      CHARACTER  P1TYPE*23, P2TYPE*23, P3TYPE*23
      CHARACTER  CHOP60*60, TEXT(30)*100
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    EXACT, TIES
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   PLEVEL, PUTIFA, TABLE1, CHOP60
      EXTERNAL   G08AHF$, G08AJF$, G08AKF$, S15ABF$
      INTRINSIC  ABS, MIN, MAX, DBLE
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
C
C Check NX and NY
C
      IF (NX.LT.2 .OR. NY.LT.2) RETURN
C
C Allocate workspaces
C
      IERR = 0
      IF (ALLOCATED(IWRK)) DEALLOCATE(IWRK, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(RANKS)) DEALLOCATE(RANKS, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(WRK)) DEALLOCATE(WRK, STAT = IERR)
      IF (IERR.NE.0) RETURN
      NMAX = MAX(NX,NY)
      LWRK = MAX(2*NMAX, LWMIN)
      ALLOCATE(IWRK(4*NMAX + 2), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(RANKS(2*NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(WRK(LWRK), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Calculate U, Z, and P with TAIL = 'T'
C
      WRITE (NOUT,'(A)') ' ' 
      WRITE (NOUT,'(A)') '***' 
      IFAIL = 1
      TAIL = 'T'
      CALL G08AHF$(NX, X, NY, Y, TAIL, U1, Z1, P1, TIES, RANKS, WRK,
     +             IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08AHF/MWUTST')
      IF (IFAIL.NE.0) THEN
         DEALLOCATE(IWRK, STAT = IERR)
         DEALLOCATE(RANKS, STAT = IERR)
         DEALLOCATE(WRK, STAT = IERR)
         RETURN
      ENDIF
C
C Copy U and set approximate significance levels in case of future errors
C
      U2 = U1
      U3 = U1
      P2 = PNT5
      P3 = PNT5

C
C Calculate exact significance levels for small samples
C
      IFAIL = 1
      IF (MAX(NX,NY).LT.30 .OR. (NX + NY).LT.40) THEN
         IF (.NOT.TIES) THEN
C
C Note: the academic version needs more workspace than the NAG one
C
            KWRK = NX*NY + 1
         ELSE
            N = MIN(NX,NY)
            NSUM = NX + NY
            KWRK = N + N*(N + 1)*NSUM - N*(N + 1)*(2*N + 1)/3 + 1
         ENDIF
         IF (KWRK.LE.LWRK) THEN
            EXACT = .TRUE.
         ELSE
            EXACT = .FALSE.
         ENDIF
      ELSE
         EXACT = .FALSE.
      ENDIF
      IF (EXACT) THEN
         IF (.NOT.TIES) THEN
            CALL G08AJF$(NX, NY, TAIL, U1, P1, WRK, LWRK, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G08AJF/MWUTST')
         ELSE
            CALL G08AKF$(NX, NY, TAIL, RANKS, U1, P1, WRK, LWRK, IWRK,
     +                   IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G08AKF/MWUTST')
         ENDIF
         IF (IFAIL.NE.0) THEN
            DEALLOCATE(IWRK, STAT = IERR)
            DEALLOCATE(RANKS, STAT = IERR)
            DEALLOCATE(WRK, STAT = IERR)
            RETURN
         ENDIF
      ENDIF
      IF (EXACT) THEN
C
C TAIL = 'L' p value to test using H1: x < y, F(x) > G(y)
C
         TAIL = 'L'
         IFAIL = 1
         IF (.NOT.TIES) THEN
            CALL G08AJF$(NX, NY, TAIL, U2, P2, WRK, LWRK, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G08AJF/MWUTST')
         ELSE
            CALL G08AKF$(NX, NY, TAIL, RANKS, U2, P2, WRK, LWRK, IWRK,
     +                   IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G08AKF/MWUTST')
         ENDIF
         IF (IFAIL.NE.0) THEN
            DEALLOCATE(IWRK, STAT = IERR)
            DEALLOCATE(RANKS, STAT = IERR)
            DEALLOCATE(WRK, STAT = IERR)
            RETURN
         ENDIF
C
C TAIL = 'U' p value to test using H1: x > y, F(x) < G(y)
C
         TAIL = 'U'
         IFAIL = 1
         IF (.NOT.TIES) THEN
            CALL G08AJF$(NX, NY, TAIL, U3, P3, WRK, LWRK, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G08AJF/MWUTST')
         ELSE
            CALL G08AKF$(NX, NY, TAIL, RANKS, U3, P3, WRK, LWRK, IWRK,
     +                   IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G08AKF/MWUTST')
         ENDIF
         IF (IFAIL.NE.0) THEN
            DEALLOCATE(IWRK, STAT = IERR)
            DEALLOCATE(RANKS, STAT = IERR)
            DEALLOCATE(WRK, STAT = IERR)
            RETURN
         ENDIF
      ELSEIF(ABS(Z1).GT.EPSI) THEN
C
C probabilities if .NOT.EXACT
C
         DNX = DBLE(NX)
         DNY = DBLE(NY)
         IF (U2.GT.PNT5*DNX*DNY) THEN
            S = (U2 - PNT5*DNX*DNY - PNT5)/Z1
         ELSE
            S = (U2 - PNT5*NX*NY + PNT5)/Z1
         ENDIF
C
C Lower tail test: reject H0 if p < alpha in favour of F(x) > G(y) i.e. x < y
C
         IF (S.GT.EPSI) THEN
            UL = U2
            UNORL = (UL - DNX*DNY*PNT5 + PNT5)/S
            I = 1
            PROB = S15ABF$(UNORL, I)
            P2 = PROB
C
C Upper tail test: reject H0 if p < alpha in favour of F(x) < G(y) i.e. x > y
C
            UU = DNX*DNY - U3
            I = 1
            UNORU = (UU - DNX*DNY*PNT5 + PNT5)/S
            PROB = S15ABF$(UNORU, I)
            P3 = PROB
         ENDIF
      ENDIF
C
C Output the results
C
      E_NUMBERS = E_FORMATS()
      ICOUNT = ICOUNT + 1
      CALL PLEVEL (P1, P1TYPE)
      CALL PLEVEL (P2, P2TYPE)
      CALL PLEVEL (P3, P3TYPE)
      IF (E_NUMBERS) THEN
         WRITE (NOUT,100) ICOUNT, TITLEX, TITLEY,
     +                    NX, NY, 
     +                    U1, Z1,
     +                    P1, P1TYPE, P2, P2TYPE, P3, P3TYPE
         WRITE (TEXT,200) ICOUNT, CHOP60(TITLEX), CHOP60(TITLEY),
     +                    NX, NY,
     +                    U1, Z1,
     +                    P1, P1TYPE, P2, P2TYPE, P3, P3TYPE
      ELSE
         I12(1) = FORM12(NX)
         I12(2) = FORM12(NY)
         D13(1) = SHOWLJ(U1)
         D13(2) = SHOWLJ(Z1)
         WRITE (NOUT,150) ICOUNT, TITLEX, TITLEY,
     +                    I12(1), I12(2), 
     +                    D13(1), D13(2),
     +                    P1, P1TYPE, P2, P2TYPE, P3, P3TYPE
         WRITE (TEXT,250) ICOUNT, CHOP60(TITLEX), CHOP60(TITLEY),
     +                    I12(1), I12(2), 
     +                    D13(1), D13(2),
     +                    P1, P1TYPE, P2, P2TYPE, P3, P3TYPE         
      ENDIF  
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.1  .OR. I.EQ.4  .OR. I.EQ.6 .OR. I.EQ.11 .OR.
     +       I.EQ.13 .OR. I.EQ.15 .OR. I.EQ.17) THEN
            ICOLOR = 4
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
C
C Deallocate workspaces
C
      DEALLOCATE(IWRK, STAT = IERR)
      DEALLOCATE(RANKS, STAT = IERR)
      DEALLOCATE(WRK, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     +/1X,'Wilcoxon-Mann-Whitney U test',I4
     +/1X,'--------------------------------'
     +/1X,'X-data: ',A
     +/1X,'Y-data: ',A
     +/1X,'NX =',I6,1X,'(X sample size)'
     +/1X,'NY =',I6,1X,'(Y-sample size)'
     +/1X,'U  =',1P,E13.5
     +/1X,'z  =',1P,E13.5
     +/1X,'H0 = F(x) is equal to G(y) (x and y are comparable)'
     +/1X,'...= as null hypothesis against the alternatives:-'
     +/1X,'H1 = F(x) not equal to G(y) (x and y not comparable)'
     +/1X,'p  =',0P,F8.4,4X,A
     +/1X,'H2 = F(x) > G(y) (x tend to be smaller than y)'
     +/1X,'p  =',0P,F8.4,4X,A
     +/1X,'H3 = F(x) < G(y) (x tend to be larger than y)'
     +/1X,'p  =',0P,F8.4,4X,A)
  150 FORMAT (
     +/1X,'Wilcoxon-Mann-Whitney U test',I4
     +/1X,'--------------------------------'
     +/1X,'X-data: ',A
     +/1X,'Y-data: ',A
     +/1X,'NX =',1X,A,1X,'(X sample size)'
     +/1X,'NY =',1X,A,1X,'(Y-sample size)'
     +/1X,'U  =',1X,A
     +/1X,'z  =',1X,A
     +/1X,'H0 = F(x) is equal to G(y) (x and y are comparable)'
     +/1X,'...= as null hypothesis against the alternatives:-'
     +/1X,'H1 = F(x) not equal to G(y) (x and y not comparable)'
     +/1X,'p  =',F7.4,4X,A
     +/1X,'H2 = F(x) > G(y) (x tend to be smaller than y)'
     +/1X,'p  =',F7.4,4X,A
     +/1X,'H3 = F(x) < G(y) (x tend to be larger than y)'
     +/1X,'p  =',F7.4,4X,A)   
  200 FORMAT (
     + 'Wilcoxon-Mann-Whitney U test',I4
     +/
     +/'X-data:'
     +/A
     +/'Y-data:'
     +/A
     +/'Size of X-data =',I6
     +/'Size of Y-data =',I6
     +/'U =',1P,E13.5
     +/'z =',1P,E13.5
     +/'H0: F(x) is equal to G(y) (x and y are comparable)'
     +/'    as null hypothesis against the alternatives:-'
     +/'H1: F(x) not equal to G(y) (x and y not comparable)'
     +/'p =',0P,F8.4,4X,A
     +/'H2: F(x) > G(y) (x tend to be smaller than y)'
     +/'p =',0P,F8.4,4X,A
     +/'H3: F(x) < G(y) (x tend to be larger than y)'
     +/'p =',0P,F8.4,4X,A)
  250 FORMAT (
     + 'Wilcoxon-Mann-Whitney U test',I4
     +/
     +/'X-data:'
     +/A
     +/'Y-data:'
     +/A
     +/'Size of X-data =',1X,A
     +/'Size of Y-data =',1X,A
     +/'U =',1X,A
     +/'z =',1X,A
     +/'H0: F(x) is equal to G(y) (x and y are comparable)'
     +/'    as null hypothesis against the alternatives:-'
     +/'H1: F(x) not equal to G(y) (x and y not comparable)'
     +/'p =',F7.4,4X,A
     +/'H2: F(x) > G(y) (x tend to be smaller than y)'
     +/'p =',F7.4,4X,A
     +/'H3: F(x) < G(y) (x tend to be larger than y)'
     +/'p =',F7.4,4X,A)     
      END
C
C
