C
C
      SUBROUTINE M_NDTEST (NOUT, NZ,
     +                     Z,
     +                     TITLE)
C
C ACTION : Kolmogorov-Smirnov and Shapiro-Wilks tests for a normal distribution
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          21/01/2006 megavariate version of NDTEST
C          29/01/2006 edited to accept Z from argument list
C          22/08/2007 edited for version 6
C          19/11/2019 increased PTITLE*40 to PTITLE*80
C          22/06/2021 introduced E_NUMBERS and E_FORMATS, etc.
C
C  NOUT: (input/unchanged) preconnected unit for results
C    NZ: (input/unchanged) sample size
C     Z: (input/unchanged) sample 
C TITLE: (input/unchanged) data title
C
      IMPLICIT   NONE
C
C  Arguments
C
      INTEGER,             INTENT (IN) :: NOUT, NZ
      DOUBLE PRECISION,    INTENT (IN) :: Z(NZ)
      CHARACTER (LEN = *), INTENT (IN) :: TITLE
C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: U(:), V(:), W(:), XGRAF(:),
     +                                 YGRAF(:)
C
C Locals
C
      INTEGER    NMAX, NMAX2
      INTEGER    I, ICOUNT, IERR, IFAIL, NBONF, NDIST, NPTS, NTYPE
      INTEGER    NGRAF, NSWMAX
      PARAMETER (NGRAF = 120, NSWMAX = 10000)
      INTEGER    ICOLOR, IX, IY, NUMTXT
      PARAMETER (IX = 4, IY = 4)
      INTEGER    NUMDEC, NUMOPT, N1, N2, N6, NMIN, NUMPAR
      PARAMETER (N1 = 1, N2 = 2, NMIN = 5, N6 = 6, NUMPAR = 2)
      INTEGER    NUMPOS(20)
      DOUBLE PRECISION PAR(NUMPAR), STDERR(NUMPAR)
      DOUBLE PRECISION D1, Z1, P1
      DOUBLE PRECISION D2, Z2, P2
      DOUBLE PRECISION D3, Z3, P3
      DOUBLE PRECISION ZBAR, ZSIG, ZVAR
      DOUBLE PRECISION XBAR, XSIG, XVAR
      DOUBLE PRECISION PL95(2), PU95(2), T95
      DOUBLE PRECISION CHIL95, CHIU95, RTOL, XTOL
      DOUBLE PRECISION PW, SW
      DOUBLE PRECISION ONE, ZERO
      PARAMETER (ONE = 1.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION PNT025, PNT975
      PARAMETER (PNT025 = 0.025D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION X02AMF$, G01FCF$, G01FBF$
      CHARACTER  CHOP80*80, TITLE1*80
      CHARACTER  DIST*2, DNAME*20, EST*1
      CHARACTER  PTYPE*100, PTYPE1*100, PTYPE2*100, PTYPE3*100
      CHARACTER  P1TYPE*23, P2TYPE*23, P3TYPE*23
      CHARACTER  PTITLE*80
      CHARACTER  ANSWER*40, TEXT(30)*100
      CHARACTER  TEMP(3)*100
      CHARACTER (LEN = 13) D13(6), SHOWLJ
      CHARACTER (LEN = 12) I12, FORM12
      CHARACTER (LEN = 9 ) D09(2), FORM09
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    CALWTS, ESTIM, REPEET
      EXTERNAL   PLEVBI, PUTIFA, PUTFAT, TABLE1, LBOX02,
     +           GETD01, GETDGE, NXXBAR, CHOP80
      EXTERNAL   E_FORMATS, FORM09, FORM12, SHOWLJ   
      EXTERNAL   CDFOUT, PDFOUT, HNPLOT, NDTES1, XSTAT1
      EXTERNAL   G08CBF$, X02AMF$, G01FCF$, G01FBF$, G01DDF$
      INTRINSIC  DBLE, SQRT, TRIM   
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
      DATA       NUMPOS / 20*1 /
C
C Check NZ
C      
      IF (NZ.LT.NMIN) THEN
         CALL PUTFAT ('Insufficient data for a meaningful test')
         RETURN
      ELSE
C
C Initialise
C
         E_NUMBERS = E_FORMATS()
         IF (NZ.LE.NSWMAX) THEN
            NBONF = N2
         ELSE
            NBONF = N1
         ENDIF       
         RTOL = 1.0D+09*X02AMF$()
         XTOL = SQRT(RTOL)
         PAR(1) = ONE
         PAR(2) = ONE
         TITLE1 = TITLE

C
C Call NXXBAR for sample mean and standard deviation
C
         CALL NXXBAR (NZ,
     +                Z, ZBAR, ZVAR)
         ZSIG = SQRT(ZVAR)
     
         IF (ZVAR.LE.RTOL) THEN
            CALL PUTFAT ('Singular data (all identical ?)')
            RETURN
         ENDIF

         npts = nz
         nmax = 4*npts + 4
         if (nmax.lt.ngraf + 4) nmax = ngraf + 4
         nmax2 = 2*nmax

         ierr = 0
         if (allocated(u)) deallocate(u, stat = ierr)
         if (ierr.eq.0) allocate(u(nmax2), stat = ierr)
         if (ierr.ne.0) return

         if (allocated(v)) deallocate(v, stat = ierr)
         if (ierr.eq.0) allocate(v(nmax2), stat = ierr)
         if (ierr.ne.0) return

         if (allocated(w)) deallocate(w, stat = ierr)
         if (ierr.eq.0) allocate(w(nmax2), stat = ierr)
         if (ierr.ne.0) return

         if (allocated(xgraf)) deallocate(xgraf, stat = ierr)
         if (ierr.eq.0) allocate(xgraf(ngraf), stat = ierr)
         if (ierr.ne.0) return

         if (allocated(ygraf)) deallocate(ygraf, stat = ierr)
         if (ierr.eq.0) allocate(ygraf(ngraf), stat = ierr)
         if (ierr.ne.0) return

      ENDIF

C
C Specify the distribution and method to use, i.e. NUMDEC = 2 for normal
C distribution and ESTIM = .TRUE. for parameters estimated from sample
C

      CALL XSTAT1 (ESTIM) 
      
      DIST = 'N'
      DNAME = 'Normal(mu,sigma^2)'
      PTYPE = 'Parameters estimated from the sample are:'
      IF (ESTIM) THEN
         EST = 'E'
         PAR(1) = ZBAR
         PAR(2) = ZVAR
         IF (E_NUMBERS) THEN
            WRITE (PTYPE3,100) 'Sample estimates:', PAR(1), PAR(2)
         ELSE
            D13(1) = SHOWLJ(PAR(1))
            D13(2) = SHOWLJ(PAR(2))
            WRITE (PTYPE3,150) 'Sample estimates:', 
     +                         TRIM(D13(1)), TRIM(D13(2))
         ENDIF      
      ELSE
         EST = 'S'
         PAR(1) = ZBAR
         CALL GETD01 (PAR(1), 'The mean, mu')
         PAR(2) = ZSIG
         CALL GETDGE (PAR(2), ZERO,
     +               'The standard deviation, sigma > 0')
         IF (PAR(2).LT.XTOL) PAR(2) = XTOL
         PAR(2) = PAR(2)**2
         IF (E_NUMBERS) THEN
            WRITE (PTYPE3,100) 'Assumed values:', PAR(1), PAR(2)
         ELSE
            D13(1) = SHOWLJ(PAR(1))
            D13(2) = SHOWLJ(PAR(2))
            WRITE (PTYPE3,150) 'Assumed values:',
     +                         TRIM(D13(1)), TRIM(D13(2))
         ENDIF  
      ENDIF
C
C The KS tests
C
      IFAIL = 1
      NTYPE = 1
      CALL G08CBF$(NZ, Z, DIST, PAR, EST, NTYPE, D1, Z1, P1, U, IFAIL)
      IF (IFAIL.GT.4 .AND. IFAIL.LT.9) THEN
         deallocate (u, stat = ierr)
         deallocate (v, stat = ierr)
         deallocate (w, stat = ierr)
         deallocate (xgraf, stat = ierr)
         deallocate (ygraf, stat = ierr)
         CALL PUTFAT ('Data inconsistent with distribution selected')
         RETURN
      ENDIF
      CALL PUTIFA (IFAIL, NOUT, 'G08CBF/M_NDTEST')
      IF (IFAIL.NE.0) THEN
         deallocate (u, stat = ierr)
         deallocate (v, stat = ierr)
         deallocate (w, stat = ierr)
         deallocate (xgraf, stat = ierr)
         deallocate (ygraf, stat = ierr)
         RETURN
      ENDIF
      IFAIL = 1
      NTYPE = 2
      CALL G08CBF$(NZ, Z, DIST, PAR, EST, NTYPE, D2, Z2, P2, U, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08CBF/M_NDTEST')
      IF (IFAIL.NE.0) THEN
         deallocate (u, stat = ierr)
         deallocate (v, stat = ierr)
         deallocate (w, stat = ierr)
         deallocate (xgraf, stat = ierr)
         deallocate (ygraf, stat = ierr)
         RETURN
      ENDIF
      IFAIL = 1
      NTYPE = 3
      CALL G08CBF$(NZ, Z, DIST, PAR, EST, NTYPE, D3, Z3, P3, U, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08CBF/M_NDTEST')
      IF (IFAIL.NE.0) THEN
         deallocate (u, stat = ierr)
         deallocate (v, stat = ierr)
         deallocate (w, stat = ierr)
         deallocate (xgraf, stat = ierr)
         deallocate (ygraf, stat = ierr)
         RETURN
      ENDIF
C
C Make sure parameters used in test are defined
C      
      XBAR = PAR(1)
      XVAR = PAR(2)
      XSIG = SQRT(XVAR)
C
C Write the sample estimates to PTYPE1 and PTYPE2
C
      STDERR(1) = SQRT(ZVAR/DBLE(NZ))
      IFAIL = 0
      T95 = G01FBF$('Lower-tail', PNT975, DBLE(NZ - 1), IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FBF/M_NDTEST')
      PL95(1) = ZBAR - T95*STDERR(1)
      PU95(1) = ZBAR + T95*STDERR(1)
      IF (E_NUMBERS) THEN
         WRITE (PTYPE1,200) ZBAR, STDERR(1), PL95(1), PU95(1)
      ELSE
         D13(1) = SHOWLJ(ZBAR)
         D13(2) = SHOWLJ(STDERR(1))
         D13(3) = SHOWLJ(PL95(1))
         D13(4) = SHOWLJ(PU95(1))
         WRITE (PTYPE1,250) TRIM(D13(1)), TRIM(D13(2)), TRIM(D13(3)),
     +                      TRIM(D13(4))  
      ENDIF  
      IFAIL = 0
      CHIL95 = G01FCF$(PNT025, DBLE(NZ - N1), IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FCF/M_NDTEST')
      IFAIL = 0
      CHIU95 = G01FCF$(PNT975, DBLE(NZ - N1), IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FCF/M_NDTEST')
      PL95(2) = (DBLE(NZ) - ONE)*ZVAR/CHIU95
      PU95(2) = (DBLE(NZ) - ONE)*ZVAR/CHIL95
      IF (E_NUMBERS) THEN
         WRITE (PTYPE2,300) ZSIG, ZVAR, PL95(2), PU95(2)
      ELSE
         D13(1) = SHOWLJ(ZSIG)
         D13(2) = SHOWLJ(ZVAR)
         D13(3) = SHOWLJ(PL95(2))
         D13(4) = SHOWLJ(PU95(2))
         WRITE (PTYPE2,350) TRIM(D13(1)), TRIM(D13(2)),
     +                      TRIM(D13(3)), TRIM(D13(4)) 
      ENDIF  
            
      IF (NBONF.EQ.N2) THEN
C
C Shapiro-Wilks if NZ sufficiently small
C
         CALWTS = .TRUE.
         IFAIL = 1
         CALL G01DDF$(U, NZ, CALWTS, W, SW, PW, IFAIL)
         IF (IFAIL.NE.0) THEN
            CALL PUTIFA (IFAIL, NOUT, 'G01DDF/M_NDTEST')
            deallocate (u, stat = ierr)
            deallocate (v, stat = ierr)
            deallocate (w, stat = ierr)
            deallocate (xgraf, stat = ierr)
            deallocate (ygraf, stat = ierr)
            RETURN
         ENDIF
         IF (PW.LT.0.005D+00) THEN
            ANSWER = 'Reject normality at 1% sig.level'
         ELSEIF (PW.LT.0.025D+00) THEN
            ANSWER = 'Reject normality at 5% sig.level'
         ELSE
            ANSWER = 'Tentatively accept normality'
         ENDIF
      ELSE
         SW = ZERO
         PW = ONE
         ANSWER = 'ERROR: sample size too large'
      ENDIF
C
C Output the results
C
      ICOUNT = ICOUNT + N1
      CALL PLEVBI (NBONF, 
     +             P1,
     +             P1TYPE)
      CALL PLEVBI (NBONF,
     +             P2,
     +             P2TYPE)
      CALL PLEVBI (NBONF, 
     +             P3,
     +             P3TYPE)
      WRITE (NOUT,'(A)') ' '
      WRITE (NOUT,'(A)') '***'
      IF (E_NUMBERS) THEN
         WRITE (NOUT,400) ICOUNT, DNAME, NBONF, TITLE1, PTYPE, PTYPE1,
     +                    PTYPE2, NZ, PTYPE3, D1, Z1, P1,
     +                    P1TYPE, D2, Z2, P2, P2TYPE, D3, Z3, P3, P3TYPE
      ELSE
         I12 = FORM12(NZ)
         D13(1) = SHOWLJ(D1)
         D13(2) = SHOWLJ(Z1)
         D13(3) = SHOWLJ(D2)
         D13(4) = SHOWLJ(Z2)
         D13(5) = SHOWLJ(D3)
         D13(6) = SHOWLJ(Z3)
         WRITE (NOUT,450) ICOUNT, DNAME, NBONF, TITLE1, PTYPE, PTYPE1,
     +                    PTYPE2, TRIM(I12), PTYPE3, D13(1), D13(2), P1,
     +                    P1TYPE, D13(3), D13(4), P2, P2TYPE, D13(5),
     +                    D13(6), P3, P3TYPE
      ENDIF  
      
      IF (E_NUMBERS) THEN
         WRITE (TEXT,600) ICOUNT, DNAME, NBONF, TITLE1, CHOP80(PTYPE),
     +                    CHOP80(PTYPE1), CHOP80(PTYPE2),
     +                    NZ, CHOP80(PTYPE3), D1, Z1, P1,
     +                    P1TYPE, D2, Z2, P2, P2TYPE, D3, Z3, P3, P3TYPE
      ELSE
         I12 = FORM12(NZ)
         D13(1) = SHOWLJ(D1)
         D13(2) = SHOWLJ(Z1)
         D13(3) = SHOWLJ(D2)
         D13(4) = SHOWLJ(Z2)
         D13(5) = SHOWLJ(D3)
         D13(6) = SHOWLJ(Z3)
         WRITE (TEXT,650) ICOUNT, DNAME, NBONF, TITLE1, PTYPE, PTYPE1,
     +                    PTYPE2, TRIM(I12), PTYPE3, D13(1), D13(2), P1,
     +                    P1TYPE, D13(3), D13(4), P2, P2TYPE, D13(5),
     +                    D13(6), P3, P3TYPE


      ENDIF  
      NUMTXT = 24
      IF (NBONF.EQ.N2) THEN
C
C Shapiro-Wilks results if NZ sufficiently small
C
         IF (E_NUMBERS) THEN
            WRITE (NOUT,500) SW, PW, ANSWER
         ELSE   
            D13(1) = SHOWLJ(SW)   
            WRITE (NOUT,550) TRIM(D13(1)), PW, ANSWER 
         ENDIF 
         IF (E_NUMBERS) THEN 
            WRITE (TEMP,700) SW, PW, ANSWER
         ELSE 
            D13(1) = SHOWLJ(SW)   
            WRITE (TEMP,750) TRIM(D13(1)), PW, ANSWER 
         ENDIF   
         NUMTXT = NUMTXT + 1
         TEXT(NUMTXT) = TEMP(1)
         NUMTXT = NUMTXT + 1
         TEXT(NUMTXT) = TEMP(2)
         NUMTXT = NUMTXT + 1
         TEXT(NUMTXT) = TEMP(3)
      ENDIF
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.1  .OR. I.EQ.4  .OR. I.EQ.12 .OR. I.EQ.13 .OR.
     +       I.EQ.17 .OR. I.EQ.21 .OR. I.EQ.25) THEN
            ICOLOR = 4
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
C
C Set NDIST = 2 and plot/chisqd if required
C
      NDIST = N2
      REPEET = .TRUE.
      NUMDEC = N1
      NUMOPT = N6
      D09(1) = FORM09(XBAR)
      D09(2) = FORM09(XSIG)
      WRITE (PTITLE,800) TRIM(D09(1)), TRIM(D09(2))
      
      WRITE (TEXT,900)
C
C Plotting options
C
      DO WHILE (REPEET)
         ICOLOR = 7
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                TEXT)
         IF (NUMDEC.EQ.1) THEN
C
C Plot CDF and sample CDF: U must be Z in ascending order
C
            CALL CDFOUT (NGRAF, NZ, NDIST, NUMPAR,
     +                   PAR, U, XGRAF, V, YGRAF, W, PTITLE)
            NUMDEC = 2
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Plot PDF and sample PDF: U must be Z in ascending order
C
            CALL PDFOUT (NDIST, NGRAF, NMAX, NUMPAR, NZ,
     +                   PAR, XGRAF, V(1), V(NMAX + 1), YGRAF, W(1),
     +                   W(NMAX + 1), U)
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Half normal plot
C
            IFAIL = N1
            CALL HNPLOT (IFAIL, NZ,
     +                   Z)
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Normal plot
C
            IFAIL = N2
            CALL HNPLOT (IFAIL, NZ,
     +                   Z)
            NUMDEC = NUMOPT
         ELSEIF (NUMDEC.EQ.5) THEN
C
C chi-square test on transforms
C         
            CALL NDTES1 (NBONF, NOUT, NZ,
     +                   U, XBAR, XSIG, V,
     +                   ESTIM)                
         ELSE
C
C Quit
C           
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Deallocate workspaces
C
      deallocate (u, stat = ierr)
      deallocate (v, stat = ierr)
      deallocate (w, stat = ierr)
      deallocate (xgraf, stat = ierr)
      deallocate (ygraf, stat = ierr)
C
C Format statements
C
  100 FORMAT (A,1X,'mu =',1P,E13.5,', sigma^2 =',E12.5)
  150 FORMAT (A,1X,'mu =',1X,A,',','sigma^2 =',1X,A)
  
  200 FORMAT ('mu =',1P,E13.5,', se =',E13.5,', 95%cl = (',
     +E13.5,',',E13.5,')')
  250 FORMAT ('mu =',1X,A,', se =',1X,A,', 95%cl = (',A,',',A,')')
     
  300 FORMAT ('sigma =',1P,E12.5,', sigma^2 =',E12.5,', 95%cl = (',
     +E9.3,',',E9.3,')')
  350 FORMAT ('sigma =',1X,A,', sigma^2 =',1X,A,', 95%cl = (',
     +A,',',A,')')
     
  400 FORMAT (
     +/1X,'Kolmogorov-Smirnov and Shapiro-Wilks tests',I4,':',2X,A
     +/1X,'----------------------------------------------'
     +/1X,'Bonferroni n =',I2,1X,'and the data title is:'
     +/1X,A
     +/1X,A
     +/1X,A
     +/1X,A
     +/1X,'Sample size =',I6,', i.e. number of x-values'
     +/1X,'Parameters used in the tests are:'
     +/1X,A
     +/
     +/1X,'H0 = F(x) equals G(y) (x & theory are comparable) against'
     +/1X,'H1 = F(x) not equal to G(y) (x & theory not comparable)'
     +/1X,'D  =',1P,E13.5
     +/1X,'z  =',1P,E13.5
     +/1X,'p  =',0P,F8.4,4X,A
     +/1X,'H2 = F(x) > G(y) (x tend to be smaller than theoretical)'
     +/1X,'D  =',1P,E13.5
     +/1X,'z  =',1P,E13.5
     +/1X,'p  =',0P,F8.4,4X,A
     +/1X,'H3 = F(x) < G(y) (x tend to be  larger than theoretical)'
     +/1X,'D  =',1P,E13.5
     +/1X,'z  =',1P,E13.5
     +/1X,'p  =',0P,F8.4,4X,A)
  450 FORMAT (
     +/1X,'Kolmogorov-Smirnov and Shapiro-Wilks tests',I4,':',2X,A
     +/1X,'----------------------------------------------'
     +/1X,'Bonferroni n =',I2,1X,'and the data title is:'
     +/1X,A
     +/1X,A
     +/1X,A
     +/1X,A
     +/1X,'Sample size =',1X,A,', i.e. number of x-values'
     +/1X,'Parameters used in the tests are:'
     +/1X,A
     +/
     +/1X,'H0 = F(x) equals G(y) (x & theory are comparable) against'
     +/1X,'H1 = F(x) not equal to G(y) (x & theory not comparable)'
     +/1X,'D  =',1X,A
     +/1X,'z  =',1X,A
     +/1X,'p  =',F7.4,4X,A
     +/1X,'H2 = F(x) > G(y) (x tend to be smaller than theoretical)'
     +/1X,'D  =',1X,A
     +/1X,'z  =',1X,A
     +/1X,'p  =',F7.4,4X,A
     +/1X,'H3 = F(x) < G(y) (x tend to be  larger than theoretical)'
     +/1X,'D  =',1X,A
     +/1X,'z  =',1X,A
     +/1X,'p  =',F7.4,4X,A)
     
  500 FORMAT (
     + 1X,'Shapiro-Wilks normality test:'
     +/1X,'W statistic =',1P,E13.5
     +/1X,'Sign. level =',0P,F8.4,5X,A)
  550 FORMAT (
     + 1X,'Shapiro-Wilks normality test:'
     +/1X,'W statistic =',1X,A
     +/1X,'Sign. level =',F7.4,5X,A)
    
  600 FORMAT (
     + 'Kolmogorov-Smirnov and Shapiro-Wilks tests',I4,':',2X,A
     +/
     +/'Bonferroni n =',I2,1X,'and the data title is:'
     +/A
     +/A
     +/A
     +/A
     +/'Sample size =',I6, ', i.e. number of x-values'
     +/'Parameters used in the tests are:'
     +/A
     +/
     +/'H0 = F(x) equals G(y)(x & theory are comparable) against'
     +/'H1 = F(x) not equal to G(y)(x & theory not comparable)'
     +/'D  =',1P,E13.5
     +/'z  =',1P,E13.5
     +/'p  =',0P,F8.4,4X,A
     +/'H2 = F(x) > G(y) (x tend to be smaller than theoretical)'
     +/'D  =',1P,E13.5
     +/'z  =',1P,E13.5
     +/'p  =',0P,F8.4,4X,A
     +/'H3 = F(x) < G(y) (x tend to be  larger than theoretical)'
     +/'D  =',1P,E13.5
     +/'z  =',1P,E13.5
     +/'p  =',0P,F8.4,4X,A)
  650 FORMAT (
     + 'Kolmogorov-Smirnov and Shapiro-Wilks tests',I4,':',2X,A
     +/
     +/1X,'Bonferroni n =',I2,1X,'and the data title is:'
     +/1X,A
     +/1X,A
     +/1X,A
     +/1X,A
     +/1X,'Sample size =',1X,A,', i.e. number of x-values'
     +/1X,'Parameters used in the tests are:'
     +/1X,A
     +/
     +/1X,'H0 = F(x) equals G(y) (x & theory are comparable) against'
     +/1X,'H1 = F(x) not equal to G(y) (x & theory not comparable)'
     +/1X,'D  =',1X,A
     +/1X,'z  =',1X,A
     +/1X,'p  =',F7.4,4X,A
     +/1X,'H2 = F(x) > G(y) (x tend to be smaller than theoretical)'
     +/1X,'D  =',1X,A
     +/1X,'z  =',1X,A
     +/1X,'p  =',F7.4,4X,A
     +/1X,'H3 = F(x) < G(y) (x tend to be  larger than theoretical)'
     +/1X,'D  =',1X,A
     +/1X,'z  =',1X,A
     +/1X,'p  =',F7.4,4X,A)

     
  700 FORMAT (
     + 'Shapiro-Wilks normality test:'
     +/'W statistic =',1P,E13.5
     +/'Sign. level =',0P,F8.4,5X,A)
  750 FORMAT (
     + 'Shapiro-Wilks normality test:'
     +/'W statistic =',1X,A
     +/'Sign. level =',F7.4,5X,A)
     
c  800 FORMAT ('Normal:mu =',1P,E12.4,',sigma =',E11.4)
  800 FORMAT ('Normal:mu =',1X,A,',sigma =',1X,A)
  
  900 FORMAT (
     + 'Plot cdf and sample cumulative'
     +/'Plot pdf and sample histogram'
     +/'Plot normal scores (half)'
     +/'Plot normal scores (full)'
     +/'Do a chi-square test'
     +/'Quit ... Exit these options')
      END
C
C
