c
c
      subroutine m_onevec (isend, nin, nout, npar, nz,
     +                     par, 
     +                     fnamez, titlez)
c
c action: version of vecone calling subprograms with parameters
c author: w.g.bardsley, university of manchester, u.k.
c         13/09/2007 derived from m_vecone 
c         12/10/2007 removed title1 as vec4in can now change fnamez and titlez  
c         31/01/2008 introduced showit to limit advice to users
c         10/05/2010 introduced NKLCFG to switch on/off the test file advice
c         30/04/2011 introduced call to TFILEQ
c
c   isend: (input/unchanged) as follows:
c           isend = 1: chi-square 
c           isend = 2: F 
c           isend = 3: t 
c     nin: (input/unchanged) unconnected unit for data input
c    nout: (input/unchanged) preconnected unit for results
c    npar: (input/unchanged) no. of parameters
c     par: (input/unchanged) parameters 
c      nz: (input/output) sample size
c  fnamez: (input/output) data file name
c  titlez: (input/output) data title
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: isend, nin, nout, npar 
      integer,             intent (inout) :: nz
      double precision,    intent (in)    :: par(npar)
      character (len = *), intent (inout) :: fnamez, titlez
c
c Local allocatable array
c
      integer,          allocatable :: icount(:), ix(:)
      double precision, allocatable :: z(:)
      double precision, allocatable :: x(:), xgraf(:), xstep(:) 
      double precision, allocatable :: y(:), ygraf(:), ystep(:)
      double precision, allocatable :: e(:), ebins(:), o(:), obins(:) 
c
c locals
c
      integer    nitems, ntop, n1, n21
      parameter (nitems = 5, ntop = 1999, n1 = 1, n21 = 21)
      integer    i, ierr, jsend, ngraf, nmax, npts, ntype, nzmax,
     +           nzsav(nitems)
      integer    n_binomial
      integer    kval9, nklcfg
      double precision p_binomial, r_poisson
      character  no_data*30, no_file*30, word15*15
      parameter (no_data = 'No data',
     +           no_file = 'No file')
      character  header(nitems)*80, line*100, tfiles(nitems)*15
      character  sim256*1024
      logical    abort, chkneg, fixnpt, label, newdat, repeet, supply
      parameter (fixnpt = .false., label = .true.)
      logical    showit(nitems)
      external   isitvf, vec2in, vec3in, vec4in, sim256
      external   dctest, bdtest, pdtest
      external   nklcfg, tfileq
      intrinsic  nint
      save       showit, nzsav, header, tfiles
      data       showit / nitems*.true. /
      data       nzsav /  50, 50, 50, 50, 40 / 
      data       header /
     +'Testing for a chi-square distribution',     !1
     +'Testing for a F distribution',              !2
     +'Testing for a t distribution',              !3      
     +'Testing for a binomial distribution',       !4
     +'Testing for a Poisson distribution'  /      !5
      data       tfiles /
     +'chisqd.tf1',       !1
     +'ftest.tf1',        !2
     +'ttest.tf1',        !3
     +'binomial.tf1',     !4
     +'poisson.tf1' /     !5
c
c------------------------------------------------------------
c Start of code to replace calls to vecone to access a vector
c------------------------------------------------------------
c
      if (isend.lt.1 .or. isend.gt.nitems) return 
      if (nz.le.0) then      
         nz = nzsav(isend)
         fnamez = sim256(tfiles(isend))
      endif   
      repeet = .true.
      do while (repeet)
c
c Step 1: if nz > 0 check if fname supplied is a current vector file
c ======= isitvf returns npts > 0 if fnamez is a vector file
c
         npts = 0
         if (nz.gt.0) call isitvf (npts,
     +                             fnamez)
c
c Step 2: if fnamez is not a vector file of size = num then try to open a file
c ======= vec3in selects a vector file of size npts > 0 if successful
c
         if (npts.le.0 .or. nz.ne.npts) then
            if (showit(isend)) then
               kval9 = nklcfg(n21)
               if (kval9.eq.n1) then
                  word15 = tfiles(isend)(1:15)
                  write (line,100) word15
                  call tfileq (line)
                  showit(isend) = .false.
               endif   
            endif   
            nz = 0
            fnamez = no_file
            titlez = no_data
            jsend = 3
            close (unit = nin)
            call vec3in (jsend, nin, npts,
     +                   fnamez, titlez,
     +                   abort, fixnpt, label)
            close (unit = nin)
            if (abort) then
               nz = 0
               fnamez = no_file
               titlez = no_data
               return
            endif
         endif
         if (npts.le.0) return
c
c Step 3: we now have a vector file with size npts > 0 so allocate workspaces
c ======  if there is any error then ierr is nonzero and exit happens
c
         nz = npts
         ierr = 0
         if (allocated(z)) deallocate(z, stat = ierr)
         if (ierr.ne.0) return  
         nzmax = nz
         if (ierr.eq.0) allocate(z(nzmax), stat = ierr)
         if (ierr.ne.0) return

c
c Step 4: read in the data consisting of nz = npts points from file fname
c ======= if an error occurs then workspaces are deallocated and exit occurs
c         otherwise fname and title are not changed from now on
c
         close (unit = nin)
         call vec2in (nin, nzmax, nz,
     +                z,
     +                fnamez, titlez,
     +                abort)
         close (unit = nin)
         if (abort) then
            deallocate (z, stat = ierr)
            nz = 0
            fnamez = no_file
            titlez = no_data
            return
         endif
c
c Step 5: see what the user wants to do ... fname and title may change in vec4in
c ======= vec4in is the equivalent of vecone offering as follows:
c         abort = .true. on return: deallocate workspaces then exit
c         newdat = .true. on return: try for a new data set
c         newdat = .false. on return: proceed with original or edited data
c         If the data are edited a new fnamex and titlez are returned
c
         call vec4in (nz,
     +                z,
     +                fnamez, header(isend), titlez,
     +                abort, newdat)
         if (abort) then
c
c Option 1 from vec4in: Deallaocate then exit
c --------
c
            deallocate (z, stat = ierr)
            return
         elseif (newdat) then
c
c Option 2 from vec4in: New data
c --------
c
            fnamez = no_file
            titlez = no_data
            nz = 0
         else
c
c Option 3 from vec4in: Proceed to analysis
c --------
c
            newdat = .false.
            ierr = 0
            if (allocated(x)) deallocate(x, stat = ierr)
            if (ierr.ne.0) return 
            nmax = nz  
            allocate(x(nmax), stat = ierr)
            if (ierr.ne.0) return
              
            if (isend.le.3) then  
               if (allocated(xgraf)) deallocate(xgraf, stat = ierr)
               if (ierr.ne.0) return
               if (allocated(xstep)) deallocate(xstep, stat = ierr)
               if (ierr.ne.0) return
               if (allocated(y)) deallocate(y, stat = ierr)
               if (ierr.ne.0) return
               if (allocated(ygraf)) deallocate(ygraf, stat = ierr)
               if (ierr.ne.0) return
               if (allocated(ystep)) deallocate(ystep, stat = ierr)
               if (ierr.ne.0) return  
               ngraf = 100
               allocate(xgraf(ngraf), stat = ierr)
               if (ierr.ne.0) return
               allocate(xstep(2*nmax), stat = ierr)
               if (ierr.ne.0) return
               allocate(y(nmax), stat = ierr)
               if (ierr.ne.0) return
               allocate(ygraf(ngraf), stat = ierr)
               if (ierr.ne.0) return
               allocate(ystep(2*nmax), stat = ierr)
               if (ierr.ne.0) return
            elseif (isend.le.5) then
               if (allocated(icount)) deallocate(icount, stat = ierr)
               if (ierr.ne.0) return
               if (allocated(ix)) deallocate(ix, stat = ierr)
               if (ierr.ne.0) return
               if (allocated(e)) deallocate(e, stat = ierr)
               if (ierr.ne.0) return
               if (allocated(ebins)) deallocate(ebins, stat = ierr)
               if (ierr.ne.0) return
               if (allocated(o)) deallocate(o, stat = ierr)
               if (ierr.ne.0) return
               if (allocated(obins)) deallocate(obins, stat = ierr)
               if (ierr.ne.0) return  
               allocate(icount(0:ntop), stat = ierr)
               if (ierr.ne.0) return 
               allocate(ix(nmax), stat = ierr)
               if (ierr.ne.0) return
               allocate(e(ntop + 1), stat = ierr)
               if (ierr.ne.0) return
               allocate(ebins(ntop + 1), stat = ierr)
               if (ierr.ne.0) return
               allocate(o(ntop + 1), stat = ierr)
               if (ierr.ne.0) return
               allocate(obins(ntop + 1), stat = ierr)
               if (ierr.ne.0) return    
            endif
            
            do i = 1, nmax
               x(i) = z(i)
            enddo
            
            supply = .true.        
            if (isend.le.3) then
               ntype = isend
               if (isend.le.2) then
                  chkneg = .true.
               else
                  chkneg = .false.
               endif      
               call dctest (ngraf, nin, nmax, nout, npar, ntype,
     +                      par, x, xgraf, xstep, y, ygraf, ystep,
     +                      titlez,
     +                      chkneg, supply)
               deallocate(xgraf, stat = ierr)
               deallocate(xstep, stat = ierr)
               deallocate(y, stat = ierr)
               deallocate(ygraf, stat = ierr)
               deallocate(ystep, stat = ierr)  
               
            elseif (isend.le.5) then
               if (isend.eq.4) then
                  n_binomial = nint(par(1))
                  p_binomial = par(2)
                  call bdtest (icount, ix, n_binomial, nmax, nout, ntop,
     +                         e, ebins, o, obins, p_binomial, x,
     +                         titlez,
     +                         supply)                  
               elseif (isend.eq.5) then
                  r_poisson = par(1)
                  call pdtest (icount, ix, nmax, nout, ntop,
     +                         e, ebins, o, obins, r_poisson, x,
     +                         titlez,
     +                         supply)    
               endif 
               deallocate(icount, stat = ierr)
               deallocate(ix, stat = ierr)
               deallocate(e, stat = ierr)
               deallocate(ebins, stat = ierr)
               deallocate(o, stat = ierr)
               deallocate(obins, stat = ierr)
            endif
            
            deallocate(x, stat = ierr)
            
            if (.not.newdat) then
               deallocate(z, stat = ierr)
               return
            endif   
         endif
      enddo
c------------------------------------------------------------
c End of code to replace calls to vecone to access a vector
c------------------------------------------------------------
c
  100 format ('Now input a vector formatted like the test file',1x,a)
      end
c
c
