c
c
      subroutine m_orotat (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     title,
     +                     newdat)
c
c action: write matrix a to a temporary file then call orotat
c author: w.g.bardsley, university of manchester, u.k.
c         01/08/2006 derived from orot01
c         07/11/2006 added intents  
c
c     ncmax: (input/unchanged) max. column dimension
c      ncol: (input/unchanged) no. columns of matrix a, ncol >= 1
c      nout: (input/unchanged) preconnected unit for results
c     nrmax: (input/unchanged) leading dimension of matrix a
c      nrow: (input/unchanged) no. rows of matrix a, nrow > = 1
c         a: (input/unchanged) data matrix
c     title: (input/unchanged) title of matrix a
c    newdat: (output) .true. if new data requested
c
      implicit    none
c
c arguments
c
      integer,             intent (in)  :: ncmax, ncol, nout, nrmax,
     +                                     nrow
      double precision,    intent (in)  :: a(nrmax,ncol)
      character (len = *), intent (in)  :: title
      logical,             intent (out) :: newdat 
c
c local allocatable arrays
c                         
      double precision, allocatable :: r(:,:), w(:), y(:,:), yhat(:,:)
c
c locals
c
      integer    i, ierr, ifail, ios, j, nin, nwmax
      integer    isend
      parameter (isend = 3)
      character  fname*1024, line*100
      logical    abort, askif, there
      parameter (askif = .false.)
      external   orotat, putfat, gettmp, deleet, getnou, i1file, i2file
c
c initialise newdat
c
      newdat = .false.      
c                  
c check dimensions
c
      if (nrow.gt.nrmax .or. nrow.lt.1 .or.
     +    ncol.gt.ncmax .or. ncol.lt.1) then
         write (line,100)
         call putfat (line)
         return
      endif     
      ierr = 0
      if (allocated(r)) deallocate(r, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(w)) deallocate(w, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y)) deallocate(yhat, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(yhat)) deallocate(yhat, stat = ierr)
      if (ierr.ne.0) return
      allocate(r(nrmax,ncol), stat = ierr)
      if (ierr.ne.0) return  
      nwmax = 2*nrmax + ncol*ncol + 5*(ncol - 1)
      allocate(w(nwmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(y(nrmax,ncol), stat = ierr)
      if (ierr.ne.0) return
      allocate(yhat(nrmax,ncol), stat = ierr)
      if (ierr.ne.0) return
c
c write the temporary file
c
      call gettmp (ifail,
     +             fname)   
      call getnou (nin)
      close (unit = nin)
      open (unit = nin, file = fname, iostat = ios)
      if (ios.ne.0) then   
         call deleet (fname,
     +                askif, there)
         close (unit = nin)
         deallocate(r, stat = ierr)  
         deallocate(w, stat = ierr)
         deallocate(y, stat = ierr)
         deallocate(yhat, stat = ierr)
         return
      endif
      write (nin,'(a)',iostat=ios) title
      if (ios.ne.0) then  
         call deleet (fname,
     +                askif, there)
         close (unit = nin)
         deallocate(r, stat = ierr)  
         deallocate(w, stat = ierr)
         deallocate(y, stat = ierr)
         deallocate(yhat, stat = ierr)
         return
      endif      
      call i2file (nin, nrow, ncol)
      do i = 1, nrow
         write (nin,200,iostat=ios) (a(i,j), j = 1, ncol)
         if (ios.ne.0) then
            call deleet (fname,
     +                   askif, there) 
            close (unit = nin)
            deallocate(r, stat = ierr)  
            deallocate(w, stat = ierr)
            deallocate(y, stat = ierr)
            deallocate(yhat, stat = ierr)
            return
         endif
      enddo
      ifail = 1 
      call i1file (nin, ifail)
      write (nin,300)
      close (unit = nin)
c
c rotate
c
      call orotat (isend, ncol, nin, nout, nrmax,
     +             r, w, y, yhat,
     +             fname,
     +             abort)
      newdat = .not.abort
c
c delete temporary file
c
      call deleet (fname,
     +             askif, there)
      close (unit = nin)
      deallocate(r, stat = ierr)  
      deallocate(w, stat = ierr)
      deallocate(y, stat = ierr)
      deallocate(yhat, stat = ierr)
c
c format statements
c      
  100 format ('Dimension exceeded in call to M_OROTAT')
  200 format (1p,50e13.5)
  300 format ('Default line')
      end
c
c
