c
c
      subroutine m_orthog (isend, ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     titlea)
c
c action: fit lines
c author: w.g.bardsley, university of manchester, u.k.
c         21/02/2006 derived from m_meta01
c
c Note: all arguments are input/unchanged
c
      implicit   none
c
c arguments
c
      integer    isend, ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  titlea*(*)
c
c local allocatable arrays
c
      double precision, allocatable :: s(:), x(:), y(:)
c
c locals
c
      integer    i, ifail, npts, ntype
      integer    ierr, nin
      parameter (nin = 3)
      double precision p(2), se(2)
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character  line*100
      logical    abort, covar, goffit, plot, supply, table
      parameter (covar = .true., plot = .true., supply = .true.,
     +           table = .true.)
      external   orthog, putfat
c
c check
c
      if (ncol.lt.2 .or. ncol.gt.3 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate workspaces (nrmax > nrow)
c
      ierr = 0
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y)) deallocate(y, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(s)) deallocate(s, stat = ierr)
      if (ierr.ne.0) return
      npts = nrow
      allocate(x(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(y(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(s(nrmax), stat = ierr)
      if (ierr.ne.0) return
      if (ncol.eq.2) then
         do i = 1, npts
           s(i) = one
         enddo
      else
         do i = 1, npts
            if (a(i,3).le.zero) then
               write (line,200) i
               call putfat (line)
               deallocate(x, stat = ierr)
               deallocate(y, stat = ierr)
               deallocate(s, stat = ierr)
               return
            else
               s(i) = a(i,3)
            endif
         enddo
      endif
c
c call orthog for calculations
c
      do i = 1, npts
         x(i) = a(i,1)
         y(i) = a(i,2)
      enddo
      if (isend.le.3) then
         ntype = isend
         goffit = .false.
      else
         ntype = isend - 3
         goffit = .true.
      endif
      write (nout,300) titlea
      call orthog (ifail, nin, nout, npts, nrmax, ntype,
     +             p, s, se, x, y,
     +             abort, covar, goffit, plot, supply, table)
c
c deallocate workspaces
c
      deallocate(x, stat = ierr)
      deallocate(y, stat = ierr)
      deallocate(s, stat = ierr)
c
c format statements
c
  100 format ('Must have 2 =< no. columns <= 3 and no. rows >= 2')
  200 format ('s <= 0 at data point',i6)
  300 format (
     +/'Title of current linear regression data:'
     +/a)
      end
c
c
