c
c
      subroutine m_pol000 (isend, ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     fnamea, titlea)
c
c action: fit lines and/or polynomials
c author: w.g.bardsley, university of manchester, u.k.
c         21/02/2006 derived from m_orthog
c         23/10/2020 added intents and expects the scheme:
c                    isend = 1: line/calibrate (simple)                           defines ... ntype = 1
c                    isend = 2: line/calibrate (advanced)                         defines ... ntype = 2
c                    isend = 3: polynomial                                        defines ... ntype = 3  
c                    isend = 4: polynomial after transformimg to X(x,y), Y(x,y)   defines ... ntype = 4   
c
c Note: all arguments are input/unchanged
c
      implicit   none
c
c arguments
c
      integer,             intent (in) :: isend, ncmax, ncol, nout,
     +                                    nrmax, nrow
      double precision,    intent (in) :: a(nrmax,ncmax)
      character (len = *), intent (in) :: fnamea, titlea
c
c local allocatable arrays
c
      double precision, allocatable :: e(:), w(:), work1(:,:), w1(:),
     +                                 w2(:), w3(:), w4(:), x(:),
     +                                 xbigt(:,:), xt(:), y(:)
c
c locals
c
      integer    i, ierr, mode, np, npts, ntype
      integer    m3, m7, nin, npmin
      parameter (nin = 3, m3 = 3, m7 = 7, npmin = 200)
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character  dname*80, line*100, type1*100
      logical    abort, new
      parameter (new = .true.)
      external   pol000, putfat, logist
      intrinsic  max
c
c check
c
      if (ncol.lt.2 .or. ncol.gt.3 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate workspaces (np >= nrow)
c
      ierr = 0
      if (allocated(e)) deallocate(e, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w)) deallocate(w, stat = ierr)
      if (allocated(work1)) deallocate(work1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w1)) deallocate(w1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w2)) deallocate(w2, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w3)) deallocate(w3, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w4)) deallocate(w4, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xbigt)) deallocate(xbigt, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(xt)) deallocate(xt, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y)) deallocate(y, stat = ierr)
      if (ierr.ne.0) return
      npts = nrow
      np = max(npmin,nrow)
      allocate(e(np), stat = ierr)
      if (ierr.ne.0) return
      allocate(w(np), stat = ierr)
      if (ierr.ne.0) return
      allocate(work1(m3,np), stat = ierr)
      if (ierr.ne.0) return
      allocate(w1(np), stat = ierr)
      if (ierr.ne.0) return
      allocate(w2(np), stat = ierr)
      if (ierr.ne.0) return
      allocate(w3(np), stat = ierr)
      if (ierr.ne.0) return
      allocate(w4(np), stat = ierr)
      if (ierr.ne.0) return
      allocate(x(np), stat = ierr)
      if (ierr.ne.0) return
      allocate(xbigt(m7,np), stat = ierr)
      if (ierr.ne.0) return
      allocate(xt(np), stat = ierr)
      if (ierr.ne.0) return
      allocate(y(np), stat = ierr)
      if (ierr.ne.0) return
      if (ncol.eq.2) then
         do i = 1, npts
           e(i) = one
         enddo
      else
         do i = 1, npts
            if (a(i,3).le.zero) then
               write (line,200) i
               call putfat (line)
               deallocate(e, stat = ierr)
               deallocate(w, stat = ierr)
               deallocate(work1, stat = ierr)
               deallocate(w1, stat = ierr)
               deallocate(w2, stat = ierr)
               deallocate(w3, stat = ierr)
               deallocate(w4, stat = ierr)
               deallocate(x, stat = ierr)
               deallocate(xbigt, stat = ierr)
               deallocate(xt, stat = ierr)
               deallocate(y, stat = ierr)
               return
            else
               e(i) = a(i,3)
            endif
         enddo
      endif
c
c call polnom for calculations
c
      do i = 1, npts
         x(i) = a(i,1)
         y(i) = a(i,2)
      enddo
      ntype = isend
      if (isend.le.2) then
         mode = 4
      else
         mode = 3
      endif
      abort = .false.
      if (isend.eq.4) then
         call logist (npts,
     +                e, x, y,
     +                type1,
     +                abort)
      endif
      if (.not.abort) then
         write (nout,300) titlea
         call pol000 (mode, m3, m7, nin, nout, np, npts, ntype,
     +                e, w, work1, w1, w2, w3, w4, x, xbigt, xt, y,
     +                dname, fnamea, titlea,
     +                abort, new)
      endif
c
c deallocate workspaces
c
      deallocate(e, stat = ierr)
      deallocate(w, stat = ierr)
      deallocate(work1, stat = ierr)
      deallocate(w1, stat = ierr)
      deallocate(w2, stat = ierr)
      deallocate(w3, stat = ierr)
      deallocate(w4, stat = ierr)
      deallocate(x, stat = ierr)
      deallocate(xbigt, stat = ierr)
      deallocate(xt, stat = ierr)
      deallocate(y, stat = ierr)
c
c format statements
c
  100 format ('Must have 2 =< no. columns <= 3 and no. rows >= 2')
  200 format ('s <= 0 at data point',i6)
  300 format (
     +/'Title of current data:'
     +/a)
      end
c
c
