c
c
      subroutine m_protat (nin, nout, ncmax, nrmax,
     +                     x, y,
     +                     fnamex, fnamey,
     +                     newdat)
c
c action: call protat with data files for Procrustes analysis
c author: w.g.bardsley, university of manchester, u.k., 01/08/2006
c         07/11/2006 added intents
c
c    nin: (input/unchanged) unconnected unit for file openeing
c   nout: (input/unchanged) preconnected unit for results
c  ncmax: (input/unchanged) dimension
c  nrmax: (input/unchanged) dimension
c      x: (input/unchanged) data (should be returned unchanged)
c      y: (input/unchanged) data (should be returned unchanged)
c fnamex: (input/unchanged) file with x
c fnamey: (input/unchanged) file with y  
c newdat: (output) requests for new data
c
      implicit   none
c
c arguments
c
      integer,             intent (in)  :: nin, nout, ncmax, nrmax
      double precision,    intent (in)  :: x(nrmax,ncmax),
     +                                     y(nrmax,ncmax)
      character (len = *), intent (in)  :: fnamex, fnamey
      logical,             intent (out) :: newdat(2)
c
c local allocatable arrays
c
      double precision, allocatable :: r(:,:), res(:), w(:), yhat(:,:)
      double precision, allocatable :: x1(:,:), y1(:,:) 
c
c locals
c
      integer    i, ierr, j, ncolx, ncoly, nrowx, nrowy, nwmax
      integer    isend
      parameter (isend = 2)
      character  filex*1024, filey*1024, line*100
      logical    abort
      external   isitmf, putfat, protat
c
c initialise newdat then check data files provided
c
      newdat(1) = .false.
      newdat(2) = .false.
      call isitmf (ncolx, nrowx,
     +             fnamex)
      call isitmf (ncoly, nrowy,
     +             fnamey)
      if (ncolx.lt.2 .or. ncolx.ne.ncoly) then
         write (line,100) 'columns'
         call putfat (line)
         return
      endif
      if (nrowx.lt.2 .or. nrowx.ne.nrowy) then
         write (line,100) 'rows'
         call putfat (line)
         return
      endif
c
c data are consistent so allocate workspace
c
      ierr = 0
      if (allocated(r)) deallocate(r, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(res)) deallocate(res, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w)) deallocate(w, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x1)) deallocate(x1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y1)) deallocate(y1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(yhat)) deallocate(yhat, stat = ierr)
      if (ierr.ne.0) return
      nwmax = ncmax*ncmax + 7*ncmax
      allocate(r(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(res(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(w(nwmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(x1(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return  
      allocate(y1(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(yhat(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
c
c now call protat with isend = 2: data in x1/filex and y1/filey
c                          
      do j = 1, ncolx 
         do i = 1, nrowx
            x1(i,j) = x(i,j)
         enddo
      enddo 
      do j = 1, ncoly 
         do i = 1, nrowy
            y1(i,j) = y(i,j)
         enddo
      enddo                     
      filex = fnamex
      filey = fnamey
      call protat (isend, ncmax, nin, nout, nrmax,
     +             r, res, w, x1, y1, yhat,
     +             filex, filey,
     +             abort, newdat)
c
c deallocate the workspaces
c
      deallocate(r, stat = ierr)
      deallocate(res, stat = ierr)
      deallocate(w, stat = ierr)
      deallocate(x1, stat = ierr)
      deallocate(y1, stat = ierr)  
      deallocate(yhat, stat = ierr) 
c
c format statement
c      
  100 format ('Must have number of',1x,a,1x,'equal and > 1')
      end
c
c
