c
c
      subroutine m_qrfact (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     titlea)
c
c action: QR factorisation
c author: w.g.bardsley, university of manchester, u.k., 05/02/2006 
c         17/10/2006 removed t and added block = bock-size 
c
c Note: all arguments are input/unchanged
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  titlea*(*)
c
c local allocatable arrays
c
      double precision, allocatable :: w(:)
c
c locals
c
      integer    ierr, nin, nwork
      parameter (nin = 3)
      integer    nblock
      parameter (nblock = 64)
      character  line*100
      logical    abort, disply, fileit, supply
      parameter (disply = .true., fileit = .true., supply = .true.)
      external   qrfact, putfat
      intrinsic  max
c
c check
c
      if (ncol.lt.2 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate workspace
c
      ierr = 0
      if (allocated(w)) deallocate(w, stat = ierr)
      if (ierr.ne.0) return
      nwork = nblock*max(ncmax,nrmax)
      allocate(w(nwork), stat = ierr)
      if (ierr.ne.0) return
c
c call qrfact for calculations
c
      call qrfact (ncmax, ncol, nin, nout, nrmax, nrow, nwork,
     +             a, w,
     +             titlea,
     +             abort, disply, fileit, supply)
c
c deallocate workspace
c
      deallocate(w, stat = ierr)
c
c format statements
c
  100 format ('Must have no. rows >= 2 and no. columns >= 2')
      end
c
c
