c
c
      subroutine m_regran (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     fnamea, titlea,
     +                     newdat)
c
c action: front end to regran
c author: bill.bardsley@manchester.ac.uk, 24/07/2006
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  fnamea*(*), titlea*(*)
      logical    newdat
c
c local allocatable arrays
c
      integer, allocatable :: icen(:), irank(:), isz(:), iwa(:), nv(:)
      double precision, allocatable :: eta(:), parest(:), parvar(:,:),
     +                                 vapvec(:), x(:,:), y(:),
     +                                 work(:), zin(:)
c
c locals
c
      integer    ierr, lwork, nin, nwmax
      parameter (nin = 3)
      logical    supply
      parameter (supply = .true.)
      external   regran
      ierr = 0
      if (allocated(icen)) deallocate(icen, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(irank)) deallocate(irank, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(isz)) deallocate(isz, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(iwa)) deallocate(iwa, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(eta)) deallocate(eta, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(parest)) deallocate(parest, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(parvar)) deallocate(parvar, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(vapvec)) deallocate(vapvec, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y)) deallocate(y, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(work)) deallocate(work, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(zin)) deallocate(zin, stat = ierr)
      if (ierr.ne.0) return
      lwork = nrmax*(ncmax + 1)
      nwmax = nrmax*(nrmax + 1)/2
      allocate(icen(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(irank(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(isz(ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(iwa(4*nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(nv(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(eta(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(parest(4*ncmax + 1), stat = ierr)
      if (ierr.ne.0) return
      allocate(parvar(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(vapvec(nwmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(x(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(y(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(work(lwork), stat = ierr)
      if (ierr.ne.0) return
      allocate(zin(nrmax), stat = ierr)
      if (ierr.ne.0) return

      newdat = .false.
      call regran (icen, irank, isz, iwa, lwork, ncmax, ncol, nin,
     +             nout, nv, nrmax, nrow, nwmax,
     +             a, eta, parest, parvar, vapvec, x, y, work,
     +             zin,
     +             fnamea, titlea,
     +             newdat, supply)

      deallocate (icen, stat = ierr)
      deallocate (irank, stat = ierr)
      deallocate (isz, stat = ierr)
      deallocate (iwa, stat = ierr)
      deallocate (nv, stat = ierr)
      deallocate (eta, stat = ierr)
      deallocate (parest, stat = ierr)
      deallocate (parvar, stat = ierr)
      deallocate (vapvec, stat = ierr)
      deallocate (x, stat = ierr)
      deallocate (y, stat = ierr)
      deallocate (work, stat = ierr)
      deallocate (zin, stat = ierr)
      end
c
c
