c
c
      subroutine m_rob001 (nout, nx,
     +                     x,
     +                     title)
c
c action: robust 1-sample calculations
c author: w.g.bardsley, university of manchester, u.k.
c         30/01/2006 derived from rob001
c         29/04/2016 added INTENT, replaced word60 by word80 and corrected initialisation 
c         14/07/2021 added E_NUMBERS and E_FORMATS, etc.       
c
c         nout: (input/unchanged) preconnected unit for results
c           nx: (input/unchanged) dimension
c            x: (input/unchanged) sample
c        title: (input/unchanged) data title
c
      implicit   none
c
c arguments
c
      integer,             intent (in) :: nout, nx
      double precision,    intent (in) :: x(nx)
      character (len = *), intent (in) :: title
c
c local allocatable workspaces
c
      integer,          allocatable :: iwrk(:)
      double precision, allocatable :: wrk(:)
c
c locals
c
      integer    i, icount, ierr, ifail1, ifail2, ifail3, itemp, j, k, n
      integer    icolor, ix, iy, lshade, numdec, numopt, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numopt = 5)
      integer    numbld(30), numpos(numopt)
      double precision alpha, pcent, used
      double precision xme, xmd, xsd
      double precision tmean, tvar, wmean, wvar
      double precision clevel, estcl, theta, thetal, thetau, wlower,
     +                 wupper
      double precision fbot, ftop, f100
      parameter (fbot = 0.0d+00, ftop = 49.9D+00, f100 = 100.0d+00)
      character (len = 100) line, text(30)
      character (len = 80 ) chop80, word80
      character (len = 13 ) d13(8), showlj      
      character (len = 12 ) form12, word12(3) 
      character (len = 1  ) blank, method
      parameter (blank = ' ', method = 'E')
      logical    e_formats, e_numbers
      logical    repeet
      logical    border
      parameter (border = .false.)
      external   getdm1, chop80, table1, lbox02, patch1, revpro,
     +           putfat, putifa
      external   g07daf$, g07ddf$, g07eaf$
      external   e_formats, form12, showlj
      intrinsic  dble
      save       icount, clevel, pcent
      data       icount / 0 /
      data       clevel, pcent / 0.95d+00, 10.0d+00 /
      data       numbld / 30*0 /
      data       numpos / numopt*1 /
c
c check
c
      if (nx.lt.2) return
      word80 = chop80(title)
c
c alocate workspaces
c
      ierr = 0
      if (allocated(iwrk)) deallocate(iwrk, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(wrk)) deallocate(wrk, stat = ierr)
      if (ierr.ne.0) return
      allocate(iwrk(3*nx), stat = ierr)
      if (ierr.ne.0) return
      allocate(wrk(4*nx), stat = ierr)
      if (ierr.ne.0) return
c
c initialise
c
      e_numbers = e_formats()
      n = nx
      numdec = numopt - 1
c
c main loop
c
      repeet = .true.
      do while (repeet)
         write (text,100) pcent
         call lbox02 (icolor, ix, iy, numdec, numopt, numpos, text)
         if (numdec.eq.1) then
c
c change pcent = 100*alpha
c
            write (line,200)
            call getdm1 (fbot, pcent, ftop, line)
            numdec = numopt - 1
         elseif (numdec.eq.2) then
c
c analyse
c
            if (n.le.2) then
               write (line,300)
               call putfat (line)
               numdec = 2
            else
               alpha = pcent/f100
               ifail1 = 1
               ifail2 = 1
               ifail3 = 1
c
c call g07daf$
c
               call g07daf$(n, x, wrk, xme, xmd, xsd, ifail1)
               if (ifail1.eq.0) then
c
c call g07ddf$ only if call to g07daf$ was successful
c
                  call g07ddf$(n, x, alpha, tmean, wmean, tvar, wvar, k,
     +                         wrk, ifail2)
               endif
               if (ifail1.eq.0 .and. ifail2.eq.0) then
c
c call g07eaf$ only if calls to g07daf$ and g07ddf$ were successful
c
                  call g07eaf$(method, n, x, clevel, theta, thetal,
     +                         thetau, estcl, wlower, wupper, wrk, iwrk,
     +                         ifail3)
               endif
               if (ifail1.eq.0 .and. ifail2.eq.0 .and. ifail3.eq.0) then
c
c output the results
c
                  icount = icount + 1
                  used = f100*dble(n - 2*k)/dble(n)
                  if (e_numbers) then
                     write (text,400) icount, word80,
     +                      n, xme, xmd, xsd,
     +                      tmean, tvar,
     +                      wmean, wvar,
     +                      2*k, n - 2*k, used,
     +                      theta
                  else
                     word12(1) = form12(n)
                     itemp = 2*k
                     word12(2) = form12(itemp)
                     itemp = n - 2*k
                     word12(3) = form12(itemp)
                     d13(1) = showlj(xme)
                     d13(2) = showlj(xmd)
                     d13(3) = showlj(xsd)
                     d13(4) = showlj(tmean)
                     d13(5) = showlj(tvar)
                     d13(6) = showlj(wmean)
                     d13(7) = showlj(wvar)
                     d13(8) = showlj(theta)
                     write (text,450) icount, word80,
     +                                word12(1), d13(1), d13(2), d13(3),
     +                                d13(4), d13(5),
     +                                d13(6), d13(7),
     +                                word12(2), word12(3), used,
     +                                d13(8)
                  endif     
                  j = 15
                  call table1 (j, 'OPEN')
                  write (nout,'(a)') blank
                  do i = 1, 15
                     if (i.eq.1) then
                        j = 4
                     elseif (i.eq.3) then
                        j = 1
                     else
                        j = 0
                     endif
                     write (nout,'(a)') text(i)
                     if (i.eq.2) text(i) = blank
                     call table1 (j, text(i))
                  enddo
                  call table1 (j, 'CLOSE')
               elseif (ifail1.ne.0) then
                  call putifa (ifail1, nout, 'G07DAF/ROB001')
               elseif (ifail2.ne.0) then
                  call putifa (ifail2, nout, 'G07DDF/ROB001')
               elseif (ifail3.ne.0) then
                  call putifa (ifail3, nout, 'G07EAF/ROB001')
               endif
               numdec = numopt - 2
            endif
         elseif (numdec.eq.numopt - 2) then
c
c results
c
            call revpro(nout)
            numdec = numopt - 1
         elseif (numdec.eq.numopt - 1) then
c
c help
c
            write (text,500)
            numtxt = 20
            numbld(1) = 1
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
            numbld(1) = 0
            numdec = 2
         elseif (numdec.eq.numopt) then
c
c cancel
c
            repeet = .false.
         endif
      enddo
c
c deallocate workspaces
c
      deallocate(iwrk, stat = ierr)
      deallocate(wrk, stat = ierr)
c
c format statements
c
  100 format (
     + 'Change percent (current =',f5.2,'%)'
     +/'Calculate'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit these options')
  200 format ('Percentage of data to suppress at each extreme')
  300 format ('First input your data')
  400 format (
     + 'Robust 1-sample analysis no.',i4
     +/'--------------------------------'
     +/'Data:',1x,a
     +/'Total sample size            =',i8
     +/'Median value                 =',1p,e12.4
     +/'Median absolute deviation    =',   e12.4
     +/'Robust standard deviation    =',   e12.4
     +/'Trimmed mean (TM)            =',   e12.4
     +/'Variance estimate for TM     =',   e12.4
     +/'Winsorized mean (WM)         =',   e12.4
     +/'Variance estimate for WM     =',   e12.4
     +/'Number of discarded values   =',i8
     +/'Number of included values    =',i8
     +/'Percentage of sample used    =',0p,f8.2,'% (for TM and WM)'
     +/'Hodges-Lehmann estimate (HL) =',1p,e12.4)
  450 format (
     + 'Robust 1-sample analysis number',i4
     +/'-----------------------------------'
     +/'Data:',1x,a
     +/'Total sample size            =',1x,a
     +/'Median value                 =',1x,a
     +/'Median absolute deviation    =',1x,a
     +/'Robust standard deviation    =',1x,a
     +/'Trimmed mean (TM)            =',1x,a
     +/'Variance estimate for TM     =',1x,a
     +/'Winsorized mean (WM)         =',1x,a
     +/'Variance estimate for WM     =',1x,a
     +/'Number of discarded values   =',1x,a
     +/'Number of included values    =',1x,a
     +/'Percentage of sample used    =',f7.2,'% (for TM and WM)'
     +/'Hodges-Lehmann estimate (HL) =',1x,a)  
  500 format (
     + 'Robust 1-sample analysis'
     +/
     +/'These techniques are used when your data set has outliers, i.e'
     +/'extreme values that are not typical of the distribution, and so'
     +/'would lead to biased parameter estimates. You supply a sample'
     +/'vector X, i.e. X = (x(1), x(2), ..., x(n)) where n >= 2.'
     +/
     +/'The median value is calculated along with the median absolute'
     +/'deviation and also a robust estimate for the sample standard'
     +/'deviation. This calculation uses the whole data set.'
     +/
     +/'Then you have to decide what percentage of the extreme values'
     +/'to reject. For instance, ten percent would lead to rejection'
     +/'of the lower ten percent and upper ten percent as potential'
     +/'outliers, i.e. twenty percent of the data would be rejected.'
     +/'From the remaining data the Trimmed and Winsorized means are'
     +/'then calculated, along with robust variance estimates.'
     +/
     +/'The Hodges-Lehmann location estimator and 95% confidence limits'
     +/'(using all n data values) are useful with symmetric densities.')
      end
c
c
