c
c
      subroutine m_rob002 (nout, nx, ny,
     +                     x, y,
     +                     titlex, titley)
c
c action: robust 2-sample calculations
c author: w.g.bardsley, university of manchester, u.k.
c         30/01/2006 derived from rob002
c         14/07/2021 added E_NUMBERS and E_FORMATS, etc.
c
c         nout: (input/unchanged) preconnected unit for results
c           nx: (input/unchanged) dimension
c           ny: (input/unchanged) dimension
c            x: (input/unchanged) sample
c            y: (input/unchanged) sample
c       titlex: (input/unchanged) data title
c       titley: (input/unchanged) data title
c
      implicit   none
c
c arguments
c
      integer    nout, nx, ny
      double precision x(nx), y(ny)
      character titlex*(*), titley*(*)
c
c local allocatable arrays
c
      integer, allocatable :: iwrk(:)
      double precision, allocatable :: wrk(:)
c
c locals
c
      integer    i, icount, ierr, ifail, j, m, n, nrmax
      integer    icolor, ix, iy, lshade, numdec, numopt, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numopt = 5)
      integer    numbld(30), numpos(numopt)
      double precision pcent
      double precision clevel, estcl, theta, thetal, thetau, ulower,
     +                 uupper
      double precision fbot, ftop, f100
      parameter (fbot = 49.9d+00, ftop = 99.9D+00, f100 = 100.0d+00)
      character  line*100, text(30)*100
      character  chop60*60, wordx*60, wordy*60
      character (len = 12) i12(2), form12
      character (len = 13) d13(5), showlj
      character  blank*1, method*1
      parameter (blank = ' ', method = 'A')
      logical    e_formats, e_numbers
      logical    repeet
      logical    border
      parameter (border = .false.)
      external   e_formats, form12, showlj
      external   getdm1, chop60, table1, lbox02, patch1, revpro,
     +           putfat, putifa
      external   g07ebf$
      intrinsic  max
      save       icount, clevel
      data       icount / 0 /
      data       clevel / 0.95d+00 /
      data       numbld / 30*0 /
      data       numpos / numopt*1 /
      if (nx.lt.2 .or. ny.lt.2) return
c
c allocate workspaces
c
      ierr = 0
      if (allocated(iwrk)) deallocate(iwrk, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(wrk)) deallocate(wrk, stat = ierr)
      if (ierr.ne.0) return
      nrmax = max(nx,ny)
      allocate(iwrk(3*nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(wrk(6*nrmax), stat = ierr)
      if (ierr.ne.0) return
c
c initialise
c
      e_numbers = e_formats() 
      ifail = 1
      n = nx
      m = ny
      wordx = chop60(titlex)
      wordy = chop60(titley)
      numdec = numopt - 1
c
c main loop
c
      repeet = .true.
      do while (repeet)
         pcent = f100*clevel
         write (text,100) pcent
         call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                text)
         if (numdec.eq.1) then
c
c change pcent = 100*alpha
c
            write (line,200)
            call getdm1 (fbot, pcent, ftop, line)
            clevel = pcent/f100
         elseif (numdec.eq.2) then
c
c analyse
c
            if (n.lt.2 .or. m.lt.2) then
               write (line,300)
               call putfat (line)
               numdec = numopt
            else
               clevel = pcent/f100
               ifail = 1
c
c call g07ebf$
c
               call g07ebf$(method, n, x, m, y, clevel, theta, thetal,
     +                      thetau, estcl, ulower, uupper, wrk, iwrk,
     +                      ifail)
               if (ifail.eq.0) then
c
c output the results
c
                  icount = icount + 1
                  if (e_numbers) then
                     write (text,400) icount, wordx, n, wordy, m,
     +                                theta, thetal, thetau, f100*estcl,
     +                                ulower, uupper
                  else
                     i12(1) = form12(n)
                     i12(2) = form12(m)
                     d13(1) = showlj(theta)
                     d13(2) = showlj(thetal)
                     d13(3) = showlj(thetau)
                     d13(4) = showlj(ulower)
                     d13(5) = showlj(uupper)
                     text(2) = blank 
                     write (text,450) icount, wordx, i12(1), wordy,
     +                                i12(2), d13(1), d13(2), d13(3),
     +                                f100*estcl,
     +                                d13(4), d13(5)
                  endif  
                  j = 15
                  call table1 (j, 'OPEN')
                  write (nout,'(a)') blank
                  do i = 1, 12
                     if (i.eq.1) then
                        j = 4
                     elseif (i.eq.3 .or. i.eq.5) then
                        j = 1
                     else
                        j = 0
                     endif
                     write (nout,'(a)') text(i)
                     if (i.eq.2) text(i) = blank
                     call table1 (j, text(i))
                  enddo
                  call table1 (j, 'CLOSE')
               else
                  call putifa (ifail, nout, 'G07EBF/ROB002')
               endif
            endif
         elseif (numdec.eq.numopt - 2) then
c
c results
c
            call revpro(nout)
         elseif (numdec.eq.numopt - 1) then
c
c help
c
            write (text,500)
            numtxt = 20
            numbld(1) = 1
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
            numbld(1) = 0
         elseif (numdec.eq.numopt) then
c
c cancel
c
            repeet = .false.
            return
         endif
         numdec = numopt - 1
      enddo
c
c deallocate workspaces
c
      deallocate(iwrk, stat = ierr)
      deallocate(wrk, stat = ierr)
c
c format statements
c
  100 format (
     + 'Change con.lim. (current =',f7.2,'%)'
     +/'Calculate'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit these option')
  200 format ('Percentage confidence limits required')
  300 format ('Test requires both X and Y data')
  400 format (
     + 'Robust 2-sample analysis number',i4
     +/'==================================='
     +/'X-Data:',1x,a
     +/'X-sample size                =',i8
     +/'Y-Data:',1x,a
     +/'Y-sample size                =',i8
     +/'Difference in location       =',1p,e12.4
     +/'Lower confidence limit       =',   e12.4
     +/'Upper confidence limit       =',   e12.4
     +/'Percentage confidence limit  =',0p,f8.2,'%'
     +/'Lower Mann-whitney U-value   =',1p,e12.4
     +/'Upper Mann-Whitney U-value   =',   e12.4)
  450 format (
     + 'Robust 2-sample analysis number',i4
     +/'-----------------------------------'
     +/'X-Data:',1x,a
     +/'X-sample size                =',1x,a
     +/'Y-Data:',1x,a
     +/'Y-sample size                =',1x,a
     +/'Difference in location       =',1x,a
     +/'Lower confidence limit       =',1x,a
     +/'Upper confidence limit       =',1x,a
     +/'Percentage confidence limit  =',f7.2,'%'
     +/'Lower Mann-whitney U-value   =',1x,a
     +/'Upper Mann-Whitney U-value   =',1x,a)
  500 format (
     + 'Robust 2-sample analyses'
     +/
     +/'These techniques are used when your data set has outliers, i.e'
     +/'extreme values that are not typical of the distribution, and so'
     +/'would lead to biased parameter estimates. You supply vectors'
     +/'x(1),x(2),...,x(n), n > 1, and y(1),y(2),...,y(m), m > 1, then'
     +/'a robust estimate for theta, the difference in location, is'
     +/'worked out together with confidence limit estimates, to test'
     +/'H0: X is distributed as F(x), and Y as F(x - theta). Numerical'
     +/'techniques are used with all of the X and Y data values.'
     +/
     +/'You first decide the percentage confidence limits required,'
     +/'then the procedure calculates a lower U-value and upper U-value'
     +/'for which the null hypothesis theta = theta_0 would not be'
     +/'rejected in a Mann-Whitney U test, together with the percentage'
     +/'confidence range this would contain. For a 100*alpha% range,'
     +/'P(U =< U-low) =< alpha/2'
     +/'P(U =< U-low + 1) > alpha/2'
     +/'P(U >= U-upper) =< alpha/2'
     +/'P(U >= U-upper - 1) > alpha/2.')
      end
c
c
