c
c
      subroutine m_rob003 (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     fnamea, titlea)
c
c action: multilinear regression
c author: w.g.bardsley, university of manchester, u.k.
c         20/07/2006 derived from m_linear
c
c Note: all arguments are input/unchanged
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  fnamea*(*), titlea*(*)
c
c local allocatable arrays
c
      integer, allocatable :: isx(:)
      double precision, allocatable :: a2(:,:), b(:), res(:),
     +                                 s(:), se(:), theory(:), wk(:),
     +                                 wt(:), y(:)
c
c locals
c
      integer    i, ierr
      double precision zero
      parameter (zero = 0.0d+00)
      character  line*100
      external   rob003, putfat
c
c check
c
      if (ncol.lt.3 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate workspaces
c
      ierr = 0
      if (allocated(isx)) deallocate(isx, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(a2)) deallocate(a2, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(res)) deallocate(res, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(s)) deallocate(s, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(se)) deallocate(se, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(theory)) deallocate(theory, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(wk)) deallocate(wk, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(wt)) deallocate(wt, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y)) deallocate(y, stat = ierr)
      if (ierr.ne.0) return
      allocate(isx(ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(a2(nrmax,ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(b(ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(res(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(s(ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(se(ncmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(theory(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(wk(4*nrmax + ncmax*(nrmax + ncmax)), stat = ierr)
      if (ierr.ne.0) return
      allocate(wt(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(y(nrmax), stat = ierr)
      if (ierr.ne.0) return
      do i = 1, nrow
         if (a(i,ncol).lt.zero) then
            write (line,200) i
            call putfat (line)
            deallocate(isx, stat = ierr)
            deallocate(a2, stat = ierr)
            deallocate(b, stat = ierr)
            deallocate(res, stat = ierr)
            deallocate(s, stat = ierr)
            deallocate(se, stat = ierr)
            deallocate(theory, stat = ierr)
            deallocate(wk, stat = ierr)
            deallocate(wt, stat = ierr)
            deallocate(y, stat = ierr)
            return
         endif
      enddo
c
c call rob003 for calculations
c
      call rob003 (isx, ncmax, ncol, nout, nrmax, nrow,
     +             a, a2, b, res, s, se, theory, wk, wt, y,
     +             fnamea, titlea)
c
c deallocate workspaces
c
      deallocate(isx, stat = ierr)
      deallocate(a2, stat = ierr)
      deallocate(b, stat = ierr)
      deallocate(res, stat = ierr)
      deallocate(s, stat = ierr)
      deallocate(se, stat = ierr)
      deallocate(theory, stat = ierr)
      deallocate(wk, stat = ierr)
      deallocate(wt, stat = ierr)
      deallocate(y, stat = ierr)
c
c format statements
c
  100 format ('Must have no. columns >= 3 and no. rows >= 2')
  200 format ('s < 0 at data point',i6)
      end
c
c
