c
c
      subroutine m_surviv (nin, nout)
c
c action: interface to m_matone/surv01 and m_mattwo/surv02
c author: w.g.bardsley, university of manchester, u.k., 03/10/2007
c
      implicit  none
c
c arguments
c
      integer, intent (in) :: nin, nout
c
c locals
c
      integer    isend, numdec
      integer    ncol1, ncol2, ncol3, nrow1, nrow2, nrow3
      integer    numopt, numsta, numtxt 
      parameter (numopt = 5, numsta = 3)
      integer    numbld(30)
      character  text(30)*100
      character  fname1*1024, fname2*1024, fname3*1024,
     +           title1*80, title2*80, title3*80
      character  blank*1
      parameter (blank = ' ')  
      logical    repeet
      external   m_matone, m_mattwo, lstbox, patch2, revpro     
      save       ncol1, ncol2, ncol3, nrow1, nrow2, nrow3
      save       fname1, fname2, fname3, title1, title2, title3
      data       ncol1, ncol2, ncol3 / 0, 0, 0 /
      data       nrow1, nrow2, nrow3 / 0, 0, 0 /
      data       fname1, fname2, fname3 / blank, blank, blank /
      data       title1, title2, title3 / blank, blank, blank /
      data       numbld / 30*0 /
      numdec = numopt - 1
      repeet = .true.
      do while (repeet)
         write (text,100)
         numtxt = numsta + numopt - 1
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.eq.1) then
            isend = 33
            call m_matone (isend, ncol1, nin, nout, nrow1,
     +                     fname1, title1)             
         elseif (numdec.eq.2) then
            isend = 4
            call m_mattwo (isend, ncol2, ncol3, nin, nout, nrow2, nrow3,
     +                     fname2, fname3, title2, title3)           
         elseif (numdec.eq.3) then
            call revpro (nout)
         elseif (numdec.eq.numopt - 1) then
            write (text,200)
            numbld(1) = 1
            numbld(12) = 1
            numbld(16) = 1
            numtxt = 20
            call patch2 (numbld, numtxt,
     +                   text)
            numbld(1) = 0
            numbld(12) = 0
            numbld(16) = 0 
         else
            repeet = .false.
         endif                  
      enddo  
c
c Format statements
c      
  100 format (
     + 'Kaplan-Meier survival analysis'
     +/
     +/'Analyse 1 sample'
     +/'Analyse 2 samples'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit Kaplan-Meier analysis')
  200 format (
     + 'Survival times, i.e., times to failure or right-censoring'
     +/
     +/'The survival time file format must be as follows:'  
     +/'column 1: survival times in any order'
     +/'column 2: 0 = failure, 1 = right-censoring'
     +/'column 3: frequency >= 0'
     +/'Data files with t < 0 in column 1, anything other than 0 or'
     +/'1 in column 2, or integers =< 0 in column 3 will be rejected'
     +/'You can examine one sample in detail or analyse two samples,'
     +/'e.g., where one is a control and the other a treatment group.'
     +/
     +/'Procedures available for one sample'
     +/'A Kaplan-Meier survival curve is constructed and also a'
     +/'Maximum likelihood Weibull survival function is fitted.'
     +/
     +/'Procedures available for two paired samples'
     +/'The Mantel-Haenszel log-rank test is done and graphs can'
     +/'be plotted to test for proportional hazards, exponential,'
     +/'or Weibull distributions. An advanced Kaplan-Meier plot'
     +/'can be displayed to illustrate censored points.')
      end
c
c
