c
c
      subroutine m_svdval (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     titlea)
c
c action: call svdval for singular value decomposition
c author: w.g.bardsley, university of manchester, u.k., 05/02/2006
c
c Note: all arguments are input/unchanged
c
      implicit   none
c
c arguments
c
      integer    ncmax, ncol, nout, nrmax, nrow
      double precision a(nrmax,ncmax)
      character  titlea*(*)
c
c local allocatable arrays
c
      double precision, allocatable :: d(:), work(:)
c
c locals
c
      integer    ierr, icount, irank, lwork, ncol1, ndmax, nin, nrow1,
     +           nsvd
      parameter (nin = 3)
      character  line*100
      logical    abort, dsply, fileit, supply
      parameter (dsply = .true., fileit = .true., supply = .true.)
      external   svdval, putfat
      intrinsic  max
      save       icount
      data       icount / 0 /
c
c check
c
      if (ncol.lt.2 .or. nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate workspaces
c
      ierr = 0
      if (allocated(d)) deallocate(d, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(work)) deallocate(work, stat = ierr)
      if (ierr.ne.0) return
      ncol1 = ncol
      nrow1 = nrow
      lwork = 64*(ncmax + nrmax)
      ndmax = max(ncmax, nrmax)
      allocate(d(ndmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(work(lwork), stat = ierr)
      if (ierr.ne.0) return
c
c call svdval
c
      icount = icount + 1
      write (nout,200) icount
      call svdval (irank, lwork, ncmax, ncol1, ndmax, nin, nout, nrmax,
     +             nrow1, nsvd,
     +             a, d, work,
     +             titlea,
     +             abort, dsply, fileit, supply)
c
c deallocate workspaces
c
      deallocate(d, stat = ierr)
      deallocate(work, stat = ierr)
c
c format statements
c
  100 format ('Must have no. rows >= 2, no. columns >= 2')
  200 format (
     +/'Singular value decomposition',i4
     +/'================================')
      end
c
c
