c
c
      subroutine m_testeo (isend, ndof, nout, nxy, 
     +                     x, y, 
     +                     xtitle, ytitle)
c
c action: call testeo from m_vectwo
c author: w.g.bardsley, university of manchester, u.k., 15/09/2007
c
      implicit none
c
c arguments
c      
      integer,             intent (in)    :: isend, nout, nxy
      integer,             intent (inout) :: ndof
      double precision,    intent (in)    :: x(nxy), y(nxy)
      character (len = *), intent (in)    :: xtitle, ytitle
c
c locals
c      
      integer    i
      integer    nin, nxymin
      parameter (nin = 3, nxymin = 2) 
      double precision rtol, x02amf$
      double precision zero
      parameter (zero = 0.0d+00)
      character  fnamee*1024, fnameo*1024, line*100
      logical    supply
      parameter (supply = .true.)
      external   x02amf$
      external   testeo, putfat
c
c check number of O/E pairs
c      
      if (nxy.lt.nxymin) then
         write (line,100) nxymin
         call putfat (line) 
         return
      endif   
      if (isend.eq.1) then
c
c check degrees of freedom
c        
         if (ndof.lt.1) then
            write (line,200)
            call putfat (line)
            return
         endif   
         if (ndof.gt.nxy - 1) then
            write (line,300)
            call putfat (line)
            return
         endif   
      endif       
c
c check for O(i) < 0, E(i) =< 0
c      
      rtol = 1.0d+09*x02amf$()
      do i = 1, nxy
         if (x(i).lt.zero) then
            write (line,400) i
            call putfat (line)
            return
         endif 
         if (y(i).le.rtol) then
            write (line,500) i
            call putfat (line)
            return
         endif     
      enddo  
c
c Note: x = observed, y = expected so reverse order in call to testeo
c      
      call testeo (isend, ndof, nin, nout, nxy,
     +             y, x, rtol,
     +             fnamee, fnameo, ytitle, xtitle,      
     +             supply)
c
c format staements
c     
  100 format ('Must have at least',i2,1x,'Observed/Expected pairs')     
  200 format ('NDOF = N - 1 - NPAR < 1 in call to M_TESTEO')
  300 format ('NDOF > N - 1 in call to M_TESTEO')
  400 format ('Observed frequency O(i) < 0 at i =',i6)
  500 format ('Expected frequency E(i) =< 0 at i =',i6)
      end
c
c      