C
C
      SUBROUTINE M_TIME01 (NOUT, NX,
     +                     X,
     +                     TITLEX)
C
C ACTION : Sample autocorrelations
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          01/02/2006 derived from TIME01
C          09/05/2011 added INTENTS and calls to FORM12
C          21/03/2012 replaced TSPLOT$ by TSPLOT
C          09/06/2015 improved output table
C          20/10/2021 added E_NUMBERS and E_FORMATS, made default ND = 1, etc.
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NOUT, NX
      DOUBLE PRECISION,    INTENT (IN) :: X(NX)
      CHARACTER (LEN = *), INTENT (IN) :: TITLEX
C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: AR(:), ERROR1(:), ERROR2(:),
     +                                 P(:), R(:), VR(:), XD(:)
C
C Locals
C
      INTEGER    NRMAX
      INTEGER    COLOUR, I, IFAIL, NSAV
      INTEGER    ND, NDS, NK, NL, NS, NVL, NXD
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER  (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 11,
     +            NSTART = 14)
      INTEGER     NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER     IERR, ISEND
      INTEGER     LVEC, MVEC
      PARAMETER  (LVEC = 1, MVEC = 0)
      DOUBLE PRECISION DELTA, DF, ERROR, PSIG, START, XM, XV, STAT
      DOUBLE PRECISION G01ECF$
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      CHARACTER (LEN = 12) I12(7), FORM12, WORD12_ND, WORD12_NDS,
     +                     WORD12_NK, WORD12_NL, WORD12_NS, WORD12_NX,
     +                     WORD12_NXD
      CHARACTER (LEN = 13) D13(3), SHOWLJ, SHOWRJ
      CHARACTER  SIGLEV*30, TITLE*80
      CHARACTER  CHOP80*80, LINE*100, TEXT(30)*100, WORD80*80
      CHARACTER  BLANK*1, TAIL*1
      PARAMETER (BLANK = ' ', TAIL = 'U')
      LOGICAL    REPEET
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    OK
      LOGICAL    FIXED, FLASH, HIGH
      PARAMETER (FIXED = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   E_FORMATS
      EXTERNAL   LBOX01, GETJM1, TABLE1, PUTIFA, CHOP80, PUTFAT,
     +           PATCH1, FORM12, SHOWLJ, SHOWRJ
      EXTERNAL   G13AAF$, G13ABF$, G13ACF$, G01ECF$, TSPLOT, PLEVEL
      INTRINSIC  DBLE, SQRT, MIN
      SAVE       ND, NDS, NK, NL, NS
      DATA       ND, NDS, NK, NL, NS / 1, 0, 10, 10, 0 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Check NX
C
      IF (NX.LT.6) THEN
         CALL PUTFAT ('Sample size too small (< 6)')
         RETURN
      ENDIF
C
C Allocate workspaces
C
      IERR = 0
      IF (ALLOCATED(AR)) DEALLOCATE(AR, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(ERROR1)) DEALLOCATE(ERROR1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(ERROR2)) DEALLOCATE(ERROR2, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(P)) DEALLOCATE(P, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(R)) DEALLOCATE(R, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(VR)) DEALLOCATE(VR, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(XD)) DEALLOCATE(XD, STAT = IERR)
      IF (IERR.NE.0) RETURN
      NRMAX = NX
      ALLOCATE (AR(NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (ERROR1(NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (ERROR2(NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (P(NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (R(NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (VR(NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (XD(NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      NXD = NX
      NUMDEC = NUMOPT - 1
      DELTA = ONE
      START = ZERO
      TITLE = TITLEX
      WORD80 = CHOP80(TITLE)
      OK = .FALSE.
C
C Main loop to analyse X
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (NK.GT.NX - 1) NK = MIN(NX - 1, 10)
         IF (NL.GT.NK) NL = NK
         NXD = NX - ND - NDS*NS
         IF (NXD.LT.1) THEN
            OK = .FALSE.
            CALL PUTFAT (
     +      'Change data or settings: NXD = NX - ND - NDS*NS < 1')
         ENDIF
         WORD12_NX = FORM12(NX)
         WORD12_NXD = FORM12(NXD)
         WORD12_ND = FORM12(ND)
         WORD12_NDS = FORM12(NDS)
         WORD12_NS = FORM12(NS)
         WORD12_NK = FORM12(NK)
         WORD12_NL = FORM12(NL)
         WRITE (TEXT,100) WORD80, WORD12_NX, WORD12_NXD, WORD12_ND,
     +                    WORD12_NDS, WORD12_NS, WORD12_NK, WORD12_NL
         NTEXT = NSTART + NUMOPT - 1
         NUMBLD(1) = 4
         NUMBLD(4) = 1

         IF (NUMDEC.LT.1) THEN
            NUMDEC = 1
         ELSEIF (NUMDEC.GT.NUMOPT) THEN
            NUMDEC = NUMOPT
         ENDIF 
                 
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                FIXED, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(4) = 0
C
C Check for current data
C
         IF (NUMDEC.EQ.1) THEN
            OK = .FALSE.
            IF (NXD.LT.1) THEN
               NUMDEC = 0
               CALL PUTFAT ('First adjust so NX > ND + NDS*NS')
            ELSEIF (NL.GT.NK) THEN
               NUMDEC = 0
               CALL PUTFAT ('First adjust so NK >= NL')
            ELSEIF (NS.EQ.0 .AND. NDS.GT.0) THEN
               NUMDEC = 0
               CALL PUTFAT ('First adjust so NS > 0 if NDS > 0')
            ENDIF
         ENDIF
C
C Check for current analysis
C
         IF (.NOT.OK .AND. NUMDEC.GE.7 .AND. NUMDEC.LE.9) THEN
            NUMDEC = 0
            CALL PUTFAT ('First analyse the current time series data')
         ENDIF
         IF (NUMDEC.EQ.1) THEN
C
C Calculate
C
            IFAIL = 1
            CALL G13AAF$(X, NX, ND, NDS, NS, XD, NXD, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G13AAF/TIME01')
            IF (NK.GT.NXD - 1) NK = NXD - 1
            IF (NL.GT.NK) NL = NK
            IF (IFAIL.EQ.0) THEN
               CALL G13ABF$(XD, NXD, NK, XM, XV, R, STAT, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G13ABF/TIME01')
               IF (IFAIL.EQ.2) CALL PUTFAT (
     +            'Sample values are all identical')
            ELSEIF (IFAIL.EQ.1) THEN
               CALL PUTFAT ('NS = 0 when NDS > 0')
            ELSEIF (IFAIL.EQ.2) THEN
               CALL PUTFAT ('NX =< ND + NDS*NS')
            ENDIF
            IF (IFAIL.EQ.0) THEN
               CALL G13ACF$(R, NK, NL, P, VR, AR, NVL, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G13ACF/TIME01')
               IF (IFAIL.EQ.1) THEN
                  CALL PUTFAT ('NK < NL')
               ELSEIF (IFAIL.EQ.2) THEN
                  CALL PUTFAT ('ABS(R(1)).GE.1')
               ELSEIF (IFAIL.EQ.3) THEN
                  CALL PUTFAT (
     +                'Singular sample ... Calculation failed')
                  IF (NVL.GE.1) IFAIL = 0
               ENDIF
            ENDIF
            IF (IFAIL.EQ.0) THEN
               OK = .TRUE.
               DF = DBLE(NK)
               IFAIL = 1
               PSIG = G01ECF$(TAIL, STAT, DF, IFAIL)
               CALL PUTIFA (IFAIL, NOUT, 'G01ECF/TIME01')
            ELSE
               OK = .FALSE.
            ENDIF
            IF (IFAIL.EQ.0) THEN
C
C Results
C
               CALL PLEVEL (PSIG,
     +                      SIGLEV)                
               COLOUR = 15
               CALL TABLE1 (COLOUR, 'OPEN')
               IF(E_NUMBERS) THEN
                  WRITE (TEXT,200) WORD80, NX, NXD, ND, NDS, NS, NK,
     +                             NVL, XM, XV, STAT, PSIG, SIGLEV
                  WRITE (NOUT,200) TITLE, NX, NXD, ND, NDS, NS, NK,
     +                             NVL, XM, XV, STAT, PSIG, SIGLEV
               ELSE
                  I12(1) = FORM12(NX)
                  I12(2) = FORM12(NXD)
                  I12(3) = FORM12(ND)
                  I12(4) = FORM12(NDS)
                  I12(5) = FORM12(NS)
                  I12(6) = FORM12(NK)
                  I12(7) = FORM12(NVL)
                  D13(1) = SHOWLJ(XM)
                  D13(2) = SHOWLJ(XV)
                  D13(3) = SHOWLJ(STAT)
                  WRITE (TEXT,250) WORD80, I12(1), I12(2), I12(3),
     +                             I12(4), I12(5), I12(6), I12(7),
     +                             D13(1), D13(2), D13(3), PSIG, SIGLEV
                  WRITE (NOUT,250) TITLE, I12(1), I12(2), I12(3),
     +                             I12(4), I12(5), I12(6), I12(7),
     +                             D13(1), D13(2), D13(3), PSIG, SIGLEV
               ENDIF
               COLOUR = 0
               DO I = 1, 14
                  CALL TABLE1 (COLOUR, TEXT(I))
               ENDDO
               WRITE (NOUT,'(A)') BLANK
               WRITE (NOUT,300)
               WRITE (LINE,300)
               COLOUR = 4
               CALL TABLE1 (COLOUR, LINE)
               COLOUR = 0
               DO I = 1, NK
                  IF (E_NUMBERS) THEN
                     IF (I.LE.NVL) THEN
                        WRITE (LINE,400) I, R(I), P(I), VR(I), AR(I)
                        WRITE (NOUT,400) I, R(I), P(I), VR(I), AR(I)
                     ELSE
                        WRITE (LINE,500) I, R(I)
                        WRITE (NOUT,500) I, R(I)
                     ENDIF   
                  ELSE   
                     IF (I.LE.NVL) THEN
                        D13(1) = SHOWRJ(P(I))
                        D13(2) = SHOWRJ(VR(I))
                        D13(3) = SHOWRJ(AR(I))
                        WRITE (LINE,450) I, R(I), D13(1), D13(2), D13(3)
                        WRITE (NOUT,450) I, R(I), D13(1), D13(2), D13(3)
                     ELSE
                        WRITE (LINE,500) I, R(I)
                        WRITE (NOUT,500) I, R(I)
                     ENDIF  
                  ENDIF  
                  CALL TABLE1 (COLOUR, LINE)
               ENDDO
               CALL TABLE1 (COLOUR, 'CLOSE')
            ENDIF
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Change ND
C
            I = 0
            IF (ND.GT.NX - 1 .OR. ND.LE.0) ND = 0
            NSAV = ND
            CALL GETJM1 (I, NSAV, NX - 1,
     +     'Order of non-seasonal differencing required (ND)')
            IF (NSAV.NE.ND) THEN
               OK = .FALSE.
               ND = NSAV
            ENDIF
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Change NDS
C
            I = 0
            IF (NDS.GT.NX - 1 .OR. NDS.LT.0) NDS = 0
            NSAV = NDS
            CALL GETJM1 (I, NSAV, NX - 1,
     +     'Order of seasonal differencing required (NDS)')
            IF (NSAV.NE.NDS) THEN
               OK = .FALSE.
               NDS = NSAV
            ENDIF
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Change NS
C
            I = 0
            IF (NS.GT.NX - 1 .OR. NS.LT.0) NS = 0
            NSAV = NS
            CALL GETJM1 (I, NSAV, NX - 1,
     +     'Seasonality required (NS)')
            IF (NSAV.NE.NS) THEN
               OK = .FALSE.
               NS = NSAV
            ENDIF
         ELSEIF (NUMDEC.EQ.5) THEN
C
C Change NK
C
            I = 1
            IF (NK.GT.NX - 1 .OR. NK.LT.1) NK = 1
            NSAV = NK
            CALL GETJM1 (I, NSAV, NX - 1,
     +     'No. of lags required')
            IF (NSAV.NE.NK) THEN
               OK = .FALSE.
               NK = NSAV
            ENDIF
            IF (NL.GT.NK) NL = NK
         ELSEIF (NUMDEC.EQ.6) THEN
C
C Change NL
C
            I = 1
            IF (NL.GT.NK) NL = NK
            NSAV = NL
            CALL GETJM1 (I, NSAV, NK,
     +     'No. of partial autocorrelations required')
            IF (NSAV.NE.NL) THEN
               OK = .FALSE.
               NL = NSAV
            ENDIF
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Plot time series
C
            ISEND = 1
            CALL TSPLOT (ISEND, LVEC, MVEC, NXD,
     +                   DELTA, ERROR1, ERROR2, START, XD,
     +                   WORD80, 'Time', 'Differenced Values')
         ELSEIF (NUMDEC.EQ.8) THEN
C
C Plot autocorrelations
C
            ERROR = ONE/SQRT(DBLE(NXD))
            DO I = 1, NK
               ERROR1(I) = TWO*ERROR
               ERROR2(I) = - ERROR1(I)
            ENDDO
            ISEND = 6
            CALL TSPLOT (ISEND, LVEC, MVEC, NK,
     +                   DELTA, ERROR1, ERROR2, START, R,
     +                   'Autocorrelation Function',
     +                   'Lags', 'ACF values')
         ELSEIF (NUMDEC.EQ.9) THEN
C
C Plot partial autocorrelations
C
            ERROR = ONE/SQRT(DBLE(NXD))
            DO I = 1, NK
               ERROR1(I) = TWO*ERROR
               ERROR2(I) = - ERROR1(I)
            ENDDO
            ISEND = 6
            CALL TSPLOT (ISEND, LVEC, MVEC, NVL,
     +                   DELTA, ERROR1, ERROR2, START, P,
     +                   'Partial Autocorrelation Function',
     +                   'Lags', 'PACF values')
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C Help
C
            WRITE (TEXT,600)
            NTEXT = 22
            NUMBLD(1) = 1
            NUMBLD(22) = 1
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT, TEXT,
     +                   BORDER)
            NUMBLD(1) = 0
            NUMBLD(22) = 0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Deallocate workspaces
C
      DEALLOCATE(AR, STAT = IERR)
      DEALLOCATE(ERROR1, STAT = IERR)
      DEALLOCATE(ERROR2, STAT = IERR)
      DEALLOCATE(P, STAT = IERR)
      DEALLOCATE(R, STAT = IERR)
      DEALLOCATE(VR, STAT = IERR)
      DEALLOCATE(XD, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     + 'Time series autocorrelation analysis'
     +/
     +/'Title for current time series data is:'
     +/A
     +/
     +/'Current sample size (NX) =',1X,A
     +/'Size after differencing (NXD) =',1X,A
     +/'Non-seasonal differencing order (ND) =',1X,A
     +/'Seasonal differencing order (NDS) =',1X,A
     +/'Assigned seasonality (NS) =',1X,A
     +/'Number of lags requested (NK) =',1X,A
     +/'Number of partial autocorrelations (NL) =',1X,A
     +/
     +/'Calculate'
     +/'Change ND (non-seasonal differencing)'
     +/'Change NDS (seasonal differencing)'
     +/'Change NS (seasonality)'
     +/'Change NK (number of lags requested)'
     +/'Change NL (number of PACFs requested)'
     +/'Plot the differenced time series (XD)'
     +/'Plot autocorrelations +- 2/sqrt(NXD)'
     +/'Plot partial autocorrelations +- 2/sqrt(NXD)'
     +/'Help'
     +/'Quit .. Exit time series autocorrelation options')
  200 FORMAT (
     + '...'
     +/'Current data title is:'
     +/A
     +/'Original dimension (NX)  =',I6
     +/'After differencing (NXD) =',I6
     +/'Non-seasonal order (ND)  =',I6
     +/'Seasonal order (NDS)     =',I6
     +/'Seasonality (NS)         =',I6
     +/'Number of lags (NK)      =',I6
     +/'Number of PACF (NVL)     =',I6
     +/'X-mean (differenced)     =',1P,1X,E13.5
     +/'X-variance (differenced) =',   1X,E13.5
     +/'Statistic (S)            =',   1X,E13.5
     +/'p = P(chi-sq >= S)       =',0P,F8.4,2X,A)
  250 FORMAT (
     + '...'
     +/'Current data title is:'
     +/A
     +/'Original dimension (NX)  =',1X,A
     +/'After differencing (NXD) =',1X,A
     +/'Non-seasonal order (ND)  =',1X,A
     +/'Seasonal order (NDS)     =',1X,A
     +/'Seasonality (NS)         =',1X,A
     +/'Number of lags (NK)      =',1X,A
     +/'Number of PACF (NVL)     =',1X,A
     +/'X-mean (differenced)     =',1X,A
     +/'X-variance (differenced) =',1X,A
     +/'Statistic (S)            =',1X,A
     +/'p = P(chi-sq >= S)       =',F7.4,2X,A)   
  300 FORMAT (' Lag       R          PACF          VR            ARP')
  400 FORMAT (I4,2X,F8.4,1P,3(1X,E13.5))
  450 FORMAT (I4,2X,F8.4,3(1X,A))
  500 FORMAT (I4,F8.4)
  600 FORMAT (
     + 'Definitions for model free time series calculations'
     +/
     +/'The procedures assume you have a sample of values measured'
     +/'at equal increments of time (or space, etc.) and wish to'
     +/'explore the data for possible autocorrelations.'
     +/'X     `the sample (i.e. vector of data with no missing values)'
     +/'NX    `dimension of X'
     +/'XD    `transformed vector derived from X by differencing'
     +/'NXD   `dimension of XD (i.e. NXD = NX - ND - NS*NDS)'
     +/'ND    `order of non-seasonal differencing'
     +/'NDS   `order of seasonal differencing'
     +/'NS    `seasonality of seasonal differencing'
     +/'NK    `number of lags requested'
     +/'NL    `number of partial correlations requested'
     +/'NVL   `number of valid partial correlations'
     +/'R     `calculated autocorrelation coefficients'
     +/'PACF  `calculated partial autocorrelation coefficients'
     +/'VR    `calculated predictor error variance ratios'
     +/'AR    `calculated autoregressive parameters of maximum order'
     +/'S     `statistic for testing H0: all autocorrelations zero'
     +/
     +/'Note: if ND = NDS = NS = 0, the original sample X is analysed.')
      END
C
C
