C
C
      SUBROUTINE M_TIME04 (NOUT, NX,
     +                     X,
     +                     TITLEX)
C
C ACTION : Time series smoothing
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          01/02/2006 derived from TIME04
C          09/05/2011 added INTENTS and calls to FORM12
C          18/10/2021 added E_NUMBERS and E_FORMATS, etc 
C
C          NOUT: (input/unchanged) preconnected unit for results
C            NX: (input/unchanged) sample size
C             X: (input/unchanged) sample
C        TITLEX: (input/unchanged) data title
C
C          NRMAX = maximum dimension
C          V = workspace for primary time
C          W = workspace for secondary time (after smoothing)
C          Y = smooth
C          Z = rough
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NOUT, NX
      DOUBLE PRECISION,    INTENT (IN) :: X(NX)
      CHARACTER (LEN = *), INTENT (IN) :: TITLEX
C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: V(:), W(:), Y(:), Z(:)
C
C Locals
C
      INTEGER    COLOUR, I, IERR, J, NBEGIN, NDIFF, NRMAX, NSTART,
     +           NTOTAL, NTYPE
      INTEGER    NOUT1, NPAR, NPTS
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, KSTART, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, KSTART = 11)
      INTEGER    N0, N1, N2, NTMAX
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, NTMAX = 5)
      INTEGER    NUMBLD(30), NUMPOS(20)
      INTEGER    ISEND
      DOUBLE PRECISION X2(2), X3(2), X4(2), Y2(2), Y3(2), Y4(2)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      LOGICAL    REPEET
      CHARACTER (LEN = 12) FORM12, WORD12_NX, WORD12_NSTART,
     +                     WORD12_NDIFF
      CHARACTER (LEN = 13) D13(4), SHOWRJ
      CHARACTER  FNAME*1024, TITLE*80
      CHARACTER  CHOP80*80, LINE*100, TEXT(30)*100, WORD80*80
      CHARACTER  PTITLE*40, TYPE1(NTMAX)*40, XTITLE*40, YTITLE*40
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, OK
      LOGICAL    FIXED, FLASH, HIGH
      PARAMETER (FIXED = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    AXES, BORDER, GSAVE, FILE1, FILE2, TSHOW1, TSHOW2
      PARAMETER (AXES = .TRUE., BORDER = .FALSE., GSAVE = .TRUE.)
      LOGICAL    QTEXT, QTITLE
      PARAMETER (QTEXT = .TRUE., QTITLE = .TRUE.)
      EXTERNAL   E_FORMATS, SHOWRJ
      EXTERNAL   LBOX01, TABLE1, CHOP80, PUTFAT, LBOX02, FORM12,
     +           PATCH1, TIME03, TIME05, GKS004, GETNOU, VECOUT,
     +           GETJM1, GETJGE, HNPLOT, REVPRO
      SAVE       NDIFF, NSTART, NTYPE
      DATA       NDIFF, NSTART, NTYPE / 1, 1, 5 /
      DATA       TYPE1 / 'Running median span 4 then 2',
     +                   'Running median span 5',
     +                   'Running median span 3',
     +                   'Moving average span 3 Hanning',
     +                   '4253H twice smoother' /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 20*1 /
C
C Check NX
C
      IF (NX.LT.5) THEN
         CALL PUTFAT ('sample size too small')
         RETURN
      ENDIF
C
C Allocate workspace
C
      IERR = 0
      IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Z)) DEALLOCATE(Z, STAT = IERR)
      IF (IERR.NE.0) RETURN
      NRMAX = NX
      ALLOCATE(V(NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(W(NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(Y(NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(Z(NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Initialise
C
      NUMDEC = 12
      TITLE = TITLEX
      WORD80 = CHOP80(TITLE)
      OK = .FALSE.
      E_NUMBERS = E_FORMATS()
C
C Main loop to analyse X
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (NUMDEC.LT.0) NUMDEC = - NUMDEC
         WORD12_NX = FORM12(NX)  
         WORD12_NSTART = FORM12(NSTART)  
         WORD12_NDIFF = FORM12(NDIFF)  
         WRITE (TEXT,100) WORD80, WORD12_NX, WORD12_NSTART, 
     +                    WORD12_NDIFF, TYPE1(NTYPE)
         NUMOPT = 14
         NTEXT = KSTART + NUMOPT - 1
         NUMBLD(1) = 4
         NUMBLD(4) = 1

         IF (NUMDEC.LT.1) THEN
            NUMDEC = 1
         ELSEIF (NUMDEC.GT.NUMOPT) THEN
            NUMDEC = NUMOPT
         ENDIF
         
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, KSTART, NTEXT,
     +                TEXT,
     +                FIXED, FLASH, HIGH)
         NUMBLD(1) = 0
         NUMBLD(4) = 0
C
C Check for current analysis
C
         IF (.NOT.OK) THEN
            IF (NUMDEC.GE.5 .AND. NUMDEC.LE.11) THEN
               NUMDEC = -1
               CALL PUTFAT ('First analyse current time series data')
            ENDIF
         ENDIF
         IF (NUMDEC.EQ.1) THEN
C
C Calculate after copying X into V since V may be altered by TIME05
C
            DO I = N1, NX
               V(I) = X(I)
            ENDDO
            CALL TIME05 (NTYPE, NX, NBEGIN, NTOTAL,
     +                   V, Y, Z)
            OK = .TRUE.
            NUMDEC = 7
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Change NSTART
C
            CALL GETJM1 (N1, NSTART, NX,
     +     'First time value required for plotting')
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Change NDIFF
C
            CALL GETJGE (NDIFF, N1,
     +     'Time increments required for plotting')
         ELSEIF (NUMDEC.EQ.4) THEN
C
C Change TYPE
C
            J = NTYPE
            NUMOPT = NTMAX
            DO I = N1, NTMAX
               TEXT(I) = TYPE1(I)
            ENDDO
            CALL LBOX02 (ICOLOR, IX, IY, J, NUMOPT, NUMPOS,
     +                   TEXT)
            IF (J.NE.NTYPE) THEN
               NTYPE = J
               OK = .FALSE.
               NUMDEC = 1
            ENDIF
         ELSEIF (NUMDEC.EQ.5 .OR. NUMDEC.EQ.6) THEN
C
C Table (and file if requested)
C
            V(N1) = NSTART
            DO I = N2, NX
               V(I) = V(I - N1) + NDIFF
            ENDDO
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            COLOUR = 4
            CALL TABLE1 (COLOUR, WORD80)
            CALL TABLE1 (COLOUR, TYPE1(NTYPE))
            WRITE (LINE,200)
            CALL TABLE1 (COLOUR, LINE)
            COLOUR = 0
            IF (NUMDEC.EQ.5) THEN
               WRITE (NOUT,'(A)') ' '
               WRITE (NOUT,'(A)') 'Data smoothing:'
               WRITE (NOUT,'(A)') WORD80
               WRITE (NOUT,'(A)') TYPE1(NTYPE)
               WRITE (NOUT,'(A)') LINE
            ENDIF
            J = NBEGIN + NTOTAL - N1
            DO I = N1, NX
               IF (E_NUMBERS) THEN
                  IF (I.LT.NBEGIN .OR. I.GT.J) THEN
                     WRITE (LINE,300) V(I), X(I)
                  ELSE
                     WRITE (LINE,400) V(I), X(I), Y(I), Z(I)
                  ENDIF
               ELSE
                  IF (I.LT.NBEGIN .OR. I.GT.J) THEN
                     D13(1) = SHOWRJ(V(I))
                     D13(2) = SHOWRJ(X(I))
                     WRITE (LINE,350) D13(1), D13(2)
                  ELSE
                     D13(1) = SHOWRJ(V(I))
                     D13(2) = SHOWRJ(X(I))
                     D13(3) = SHOWRJ(Y(I))
                     D13(4) = SHOWRJ(Z(I))
                     WRITE (LINE,450) D13(1), D13(2), D13(3), D13(4)
                  ENDIF
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)
               IF (NUMDEC.EQ.5) WRITE (NOUT,'(A)') LINE
            ENDDO
            CALL TABLE1 (COLOUR, 'CLOSE')
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.7) THEN
C
C Plot smooth
C
           V(N1) = NSTART
           DO I = N2, NX
              V(I) = V(I - N1) + NDIFF
           ENDDO
           DO I = N1, NX
             W(I) = V(I)
           ENDDO
           DO I = N1, N2
              X3(I) = ZERO
              X4(I) = ZERO
              Y3(I) = ZERO
              Y4(I) = ZERO
           ENDDO
           PTITLE = TYPE1(NTYPE)
           XTITLE = 'Time'
           YTITLE = 'Data and Smooth'
           CALL GKS004 (N1, N2, N0, N0, N1, N0, N0, N0,
     +                  NX, NTOTAL, N0, N0,
     +                  V, W(NBEGIN), X3, X4,
     +                  X, Y(NBEGIN), Y3, Y4,
     +                  PTITLE, XTITLE, YTITLE,
     +                  AXES, GSAVE)
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.8) THEN
C
C Plot rough
C
           V(N1) = NSTART
           DO I = N2, NX
              V(I) = V(I - N1) + NDIFF
           ENDDO
           DO I = N1, N2
              X2(I) = ZERO
              Y2(I) = ZERO
              X3(I) = ZERO
              X4(I) = ZERO
              Y3(I) = ZERO
              Y4(I) = ZERO
           ENDDO
           PTITLE = TYPE1(NTYPE)
           XTITLE = 'Time'
           YTITLE = 'Rough'
           CALL GKS004 (N0, N0, N0, N0, N2, N0, N0, N0,
     +                  NTOTAL, N0, N0, n0,
     +                  V(NBEGIN), X2, X3, X4,
     +                  Z(NBEGIN), Y2, Y3, Y4,
     +                  PTITLE, XTITLE, YTITLE,
     +                  AXES, GSAVE)
            ISEND = 1
            CALL HNPLOT (ISEND, NTOTAL,
     +                   Z(NBEGIN))            
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.9 .OR. NUMDEC.EQ.10) THEN
C
C Residuals
C
            NPAR = N0
            NPTS = NTOTAL
            IF (NUMDEC.EQ.9) THEN
               FILE1 =.TRUE.
            ELSE
               FILE1 = .FALSE.
            ENDIF
            FILE2 = .TRUE.
            TSHOW1 = .TRUE.
            TSHOW2 = .TRUE.
            CALL TIME03 (NOUT, NPAR, NPTS,
     +                   Z(NBEGIN), Y(NBEGIN), X(NBEGIN),
     +                   FILE1, FILE2, TSHOW1, TSHOW2)
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.11) THEN
C
C File the smooth
C
            CALL GETNOU (NOUT1)
            NPTS = NTOTAL
            ISEND = 1
            TITLE = 'Smoothed data'
            CLOSE (UNIT = NOUT1)
            CALL VECOUT (ISEND, NTOTAL, NOUT1, NPTS,
     +                   Y(NBEGIN),
     +                   FNAME, TITLE,
     +                   ABORT, QTEXT, QTITLE)
            CLOSE (UNIT = NOUT1)
         ELSEIF (NUMDEC.EQ.12) THEN
C
C Help
C
            WRITE (TEXT,500)
            NTEXT = 21
            NUMBLD(1) = 1
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT, TEXT,
     +                   BORDER)
            NUMBLD(1) = 0
            NUMDEC = 1
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
            CALL REVPRO (NOUT)   
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Cancel
C
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Deallocate workspaces
C
      DEALLOCATE(V, STAT = IERR)
      DEALLOCATE(W, STAT = IERR)
      DEALLOCATE(Y, STAT = IERR)
      DEALLOCATE(Z, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     + 'Time series data smoothing'
     +/ 
     +/'Title for current time series data is:'
     +/A
     +/
     +/'Current sample size =',1X,A
     +/'Starting time (Start) =',1X,A
     +/'Time increment (Diff) =',1X,A
     +/'Filter type =',1X,A
     +/
     +/'Calculate'
     +/'Change starting time'
     +/'Change time increment'
     +/'Change smoothing type'
     +/'Table (Display and Save to Results file)'
     +/'Table (Display)'
     +/'Plot smooth'
     +/'Plot rough'
     +/'Analyse residuals (Display and Save to Results file)'
     +/'Analyse residuals (Display)'
     +/'Save smooth As...'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit time series data smoothing')
  200 FORMAT (
     +'          Time          Data        Smooth         Rough')
  300 FORMAT (1P,2(1X,E13.5))
  350 FORMAT (2(1X,A13))
  400 FORMAT (1P,4(1X,E13.5))
  450 FORMAT (4(1X,A13))
  500 FORMAT (
     + 'Definitions for time series smoothing'
     +/
     +/'The procedures assume you have a sample of values measured'
     +/'at equal increments of time (or space, etc.) and wish to'
     +/'generate smooth (i.e. best-fit) and rough (i.e. residuals).'
     +/'Start `first time value'
     +/'Diff  `increment between time values'
     +/
     +/'Type  `type of smoothing filter required as follows:'
     +/'1)    `Running median span 4 then 2'
     +/'2)    `Running median span 5'
     +/'3)    `Running median span 3'
     +/'4)    `Moving average span 3 Hanning'
     +/'5)    `4253H twice smoother'
     +/
     +/'Even span moving averages use Hanning, 4253H twice does 4 by 2,'
     +/'then 5, then 3 running medians, then Hanning, then re-roughs.'
     +/'Try 3) for sparse data, 4253H twice for extensive data.'
     +/'Data can be plotted, tables of smooth and rough can be saved'
     +/'to file and/or displayed, residuals can be analysed, and the'
     +/'smooth can be written to a file for time series analysis.')
      END
C
C
