c
c
      subroutine m_trinom (ncmax, ncol, nout, nrmax, nrow,
     +                     a,
     +                     fname, title,
     +                     newdat)
c
c action: call trinom
c author: w.g.bardsley, university of manchester, u.k., 22/09/2007
c
      implicit none
c
c arguments
c          
      integer,             intent (in)    :: ncmax, ncol, nout, nrmax,
     +                                       nrow
      double precision,    intent (in)    :: a(nrmax,ncmax)
      character (len = *), intent (inout) :: fname, title
      logical,             intent (out)   :: newdat 
c
c local allocatable workspace
c      
      integer,          allocatable :: nobs(:,:)
      double precision, allocatable :: b(:), pred(:,:)
c
c locals
c                                             
      integer    ierr, nin
      parameter (nin = 3)
      logical    supply
      parameter (supply = .true.)
      external   trinom, putfat
      if (ncol.ne.3) then
         call putfat ('Must have 3 columns: x, y, and N = x + y + z')
         return
      endif   
      ierr = 0
      if (allocated(nobs)) deallocate(nobs, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(pred)) deallocate(pred, stat = ierr)
      if (ierr.ne.0) return    
      allocate(nobs(nrmax + 1, ncmax + 1), stat = ierr)
      if (ierr.ne.0) return  
      allocate(b(nrmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(pred(nrmax + 1, ncmax + 1), stat = ierr)
      if (ierr.ne.0) return 
      call trinom (ncmax, nin, nobs, nout, nrmax, nrow,
     +             a, b, pred,
     +             fname, title,
     +             newdat, supply)

      deallocate(nobs, stat = ierr)
      deallocate(b, stat = ierr)
      deallocate(pred, stat = ierr)
      end
c
c      