C
C
      SUBROUTINE M_TTEST1 (NOUT, NUMX,
     +                     x,
     +                     TITLEX)
C
C ACTION : megavariate version of 1-sample t test
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          22/01/2206 derived from TTEST1
C          29/01/2006 edited to accept X as an argument
C          26/09/2016 increased number of significant figures, etc.
C          19/07/2021 added E_NUMBERS and E_FORMATS, etc.
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NOUT, NUMX
      DOUBLE PRECISION,    INTENT (IN) :: X(NUMX)
      CHARACTER (len = *), INTENT (IN) :: TITLEX
C
C Local allocatable workspace
C
      DOUBLE PRECISION, ALLOCATABLE :: XSTEP(:), YSTEP(:)
C
C Locals
C
      INTEGER    NMAX, NMAX2, NPTS
      INTEGER    I, ICOLOR, ICOUNT, IERR, IFAIL, NDOF, NUMTXT
      INTEGER    ISEND
      PARAMETER (ISEND = 4)
      INTEGER    IX, IY, K0, K1, K2, K3
      PARAMETER (IX = 4, IY = 4, K0 = 0, K1 = 1, K2 = 2, K3 = 3)
      DOUBLE PRECISION PNT01, PNT05, PNT975
      PARAMETER (PNT01 = 0.01D+00, PNT05 = 0.05D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION RTOL
      DOUBLE PRECISION SEMEAN, XMU
      DOUBLE PRECISION ALPHA, BETA, GAMMA, XBAR, XVAR
      DOUBLE PRECISION DIFF, DHIGH, DLOW, DNDF
      DOUBLE PRECISION TU, T95
      DOUBLE PRECISION G01EBF$, G01FBF$, X02AMF$
      CHARACTER (LEN = 100) LINE, TEXT(30), TTEXT(4), TEMP(4)
      CHARACTER (LEN = 80 ) TITLE1
      CHARACTER (LEN = 60 ) CHOP60, WORD60
      CHARACTER (LEN = 12 ) FORM12, WORD12(2)
      CHARACTER (LEN = 13 ) D13(4), SHOWLJ 
      CHARACTER (LEN = 3  ) STAR3
      PARAMETER (STAR3 = '***')
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    REPEET
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   G01EBF$, G01FBF$, X02AMF$
      EXTERNAL   NXXBAR, PUTFAT, PUTIFA, TABLE1, MIDDLE, NORDIS, GETD01,
     +           CHOP60, YESNO2
      INTRINSIC  SQRT, MIN, DBLE
      SAVE       XMU
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
      DATA       XMU / ZERO /
      
      IF (NUMX.LT.K2) THEN
C
C NX too small so inform user then exit
C
         WRITE (LINE,100) NUMX
         CALL PUTFAT (LINE)
         RETURN
      ELSE
C
C Initialise then allocate workspace
C
         E_NUMBERS = E_FORMATS()
         RTOL = 1.0D+09*X02AMF$()
         RTOL = 1.0D+09*RTOL
         TITLE1 = TITLEX

         npts = numx
         nmax = npts
         nmax2 = 2*nmax
         ierr = 0
         if (allocated(xstep)) deallocate(xstep, stat = ierr)
         if (ierr.eq.0) allocate(xstep(nmax2), stat = ierr)
         if (ierr.ne.0) return

         if (allocated(ystep)) deallocate(ystep, stat = ierr)
         if (ierr.eq.0) allocate(ystep(nmax2), stat = ierr)
         if (ierr.ne.0) return

      ENDIF

C
C Calculate means and variances
C
      
      CALL NXXBAR (NUMX,
     +             X, XBAR, XVAR)
      SEMEAN = SQRT(XVAR/DBLE(NUMX))
      IF (XVAR.LE.RTOL) THEN
         DEALLOCATE(XSTEP, STAT = IERR)
         DEALLOCATE(YSTEP, STAT = IERR)
         WRITE (LINE,200)
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C Shapiro-Wilks
C
      WRITE (NOUT,'(A)') BLANK
      WRITE (NOUT,'(A)') STAR3
      WORD60 = CHOP60(TITLE1)
      CALL NORDIS (ISEND, NUMX, NOUT,
     +             X, XSTEP, YSTEP,
     +             TTEXT, WORD60)
C
C Get reference
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         WRITE (LINE,300)
         CALL GETD01 (XMU, LINE)
C
C t test
C
         DIFF = XBAR - XMU
         TU = DIFF/SEMEAN
         NDOF = NUMX - K1
         DNDF = DBLE(NDOF)
         IFAIL = K1
         BETA = G01EBF$('Lower-tail', TU, DNDF, IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G01EBF/TTEST1')
         ALPHA = ONE - BETA
         GAMMA = TWO*MIN(ALPHA, BETA)
         CALL MIDDLE (ZERO, ALPHA, ONE)
         CALL MIDDLE (ZERO, BETA, ONE)
         CALL MIDDLE (ZERO, GAMMA, ONE)
         ICOUNT = ICOUNT + K1
         IF (E_NUMBERS) THEN
            WRITE (TEXT,400) ICOUNT, TITLE1,
     +                       NUMX, NDOF, XMU, XBAR, SEMEAN, TU,
     +                       ALPHA, BETA, GAMMA
            WRITE (NOUT,500) ICOUNT, TITLE1,
     +                       NUMX, NDOF, XMU, XBAR, SEMEAN, TU,
     +                       ALPHA, BETA, GAMMA
         ELSE
            WORD12(1) = FORM12(NUMX)
            WORD12(2) = FORM12(NDOF)
            D13(1) = SHOWLJ(XMU)
            D13(2) = SHOWLJ(XBAR)
            D13(3) = SHOWLJ(SEMEAN)
            D13(4) = SHOWLJ(TU)
            WRITE (TEXT,450) ICOUNT, TITLE1,
     +                       WORD12(1), WORD12(2), D13(1), D13(2), 
     +                       D13(3), D13(4),
     +                       ALPHA, BETA, GAMMA
            WRITE (NOUT,550) ICOUNT, TITLE1,
     +                       WORD12(1), WORD12(2), D13(1), D13(2), 
     +                       D13(3), D13(4),            
     +                       ALPHA, BETA, GAMMA
         ENDIF
         NUMTXT = 11
         IFAIL = K1
         T95 = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), IFAIL)
         IF (IFAIL.EQ.K0) THEN
            DLOW = DIFF - T95*SEMEAN
            DHIGH = DIFF + T95*SEMEAN
            IF (E_NUMBERS) THEN
               WRITE (TEMP,600) DIFF, DLOW, DHIGH
               WRITE (NOUT,700) DIFF, DLOW, DHIGH
            ELSE
               D13(1) = SHOWLJ(DIFF)
               D13(2) = SHOWLJ(DLOW)
               D13(3) = SHOWLJ(DHIGH) 
               WRITE (TEMP,650) D13(1), D13(2), D13(3)
               WRITE (NOUT,750) D13(1), D13(2), D13(3)
            ENDIF   
            DO I = K1, K3
               NUMTXT = NUMTXT + K1
               TEXT(NUMTXT) = TEMP(I)
            ENDDO
         ELSE
            CALL PUTIFA (IFAIL, NOUT, 'G01FBF/TTEST1')
         ENDIF

         IF (GAMMA.LE.PNT01) THEN
            WRITE (LINE,800)
            WRITE (NOUT,800)
         ELSEIF (GAMMA.LE.PNT05) THEN
            WRITE (LINE,900)
            WRITE (NOUT,900)
         ELSE
            WRITE (LINE,1000)
            WRITE (NOUT,1000)
         ENDIF
         NUMTXT = NUMTXT + K1
         TEXT(NUMTXT) = BLANK
         NUMTXT = NUMTXT + K1
         TEXT(NUMTXT) = LINE

         ICOLOR = 15
         CALL TABLE1 (ICOLOR, 'OPEN')
         DO I = K1, NUMTXT
            IF (I.EQ.1 .OR. I.EQ.NUMTXT) THEN
               ICOLOR = 4
            ELSE
               ICOLOR = 0
            ENDIF
            CALL TABLE1 (ICOLOR, TEXT(I))
         ENDDO
         CALL TABLE1 (ICOLOR, 'CLOSE')
         ICOLOR = 1
         WRITE (LINE,1100)
         CALL YESNO2 (ICOLOR, IX, IY, LINE, REPEET)
      ENDDO
C
C Deallocate workspaces
C
      deallocate (xstep, stat = ierr)
      deallocate (ystep, stat = ierr)
C
C Format statements
C
  100 FORMAT ('NX =',I2,' ... Sample size too small')
  200 FORMAT ('Variance too small for analysis')
  300 FORMAT ('Theoretical population mean mu')
  400 FORMAT (
     + 'One sample t test',I4
     +/
     +/'Data:',1X,A
     +/'Sample size (Number of x-values) =',I8
     +/'Number of degrees of freedom     =',I8
     +/'Theoretical mean (mu)            =',1P,E13.5
     +/'Sample mean (x-bar)              =',   E13.5
     +/'Standard error of mean (SEM)     =',   E13.5
     +/'TS (i.e. (x-bar - mu)/SEM)       =',   E13.5
     +/'p = P(t >= TS) (upper tail p)    =',0P,F8.4
     +/'p = P(t =< TS) (lower tail p)    =',   F8.4
     +/'p for two tailed t test          =',   F8.4)
  450 FORMAT (
     + 'One sample t test',I4
     +/
     +/'Data:',1X,A
     +/'Sample size (Number of x-values) =',1X,A
     +/'Number of degrees of freedom     =',1X,A
     +/'Theoretical mean (mu)            =',1X,A
     +/'Sample mean (x-bar)              =',1X,A
     +/'Standard error of mean (SEM)     =',1X,A
     +/'TS (i.e. (x-bar - mu)/SEM)       =',1X,A
     +/'p = P(t >= TS) (upper tail p)    =',F8.4
     +/'p = P(t =< TS) (lower tail p)    =',F8.4
     +/'p for two tailed t test          =',F8.4)     
  500 FORMAT (
     +/1X,'One sample t test',I4
     +/1X,'---------------------'
     +/1X,'Data:',1X,A
     +/1X,'Sample size (Number of x-values) =',I8
     +/1X,'Number of degrees of freedom     =',I8
     +/1X,'Theoretical mean (mu)            =',1P,E13.5
     +/1X,'Sample mean (x-bar)              =',   E13.5
     +/1X,'Standard error of mean (SEM)     =',   E13.5
     +/1X,'TS (i.e. (x-bar - mu)/SEM)       =',   E13.5
     +/1X,'p = P(t >= TS) (upper tail p)    =',0P,F8.4
     +/1X,'p = P(t =< TS) (lower tail p)    =',   F8.4
     +/1X,'p for two tailed t test          =',   F8.4)   
  550 FORMAT (
     +/1X,'One sample t test',I4
     +/1X,'---------------------'
     +/1X,'Data:',1X,A
     +/1X,'Sample size (Number of x-values) =',1X,A
     +/1X,'Number of degrees of freedom     =',1X,A
     +/1X,'Theoretical mean (mu)            =',1X,A
     +/1X,'Sample mean (x-bar)              =',1X,A
     +/1X,'Standard error of mean (SEM)     =',1X,A
     +/1X,'TS (i.e. (x-bar - mu)/SEM)       =',1X,A
     +/1X,'p = P(t >= TS) (upper tail p)    =',F8.4
     +/1X,'p = P(t =< TS) (lower tail p)    =',F8.4
     +/1X,'p for two tailed t test          =',F8.4)              
  600 FORMAT (
     + 'Difference D (i.e. x_bar - mu)   =',1P,E13.5
     +/'Lower 95% confidence limit for D =',   E13.5
     +/'Upper 95% confidence limit for D =',   E13.5) 
  650 FORMAT (
     + 'Difference D (i.e. x_bar - mu)   =',1X,A
     +/'Lower 95% confidence limit for D =',1X,A
     +/'Upper 95% confidence limit for D =',1X,A)      
  700 FORMAT (
     + 1X,'Difference D (i.e. x_bar - mu)   =',1P,E13.5
     +/1X,'Lower 95% confidence limit for D =',   E13.5
     +/1X,'Upper 95% confidence limit for D =',   E13.5) 
  750 FORMAT (
     + 1X,'Difference D (i.e. x_bar - mu)   =',1X,A
     +/1X,'Lower 95% confidence limit for D =',1X,A
     +/1X,'Upper 95% confidence limit for D =',1X,A)      
  800 FORMAT (
     +1X,'Conclusion: Reject equality of means at 1% sig. level' )
  900 FORMAT (
     +1X,'Conclusion: Reject equality of means at 5% sig. level' )
 1000 FORMAT (
     +1X,'Conclusion: Consider accepting equality of means')
 1100 FORMAT ('Try again with a different mu-0 value')
      END
C
C
