C
C
      SUBROUTINE M_TTESTS (ISEND, NOUT, NUMX, NUMY,
     +                     X, Y,
     +                     TITLEX, TITLEY)
C
C ACTION : Unpaired and paired t tests
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          28/01/2006 Derived from TTESTS
C          15/11/2013 Changed F test from 1-tail to 2-tail
C          25/11/2013 Added INTENTS and edited to improve output
C          01/10/2016 Increased number of significant digits in output
C          03/11/2018 Changed INTENTS to IN, now only 1 call to TABLE1('OPEN'), 
C                     and minor changes to formatting and significant figures
C          21/07/2021 added E_NUMBERS and E_FORMATS, etc.  
C
C        ISEND: (input/unchanged) 1 = paired/unpaired, 2 = unpaired, 3 = paired
C         NOUT: (input/unchanged) unit connected for saving results
C         NUMX: (input/unchanged) sample size for X
C         NUMY: (input/unchanged) sample size for Y
C            X: (input/unchanged) X-data
C            Y: (input/unchanged) Y-data
C       TITLEX: (input/unchanged) X-title
C       TITLEY: (input/unchanged) Y-title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: ISEND, NOUT
      INTEGER,             INTENT (IN) :: NUMX, NUMY
      DOUBLE PRECISION,    INTENT (IN) :: X(NUMX), Y(NUMY)
      CHARACTER (LEN = *), INTENT (IN) :: TITLEX, TITLEY
C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: XSTEP(:), YSTEP(:)
C
C Locals
C
      INTEGER    IERR, NMAX
      INTEGER    I, ICOUNT, IFAIL, JCOUNT, KCOUNT, NDOF, N1, N2
      INTEGER    JSEND
      PARAMETER (JSEND = 3)
      INTEGER    ICOLOR, IX, IY
      PARAMETER (IX = 4, IY = 4)
      INTEGER    K0, K1, K2, K3, K5
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K5 = 5)
      INTEGER    NUMTXT
      INTEGER    NDOF_NAG
      INTEGER    LSHADE, NUMDEC, NSTART, NTEXT, NUMOPT
      PARAMETER (LSHADE = 1, NUMDEC = 1)
      INTEGER    KUMPOS(3), NUMBLD(20), NUMPOS(5)
      DOUBLE PRECISION PNT01, PNT05, PNT975
      PARAMETER (PNT01 = 0.01D+00, PNT05 = 0.05D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION RTOL
      DOUBLE PRECISION DTEMP
      DOUBLE PRECISION SSQ, S1, S2, PFGTVR, P2, VRATIO
      DOUBLE PRECISION ALPHA, BETA, GAMMA, XBAR, XVAR, YBAR, YVAR
      DOUBLE PRECISION DBAR, DIFF, DHIGH, DLOW, DVAR, SEDBAR, SEDIFF
      DOUBLE PRECISION BOT, TOP, TP, TU, T95
      DOUBLE PRECISION ALPHA_NAG, BETA_NAG, DLOW_NAG, DHIGH_NAG, F_NAG,
     +                 GAMMA_NAG, SE_NAG, TU_NAG
      DOUBLE PRECISION DNDF, DNX, DNY
      DOUBLE PRECISION G01EBF$, G01EDF$, G01FBF$, X02AMF$
      CHARACTER (LEN = 100) LINE, TEXT(30), TTEXT_1(4), TTEXT_2(4)
      CHARACTER (LEN = 100) TEMP(5)
      CHARACTER (LEN = 80 ) CHOP80
      CHARACTER (LEN = 13 ) D13(6), SHOWLJ
      CHARACTER (LEN = 12 ) I12(4), FORM12 
      CHARACTER (LEN = 3  ) STAR3
      PARAMETER (STAR3 = '***')
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   G01EBF$, G01FBF$, G01EDF$, X02AMF$
      EXTERNAL   NXXBAR, PUTADV, PUTIFA, TABLE1, MIDDLE,
     +           NORDIS, CHOP80, RBOX01
      INTRINSIC  SQRT, MIN, DBLE, NINT, MAX
      SAVE       ICOUNT, JCOUNT, KCOUNT
      SAVE       KUMPOS, NUMPOS
      DATA       ICOUNT, JCOUNT, KCOUNT / 0, 0, 0 /
      DATA       NUMBLD / 20*0 /
      DATA       KUMPOS / 2*1, 0 /
      DATA       NUMPOS / 4*1, 0 /
C
C Scheme for controlling the t test procedures (0 = false, 1 = true)
C
C     NUMPOS(1) = 0: no Shapiro-Wilks normality test for small samples
C     NUMPOS(2) = 0: no variance ratio tests for small samples
C     NUMPOS(3) = 0: no unpaired t test (set to 1 if ISEND = 2)
C     NUMPOS(4) = 0: no paired t test   (set to 1 if ISEND = 3)
C     NUMPOS(5) = 0: no further questions
C     KUMPOS(1) = NUMPOS(1)...these are always equal
C     KUMPOS(2) = NUMPOS(2)...these are always equal
C     KUMPOS(3) = NUMPOS(5)...these are always equal
C     ISEND = 1: NUMPOS are primary, KUMPOS secondary
C     ISEND > 1: KUMPOS are primary, NUMPOS are secondary
C

C
C Check NUMX and NUMY
C
      IF (NUMX.LT.K2 .OR. NUMY.LT.K2) THEN
         WRITE (LINE,100) NUMX, NUMY
         CALL PUTADV (LINE)
         RETURN
      ENDIF
C
C Initialise depending on ISEND
C
      IFAIL = -K1
      IF (ISEND.EQ.K1) THEN
C
C Do both tests
C
         NUMOPT = K5
      ELSEIF (ISEND.EQ.K2) THEN
C
C Do unpaired only
C
         NUMOPT = K3
         NUMPOS(3) = K1
         NUMPOS(4) = K0
      ELSEIF (ISEND.EQ.3) THEN
C
C Do paired only
C
         IF (NUMX.NE.NUMY) THEN
            WRITE (LINE,150)
            CALL PUTADV (LINE)
            RETURN
         ELSE   
            NUMOPT = K3
            NUMPOS(3) = K0
            NUMPOS(4) = K1
         ENDIF
      ELSE
         RETURN
      ENDIF
C
C Allocate workspace
C
      E_NUMBERS = E_FORMATS()
      IERR = K0
      IF (ALLOCATED(XSTEP)) DEALLOCATE(XSTEP, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(YSTEP)) DEALLOCATE(YSTEP, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      NMAX = MAX(NUMX,NUMY)
      ALLOCATE(XSTEP(K2*NMAX), STAT = IERR)
      IF (IERR.NE.K0) RETURN
      ALLOCATE(YSTEP(K2*NMAX), STAT = IERR)
      IF (IERR.NE.K0) RETURN
C
C Use a larger RTOL than usual
C
      RTOL = 1.0D+09*X02AMF$()
      RTOL = 1.0D+09*RTOL
C
C Calculate means and variances
C
      CALL NXXBAR (NUMX,
     +             X, XBAR, XVAR)
      CALL NXXBAR (NUMY, Y, 
     +             YBAR, YVAR)
      IF (XVAR.LE.RTOL .OR. YVAR.LE.RTOL) THEN
         DEALLOCATE(XSTEP, STAT = IERR)
         DEALLOCATE(YSTEP, STAT = IERR)
         WRITE (LINE,200)
         CALL PUTADV (LINE)
         RETURN
      ENDIF
      WRITE (NOUT,'(A)') BLANK
      WRITE (NOUT,'(A)') STAR3
C
C Check-list if NUMPOS(5) = 0
C
      IF (KUMPOS(3).EQ.K0 .OR. NUMPOS(5).EQ.K0) THEN
         IF (ISEND.EQ.K1) THEN
            WRITE (TEXT,300)
            ICOLOR = K1
            NUMBLD(1) = K1
            NSTART = 8
            NTEXT = 12
            CALL RBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                   NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            KUMPOS(1) = NUMPOS(1)
            KUMPOS(2) = NUMPOS(2)
            KUMPOS(3) = NUMPOS(5)
         ELSE
            WRITE (TEXT,350)
            ICOLOR = K1
            NUMBLD(1) = K1
            NSTART = 7
            NTEXT = 9
            CALL RBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                   KUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            NUMPOS(1) = KUMPOS(1)
            NUMPOS(2) = KUMPOS(2)
            NUMPOS(5) = KUMPOS(3)
         ENDIF
      ENDIF
      IF (NUMPOS(1).EQ.K0 .AND. NUMPOS(2).EQ.K0 .AND.
     +    NUMPOS(3).EQ.K0 .AND. NUMPOS(4).EQ.K0) NUMPOS(5) = K0
     
      IF (NUMPOS(1).EQ.K1) THEN
C ------------------------------
C Shapiro-Wilks if NUMPOS(1) = 1
C ------------------------------
C
      
         CALL NORDIS (JSEND, NUMX, NOUT,
     +                X, XSTEP, YSTEP,
     +                TTEXT_1, 'X-data for t test')
         CALL NORDIS (JSEND, NUMY, NOUT, 
     +                Y, XSTEP, YSTEP, 
     +                TTEXT_2, 'Y-data for t test')
      ENDIF
C        
C-------------------------------------
C Variance ratio test if NUMPOS(2) = 1
C-------------------------------------
C
      IF (NUMPOS(2).EQ.K1) THEN
C
C Output means and standard deviations
C
         ICOUNT = ICOUNT + K1
         IF (E_NUMBERS) THEN
            WRITE (TEXT,400) ICOUNT,
     +                       CHOP80(TITLEX), CHOP80(TITLEY), NUMX, XBAR, 
     +                       XVAR, SQRT(XVAR),
     +                       NUMY, YBAR, YVAR, SQRT(YVAR)
            WRITE (NOUT,450) ICOUNT,
     +                       TITLEX, TITLEY, NUMX, XBAR,
     +                       XVAR, SQRT(XVAR),
     +                       NUMY, YBAR, YVAR, SQRT(YVAR)
         ELSE
            I12(1) = FORM12(NUMX)
            I12(2) = FORM12(NUMY)
            D13(1) = SHOWLJ(XBAR)
            D13(2) = SHOWLJ(XVAR)
            DTEMP = SQRT(XVAR)
            D13(3) = SHOWLJ(DTEMP)
            D13(4) = SHOWLJ(YBAR)
            D13(5) = SHOWLJ(YVAR)
            DTEMP = SQRT(YVAR)
            D13(6) = SHOWLJ(DTEMP)
            WRITE (TEXT,405) ICOUNT,
     +                       CHOP80(TITLEX), CHOP80(TITLEY), I12(1),
     +                       D13(1), D13(2), D13(3),
     +                       I12(2), D13(4), D13(5), D13(6)
            WRITE (NOUT,455) ICOUNT,
     +                       TITLEX, TITLEY, I12(1),
     +                       D13(1), D13(2), D13(3),
     +                       I12(2), D13(4), D13(5), D13(6)

         ENDIF  
C
C Now variance ratio (F) test
C
         IF (XVAR.GE.YVAR) THEN
            S1 = XVAR
            S2 = YVAR
            N1 = NUMX - K1
            N2 = NUMY - K1
         ELSE
            S1 = YVAR
            S2 = XVAR
            N1 = NUMY - K1
            N2 = NUMX - K1
         ENDIF
         IF (S2.GT.RTOL) THEN
            VRATIO = S1/S2
            IFAIL = K1
            PFGTVR = G01EDF$('Upper-tail', VRATIO, DBLE(N1), DBLE(N2),
     +                      IFAIL)
            IF (IFAIL.EQ.0) THEN
               P2 = TWO*PFGTVR
               IF (E_NUMBERS) THEN
                  WRITE (TEMP,500) VRATIO, N1, N2, PFGTVR, P2
                  WRITE (NOUT,550) VRATIO, N1, N2, PFGTVR, P2
               ELSE 
                  D13(1) = SHOWLJ(VRATIO)
                  I12(1) = FORM12(N1)
                  I12(2) = FORM12(N2) 
                  WRITE (TEMP,505) D13(1), I12(1), I12(2), PFGTVR, P2
                  WRITE (NOUT,555) D13(1), I12(1), I12(2), PFGTVR, P2
               ENDIF     
               DO I = K1, K5
                  TEXT(14 + I) = TEMP(I)
               ENDDO
               IF (P2.LE.PNT01) THEN
                  WRITE (LINE,600)
                  WRITE (NOUT,600)
               ELSEIF (P2.LE.PNT05) THEN
                  WRITE (LINE,700)
                  WRITE (NOUT,700)
               ELSE
                  WRITE (LINE,800)
                  WRITE (NOUT,800)
               ENDIF
               NUMTXT = 20
               TEXT(NUMTXT) = LINE
               NUMTXT = 21
               TEXT(NUMTXT) = BLANK
            ELSE
               CALL PUTIFA (IFAIL, NOUT, 'G01EDF/TTESTS')
            ENDIF
         ENDIF
      ENDIF
C
C-----------------------------
C Always open the output table
C----------------------------- 
C      
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      IF (NUMPOS(1).EQ.K1 .OR. NUMPOS(2).EQ.K1) THEN
C
C Output if Shapiro-Wilks tests and/or variance ratio test
C        
         IF (NUMPOS(1).EQ.K1) THEN
            DO I = 1, 4
               IF (I.EQ.1) THEN
                  ICOLOR = 4
               ELSE
                  ICOLOR = 0
               ENDIF
               CALL TABLE1 (ICOLOR, TTEXT_1(I))
            ENDDO 
            CALL TABLE1 (ICOLOR, BLANK) 
            DO I = 1, 4
               IF (I.EQ.1) THEN
                  ICOLOR = 4
               ELSE
                  ICOLOR = 0
               ENDIF
               CALL TABLE1 (ICOLOR, TTEXT_2(I))
            ENDDO 
            CALL TABLE1 (ICOLOR, BLANK) 
         ENDIF
         IF (IFAIL.EQ.K0 .AND. NUMPOS(2).EQ.K1) THEN
            DO I = K1, NUMTXT
               IF (I.EQ.1 .OR. I.EQ.4 .OR. I.EQ.6 .OR.
     +             I.EQ.NUMTXT - 1) THEN
                  ICOLOR = 4
               ELSE
                  ICOLOR = 0
               ENDIF
               CALL TABLE1 (ICOLOR, TEXT(I))
            ENDDO
         ENDIF               
      ENDIF  
C
C t test if NUMPOS(3) = 1
C
      IF (NUMPOS(3).EQ.K1) THEN
C
C Unpaired t test
C
         DNX = DBLE(NUMX)
         DNY = DBLE(NUMY)
         TOP = (DNX - ONE)*XVAR + (DNY - ONE)*YVAR
         IF (TOP.GT.RTOL) THEN
            DIFF = XBAR - YBAR
            NDOF = NUMX + NUMY - K2
            DNDF = DBLE(NDOF)
            BOT = DBLE(NDOF)
            SSQ = TOP/BOT
            SEDIFF = SQRT(SSQ*(ONE/DNX + ONE/DNY))
            TU = DIFF/SEDIFF
            IFAIL = K1
            BETA = G01EBF$('Lower-tail', TU, DNDF, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01EBF/TTESTS')
            ALPHA = ONE - BETA
            GAMMA = TWO*MIN(ALPHA, BETA)
            CALL MIDDLE (ZERO, ALPHA, ONE)
            CALL MIDDLE (ZERO, BETA, ONE)
            CALL MIDDLE (ZERO, GAMMA, ONE)
C
C Satterthwaites procedure for unequal variances
C
            SE_NAG = SQRT(XVAR/DNX + YVAR/DNY)
            TOP = SE_NAG**4
            BOT = (XVAR/DNX)**2/(DNX - ONE) + (YVAR/DNY)**2/(DNY - ONE)
            F_NAG = TOP/BOT
            NDOF_NAG = NINT(F_NAG)
            TU_NAG = DIFF/SE_NAG
            IFAIL = K1
            BETA_NAG = G01EBF$('Lower-tail', TU_NAG, F_NAG, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01EBF/TTESTS')
            ALPHA_NAG = ONE - BETA_NAG
            GAMMA_NAG = TWO*MIN(ALPHA_NAG, BETA_NAG)
            CALL MIDDLE (ZERO, ALPHA_NAG, ONE)
            CALL MIDDLE (ZERO, BETA_NAG, ONE)
            CALL MIDDLE (ZERO, GAMMA_NAG, ONE)
            JCOUNT = JCOUNT + K1
            IF (E_NUMBERS) THEN
               WRITE (TEXT,900) JCOUNT,
     +                          NUMX, NUMY, NDOF, NDOF_NAG, TU, TU_NAG,
     +                          ALPHA, ALPHA_NAG, BETA, BETA_NAG,
     +                          GAMMA, GAMMA_NAG
               WRITE (NOUT,950) JCOUNT,
     +                          NUMX, NUMY, NDOF, NDOF_NAG, TU, TU_NAG,
     +                          ALPHA, ALPHA_NAG, BETA, BETA_NAG,
     +                          GAMMA, GAMMA_NAG
            ELSE
               I12(1) = FORM12(NUMX)
               I12(2) = FORM12(NUMY)
               I12(3) = FORM12(NDOF)
               I12(4) = FORM12(NDOF_NAG)
               D13(1) = SHOWLJ(TU)
               D13(2) = SHOWLJ(TU_NAG)
               WRITE (TEXT,905) JCOUNT,
     +                          I12(1), I12(2), TRIM(I12(3)), 
     +                          TRIM(I12(4)),
     +                          TRIM(D13(1)), TRIM(D13(2)),
     +                          ALPHA, ALPHA_NAG, BETA, BETA_NAG,
     +                          GAMMA, GAMMA_NAG
               WRITE (NOUT,955) JCOUNT,
     +                          I12(1), I12(2), TRIM(I12(3)),
     +                          TRIM(I12(4)),
     +                          TRIM(D13(1)), TRIM(D13(2)),
     +                          ALPHA, ALPHA_NAG, BETA, BETA_NAG,
     +                          GAMMA, GAMMA_NAG
            ENDIF  
            NUMTXT = 9
            IFAIL = K1
            T95 = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), IFAIL)
            IF (IFAIL.EQ.K0) THEN
               DLOW = DIFF - T95*SEDIFF
               DHIGH = DIFF + T95*SEDIFF
               DLOW_NAG = DIFF - T95*SE_NAG
               DHIGH_NAG = DIFF + T95*SE_NAG
               IF (E_NUMBERS) THEN
                  WRITE (TEMP,1000) DIFF, DLOW, DLOW_NAG, DHIGH, 
     +                              DHIGH_NAG
                  WRITE (NOUT,1050) DIFF, DLOW, DLOW_NAG, DHIGH,
     +                              DHIGH_NAG
               ELSE
                  D13(1) = SHOWLJ(DIFF)
                  D13(2) = SHOWLJ(DLOW)
                  D13(3) = SHOWLJ(DLOW_NAG)
                  D13(4) = SHOWLJ(DHIGH)
                  D13(5) = SHOWLJ(DHIGH_NAG)
                  WRITE (TEMP,1005) TRIM(D13(1)), TRIM(D13(2)),
     +                              TRIM(D13(3)), TRIM(D13(4)), 
     +                              TRIM(D13(5)) 
                  WRITE (NOUT,1055) TRIM(D13(1)), TRIM(D13(2)),
     +                              TRIM(D13(3)), TRIM(D13(4)), 
     +                              TRIM(D13(5))              
               ENDIF  
               DO I = K1, K3
                  NUMTXT = NUMTXT + K1
                  TEXT(NUMTXT) = TEMP(I)
               ENDDO
            ELSE
               CALL PUTIFA (IFAIL, NOUT, 'G01FBF/TTESTS')
            ENDIF
            IF (GAMMA.LE.PNT01) THEN
               WRITE (LINE,1100)
               WRITE (NOUT,1100)
            ELSEIF (GAMMA.LE.PNT05) THEN
               WRITE (LINE,1200)
               WRITE (NOUT,1200)
            ELSE
               WRITE (LINE,1300)
               WRITE (NOUT,1300)
            ENDIF
            NUMTXT = NUMTXT + K1
            TEXT(NUMTXT) = LINE
            NUMTXT = NUMTXT + K1
            TEXT(NUMTXT) = BLANK
            DO I = K1, NUMTXT
               IF (I.EQ.1 .OR. I.EQ.NUMTXT - 1) THEN
                  ICOLOR = 4
               ELSE
                  ICOLOR = 0
               ENDIF
               CALL TABLE1 (ICOLOR, TEXT(I))
            ENDDO
         ELSE
            WRITE (LINE,1400)
            WRITE (NOUT,1400)
            CALL PUTADV (LINE)
         ENDIF
      ENDIF
C
C Option for paired t test if NUMX = NUMY
C
      IF (NUMPOS(4).EQ.K1 .AND. NUMX.NE.NUMY) THEN
         WRITE (LINE,150)
         CALL PUTADV (LINE) 
      ELSEIF (NUMPOS(4).EQ.K1 .AND. NUMX.EQ.NUMY) THEN
         DO I = K1, NUMX
            XSTEP(I) = X(I) - Y(I)
         ENDDO
         CALL NXXBAR (NUMX, XSTEP, DBAR, DVAR)
         IF (DVAR.LE.RTOL) THEN
            DEALLOCATE(XSTEP, STAT = IERR)
            DEALLOCATE(YSTEP, STAT = IERR)
            CALL TABLE1 (ICOLOR, 'CLOSE')
            WRITE (LINE,200)
            CALL PUTADV (LINE)
            RETURN
         ENDIF
         SEDBAR = SQRT(DVAR/NUMX)
         TP = DBAR/SEDBAR
         NDOF = NUMX - K1
         IFAIL = K1
         BETA = G01EBF$('Lower-tail', TP, DBLE(NDOF), IFAIL)
         IF (IFAIL.EQ.K0) THEN
            ALPHA = ONE - BETA
            GAMMA = TWO*MIN(ALPHA, BETA)
            CALL MIDDLE (ZERO, ALPHA, ONE)
            CALL MIDDLE (ZERO, BETA, ONE)
            CALL MIDDLE (ZERO, GAMMA, ONE)
            KCOUNT = KCOUNT + K1
            IF (E_NUMBERS) THEN
               WRITE (TEXT,1600) KCOUNT, NUMX, NDOF, TP, ALPHA, BETA,
     +                           GAMMA
               WRITE (NOUT,1650) KCOUNT, NUMX, NDOF, TP, ALPHA, BETA, 
     +                           GAMMA
            ELSE
               I12(1) = FORM12(NUMX)
               I12(2) = FORM12(NDOF)
               D13(1) = SHOWLJ(TP)
               WRITE (TEXT,1605) KCOUNT, I12(1), I12(2), D13(1), ALPHA,
     +                           BETA, GAMMA
               WRITE (NOUT,1655) KCOUNT, I12(1), I12(2), D13(1), ALPHA,
     +                           BETA, GAMMA

            ENDIF  
         ELSE
            DEALLOCATE(XSTEP, STAT = IERR)
            DEALLOCATE(YSTEP, STAT = IERR)
            CALL PUTIFA (IFAIL, NOUT, 'G01BAF/TTESTS')
            CALL TABLE1 (ICOLOR, 'CLOSE')
            RETURN
         ENDIF
         IFAIL = K1
         T95 = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), IFAIL)
         IF (IFAIL.EQ.K0) THEN
            DLOW = DBAR - T95*SEDBAR
            DHIGH = DBAR + T95*SEDBAR
            IF (E_NUMBERS) THEN
               WRITE (TEMP,1700) DBAR, DLOW, DHIGH
               WRITE (NOUT,1750) DBAR, DLOW, DHIGH
            ELSE
               D13(1) = SHOWLJ(DBAR)
               D13(2) = SHOWLJ(DLOW)
               D13(3) = SHOWLJ(DHIGH)
               WRITE (TEMP,1705) D13(1), D13(2), D13(3)
               WRITE (NOUT,1755) D13(1), D13(2), D13(3)
            ENDIF  
            NUMTXT = 8
            DO I = K1, K3
               NUMTXT = NUMTXT + K1
               TEXT(NUMTXT) = TEMP(I)
            ENDDO
         ELSE
            DEALLOCATE(XSTEP, STAT = IERR)
            DEALLOCATE(YSTEP, STAT = IERR)
            CALL TABLE1 (ICOLOR, 'CLOSE')
            CALL PUTIFA (IFAIL, NOUT, 'G01FBF/TTESTS')
            CALL TABLE1 (ICOLOR, 'CLOSE')
            RETURN
         ENDIF
         IF (GAMMA.LE.PNT01) THEN
            WRITE (LINE,1100)
            WRITE (NOUT,1100)
         ELSEIF (GAMMA.LE.PNT05) THEN
            WRITE (LINE,1200)
            WRITE (NOUT,1200)
         ELSE
            WRITE (LINE,1300)
            WRITE (NOUT,1300)
         ENDIF
         NUMTXT = NUMTXT + K1
         TEXT(NUMTXT) = LINE
         NUMTXT = NUMTXT + K1
         TEXT(NUMTXT) = BLANK
         DO I = K1, NUMTXT
            IF (I.EQ.1 .OR. I.EQ.NUMTXT - 1) THEN
               ICOLOR = 4
            ELSE
               ICOLOR = 0
            ENDIF
            CALL TABLE1 (ICOLOR, TEXT(I))
         ENDDO
      ENDIF
C
C Deallocate workspaces
C
      DEALLOCATE(XSTEP, STAT = IERR)
      DEALLOCATE(YSTEP, STAT = IERR)
      CALL TABLE1 (ICOLOR, 'CLOSE')
C
C Format statements
C
  100 FORMAT ('Nx =',I2,', Ny =',I2,' ... Sample size too small')
  150 FORMAT ('Paired test requires equal sample sizes')
  200 FORMAT ('Variance too small for analysis')
  300 FORMAT (
     + 'Configuration options for normal, variance ratio and t tests'
     +/'...'
     +/'Do normality tests only for large samples'
     +/'Do variance ratio tests only for very large samples'
     +/'Do paired t tests only for paired samples'
     +/'Choose [OK] only when the configuration is as required'
     +/'...'
     +/'Shapiro-Wilks normality tests'
     +/'Variance ratio F test'
     +/'Unpaired t test'
     +/'Paired t test'
     +/'[OK] ... Do not ask again this session')
  350 FORMAT (
     + 'Configuration options for normal, variance ratio and t tests'
     +/'...'
     +/'Do normality tests only for large samples'
     +/'Do variance ratio tests only for very large samples'
     +/'Choose [OK] only when the configuration is as required'
     +/'...'
     +/'Shapiro-Wilks normality tests'
     +/'Variance ratio F test'
     +/'[OK] ... Do not ask again this session')
  400 FORMAT (
     + 'F test for equality of variances',I4
     +/
     +/'X-data:'
     +/A
     +/'y-data:'
     +/A
     +/'X sample size                =',I9
     +/'X sample mean                =',1P,E13.5
     +/'X sample variance            =',   E13.5
     +/'X sample standard deviation  =',   E13.5
     +/'Y sample size                =',I9
     +/'Y sample mean                =',1P,E13.5
     +/'Y sample variance            =',   E13.5
     +/'Y sample standard deviation  =',   E13.5)
  405 FORMAT (
     + 'F test for equality of variances',I4
     +/
     +/'X-data:'
     +/A
     +/'y-data:'
     +/A
     +/'X sample size                =',1X,A
     +/'X sample mean                =',1X,A
     +/'X sample variance            =',1X,A
     +/'X sample standard deviation  =',1X,A
     +/'Y sample size                =',1X,A
     +/'Y sample mean                =',1X,A
     +/'Y sample variance            =',1X,A
     +/'Y sample standard deviation  =',1X,A)     
  450 FORMAT (
     +/1X,'F test for equality of variances',I4
     +/1X,'------------------------------------'
     +/1X,'X-data:'
     +/1X,A
     +/1X,'Y-data:'
     +/1X,A
     +/1X,'X Sample size                =',I9
     +/1X,'X Sample mean                =',1P,E13.5
     +/1X,'X Sample variance            =',   E13.5
     +/1X,'X Sample standard deviation  =',   E13.5
     +/1X,'Y Sample size                =',I9
     +/1X,'Y Sample mean                =',1P,E13.5
     +/1X,'Y Sample variance            =',   E13.5
     +/1X,'Y Sample standard deviation  =',   E13.5) 
  455 FORMAT (
     +/1X,'F test for equality of variances',I4
     +/1X,'------------------------------------'
     +/1X,'X-data:'
     +/1X,A
     +/1X,'Y-data:'
     +/1X,A
     +/1X,'X Sample size                =',1X,A
     +/1X,'X Sample mean                =',1X,A
     +/1X,'X Sample variance            =',1X,A
     +/1X,'X Sample standard deviation  =',1X,A
     +/1X,'Y Sample size                =',1X,A
     +/1X,'Y Sample mean                =',1X,A
     +/1X,'Y Sample variance            =',1X,A
     +/1X,'Y Sample standard deviation  =',1X,A)      
  500 FORMAT (
     + 'Variance ratio               =',1P,E13.5
     +/'Degrees of freedom (num)     =',I9
     +/'Degrees of freedom (denom)   =',I9
     +/'p = P(F >= Variance ratio)   =',0P,F9.5
     +/'Two tail p value             =',   F9.5)     
  505 FORMAT (
     + 'Variance ratio               =',1X,A
     +/'Degrees of freedom (num)     =',1X,A
     +/'Degrees of freedom (denom)   =',1X,A
     +/'p = P(F >= Variance ratio)   =',F7.4
     +/'Two tail p value             =',F7.4)          
  550 FORMAT (
     + 1X,'Variance ratio               =',1P,E13.5
     +/1X,'Degrees of freedom (num)     =',I9
     +/1X,'Degrees of freedom (denom)   =',I9
     +/1X,'p = P(F >= Variance ratio)   =',0P,F9.5
     +/1X,'Two tail p value             =',   F9.5)      
  555 FORMAT (
     + 1X,'Variance ratio               =',1X,A
     +/1X,'Degrees of freedom (num)     =',1X,A
     +/1X,'Degrees of freedom (denom)   =',1X,A
     +/1X,'p = P(F >= Variance ratio)   =',F7.4
     +/1X,'Two tail p value             =',F7.4)                 
  600 FORMAT (
     +1X,'Conclusion: Reject equality of variances at 1% sig. level')
  700 FORMAT (
     +1X,'Conclusion: Reject equality of variances at 5% sig. level')
  800 FORMAT (
     +1X,'Conclusion: Consider accepting equality of variances')
  900 FORMAT (
     + 'Unpaired t test ([ ] = corrected for unequal variances)',I4
     +/
     +/'Number of x-values           =',I9
     +/'Number of y-values           =',I9
     +/'Number of degrees of freedom =',I9,'      [',I9,']'
     +/'Unpaired t test statistic U  =',1P,E13.5,' [',E13.5,']'
     +/'p = P(t >= U) (upper tail p) =',0P,F9.5,'     [',F9.5,']'
     +/'p = P(t =< U) (lower tail p) =',F9.5,'     [',F9.5,']'
     +/'p for two tailed t test      =',F9.5,'     [',F9.5,']')
  905 FORMAT (
     + 'Unpaired t test ([ ] = corrected for unequal variances)',I4
     +/
     +/'Number of x-values           =',1X,A
     +/'Number of y-values           =',1X,A
     +/'Number of degrees of freedom =',1X,A,' [',A,']'
     +/'Unpaired t test statistic U  =',1X,A,' [',A,']'
     +/'p = P(t >= U) (upper tail p) =',F7.4,' [',F6.4,']'
     +/'p = P(t =< U) (lower tail p) =',F7.4,' [',F6.4,']'
     +/'p for two tailed t test      =',F7.4,' [',F6.4,']')     
  950 FORMAT (
     +/1X,'Unpaired t test ([ ] = corrected for unequal variances)',I4
     +/1X,'-----------------------------------------------------------'
     +/1X,'Number of x-values           =',I9
     +/1X,'Number of y-values           =',I9
     +/1X,'Number of degrees of freedom =',I9,'      [',I9,']'
     +/1X,'Unpaired t test statistic U  =',1P,E13.5,' [',E13.5,']'
     +/1X,'p = P(t >= U) (upper tail p) =',0P,F9.5,'     [',F9.5,']'
     +/1X,'p = P(t =< U) (lower tail p) =',F9.5,'     [',F9.5,']'
     +/1X,'p for two tailed t test      =',F9.5,'     [',F9.5,']')
  955 FORMAT (
     +/1X,'Unpaired t test ([ ] = corrected for unequal variances)',I4
     +/1X,'-----------------------------------------------------------'
     +/1X,'Number of x-values           =',1X,A
     +/1X,'Number of y-values           =',1X,A
     +/1X,'Number of degrees of freedom =',1X,A,' [',A,']'
     +/1X,'Unpaired t test statistic U  =',1X,A,' [',A,']'
     +/1X,'p = P(t >= U) (upper tail p) =',F7.4,' [',F6.4,']'
     +/1X,'p = P(t =< U) (lower tail p) =',F7.4,' [',F6.4,']'
     +/1X,'p for two tailed t test      =',F7.4,' [',F6.4,']')     
 1000 FORMAT (
     + 'Difference between means DM  =',1P,E13.5
     +/'Lower 95% con. limit for DM  =',   E13.5,' [',E13.5,']'
     +/'Upper 95% con. limit for DM  =',   E13.5,' [',E13.5,']')
 1005 FORMAT (
     + 'Difference between means DM  =',1X,A
     +/'Lower 95% con. limit for DM  =',1X,A,' [',A,']'
     +/'Upper 95% con. limit for DM  =',1X,A,' [',A,']')     
 1050 FORMAT (
     + 1X,'Difference between means DM  =',1P,E13.5
     +/1X,'Lower 95% con. limit for DM  =',   E13.5,' [',E13.5,']'
     +/1X,'Upper 95% con. limit for DM  =',   E13.5,' [',E13.5,']')
 1055 FORMAT (
     + 1X,'Difference between means DM  =',1X,A
     +/1X,'Lower 95% con. limit for DM  =',1X,A,' [',A,']'
     +/1X,'Upper 95% con. limit for DM  =',1X,A,' [',A,']')     
 1100 FORMAT (
     +1X,'Conclusion: Reject equality of means at 1% sig. level' )
 1200 FORMAT (
     +1X,'Conclusion: Reject equality of means at 5% sig. level' )
 1300 FORMAT (
     +1X,'Conclusion: Consider accepting equality of means')
 1400 FORMAT ('Unpaired t test not possible for this data')
 1600 FORMAT (
     + 'Paired t test',I4
     +/
     +/'Number of paired comparisons =',I9
     +/'Number of degrees of freedom =',I9
     +/'Paired t test statistic S    =',1P,E13.5
     +/'p = P(t >= S)                =',0P,F9.5
     +/'p = P(t =< S)                =',   F9.5
     +/'p for two tailed t test      =',   F9.5)
 1605 FORMAT (
     + 'Paired t test',I4
     +/
     +/'Number of paired comparisons =',1X,A
     +/'Number of degrees of freedom =',1X,A
     +/'Paired t test statistic S    =',1X,A
     +/'p = P(t >= S)                =',F7.4
     +/'p = P(t =< S)                =',F7.4
     +/'p for two tailed t test      =',F7.4)     
 1650 FORMAT (
     +/1X,'Paired t test',I4
     +/1X,'-----------------'
     +/1X,'Number of paired comparisons =',I9
     +/1X,'Number of degrees of freedom =',I9
     +/1X,'Paired t test statistic S    =',1P,E13.5
     +/1X,'p = P(t >= S)                =',0P,F9.5
     +/1X,'p = P(t =< S)                =',   F9.5
     +/1X,'p for two tailed t test      =',   F9.5)
 1655 FORMAT (
     +/1X,'Paired t test',I4
     +/1X,'-----------------'
     +/1X,'Number of paired comparisons =',1X,A
     +/1X,'Number of degrees of freedom =',1X,A
     +/1X,'Paired t test statistic S    =',1X,A
     +/1X,'p = P(t >= S)                =',F7.4
     +/1X,'p = P(t =< S)                =',F7.4
     +/1X,'p for two tailed t test      =',F7.4)     
 1700 FORMAT (
     + 'Mean of differences MD       =',1P,E13.5
     +/'Lower 95% conf. limit for MD =',   E13.5
     +/'Upper 95% conf. limit for MD =',   E13.5)
 1705 FORMAT (
     + 'Mean of differences MD       =',1X,A
     +/'Lower 95% conf. limit for MD =',1X,A
     +/'Upper 95% conf. limit for MD =',1X,A)     
 1750 FORMAT (
     + 1X,'Mean of differences MD       =',1P,E13.5
     +/1X,'Lower 95% conf. limit for MD =',   E13.5
     +/1X,'Upper 95% conf. limit for MD =',   E13.5)
 1755 FORMAT (
     + 1X,'Mean of differences MD       =',1X,A
     +/1X,'Lower 95% conf. limit for MD =',1X,A
     +/1X,'Upper 95% conf. limit for MD =',1X,A)     
      END
C
C
