C
C
      SUBROUTINE M_VECEXH (NIN, NOUT, NUM,
     +                     W,
     +                     FNAME, TITLE)
C
C ACTION: Megavariate version of VECEXH using allocatable workspaces
C AUTHOR: W.G.Bardsley, University of Manchester, U.K.
C         19/01/2006 derived from VECEXH
C         29/01/2006 edited to accept W as input vector
C         10/08/2008 added FNAME to arguments
C         01/03/2009 corrected NUM (argument 6)to NMAX in call to VECEXH
C         04/04/2009 new argument list for vecexh and removed allocations
C
C           NIN: (input/unchanged) unconnected unit for data input
C          NOUT: (input/unchanged) preconnected unit for results
C           NUM: (input/output) number of current data rows
C             W: (input/unchanged) the sample
C         FNAME: (input/output) file name
C         TITLE: (input/output) data title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NIN, NOUT, NUM
      DOUBLE PRECISION,    INTENT (IN)    :: W(NUM)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
C
C Locals
C
      INTEGER    NFILE, NMAX
      INTEGER    ISEND
      PARAMETER (ISEND = 0)
      INTEGER    N2
      PARAMETER (N2 = 2)
      LOGICAL    FILEIT
      PARAMETER (FILEIT = .TRUE.)
      EXTERNAL   PUTFAT, GETNOU, VECEXH
      IF (NUM.LT.N2) THEN
C
C Return if sample size too small
C
         CALL PUTFAT ('Sample too small for meaningful analysis')
         RETURN
      ElSE
C
C Otherwise allocate workspaces
C
         nmax = num
      ENDIF
C
C Call VECEXH
C
      CALL GETNOU (NFILE)
      CALL VECEXH (ISEND, NFILE, NIN, NMAX, NOUT, NUM,
     +             W, 
     +             FNAME, TITLE,
     +             FILEIT)       
      CLOSE (UNIT = NFILE)
      END
C
C
