c
c
      subroutine m_vecone (isend, nin, nout, nz,
     +                     fnamez, titlez)
c
c action: version of vecone calling subprograms
c author: w.g.bardsley, university of manchester, u.k., 29/01/2006
c         06/03/2006 introduced number, nzsav, and tfile
c         23/11/2006 added intents and introduced simdir  
c         25/01/2007 replaced simdir by sim256 
c         06/03/2007 corrected dimensioning before call to vec2in
c         20/08/2007 added calls to m_runs01, and m_updown
c         12/10/2007 edited for version 6 to allow vec4in to create files
c         31/02/2008 introduced showit to limit repeat advice about test files
c         10/05/2010 introduced NKLCFG to switch on/off the test file advice
c         30/04/2011 introduced call to TFILEQ
c         02/02/2017 added call to FDRVEC
c         30/03/2019 added call to RANNUM_SAMPLE 
c
c    send: (input/unchanged) as follows:
c           isend = 1: exhaustive analysis
c           isend = 2: 1-sample t test
c           isend = 3: 1-sample Kolmogorov-Smirnov test
c           isend = 4: normal distribution test
c           isend = 5: Poisson distribution
c           isend = 6: robust analysis
c           isend = 7: data smoothing
c           isend = 8: autocorrelations
c           isend = 9: ARIMA  
c           isend = 10: zeros of a polynomial  
c           isend = 11: kernel density estimation  
c           isend = 12: distance matrix scaling
c           isend = 13: runs and signs
c           isend = 14: runs up or down
c           isend = 15: Kolmogorov-Smirnov 1-sample for binomial 
c           isend = 16: Kolmogorov-Smirnov 1-sample for Poisson
c           isend = 17: False dicovery Rate for a vector
c           isend = 18: overlay pdf/cdf on sample 
c
c     nin: (input/unchanged) unconnected unit for data input
c    nout: (input/unchanged) preconnected unit for results
c      nz: (input/output) sample size
c  fnamez: (input/output) data file name
c  titlez: (input/output) data title
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: isend, nin, nout 
      integer,             intent (inout) :: nz
      character (len = *), intent (inout) :: fnamez, titlez
c
c Local allocatable array
c
      double precision, allocatable :: z(:)
c
c locals
c
      integer    nitems, n1, n21
      parameter (nitems = 18, n1 = 1, n21 = 21)
      integer    ierr, jsend, npts, nzmax, nzsav(nitems)
      integer    kval9, nklcfg
      character  no_data*30, no_file*30, word15*15
      parameter (no_data = 'No data',
     +           no_file = 'No file')
      character  header(nitems)*80, line*100, tfiles(nitems)*15
      character  sim256*1024
      logical    showit(nitems)
      logical    abort, fixnpt, label, newdat, repeet
      parameter (fixnpt = .false., label = .true.)
      external   isitvf, vec2in, vec3in, vec4in, sim256
      external   m_vecexh, m_ttest1, m_ks1sam, m_ndtest, m_exactp,
     +           m_rob001, m_time04, m_time01, m_time02, m_zeros1,
     +           m_kernde, m_dmat00, m_runs01, m_updown
      external   nklcfg, tfileq, fdrvec, rannum_sample
      save       showit, nzsav, header, tfiles
      data       showit / nitems*.true. /
      data       nzsav /  50,  50,  30,   50,  40, 
     +                    50,  49, 100,  100,   6, 
     +                    50,  91,  50, 1000,  50,
     +                    40,  17,  50  / 
      data       header /
     +'Exhaustive analysis of a vector',     !1
     +'One sample t test',                   !2
     +'One sample Kolmogorov-Smirnov test',  !3  
     +'Normal distribution test',            !4 
     +'Exact Poisson distribution test',     !5
     +'Robust analysis of one sample',       !6
     +'Data smoothing',                      !7
     +'Sample autocorrelations',             !8 
     +'ARIMA modelling',                     !9
     +'Zeros of a polynomial',               !10
     +'Kernel density estimation',           !11
     +'Distance matrix scaling',             !12
     +'Runs and signs',                      !13  
     +'Runs up or down',                     !14
     +'K-S-1-sample binomial test',          !15
     +'K-S-1-sample Poisson test',           !16
     +'False discovery rate',                !17 
     +'Overlay pdf/cdf on a sample' /        !18 
      data       tfiles /
     +'normal.tf1',      !1
     +'normal.tf1',      !2
     +'g08cbf.tf1',      !3
     +'normal.tf1',      !4 
     +'poisson.tf1',     !5 
     +'normal.tf1',      !6
     +'g10caf.tf1',      !7 
     +'times.tf1',       !8 
     +'times.tf1',       !9
     +'c02agf.tf1',      !10 
     +'normal.tf1',      !11
     +'g03faf.tf1',      !12   
     +'rstest.tf1',      !13
     +'g08eaf.tf1',      !14
     +'binomial.tf1',    !15
     +'poisson.tf1',     !16
     +'fdr_bh.tf1',      !17
     +'normal.tf1' /     !18
c
c------------------------------------------------------------
c Start of code to replace calls to vecone to access a vector
c------------------------------------------------------------
c
      if (isend.lt.1 .or. isend.gt.nitems) return 
      if (nz.le.0) then      
         nz = nzsav(isend)
         fnamez = sim256(tfiles(isend))
      endif   
      repeet = .true.
      do while (repeet)
c
c Step 1: if nz > 0 check if fname supplied is a current vector file
c ======= isitvf returns npts > 0 if fnamez is a vector file
c
         npts = 0
         if (nz.gt.0) call isitvf (npts,
     +                             fnamez)
c
c Step 2: if fnamez is not a vector file of size = num then try to open a file
c ======= vec3in selects a vector file of size npts > 0 if successful
c
         if (npts.le.0 .or. nz.ne.npts) then
            if (showit(isend)) then
               kval9 = nklcfg(n21)
               if (kval9.eq.n1) then
                  word15 = tfiles(isend)(1:15)
                  write (line,100) word15
                  call tfileq (line)
                  showit(isend) = .false.
               endif   
            endif   
            nz = 0
            fnamez = no_file
            titlez = no_data
            jsend = 3
            close (unit = nin)
            call vec3in (jsend, nin, npts,
     +                   fnamez, titlez,
     +                   abort, fixnpt, label)
            close (unit = nin)
            if (abort) then
               nz = 0
               fnamez = no_file
               titlez = no_data
               return
            endif
         endif
         if (npts.le.0) return
c
c Step 3: we now have a vector file with size npts > 0 so allocate workspaces
c ======  if there is any error then ierr is nonzero and exit happens
c
         nz = npts
         ierr = 0
         if (allocated(z)) deallocate(z, stat = ierr)
         if (ierr.ne.0) return  
         nzmax = nz
         if (ierr.eq.0) allocate(z(nzmax), stat = ierr)
         if (ierr.ne.0) return

c
c Step 4: read in the data consisting of nz = npts points from file fname
c ======= if an error occurs then workspaces are deallocated and exit occurs
c         otherwise fname and title are not changed from now on
c
         close (unit = nin)
         call vec2in (nin, nzmax, nz,
     +                z,
     +                fnamez, titlez,
     +                abort)
         close (unit = nin)
         if (abort) then
            deallocate (z, stat = ierr)
            nz = 0
            fnamez = no_file
            titlez = no_data
            return
         endif
c
c Step 5: see what the user wants to do ... title may change in vec4in
c ======= vec4in is the equivalent of vecone offering as follows:
c         abort = .true. on return: deallocate workspaces then exit
c         newdat = .false. on return: try for a new data set
c         newdat = .true. on return: proceed with original or edited data
c         fnamez and titlez are altered if the data are edited
c
         call vec4in (nz,
     +                z,
     +                fnamez, header(isend), titlez,
     +                abort, newdat)
         if (abort) then
c
c Option 1 from vec4in: Deallaocate then exit
c --------
c
            deallocate (z, stat = ierr)
            return
         elseif (newdat) then
c
c Option 2 from vec4in: New data
c --------
c
            fnamez = no_file
            titlez = no_data
            nz = 0
         else
c
c Option 3 from vec4in: Proceed to analysis
c --------
c
            newdat = .false.
            if (isend.eq.1) then
               call m_vecexh (nin, nout, nz,
     +                        z,
     +                        fnamez, titlez)
            elseif (isend.eq.2) then
               call m_ttest1 (nout, nz,
     +                        z,
     +                        titlez)
            elseif (isend.eq.3) then
               jsend = 0
               call m_ks1sam (jsend, nout, nz,
     +                        z,
     +                        titlez)
            elseif (isend.eq.4) then
               call m_ndtest (nout, nz,
     +                        z,
     +                        titlez)
            elseif (isend.eq.5) then
               call m_exactp (nout, nz,
     +                        z,
     +                        titlez)
            elseif (isend.eq.6) then
               call m_rob001 (nout, nz,
     +                        z,
     +                        titlez)
            elseif (isend.eq.7) then
               call m_time04 (nout, nz,
     +                        z,
     +                        titlez)
            elseif (isend.eq.8) then
               call m_time01 (nout, nz,
     +                        z,
     +                        titlez) 
            elseif (isend.eq.9) then
               call m_time02 (nout, nz,
     +                        z,
     +                        titlez) 
            elseif (isend.eq.10) then
               call m_zeros1 (nout, nz,
     +                        z,
     +                        titlez)
            elseif (isend.eq.11) then
               call m_kernde (nout, nz,
     +                        z,
     +                        titlez,
     +                        newdat)
            elseif (isend.eq.12) then
               call m_dmat00 (nout, nz,
     +                        z,
     +                        titlez,
     +                        newdat)
            elseif (isend.eq.13) then
               call m_runs01 (nout, nz,
     +                        z,
     +                        titlez)   
            elseif (isend.eq.14) then
               call m_updown (nout, nz,
     +                        z,
     +                        titlez,
     +                        newdat)  
            elseif (isend.eq.15) then
               jsend = 5
               call m_ks1sam (jsend, nout, nz,
     +                        z,
     +                        titlez)
            elseif (isend.eq.16) then
               jsend = 7
               call m_ks1sam (jsend, nout, nz,
     +                        z,
     +                        titlez)
            elseif (isend.eq.17) then
               call fdrvec (nz, nout,
     +                      z,                
     +                      titlez) 
            elseif (isend.eq.18) then
               call rannum_sample (nout, nz,
     +                             z,
     +                             titlez)                             
            endif     
            if (.not.newdat) then
               deallocate(z, stat = ierr)
               return
            endif   
         endif
      enddo
c------------------------------------------------------------
c End of code to replace calls to vecone to access a vector
c------------------------------------------------------------
c
  100 format ('Now input a vector formatted like the test file',1x,a)
      end
c
c
