c
c
      subroutine m_vectst (nin, nout)
c
c action: all possible pairwise comparisons
c author: w.g.bardsley, university of manchester, u.k., 12/02/2006
c
      implicit  none
c
c arguments
c
      integer   nin, nout
c
c local allocatable arrays
c
      integer,                allocatable :: iwrk(:)
      double precision,       allocatable :: v(:), w(:), x(:), y(:)
      character (len = 1024), allocatable :: fsav(:)
      character (len = 80),   allocatable :: tsav(:)
c
c locals
c
      integer    ierr, nmax, nsmall
      parameter (nmax = 2000, nsmall = 10)
      external   vectst
      if (nin. le.0  .or. nout.le.0) return
      ierr = 0
      if (allocated(iwrk)) deallocate(iwrk, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(v)) deallocate(v, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w)) deallocate(w, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y)) deallocate(y, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(fsav)) deallocate(fsav, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(tsav)) deallocate(tsav, stat = ierr)
      if (ierr.ne.0) return
      allocate(iwrk(4*nmax + 2), stat = ierr)
      if (ierr.ne.0) return
      allocate(v(2*nmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(w(3*nmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(x(nmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(y(nmax), stat = ierr)
      if (ierr.ne.0) return
      allocate (fsav(nsmall), stat = ierr)
      if (ierr.ne.0) return
      allocate (tsav(nsmall), stat = ierr)
      if (ierr.ne.0) return
      call vectst (iwrk, nin, nmax, nout, nsmall,
     +             v, w, x, y,
     +             fsav, tsav)
      deallocate(iwrk, stat = ierr)
      deallocate(v, stat = ierr)
      deallocate(w, stat = ierr)
      deallocate(x, stat = ierr)
      deallocate(y, stat = ierr)
      deallocate(fsav, stat = ierr)
      deallocate(tsav, stat = ierr)
      end
c
c
