C
C
      SUBROUTINE M_VECTWO (ISEND, NIN, NOUT, NX, NY,
     +                     FNAMEX, FNAMEY, TITLEX, TITLEY)
C
C ACTION : Analayse one or two vectors or two rows or columns from a matrix
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.,1/12/94
C          27/01/2006 derived from VECTWO
C          05/02/2006 altered order in argument list to MAT3IN
C          25/01/2007 introduced SIM256  
C          06/03/2007 corrected dimensioning before call to vec2in
C          15/09/2006 added call to m_testeo
C          31/02/2008 introduced show_x and show_y to limit advice about file types 
C                                 
C         ISEND: (input/unchanged) as follows:
C                ISEND = 1: both unpaired and paired t tests
C                ISEND = 2: just unpaired t tests
C                ISEND = 3: just paired t tests   
C                ISEND = 4: Kolmogorov-Smirnov 2-sample test
C                ISEND = 5: Mann-Whitney U test
C                ISEND = 6: Wilcoxon signed rank test
C                ISEND = 7: Robust analysis
C                ISEND = 8: Runs and signs 
C                ISEND = 9: Mood and David
C                ISEND = 10: O/E chi-square test
C           NIN: (input/unchanged) unconnected unit for data input
C          NOUT: (input/unchanged) preconnected unit for results 
C            NX: (input/output) size of X
C            NY: (input/output) size of Y
C        FNAMEX: (input/output) file name for X data
C        FNAMEY: (input/output) file name for Y data
C        TITLEX: (input/output) X-title
C        TITLEY: (input/output) Y-title
C
C If NX/FNAMEX and/or NY/FNAMEY correctly identify vector files they are
C used as defaults. Successful installation of vectors will cause NX/NY
C FNAME/FNAMEY, TITLEY/TITLEY to be overwritten. Reversing the order
C will reverse the order of these vectors, but using rows or columns
C from a matrix  will not alter these parameters at all because the
C actual input/output and calculations use NXTEMP and NYTEMP which do 
C not overwrite the vector file identification parameters. 
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND, NIN, NOUT 
      INTEGER,             INTENT (INOUT) :: NX, NY
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAMEX, FNAMEY,
     +                                       TITLEX, TITLEY
      
C
C Local allocatable wokspaces
C
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:), B(:), X(:), Y(:)
C
C Locals
C
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NSTART, NTEXT, NUMOPT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NSTART = 11,
     +           NUMOPT = 8)
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, N10
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N8 = 8, N9 = 9, N10 = 10)
      INTEGER    NCMAX, NRMAX, NXMAX, NXTEMP, NYMAX, NYTEMP
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    I, IERR, J, JSEND, NCOL, NCOL1, NCOL2, NDOF, NPTS,
     +           NROW, NROW1, NROW2
      CHARACTER  FNAME*1024, LINE*100, SIM256*1024, TITLE*80
      CHARACTER  CHOP60*60, CHOP80*80, TEXT(30)*100
      CHARACTER  XTITLE*80, YTITLE*80
      CHARACTER  STATE*30, WORD6*6, WORD60*60, WX8*10, WY8*10
      CHARACTER  NODATA*60, NOFILE*30, NREADY*30, READY*30
      PARAMETER (NODATA = '(...No data...)',
     +           NOFILE = 'No file', 
     +           NREADY = '(..Not ready..)',
     +            READY = '(*** Ready ***)' )
      CHARACTER  HEADER(10)*100, OPTION(4)*4
      CHARACTER  BLANK4*4, STAR4*4
      PARAMETER (BLANK4 = '    ', STAR4 = '****')
      LOGICAL    ABORT, REPEET
      LOGICAL    SHOW_X, SHOW_Y
      LOGICAL    FIXNX, FIXNY, FIXNPT, LABEL
      PARAMETER (FIXNX = .FALSE., FIXNY = .FALSE., LABEL = .TRUE.)
      LOGICAL    FIXCOL, FIXROW
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   PUTADV, VEC2IN, VEC3IN, PUTFAT, LBOX01, CHOP80, TRIML1,
     +           PATCH1, CHOP60, ISITVF, MAT2IN, MAT3IN, GETJM1, SIM256
      EXTERNAL   M_TTESTS, M_KS2SAM, M_MWUTST, M_WSRTST, M_ROB002,
     +           M_RUNS02, M_MMOODD, M_TESTEO
      SAVE       SHOW_X, SHOW_Y
      DATA       SHOW_X, SHOW_Y / .TRUE., .TRUE. /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       HEADER /
     +'Paired and unpaired t tests',             !1
     +'2-sample unpaired t test',                !2
     +'2-sample paired t test',                  !3
     +'2-sample Kolmogorv-Smirnov test',         !4
     +'Mann-Whitney U test',                     !5
     +'Wilcoxon signed rank test',               !6 
     +'Robust 2-sample comparison',              !7
     +'Runs and Signs tests',                    !8
     +'Mood and David tests',                    !9 
     +'X=observed, Y=expected for chi-square' / !10
      IF (ISEND.LT.N1 .OR. ISEND.GT.N10) RETURN
      IF (ISEND.EQ.N3 .OR. ISEND.EQ.N6 .OR. ISEND.EQ.N8 .OR. 
     +    ISEND.EQ.N10) THEN             
         FIXNPT = .TRUE.
      ELSE   
         FIXNPT = .FALSE.
      ENDIF   
      NCMAX = N2
      NRMAX = N2
C
C Allocate workspaces
C
      IERR = 0
      IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.0) RETURN      
C
C Check input data using ISITVF and initialise nxtemp, nytemp, etc.
C                        
      IF (NX.LE.N0 .AND. NY.LE.N0) THEN 
         IF (ISEND.EQ.N5) THEN
            NX = 16
            NY = 23
            FNAMEX = SIM256('g08ahf.tf1')
            FNAMEY = SIM256('g08ahf.tf2')
         ELSEIF (ISEND.EQ.N6) THEN
            NX = 8
            NY = 8
            FNAMEX = SIM256('g08agf.tf1')
            FNAMEY = SIM256('g08agf.tf2')
         ELSEIF (ISEND.EQ.N8) THEN
            NX = 50
            NY = 50
            FNAMEX = SIM256('rstest.tf1')
            FNAMEY = SIM256('normal.tf1')
         ELSEIF (ISEND.EQ.N9) THEN
            NX = 6
            NY = 6
            FNAMEX = SIM256('g08baf.tf1')
            FNAMEY = SIM256('g08baf.tf2')
         ELSEIF (ISEND.EQ.N10) THEN
            NX = 6
            NY = 6
            FNAMEX = SIM256('chisqd.tf2')
            FNAMEY = SIM256('chisqd.tf3')  
         ELSE   
            NX = 10
            NY = 10                         
            FNAMEX = SIM256('ttest.tf2')
            FNAMEY = SIM256('ttest.tf3') 
         ENDIF   
      ENDIF  
      IF (NX.GT.N1) THEN
         NPTS = N0
         CALL ISITVF(NPTS,
     +               FNAMEX)
         IF (NPTS.EQ.NX) THEN 
            NXMAX = NX
            ALLOCATE(X(NXMAX), STAT = IERR)
            ABORT = .FALSE. 
            IF (IERR.EQ.N0) THEN
               CLOSE (UNIT = NIN)
               CALL VEC2IN (NIN, NXMAX, NX, 
     +                      X,
     +                      FNAMEX, TITLEX,
     +                      ABORT)
               CLOSE (UNIT = NIN)
               NXTEMP = NX 
               XTITLE = CHOP80(TITLEX)
            ENDIF  
            IF (ABORT) THEN
               DEALLOCATE(X, STAT = IERR) 
               NX = N0
               FNAMEX = NOFILE
               TITLEX = NODATA
            ENDIF 
         ELSE
            NX = N0    
            NXTEMP = N0    
            FNAMEX = NOFILE
            XTITLE = NODATA
         ENDIF
      ELSE
         NX = N0 
         NXTEMP = N0  
         FNAMEX = NOFILE
         TITLEX = NODATA
         XTITLE = NODATA
      ENDIF
      IF (NY.GT.N1) THEN
         NPTS = N0
         CALL ISITVF(NPTS,
     +               FNAMEY)
         IF (NPTS.EQ.NY) THEN 
            NYMAX = NY
            ALLOCATE(Y(NYMAX), STAT = IERR)
            ABORT = .FALSE. 
            IF (IERR.EQ.N0) THEN
               CLOSE (UNIT = NIN)
               CALL VEC2IN (NIN, NYMAX, NY, 
     +                      Y,
     +                      FNAMEY, TITLEY,
     +                      ABORT)
               CLOSE (UNIT = NIN)
               NYTEMP = NY 
               YTITLE = CHOP80(TITLEY)
            ENDIF  
            IF (ABORT) THEN
               DEALLOCATE(Y, STAT = IERR) 
               NY = N0
               FNAMEY = NOFILE
               TITLEY = NODATA
            ENDIF     
         ELSE
            NY = N0
            NYTEMP = N0        
            FNAMEY = NOFILE
            TITLEY = NODATA
            YTITLE = NODATA
         ENDIF
      ELSE
         NY = N0   
         NYTEMP = N0
         YTITLE = NODATA
      ENDIF

C
C Main loop......................................................
C
      NUMBLD(1) = 1
      REPEET = .TRUE.
      DO WHILE (REPEET)
         DO I = N1, N4
            OPTION(I) = BLANK4
         ENDDO
         IF (NXTEMP.LT.N2) THEN
            IF (FIXNPT) THEN
               NUMDEC = N3
            ELSE
               NUMDEC = N1
            ENDIF
            OPTION(NUMDEC) = STAR4
            STATE = NREADY
         ELSEIF (NYTEMP.LT.N2) THEN
            NUMDEC = N2
            OPTION(NUMDEC) = STAR4
            STATE = NREADY
         ELSEIF (FIXNPT) THEN
            IF (NXTEMP.EQ.NYTEMP) THEN
               NUMDEC = N6
               STATE = READY
            ELSE
               NUMDEC = N3
               OPTION(NUMDEC) = STAR4
               STATE = NREADY
            ENDIF
         ELSE
            NUMDEC = N6
            STATE = READY
         ENDIF
         WRITE (WX8,100) NXTEMP
         WRITE (WY8,100) NYTEMP
         CALL TRIML1 (WX8)
         CALL TRIML1 (WY8)
         WRITE (TEXT,200) HEADER(ISEND), WX8, XTITLE, WY8, YTITLE,
     +                   (OPTION(I), I = N1, N4),STATE
         NTEXT = NSTART + NUMOPT - 1
         NUMBLD(1) = 4
         NUMBLD(5) = 1
         NUMBLD(9) = 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(5) = 0
         NUMBLD(9) = 0
         IF (NUMDEC.EQ.N1) THEN
C
C NUMDEC = 1: Read in X data
C ===========
C 
            IF (SHOW_X) THEN
               SHOW_X = .FALSE.
               WRITE (LINE,300)
               CALL PUTADV (LINE)
            ENDIF   
c
c start of code to read in a vector
c ---------------------------------
c            
            npts = 0
            fname = nofile
            title = nodata 
            jsend = 3
            close (unit = nin)
            call vec3in (jsend, nin, npts,
     +                   fname, title,
     +                   abort, fixnx, label)
            close (unit = nin) 
            if (.not.abort .and. npts.gt.n1) then
               if (allocated(b)) deallocate(b, stat = ierr) 
               nxmax = npts
               if (ierr.eq.0) allocate(b(nxmax), stat = ierr)
               abort = .true.
               if (ierr.eq.0) then
                  close (unit = nin)     
                  call vec2in (nin, nxmax, npts,
     +                         b,
     +                         fname, title, 
     +                         abort)
                  close (unit = nin)
               endif   
               if (.not.abort .and. ierr.eq.0) then
                  if (allocated(x)) deallocate(x, stat = ierr)
                  if (ierr.eq.0) allocate(x(npts), stat = ierr)
                  if (ierr.eq.0) then
                     nx = npts 
                     nxtemp = nx
                     fnamex = fname
                     titlex = chop80(title)
                     xtitle = titlex
                     do i = n1, nx
                        x(i) = b(i)
                     enddo
                     deallocate(b, stat = ierr)  
                  endif    
               endif
            endif                  
c
c end of code to read in a vector
c -------------------------------
c            
            
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C NUMDEC = 2: Read in Y data
C ===========
C
            IF (SHOW_Y) THEN
               SHOW_Y = .FALSE. 
               WRITE (LINE,400)
               CALL PUTADV (LINE) 
            ENDIF   
c
c start of code to read in a vector
c ---------------------------------
c            
            npts = 0
            fname = nofile
            title = nodata 
            jsend = 3
            close (unit = nin)
            call vec3in (jsend, nin, npts,
     +                   fname, title,
     +                   abort, fixny, label)
            close (unit = nin) 
            if (.not.abort .and. npts.gt.n1) then
               if (allocated(b)) deallocate(b, stat = ierr)
               nymax = npts
               if (ierr.eq.0) allocate(b(nymax), stat = ierr)
               abort = .true.
               if (ierr.eq.0) then
                  close (unit = nin)     
                  call vec2in (nin, nymax, npts,
     +                         b,
     +                         fname, title, 
     +                         abort)
                  close (unit = nin)
               endif   
               if (.not.abort .and. ierr.eq.0) then
                  if (allocated(y)) deallocate(y, stat = ierr)
                  if (ierr.eq.0) allocate(y(npts), stat = ierr)
                  if (ierr.eq.0) then
                     ny = npts  
                     nytemp = ny
                     fnamey = fname
                     titley = chop80(title)
                     ytitle = titley
                     do i = n1, ny
                        y(i) = b(i)
                     enddo
                     deallocate(b, stat = ierr)  
                  endif    
               endif
            endif                  
c
c end of code to read in a vector
c -------------------------------
c                   
            
            
         ELSEIF (NUMDEC.EQ.N3 .OR. NUMDEC.EQ.N4) THEN
C
C NUMDEC = 3 or 4: read in a matrix
C ================
C
        
c                 
c -------------------------------
c start of code to input a matrix
c                 
            jsend = 3
            close (unit = nin)
            call mat3in (jsend, j, nin, i, 
     +                   fname, title,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (.not.abort .and. i.gt.0 .and. j.gt.0) then
               nrmax = i 
               nrow = nrmax
               ncmax = j   
               ncol = ncmax     
               close (unit = nin) 
               if (allocated(a)) deallocate(a, stat = ierr)
               if (ierr.eq.0) allocate(a(nrmax,ncmax), stat = ierr) 
               if (ierr.eq.0) then
                  call mat2in (nin, ncmax, j, i, nrmax,
     +                         a,
     +                         fname, title,
     +                         abort)
                  close (unit = nin)
                  if (.not.abort .and. i.gt.0 .and. j.gt.0) then            
                     if (numdec.eq.3) then
                        nrow = i
                        ncol = j        
                        nxtemp = nrow
                        nytemp = nrow
                        if (allocated(x)) deallocate(x, stat = ierr)
                        if (ierr.eq.0) allocate(x(nrow), stat = ierr)
                        if (allocated(y)) deallocate(y, stat = ierr)
                        if (ierr.eq.0) allocate(y(nrow), stat = ierr)
                        if (ncol.eq.n2) then
                           ncol1 = n1
                           ncol2 = n2
                        else 
                           i = n1
                           j = ncol 
                           ncol1 = n1
                           call getjm1 (i, ncol1, j,
     +                                 'Column required for X')
                           ncol2 = n2 
                           call getjm1 (i, ncol2, j, 
     +                                 'Column required for Y') 
                        endif  
                        do i = n1, nrow
                           x(i) = a(i,ncol1)
                           y(i) = a(i,ncol2)
                        enddo
                        word60 = chop60(title)   
                        write (word6,'(i6)') ncol1
                        call triml1 (word6)
                        xtitle = 'Col '//word6//' of: '//WORD60
                        write (word6,'(i6)') ncol2
                        call triml1 (word6)
                        ytitle = 'Col '//word6//' of: '//WORD60
                     else
                        nrow = i
                        ncol = j        
                        nxtemp = ncol
                        nytemp = ncol
                        if (allocated(x)) deallocate(x, stat = ierr)
                        if (ierr.eq.0) allocate(x(ncol), stat = ierr)
                        if (allocated(y)) deallocate(y, stat = ierr)
                        if (ierr.eq.0) allocate(y(ncol), stat = ierr)
                        if (nrow.eq.n2) then
                           nrow1 = n1
                           nrow2 = n2
                        else 
                           i = n1
                           j = nrow 
                           nrow1 = n1
                           call getjm1 (i, nrow1, j,
     +                                 'Row required for X')
                           nrow2 = n2 
                           call getjm1 (i, nrow2, j, 
     +                                 'Row required for Y') 
                        endif  
                        do j = n1, ncol
                           x(j) = a(nrow1,j)
                           y(j) = a(nrow2,j)
                        enddo
                        word60 = chop60(title)   
                        write (word6,'(i6)') nrow1
                        call triml1 (word6)
                        xtitle = 'Row '//word6//' of: '//WORD60
                        write (word6,'(i6)') nrow2
                        call triml1 (word6)
                        ytitle = 'Row '//word6//' of: '//WORD60
                     endif   
                  endif    
               endif    
c
c end of code to read in a matrix
c -------------------------------
c
            endif             
            
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C NUMDEC = 5: Interchange X and Y
C =========== 
C
            IF (NXTEMP.GT.N1 .AND. NYTEMP.GT.N1) THEN   
               NPTS = MAX(NXTEMP,NYTEMP)
               IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
               IF (IERR.EQ.0) ALLOCATE(B(NPTS), STAT = IERR)
               IF (NXTEMP.NE.NYTEMP) THEN 
C
C Make arrays X and Y of equal length prior to swapping round              
C
                  DO I = N1, NXTEMP
                     B(I) = X(I)
                  ENDDO
                  DEALLOCATE(X, STAT = IERR)
                  ALLOCATE(X(NPTS), STAT = IERR)
                  DO I = N1, NXTEMP
                     X(I) = B(I)
                  ENDDO 
                  DO I = N1, NYTEMP
                     B(I) = Y(I)
                  ENDDO
                  DEALLOCATE(Y, STAT = IERR)
                  ALLOCATE(Y(NPTS), STAT = IERR)
                  DO I = N1, NYTEMP
                     Y(I) = B(I)
                  ENDDO 
               ENDIF       
               IF (IERR.EQ.0) THEN  
C
C Interchange X and Y
C               
                  TITLE = XTITLE
                  NROW = NXTEMP
                  DO I = N1, NROW
                     B(I) = X(I)
                  ENDDO
                  XTITLE = YTITLE
                  NXTEMP = NYTEMP
                  DO I = N1, NXTEMP
                     X(I) = Y(I)
                  ENDDO
                  YTITLE = TITLE
                  NYTEMP = NROW
                  DO I = N1, NYTEMP
                     Y(I) = B(I)
                  ENDDO
                  WRITE (LINE,500)
                  CALL PUTADV (LINE)
                  DEALLOCATE(B, STAT = IERR)
               ENDIF   
            ELSE
               WRITE (LINE,600)
               CALL PUTFAT (LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.N6) THEN
C
C NUMDEC = 6: Analyse vectors
C ===========
C         
            IF (NXTEMP.LT.N2 .OR. NYTEMP.LT.N2) THEN
               WRITE (LINE,700)
               CALL PUTFAT (LINE)
            ELSEIF (FIXNPT .AND. NXTEMP.NE.NYTEMP) THEN
               WRITE (LINE,800)
               CALL PUTFAT (LINE)
            ELSEIF (ISEND.GE.N1 .AND. ISEND.LE.N3) THEN
               CALL M_TTESTS (ISEND, NOUT, NXTEMP, NYTEMP,
     +                        X, Y,
     +                        XTITLE, YTITLE)
            ELSEIF (ISEND.EQ.N4) THEN
               CALL M_KS2SAM (NOUT, NXTEMP, NYTEMP,
     +                        X, Y,
     +                        XTITLE, YTITLE) 
            ELSEIF (ISEND.EQ.N5) THEN
               CALL M_MWUTST (NOUT, NXTEMP, NYTEMP,
     +                        X, Y,
     +                        XTITLE, YTITLE) 
            ELSEIF (ISEND.EQ.N6) THEN
               CALL M_WSRTST (NOUT, NXTEMP, NYTEMP,
     +                        X, Y,
     +                        XTITLE, YTITLE)
            ELSEIF (ISEND.EQ.N7) THEN
               CALL M_ROB002 (NOUT, NXTEMP, NYTEMP,
     +                        X, Y,
     +                        XTITLE, YTITLE)
            ELSEIF (ISEND.EQ.N8) THEN
               CALL M_RUNS02 (NOUT, NXTEMP, 
     +                        X, Y,
     +                        XTITLE, YTITLE)
            ELSEIF (ISEND.EQ.N9) THEN
               CALL M_MMOODD (NOUT, NXTEMP, NYTEMP,
     +                        X, Y,
     +                        XTITLE, YTITLE)
            ELSEIF (ISEND.EQ.N10) THEN
               JSEND = 0
               CALL M_TESTEO (JSEND, NDOF, NOUT, NXTEMP, 
     +                        X, Y,
     +                        XTITLE, YTITLE)
            ELSE
               ABORT = .FALSE.
               REPEET = .FALSE.
            ENDIF
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C NUMDEC = NUMOPT - 1: Help
C ====================
C         
            WRITE (TEXT,1000)
            NTEXT = 20
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT,
     +                   TEXT,
     +                   BORDER)
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = NUMOPT: Exit
C =====================
C         
            REPEET = .FALSE.
            CLOSE (UNIT = NIN)
            ABORT = .TRUE.
         ENDIF
      ENDDO
C
C End of main loop......................................................
C
      
C
C Deallocate workspace
C
      DEALLOCATE(A, STAT = IERR)
      DEALLOCATE(B, STAT = IERR) 
      DEALLOCATE(X, STAT = IERR)
      DEALLOCATE(Y, STAT = IERR)
C
C Format statements
C
  100 FORMAT (I8)
  200 FORMAT (
     + A
     +/
     +/'For current X-data: NX =',1X,A
     +/'Title of X-data is:'
     +/A
     +/
     +/'For current Y-data: NY =',1X,A
     +/'Title of Y-data is:'
     +/A
     +/
     +/'Input a new X-data vector',1X,A
     +/'Input a new Y-data vector',1X,A
     +/'Input columns from a data matrix',1X,A
     +/'Input rows from a data matrix',1X,A
     +/'Interchange the X and Y samples'
     +/'Analyse the current X,Y data',1X,A
     +/'Help'
     +/'Quit ... Exit this data input procedure')
  300 FORMAT ('Now input the first data sample (X as a n by 1 vector)')
  400 FORMAT ('Now input the second data sample (Y as a n by 1 vector)')
  500 FORMAT ('The data sets have been successfully interchanged')
  600 FORMAT ('Insufficient data')
  700 FORMAT ('Sample size too small for a meaningful test')
  800 FORMAT ('Sample sizes are not equal')
 1000 FORMAT (
     + 'Supplying two data samples for analysis'
     +/
     +/'The analytical procedure you have selected requires two samples'
     +/'in the form of column vectors with no missing values, that is'
     +/
     +/'X with sample size NX (where NX > 1), and'
     +/'Y with sample size NY (where NY > 1).'
     +/
     +/'From this control you can input two sample vectors for each'
     +/'analysis or, if it is more convenient, maintain one sample'
     +/'as a reference sample and just renew one of the data sets.'
     +/
     +/'Note that some procedures (e.g. a paired t test) require'
     +/'identical sample sizes, i.e. NX = NY, which is easily done'
     +/'by reading in a rectangular data matrix instead of 2 vectors.'
     +/'You can input data from vector/matrix files, type values at'
     +/'the terminal, or paste in as columns from the clipboard, but'
     +/'you should always supply meaningful titles, to identify the'
     +/'results retrospectively from these titles as they are written'
     +/'to the results log file.')
      END
C
C
