C
C
      SUBROUTINE M_WSRTST (NOUT, NX, NY,
     +                     X, Y, 
     +                     TITLEX, TITLEY)
C
C ACTION : Wilcoxon signed rank test
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          28/01/2006 Derived from WSRTST
C          22/07/2021 added E_NUMBERS and E_FORMATS, etc.
C
C          NOUT: (input/unchanged) preconnected unit for output
C            NX: (input/unchanged) X-dimension
C            NY: (input/unchanged) Y-dimension
C             X: (input/unchanged) X-data
C             Y: (input/unchanged) Y-data
C        TITLEX: (input/unchanged) X-title
C        TITLEY: (input/unchanged) Y-title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NOUT, NX, NY
      DOUBLE PRECISION X(NX), Y(NY)
      CHARACTER  TITLEX*(*), TITLEY*(*)  
C
C Local allocatable workspaces
C                             
        DOUBLE PRECISION, ALLOCATABLE :: WRK(:), Z(:)
C
C Locals
C
      INTEGER    I, ICOUNT, IERR, IFAIL, N, NMAX, NSUPP
      INTEGER    ICOLOR, NUMTXT, N1
      PARAMETER (NUMTXT = 19, N1 = 1)
      INTEGER    JCOLOR, IX, IY, NOPT, NUMDEC
      PARAMETER (JCOLOR = 9, IX = 4, IY = 4, NOPT = 4)
      INTEGER    NUMPOS(NOPT)
      DOUBLE PRECISION P1, P2, P3, U1, U2, U3, Z1, Z2, Z3
      DOUBLE PRECISION W, WNOR, XME
      DOUBLE PRECISION ONE, TWO, EPSI
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, EPSI = 1.0D-06)
      CHARACTER (LEN = 12) I12(2), FORM12
      CHARACTER (LEN = 13) D13(2), SHOWLJ
      CHARACTER  TAIL*1
      CHARACTER  P1TYPE*23, P2TYPE*23, P3TYPE*23
      CHARACTER  CHOP60*60, LINE*100, TEXT(30)*100
      CHARACTER  CIPHER*10, ZEROS*1
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    REPEET
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   PLEVEL, PUTIFA, TABLE1, CHOP60, PUTFAT,
     +           GETD01, PUTADV, LBOX02
      EXTERNAL   G08AGF$
      INTRINSIC  ABS, MIN
      SAVE       ICOUNT, XME, ZEROS
      DATA       ICOUNT / 0 /
      DATA       NUMPOS / NOPT*1 /
      DATA       XME / 0.0D+00 /
      DATA       ZEROS / 'N' /
      IF (NX.NE.NY) THEN
         WRITE (LINE,100) NX, NY
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
      N = NX
      IF (N.LT.2) THEN
         WRITE (LINE,200) N
         CALL PUTFAT (LINE)
         RETURN
      ENDIF    
C
C Allocate workspaces
C              
      WRITE (NOUT,'(A)') ' '      
      WRITE (NOUT,'(A)') '***'      
      IERR = 0
      IF(ALLOCATED(WRK)) DEALLOCATE(WRK, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Z)) DEALLOCATE(Z, STAT = IERR)
      IF (IERR.NE.0) RETURN
      NMAX = N
      ALLOCATE(WRK(3*NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(Z(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Decision loop
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (ZEROS.EQ.'Y' .OR. ZEROS.EQ.'y') THEN
            CIPHER = ' [Yes]'
         ELSE
            ZEROS = 'N'
            CIPHER = ' [No]'
         ENDIF
         WRITE (TEXT,300) XME, CIPHER
         NUMDEC = NOPT - 1
         CALL LBOX02 (JCOLOR, IX, IY, NUMDEC, NOPT, NUMPOS, TEXT)
         IF (NUMDEC.EQ.1) THEN
C
C Change test median
C
            WRITE (LINE,400)
            CALL GETD01 (XME, LINE)
            IF (ABS(XME).GT.EPSI) THEN
               WRITE (LINE,500)
               CALL PUTADV (LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.2) THEN
C
C Togle ZEROS
C
            IF (ZEROS.EQ.'Y' .OR. ZEROS.EQ.'y') THEN
               ZEROS = 'N'
            ELSE
               ZEROS = 'Y'
            ENDIF
            IF (ZEROS.EQ.'Y') THEN
               WRITE (LINE,600)
               CALL PUTADV (LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.3) THEN
C
C Analysis requested
C
            REPEET = .FALSE.
            IF (ABS(XME).GT.EPSI) THEN
               WRITE (LINE,500)
               CALL PUTADV (LINE)
            ENDIF
            IF (ZEROS.EQ.'Y') THEN
               WRITE (LINE,600)
               CALL PUTADV (LINE)
            ENDIF
         ELSE
C
C Cancel
C
            REPEET = .FALSE.
         ENDIF
      ENDDO
      IF (NUMDEC.EQ.NOPT) RETURN
C
C Calculate the differences
C
      DO I = N1, N
         Z(I) = X(I) - Y(I)
      ENDDO
C
C Calculate U, Z, and P with TAIL = 'L'
C
      IFAIL = 1
      TAIL = 'L'
      CALL G08AGF$(N, Z, XME, TAIL, ZEROS, U2, Z2, P2, I, WRK,
     +             IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G08AGF/WSRTST')
      IF (IFAIL.NE.0) THEN
         DEALLOCATE(WRK, STAT = IERR)
         DEALLOCATE(Z, STAT = IERR)
         RETURN
      ENDIF   
      NSUPP = N - I
C
C Copy U and set approximate significance levels in case of future errors
C
      W = U2
      WNOR = Z2
      U1 = U2
      U3 = U2
      P3 = ONE - P2
      P1 = TWO*MIN(P2, P3)
C
C Calculate exact significance levels for small samples
C
      IF (N.LE.80) THEN
         IFAIL = 1
         TAIL = 'T'
         CALL G08AGF$(N, Z, XME, TAIL, ZEROS, U1, Z1, P1, I, WRK,
     +             IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G08AGF/WSRTST')
         IF (IFAIL.NE.0) THEN
            DEALLOCATE(WRK, STAT = IERR)
            DEALLOCATE(Z, STAT = IERR)
            RETURN
         ENDIF   
         IFAIL = 1
         TAIL = 'U'
         CALL G08AGF$(N, Z, XME, TAIL, ZEROS, U3, Z3, P3, I, WRK,
     +                IFAIL)
         CALL PUTIFA (IFAIL, NOUT, 'G08AGF/WSRTST')
         IF (IFAIL.NE.0) THEN
            DEALLOCATE(WRK, STAT = IERR)
            DEALLOCATE(Z, STAT = IERR)
            RETURN
         ENDIF   
      ENDIF
C
C Output the results
C
      E_NUMBERS = E_FORMATS()
      ICOUNT = ICOUNT + 1
      CALL PLEVEL (P1, P1TYPE)
      CALL PLEVEL (P2, P2TYPE)
      CALL PLEVEL (P3, P3TYPE)
      IF (E_NUMBERS) THEN
         IF (ZEROS.EQ.'Y') THEN
            WRITE (LINE,700) XME
         ELSE
            WRITE (LINE,800) XME
         ENDIF
      ELSE
         D13(1) = SHOWLJ(XME)
         IF (ZEROS.EQ.'Y') THEN
            WRITE (LINE,750) D13(1)
         ELSE
            WRITE (LINE,850) D13(1)
         ENDIF
      ENDIF  
      IF (E_NUMBERS) THEN
         WRITE (NOUT,1000) ICOUNT,
     +                     LINE, TITLEX, TITLEY,
     +                     N, NSUPP, 
     +                     W, WNOR,
     +                     P1, P1TYPE, 
     +                     P2, P2TYPE,
     +                     P3, P3TYPE
         WRITE (TEXT,2000) ICOUNT,
     +                     LINE, CHOP60(TITLEX), CHOP60(TITLEY),
     +                     N, NSUPP,
     +                     W, WNOR,
     +                     P1, P1TYPE, 
     +                     P2, P2TYPE, 
     +                     P3, P3TYPE
      ELSE
         I12(1) = FORM12(N)
         I12(2) = FORM12(NSUPP)
         D13(1) = SHOWLJ(W)
         D13(2) = SHOWLJ(WNOR)
         WRITE (NOUT,1500) ICOUNT,
     +                     LINE, TITLEX, TITLEY,
     +                     I12(1), I12(2), 
     +                     D13(1), D13(2),
     +                     P1, P1TYPE, 
     +                     P2, P2TYPE,
     +                     P3, P3TYPE
         WRITE (TEXT,2500) ICOUNT,
     +                     LINE, CHOP60(TITLEX), CHOP60(TITLEY),
     +                     I12(1), I12(2), 
     +                     D13(1), D13(2),     
     +                     P1, P1TYPE, 
     +                     P2, P2TYPE, 
     +                     P3, P3TYPE
      ENDIF  
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.1  .OR. I.EQ.12 .OR. I.EQ.14 .OR. I.EQ.16 .OR.
     +       I.EQ.18) THEN
            ICOLOR = 4
         ELSEIF (I.EQ.5 .OR. I.EQ.7) THEN
            ICOLOR = 1
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
C
C Deallocate workspaces
C      
      DEALLOCATE(WRK, STAT = IERR)
      DEALLOCATE(Z, STAT = IERR)
C
C Format statements
C      
  100 FORMAT (
     +'This test requires equal sample sizes but NX =',I6,', NY =',I6)
  200 FORMAT (
     +'This test requires sample sizes > 2 but NX = NY =',I6)
  300 FORMAT (
     + 'Change median of differences (current =',1P,E13.5,')'
     +/'Include zero differences,',A
     +/'Calculate'
     +/'Quit ... Exit these options')
  400 FORMAT ('New median test value required (usually median = 0)')
  500 FORMAT ('Usually set the median of differences test value = 0')
  600 FORMAT ('It is usual to suppress zero differences')
  700 FORMAT (
     +'Zero differences included, median test value =',1P,E13.5)
  750 FORMAT (
     +'Zero differences included, median test value =',1X,A)     
  800 FORMAT (
     +'Zero differences suppressed, median test value =',1P,E13.5)
  850 FORMAT (
     +'Zero differences suppressed, median test value =',1X,A)     
 1000 FORMAT (
     +/1X,'Wilcoxon paired-sample signed-rank test',I4
     +/1X,'-------------------------------------------'
     +/1X,A
     +/1X,'X-data: ',A
     +/1X,'Y-data: ',A
     +/1X,'N  =',i6,1X,'(number of X,Y pairs)'
     +/1X,'M  =',I4,1X,'(number suppressed)'
     +/1X,'W  =',1P,E13.5
     +/1X,'z  =',1P,E13.5
     +/1X,'H0 = X median and Y median are equal'
     +/1X,'...= as null hypothesis against the alternatives:-'
     +/1X,'H1 = Medians differ'
     +/1X,'p  =',0P,F8.4,4X,A
     +/1X,'H2 = X median < Y median'
     +/1X,'p  =',0P,F8.4,4X,A
     +/1X,'H3 = X median > Y median'
     +/1X,'p  =',0P,F8.4,4X,A)
 1500 FORMAT (
     +/1X,'Wilcoxon paired-sample signed-rank test',I4
     +/1X,'-------------------------------------------'
     +/1X,A
     +/1X,'X-data: ',A
     +/1X,'Y-data: ',A
     +/1X,'N  =',1X,A,1X,'(number of X,Y pairs)'
     +/1X,'M  =',1X,A,1X,'(number suppressed)'
     +/1X,'W  =',1X,A
     +/1X,'z  =',1X,A
     +/1X,'H0 = X median and Y median are equal'
     +/1X,'...= as null hypothesis against the alternatives:-'
     +/1X,'H1 = Medians differ'
     +/1X,'p  =',F7.4,4X,A
     +/1X,'H2 = X median < Y median'
     +/1X,'p  =',F7.4,4X,A
     +/1X,'H3 = X median > Y median'
     +/1X,'p  =',F7.4,4X,A)     
 2000 FORMAT (
     + 'Wilcoxon paired-sample signed-rank test',I4
     +/
     +/A
     +/'X-data:'
     +/A
     +/'Y-data:'
     +/A
     +/'Size of data =',I6
     +/'Number of values suppressed =',I4
     +/'W =',1P,E13.5
     +/'z =',1P,E13.5
     +/'H0: X median = Y median'
     +/'    as null hypothesis against the alternatives:-'
     +/'H1: Medians differ'
     +/'p =',0P,F8.4,4X,A
     +/'H2: X median < Y median'
     +/'p =',0P,F8.4,4X,A
     +/'H3: X median > Y median'
     +/'p =',0P,F8.4,4X,A)
 2500 FORMAT (
     + 'Wilcoxon paired-sample signed-rank test',I4
     +/
     +/A
     +/'X-data:'
     +/A
     +/'Y-data:'
     +/A
     +/'Size of data =',1X,A
     +/'Number of values suppressed =',1X,A
     +/'W =',1X,A
     +/'z =',1X,A
     +/'H0: X median = Y median'
     +/'    as null hypothesis against the alternatives:-'
     +/'H1: Medians differ'
     +/'p =',F7.4,4X,A
     +/'H2: X median < Y median'
     +/'p =',F7.4,4X,A
     +/'H3: X median > Y median'
     +/'p =',F7.4,4X,A)     
      END
C
C
