c
c
      subroutine manova (ing, ncmax, ncsav, nin, nout, nrmax, nrsav,
     +                   a, wk,
     +                   fname, title,
     +                   newdat, supply)
c
c action: multivariate analysis of vaif (firstriance
c author: w.g.bardsley, university of manchester, u.k., 28/10/2003
c         14/04/2004 added calls to isxedi, isxtyp, and isxvec
c         12/01/2006 moved w1 to allocatable
c         07/03/2006 added ncsav, nrsav, fname, title, newdat and supply
c                    to argument list
c         21/06/2006 trapped F < 0 in call to g01edf$
c         14/07/2006 now set F >= epsi before calls to g01edf$ 
c         05/11/2006 edited and introduced eofint
c         01/11/2006 added allpos in call to eofint
c         09/02/2016 added l11, l22, and made nwmax kind = 7  
c         28/02/2019 corrected word12_ng = NG not N
c         11/01/2022 added e_numbers and e_formats, etc.
c         15/02.2022 added itype() and eigvals to control writing to results file
c
c       ing: workspace
c     ncmax: (input/unchanged) second dimension of a 
c     ncsav: (input/output) column dimension
c       nin: (input/unchanged) unconnected unit for file opening 
c      nout: (input/unchanged) preconnected unit for writing results
c     nrmax: (input/unchanged) leading dimension of a 
c     nrsav: (input/output) row dimension
c         a: (input/output) data
c        wk: workspace
c     fname: (input/output) data file
c     title: (input/output) data title
c    newdat: (output) request for new data
c    supply: (input/unchanged) flags data supplied
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: ncmax, nin, nout, nrmax   
      integer,             intent (inout) :: ncsav, nrsav
      integer,             intent (inout) :: ing(nrmax)
      double precision,    intent (inout) :: a(nrmax,ncmax), 
     +                                       wk(nrmax*(ncmax + 1))
      character (len = *), intent (inout) :: fname, title
      logical,             intent (in)    :: supply   
      logical,             intent (out)   :: newdat
c
c local allocatable arrays
c
      integer, allocatable :: isx(:), iwk(:), nig(:) 
      double precision, allocatable :: c(:,:), d(:,:), det(:),
     +                                 eigval(:), gc(:), gmean(:,:),
     +                                 tb(:,:), tbtwi(:,:), tt(:,:),
     +                                 tw(:,:), twi(:,:), w1(:),
     +                                 x1(:), x2(:), y1(:), y2(:) 
c
c locals
c
      integer (kind = 7) l11, l22, nwmax
      integer    i, j, jsend, ldx, ntext, m, n, ncol, ng, nrow, nvar
      integer    ierr, ng1, ng2
      integer    icount, ifail
      integer    icolor, ix, iy, lshade, numdec
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1)
      integer    isend, nstart, nopt, ntype, numopt, numtxt
      parameter (isend = 1, nopt = 7, nstart = 10, ntype = 3,
     +           numopt = 12, numtxt = nstart + numopt - 1)
      integer    n0, n1, n2, n4, nxmin
      parameter (n0 = 0, n1 = 1, n2 = 2, n4 = 4, nxmin = 2)
      integer    l1, l2, l3, l4, m1, m2, m3, m4, np1, np2, np3, np4
      parameter (l1 = 1, l2 = 2, l3 = 0, l4 = 0,
     +           m1 = 5, m2 = 8, m3 = 0, m4 = 0, np3 = 0, np4 = 0)
      integer    idtype, ldg, nisx, ngmax, nvmax, nvmax1
      parameter (idtype = 2, nisx = 100)
      integer    isxsav(nisx)
      integer    numbld(30), numpos(20)
      double precision df, df1(2), sig, sig1(2), stat,
     +                 stat1(2), tsqd, tsqdof(2), tsqsig, wt(2)
      double precision eigdf1(4), eigdf2(4), eigfcn(4), eigsig(4),
     +                 eigtrn(4), factor,
     +                 x3(2), x4(2),
     +                 y3(2), y4(2)
      double precision bot, ratio, top
      double precision alpha, beta, dm, dnu, dnu1, dnu2
      double precision g01ecf$, g01edf$
      double precision zero, one, two, three
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00,
     +           three = 3.0d+00)
      double precision epsi
      parameter (epsi = 1.0d-6)
      character  line*100, symbol*40, text(30)*100
      character  chop80*80, word80*80
      character  banner(2)*100, eigsym(4)*40
      character  ptitle*50, xtitle*30, ytitle*30
      parameter (xtitle = 'Variables', ytitle = 'Group Means')
      character (len = 13) d13(2), showlj, showrj
      character (len = 12) form12, word12_n, word12_ng, i12(6)
      character  failed*100, header*100
      parameter (failed =
     +'Singularity during calculation  ...  Data cannot be analysed',
     +           header = 'Mean vectors: groups then pooled')
      character  blank*1, weight*1
      parameter (blank = ' ', weight = 'U')
      logical    e_numbers, e_formats
      logical    abort, again, first, ok, ready, repeet, showit
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      logical    itfile (5), eigvals, fileit, frame, next, updown
      parameter (fileit = .true., frame = .false.,
     +           updown = .true.)
      logical    axes, gsave
      parameter (axes = .true., gsave = .true.)
      logical    allpos
      parameter (allpos = .true.)
      external   e_formats, showlj, showrj
      external   lbox01, chop80, putadv, putfat, getjm1,
     +           table1, putifa, tutor1, revpro, manovd, dsplay, plevel,
     +           manovx, manovy, xtrnax, lbox02, gks004, isxedi, isxtyp,
     +           isxvec, eofint, form12
      external   g03daf$, dafg03, g01ecf$, g01edf$
      intrinsic  sqrt, log, dble, nint, min
      save       icount, isx, ng1, ng2
      data       numbld / 30*0 /
      data       numpos / 20*1 /
      data       isxsav / nisx*1 /
      data       ng1, ng2 / 1, 2 /
      data       icount / 0 /
c
c initialise newdat then check if supply = .true.
c
      first = .true.
      newdat = .false.
      if (supply) then
         if (ncsav.lt.2 .or. ncsav.gt.ncmax .or.
     +       nrsav.lt.2 .or. nrsav.gt.nrmax) return
      endif
      do i = 1, 5
        itfile(i) = .true.
      enddo  
      eigvals = .true.
c
c allocate workspaces
c
      ierr = 0
      if (allocated(isx)) deallocate(isx, stat = ierr)
      if (ierr.ne.0) return   
      if (allocated(iwk)) deallocate(iwk, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(nig)) deallocate(nig, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(c)) deallocate(c, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(d)) deallocate(d, stat = ierr)
      if (ierr.ne.0) return   
      if (allocated(det)) deallocate(det, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(eigval)) deallocate(eigval, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(gc)) deallocate(gc, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(gmean)) deallocate(gmean, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(tb)) deallocate(tb, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(tbtwi)) deallocate(tbtwi, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(tt)) deallocate(tt, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(tw)) deallocate(tw, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(twi)) deallocate(twi, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w1)) deallocate(w1, stat = ierr)
      if (ierr.ne.0) return   
      if (allocated(x1)) deallocate(x1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x2)) deallocate(x2, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(y1)) deallocate(y1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y2)) deallocate(y2, stat = ierr)
      if (ierr.ne.0) return   
      
      ngmax = nrmax 
      ldg = ngmax + 1
      nvmax = ncmax - 1
      nvmax1 = nvmax + 1 
      
      allocate(isx(nvmax), stat = ierr)
      if (ierr.ne.0) return  
      allocate(iwk(ngmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(nig(ngmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(c(nvmax,nvmax), stat = ierr) 
      if (ierr.ne.0) return 
      allocate(d(nvmax,nvmax), stat = ierr) 
      if (ierr.ne.0) return   
      allocate(det(ngmax + 2), stat = ierr) 
      if (ierr.ne.0) return   
      allocate(eigval(2*nvmax), stat = ierr) 
      if (ierr.ne.0) return 
      allocate(gc((ngmax + 2)*nvmax*(nvmax + 1)/2), stat = ierr)
      if (ierr.ne.0) return
      allocate(gmean(ldg,nvmax), stat = ierr)
      if (ierr.ne.0) return    
      allocate(tb(nvmax,nvmax), stat = ierr)
      if (ierr.ne.0) return   
      allocate(tbtwi(nvmax1,nvmax), stat = ierr)
      if (ierr.ne.0) return  
      allocate(tt(nvmax,nvmax), stat = ierr)
      if (ierr.ne.0) return  
      allocate(tw(nvmax,nvmax), stat = ierr)
      if (ierr.ne.0) return  
      allocate(twi(nvmax,nvmax), stat = ierr)
      if (ierr.ne.0) return   
      allocate(w1(nrmax), stat = ierr)
      if (ierr.ne.0) return 
      allocate(x1(nvmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(x2(nvmax), stat = ierr)
      if (ierr.ne.0) return  
      allocate(y1(nvmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(y2(nvmax), stat = ierr)
      if (ierr.ne.0) return
c
c initialise
c
      do i = 1, nvmax
         if (i.le.nisx) then
            isx(i) = isxsav(i)
         else
            isx(i) = 1
         endif
      enddo
      if (supply) then
         n = nrsav
         m = ncsav
         
c         nwmax = nrmax*(ncmax + 1)
         l11 = nrmax
         l22 = ncmax
         nwmax = l11*(l22 + 1)
         
         call manovd (idtype, ing, m, n, ng, nig, ncmax, nin, nrmax,
     +                nxmin, nwmax,
     +                a, wk,
     +                fname, title,
     +                abort, supply)
         if (abort) then
            deallocate(isx, stat = ierr)
            deallocate(iwk, stat = ierr)
            deallocate(nig, stat = ierr)
            deallocate(c, stat = ierr) 
            deallocate(d, stat = ierr)  
            deallocate(det, stat = ierr)
            deallocate(eigval, stat = ierr)  
            deallocate(gc, stat = ierr)     
            deallocate(gmean, stat = ierr)
            deallocate(tb, stat = ierr)   
            deallocate(tbtwi, stat = ierr)  
            deallocate(tt, stat = ierr)
            deallocate(tw, stat = ierr)
            deallocate(twi, stat = ierr)
            deallocate(w1, stat = ierr)    
            deallocate(x1, stat = ierr)
            deallocate(x2, stat = ierr)
            deallocate(y1, stat = ierr)
            deallocate(y2, stat = ierr)
            return
         endif 
         call eofint (isx, m,
     +                fname,
     +                abort, allpos)         
         ncol = m
         nrow = n
         ready = .true.
      else
         n = n0
         m = n0
         ncol = n0
         nrow = n0
         ncsav = ncol
         nrsav = nrow
         ng = n0     
         fname = 'No file'
         title = 'No data'
         ready = .false.
      endif
      nvar = n0
      word80 = chop80(title)
      ok = .false.
      showit = .false.
c
c main loop ............................................................
c
      e_numbers = e_formats()
      repeet = .true.
      do while (repeet)
         if (ncol.gt.n0) then
            call isxtyp (isx, ncol, nvar, nxmin,
     +                   line,
     +                   showit)
         else
            line = blank
            showit = .false.
         endif
c
c set up the main menu
c
         word12_ng = form12(ng)! corrected as it was incorrectly form12(n)
         word12_n = form12(n)  
        
         write (text,100) word80, line, word12_ng, word12_n
         if (showit) then
              banner(1) = text(5)
              banner(2) = text(6)
         endif
         numdec = numopt - n1
         numbld(1) = n4
         numbld(4) = n1
         numbld(6) = n1
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, numtxt,
     +                text,
     +                border, flash, high)
         if (ready .and. first .and. numdec.ge.2 .and. numdec.le.6) then
            first = .false.
            icount = icount + 1
            write (nout,200) icount, fname, title
         endif   
         numbld(1) = n0
         numbld(4) = n0
         numbld(6) = n0
c
c Special action: Set up the covariance matrices if ready and not ok
c
         if (ready .and. .not.ok .and. numdec.gt.1 .and.
     +       numdec.le.9) then
            ldx = nrmax
            call g03daf$(weight, n, m, a, ldx, isx, nvar, ing, ng,
     +                   wt, nig, gmean, ldg, det, gc, stat, df,
     +                   sig, wk, iwk, ifail)
            call putifa (ifail, nout, 'G03DAF/MANOVA')
            if (ifail.eq.0) then
               call dafg03 (weight, n, m, a, ldx, isx, nvar, ing, ng,
     +                      wt, nig, gmean, ldg, det, gc, stat, df,
     +                      sig, wk, iwk, ifail)
               if (ifail.ne.0) then
                  call putfat (failed)
                endif
            endif
            if (ifail.eq.0) then
               call manovx (iwk, n, ng, nout, nvar, nvmax, nvmax1,
     +                      eigval, gc, tb, tbtwi, tt, tw, twi,
     +                      abort)
               if (abort) then
                  call putfat (failed)
                  ok = .false.
               else
                  ok = .true.
               endif
            else
               ok = .false.
               call putfat (failed)
            endif
         endif
c
c Special action: check current data if analysis has been requested
c
         if (numdec.gt.1 .and. numdec.le.9) then
            if (.not.ready) then
               call putfat ('First read in some data')
               numdec = n0
            else
               call isxvec (isx, ncol, nvar, nxmin)
               if (nvar.lt.nxmin) numdec = n0
            endif
         endif
c
c Special action: inform user if any variables are suppressed
c
         if (ready .and. ok .and. numdec.ge.2 .and. numdec.le.7) then
             write (nout,'(a)') blank
             if (showit) then
                write (nout,'(a)') banner(1)
                write (nout,'(a)') banner(2)
             else 
               write (nout,'(a)') ' All variables included'  
             endif  
         endif
c
c Special action: select group subsets if numdec = 5, 6, or 7
c
         if (ready .and. ok .and. numdec.ge.5 .and. numdec.le.7) then
             if (ng.eq.2) then
                ng1 = 1
                ng2 = 2
             else
                call getjm1 (n1, ng1, ng,
     +                      'Select group 1')
                call getjm1 (n1, ng2, ng,
     +                      'Select group 2')
                do while (ng1.eq.ng2)
                   call putadv ('Group 2 cannot equal group 1')
                   call getjm1 (n1, ng2, ng,
     +                          'Try again to select group 2')
                enddo
             endif
         endif
c
c The main options .....................................................
c
         if (numdec.eq.1) then
c
c numdec = 1: new data...matrix a will not be changed from now on
c **********
c
            if (supply) then
               newdat = .true.
c
c store isx then deallocate workspace
c
               do i = 1, min(nisx,nvmax)
                  isxsav(i) = isx(i)
               enddo
               deallocate(isx, stat = ierr)   
               deallocate(iwk, stat = ierr)
               deallocate(nig, stat = ierr)
               deallocate(c, stat = ierr) 
               deallocate(d, stat = ierr)   
               deallocate(det, stat = ierr)  
               deallocate(eigval, stat = ierr)  
               deallocate(gc, stat = ierr)  
               deallocate(gmean, stat = ierr)
               deallocate(tb, stat = ierr)   
               deallocate(tbtwi, stat = ierr)  
               deallocate(tt, stat = ierr)
               deallocate(tw, stat = ierr)
               deallocate(twi, stat = ierr)
               deallocate(w1, stat = ierr)
               deallocate(x1, stat = ierr)
               deallocate(x2, stat = ierr) 
               deallocate(y1, stat = ierr)
               deallocate(y2, stat = ierr)
               return
            endif
            ready = .false.
            ok = .false.
            nwmax = nrmax*(ncmax + 1)
            call manovd (idtype, ing, m, n, ng, nig, ncmax, nin, nrmax,
     +                   nxmin, nwmax,
     +                   a, wk,
     +                   fname, title,
     +                   abort, supply)
            ncol = m
            nrow = n
            if (.not.abort .and. ncol.gt.n1 .and. nrow.gt.ncol) then
               abort = .false.
            else
               abort = .true.
            endif
            if (.not.abort .and. ncol.lt.n2) then
               abort = .true.
               call putfat ('Must have at least 2 columns')
            endif
            if (.not.abort .and. nrow.lt.n2) then
               abort = .true.
               call putfat ('Must have at least 2 rows')
            endif
            if (ng.gt.ngmax) then
               abort = .true.
               call putfat ('Dimension exceeded: ng > ngmax')
            endif
            if (abort) then
               nvar = n0
               ready = .false.
               word80 = 'No data'
               numdec = n1
            else
               ready = .true.
               nvar = ncol 
               call eofint (isx, m,
     +                      fname,
     +                      abort, allpos)    
               do i = n1, ncol
                  if (isx(i).eq.0) nvar = nvar - n1
               enddo
               if (nvar.lt.n2) then
                  isx(1) = n1
                  isx(2) = n1
                  nvar = n2
                  call putadv ('Variables 1 and 2 have been restored')
               endif
              
               
               word80 = chop80(title)
               if (ng1.gt.ng) ng1 = n1
               if (ng2.gt.ng) ng2 = ng
            endif
         elseif (numdec.eq.2) then
c
c numdec = 2: display means
c **********
c
            call dsplay (nvmax, nvar, nout, ldg, ng + 1, ntype,
     +                   gmean,
     +                   header,
     +                   fileit)
         elseif (numdec.eq.3) then
c
c numdec = 3: test all means
c **********
c
            eigfcn(1) = one      !Wilks lambda
            eigfcn(2) = eigval(1)!Roys largest root
            eigfcn(3) = zero     !Lawley-Hotelling trace
            eigfcn(4) = zero     !Pillai trace
            do i = 1, nvar
               factor = one + eigval(i)
               eigfcn(1) = eigfcn(1)/factor
               if (eigval(i).gt.eigfcn(2)) eigfcn(2) = eigval(i)
               eigfcn(3) = eigfcn(3) + eigval(i)
               eigfcn(4) = eigfcn(4) + eigval(i)/factor
            enddo
c
c Write the header for the MANOVA table and set ifail = 1 to test for Wilks type
c
            i12(1) = form12(ng)
            i12(2) = form12(nvar)
            i12(3) = form12(n)  
            write (text,300) i12(1), i12(2), i12(3)
            ifail = 1
c
c eigfcn(1) = Wilks lambda
c

            if (nvar.eq.2 .and. n - ng - 1.gt.0) then
               eigdf1(1) = dble(2*(ng - 1))
               eigdf2(1) = dble(2*(n - ng - 1))
               top = (one - sqrt(eigfcn(1)))*eigdf2(1)
               bot = sqrt(eigfcn(1))*eigdf1(1)
               ratio = top/bot
               eigtrn(1) = ratio
               if (eigtrn(1).lt.epsi) eigtrn(1) = epsi
               eigsig(1) = g01edf$('U', eigtrn(1), eigdf1(1), eigdf2(1),
     +                             ifail)
               call putifa (ifail, nout, 'G01EDF/MANOVA')
            elseif (ng.eq.2 .and. 2*ng - nvar - 1.gt.0) then
               eigdf1(1) = dble(nvar)
               eigdf2(i) = dble(2*ng - nvar - 1)
               top = (one - eigfcn(1))*eigdf2(1)
               bot = eigfcn(1)*eigdf1(1)
               ratio = top/bot
               eigtrn(1) = ratio
               if (eigtrn(1).lt.epsi) eigtrn(1) = epsi
               eigsig(1) = g01edf$('U', eigtrn(1), eigdf1(1), eigdf2(1),
     +                             ifail)
               call putifa (ifail, nout, 'G01EDF/MANOVA')
            elseif (ng.eq.3 .and. n - nvar - 2.gt.0) then
               eigdf1(1) = dble(2*nvar)
               eigdf2(1) = dble(2*(n - nvar - 2))
               top = (one - sqrt(eigfcn(1)))*dble(3*ng - nvar - 2)
               bot = sqrt(eigfcn(1))*dble(nvar)
               ratio = top/bot
               eigtrn(1) = ratio
               if (eigtrn(1).lt.epsi) eigtrn(1) = epsi
               eigsig(1) = g01edf$('U', eigtrn(1), eigdf1(1), eigdf2(1),
     +                             ifail)
               call putifa (ifail, nout, 'G01EDF/MANOVA')
            endif
            if (ifail.eq.0) then
               call plevel (eigsig(1), eigsym(1))
               if (e_numbers) then
                  write (text(8),310) eigfcn(1), eigtrn(1),
     +                                nint(eigdf1(1)), nint(eigdf2(1)),
     +                                eigsig(1), eigsym(1)
               else
                  d13(1) = showrj(eigfcn(1))
                  d13(2) = showrj(eigtrn(1))
                  write (text(8),311) d13(1), d13(2),
     +                                nint(eigdf1(1)), nint(eigdf2(1)),
     +                                eigsig(1), eigsym(1)
               endif  
            else
               factor = - dble(2*n - 2 - nvar - ng)/two
               if (eigfcn(1).lt.epsi) eigfcn(1) = epsi
               eigtrn(1) = factor*log(eigfcn(1))
               if (eigtrn(1).lt.epsi) eigtrn(1) = epsi
               eigdf1(1) = dble(nvar*(ng - 1))
               ifail = 1
               eigsig(1) = g01ecf$('U', eigtrn(1), eigdf1(1), ifail)
               call putifa (ifail, nout, 'G01ECF/MANOVA')
               call plevel (eigsig(1), eigsym(1))
               if (e_numbers) then
                  write (text(8),320) eigfcn(1), eigtrn(1),
     +                                nint(eigdf1(1)), eigsig(1),
     +                                eigsym(1)
               else
                  d13(1) = showrj(eigfcn(1))
                  d13(2) = showrj(eigtrn(1))
                  write (text(8),321) d13(1), d13(2),
     +                                nint(eigdf1(1)), eigsig(1),
     +                                eigsym(1)

               endif  
            endif
c
c eigfcn(2) = Roys largest root
c
            if (e_numbers) then 
               write (text(9),330) eigfcn(2)
            else
               d13(1) = showrj(eigfcn(2))
               write (text(9),331) d13(1)
            endif   
c
c eigfcn(3) = Lawley Hotelling trace i.e. generalised T_0^2
c
            dnu1 = dble(ng - 1)
            dnu2 = dble(n - ng)
            dm = dble(nvar)
            top = dm*dnu1*(dnu2 - dm)
            bot = dnu1 + dnu2 - dm*dnu1 - one
            ratio = top/bot
            dnu = ratio
            if (dnu.gt.zero)then
                beta = dm*dnu1/(dnu2 - dm + one)
                eigtrn(3) = eigfcn(3)/beta
                if (eigtrn(3).lt.epsi) eigtrn(3) = epsi
                eigdf1(3) = dnu
                eigdf2(3) = dnu2 - dm + one
                ifail = 1
                eigsig(3) = g01edf$('U', eigtrn(3), eigdf1(3),
     +                              eigdf2(3), ifail)
                call putifa (ifail, nout, 'G01EDF/MANOVA')
                call plevel (eigsig(3), eigsym(3))
                if (e_numbers) then
                   write (text(10),350) eigfcn(3), eigtrn(3),
     +                                  nint(eigdf1(3)),
     +                                  nint(eigdf2(3)),
     +                                  eigsig(3), eigsym(3)
               else
                  d13(1) = showrj(eigfcn(3))
                  d13(2) = showrj(eigtrn(3))
                  write (text(10),351) d13(1), d13(2),
     +                                  nint(eigdf1(3)),
     +                                  nint(eigdf2(3)),
     +                                  eigsig(3), eigsym(3) 

               endif  
            else
               top = (dnu2 - one)*(dnu1 + dnu2 - dm - one)
               bot = (dnu2 - dm)*(dnu2 - dm - one)*(dnu2 - dm - three)
               alpha = top/bot
               top = dm*dnu1
               bot = alpha*(dnu2 - dm - one)
               eigdf1(3) = top/bot
               if (eigtrn(3).lt.epsi) eigtrn(3) = epsi
               eigsig(3) = g01ecf$('U', eigtrn(3), eigdf1(3), ifail)
               call putifa (ifail, nout, 'G01ECF/MANOVA')
               call plevel (eigsig(3), eigsym(3))
               if (e_numbers) then
                  write (text(10),360) eigfcn(3), eigtrn(3),
     +                                 nint(eigdf1(3)), eigsig(3), 
     +                                 eigsym(3)
                  else
                     d13(1) = showrj(eigfcn(3))
                     d13(2) = showrj(eigtrn(3))
                     write (text(10),361) d13(1), d13(2),
     +                                 nint(eigdf1(3)), eigsig(3), 
     +                                 eigsym(3)
                  endif  
            endif
c
c eifcn(4) = Pillai trace
c
            if (e_numbers) then
               write (text(11),370) eigfcn(4)
            else
               d13(1) = showrj(eigfcn(4))
               write (text(11),371) d13(1)
            endif  
            write (nout,'(a)') blank
            j = 15
            call table1 (j, 'OPEN')
            do i = 1, 11
               if (i.eq.1) then
                  j = 4
               elseif (i.eq.7) then
                  j = 1
               else
                 j = 0
               endif
               call table1 (j, text(i))
               write (nout,'(a)') text(i)
            enddo
            call table1 (j, 'CLOSE')
         elseif (numdec.eq.4) then
c
c numdec = 4: test for all CV equality
c **********
c
            call plevel (sig, symbol)
            if (e_numbers) then
               write (text,400) ng, n, nvar, stat, nint(df), sig, symbol
            else
               i12(1) = form12(ng)
               i12(2) = form12(n)
               i12(3) = form12(nvar)
               d13(1) = showlj(stat)
               i12(4) = form12(nint(df))
               write (text,450) i12(1), i12(2), i12(3), d13(1),
     +                          i12(4), sig, symbol 
            endif  
            write (nout,'(a)') blank
            j = 15
            call table1 (j, 'OPEN')
            do i = 1, 8
               if (i.eq.1) then
                  j = 4
               else
                  j = 0
               endif
               call table1 (j, text(i))
               write (nout,'(a)') text(i)
            enddo
            call table1 (j,'CLOSE')
         elseif (numdec.eq.5) then
c
c numdec = 5: test means pairwise
c **********
c
            if (ng.gt.2) then
               do i = 1, nvar
                  w1(i) = gmean(ng1,i) - gmean(ng2,i)
               enddo
               call xtrnax (isend, nout, nvmax, nvar,
     +                      twi, tsqd, w1,
     +                      abort)
               if (abort) then
                  call putfat (failed)
               else
                  factor = dble((n - ng)*nig(ng1)*nig(ng2))/
     +                     dble(nig(ng1) + nig(ng2))
                  tsqd = factor*tsqd
                  tsqdof(1) = dble(nvar)
                  tsqdof(2) = dble(n - ng - nvar + 1)
                  factor = tsqdof(2)*tsqd/(tsqdof(1)*dble(n - ng))
                  if (factor.lt.epsi) factor = epsi
                  ifail = 1
                  tsqsig = g01edf$('U', factor, tsqdof(1), tsqdof(2),
     +                             ifail)
                  call putifa (ifail, nout, 'G01EDF/MANOVA')
                  if (ifail.eq.0) then
                     call plevel (tsqsig, 
     +                            symbol)
                     if (e_numbers) then
                        write (text,500) ng1, nig(ng1), ng2, nig(ng2),
     +                                   n, nvar, tsqd, factor,
     +                                   nint(tsqdof(1)), 
     +                                   nint(tsqdof(2)),
     +                                   tsqsig, symbol
                     else
                        i12(1) = form12(ng1)
                        i12(2) = form12(ng2)
                        i12(3) = form12(n)
                        i12(4) = form12(nvar)
                        d13(1) = showlj(tsqd)
                        d13(2) = showlj(factor)
                        i12(5) = form12(nint(tsqdof(1)))
                        i12(6) = form12(nint(tsqdof(2)))
                        write (text,550) i12(1), nig(ng1),
     +                                   i12(2), nig(ng2),
     +                                   i12(3), i12(4),
     +                                   d13(1), d13(2),
     +                                   i12(5), i12(6), 
     +                                   tsqsig, symbol 
                     endif  
                     write (nout,'(a)') blank
                     j = 15
                     call table1 (j, 'OPEN')
                     do i = 1, 11
                       if (i.eq.1) then
                           j = 4
                        else
                           j = 0
                        endif
                        call table1 (j, text(i))
                        write (nout,'(a)') text(i)
                     enddo
                     call table1 (j, 'CLOSE')
                  endif
               endif
            endif
            ldx = nrmax
            jsend = 2
            call manovy (jsend, ldg, n, ng, ng1, ng2, nig, nout,
     +                   nvar, nvmax,
     +                   c, d, det, df1, gc, gmean, sig1, stat1, w1,
     +                   wk,
     +                   abort)
             if (abort) then
                call putfat (failed)
             else
                  call plevel (sig1(1), symbol)
                  j = nig(ng1) + nig(ng2)
                  if (e_numbers) then
                     write (text,500) ng1, nig(ng1), ng2, nig(ng2), j,
     +                                nvar, stat1(1), stat1(2),
     +                                nint(df1(1)), nint(df1(2)),
     +                                sig1(1), symbol
                  else
                     i12(1) = form12(ng1)
                     i12(2) = form12(ng2)
                     i12(3) = form12(j)
                     i12(4) = form12(nvar)
                     d13(1) = showlj(stat1(1))
                     d13(2) = showlj(stat1(2))
                     i12(5) = form12(nint(df1(1)))
                     i12(6) = form12(nint(df1(2)))
                     write (text,550) i12(1), nig(ng1),
     +                                i12(2), nig(ng2),
     +                                i12(3), i12(4),
     +                                d13(1), d13(2),
     +                                i12(5), i12(6), 
     +                                sig1(1), symbol  
                  endif  
                  write (nout,'(a)') blank
                  j = 15
                  call table1 (j, 'OPEN')
                  do i = 1, 11
                     if (i.eq.1) then
                        j = 4
                     else
                        j = 0
                     endif
                     call table1 (j, text(i))
                     write (nout,'(a)') text(i)
                  enddo
                  call table1 (j, 'CLOSE')
               endif
         elseif (numdec.eq.6) then
c
c numdec = 6: test for pairwise profiles
c **********
c
            if (nvar.lt.3) then
               call putfat ('Insufficient data ... Must have m >= 3')
            else
               ldx = nrmax
               jsend = 3
               call manovy (jsend, ldg, n, ng, ng1, ng2, nig, nout,
     +                      nvar, nvmax,
     +                      c, d, det, df1, gc, gmean, sig1, stat1, w1,
     +                      wk,
     +                      abort)
               if (abort) then
                  call putfat (failed)
               else
                  call plevel (sig1(1), symbol)
                  j = nig(ng1) + nig(ng2)
                  if (e_numbers) then
                     write (text,600) ng1, nig(ng1), ng2, nig(ng2), j,
     +                                nvar, stat1(1), stat1(2),
     +                                nint(df1(1)), nint(df1(2)),
     +                                sig1(1), symbol
                  else
                     i12(1) = form12(ng1)
                     i12(2) = form12(ng2)
                     i12(3) = form12(j)
                     i12(4) = form12(nvar)
                     d13(1) = showlj(stat1(1))
                     d13(2) = showlj(stat1(2))
                     i12(5) = form12(nint(df1(1)))
                     i12(6) = form12(nint(df1(2)))
                     write (text,650) i12(1), nig(ng1), i12(2),
     +                                nig(ng2), i12(3), i12(4),
     +                                d13(1), d13(2),
     +                                i12(5), i12(6),
     +                                sig1(1), symbol 
                  endif  
                  write (nout,'(a)') blank
                  j = 15
                  call table1 (j, 'OPEN')
                  do i = 1, 11
                     if (i.eq.1) then
                        j = 4
                     else
                        j = 0
                     endif
                     call table1 (j, text(i))
                     write (nout,'(a)') text(i)
                  enddo
                  call table1 (j, 'CLOSE')
               endif
               np1 = nvar
               np2 = np1
               do i = 1, np1
                  x1(i) = dble(i)
                  x2(i) = x1(i)
                  y1(i) = gmean(ng1,i)
                  y2(i) = gmean(ng2,i)
               enddo
               write (ptitle,700) ng1, ng2
               call gks004 (l1, l2, l3, l4, m1, m2, m3, m4,
     +                      np1, np2, np3, np4,
     +                      x1, x2, x3, x4, y1, y2, y3, y4,
     +                      ptitle, xtitle, ytitle,
     +                      axes, gsave)
            endif
         elseif (numdec.eq.7) then
c
c numdec = 7: test for pairwise CV equality
c **********
c
            ldx = nrmax
            jsend = 1
            call manovy (jsend, ldg, n, ng, ng1, ng2, nig, nout,
     +                   nvar, nvmax,
     +                   c, d, det, df1, gc, gmean, sig1, stat1, w1,
     +                   wk,
     +                   abort)
            if (abort) then
               call putfat (failed)
            else
               call plevel (sig1(1), symbol)
               j = nig(ng1) + nig(ng2)
               if (e_numbers) then
                  write (text,800) ng1, nig(ng1), ng2, nig(ng2), j,
     +                             nvar, stat1(1), nint(df1(1)),
     +                             sig1(1), symbol
               else
                  i12(1) = form12(ng1)
                  i12(2) = form12(ng2)
                  i12(3) = form12(j)
                  i12(4) = form12(nvar)
                  d13(1) = showlj(stat1(1)) 
                  i12(5) = form12(nint(df1(1)))
                  write (text,850) i12(1), nig(ng1), i12(2), nig(ng2), 
     +                             i12(3), i12(4), d13(1), i12(5),
     +                             sig1(1), symbol 
               endif  
               write (nout,'(a)') blank
               j = 15
               call table1 (j, 'OPEN')
               do i = 1, 9
                  if (i.eq.1) then
                     j = 4
                  else
                     j = 0
                  endif
                  call table1 (j, text(i))
                  write (nout,'(a)') text(i)
               enddo
               call table1 (j,'CLOSE')
            endif
         elseif (numdec.eq.8) then
c
c numdec = 8: display details
c **********
c
            write (text,900)
            again = .true.
            do while (again)
               numdec = nopt
               call lbox02 (icolor, ix, iy, numdec, nopt, numpos,
     +                      text)
               if (numdec.eq.1) then
                  call dsplay (nvmax, nvar, nout, nvmax, nvar, ntype,
     +                         tb, 
     +                         text(1),
     +                         itfile(1))
                  itfile(1) = .false.
               elseif (numdec.eq.2) then
                  call dsplay (nvmax, nvar, nout, nvmax, nvar, ntype,
     +                         tw, 
     +                         text(2),
     +                         itfile(2))
                  itfile(2) = .false.     
               elseif (numdec.eq.3) then
                  call dsplay (nvmax, nvar, nout, nvmax, nvar, ntype,
     +                         tt, 
     +                         text(3),
     +                         itfile(3))
                  itfile(3) = .false.     
               elseif (numdec.eq.4) then
                  call dsplay (nvmax, nvar, nout, nvmax, nvar, ntype,
     +                         twi, 
     +                         text(4),
     +                         itfile(4))
                  itfile(4) = .false.     
               elseif (numdec.eq.5) then
                  call dsplay (nvmax, nvar, nout, nvmax1, nvar, ntype,
     +                         tbtwi,
     +                         text(5),
     +                         itfile(5))
                  itfile(5) = .false.     
               elseif (numdec.eq.6) then
                  write (line,1000)
                  if (eigvals) then
                     write (nout,'(a)') blank
                     write (nout,'(a)') 'Eigenvalues'
                     write (nout,'(a)') line
                  endif    
                  j = 15
                  call table1 (j, 'OPEN')
                  j = 4
                  call table1 (j, line)
                  j = 0
                  do i = 1, nvar
                     if (e_numbers) then
                        write (line,1100) eigval(i), eigval(nvmax + i)
                        if (eigvals) write (nout,1100) eigval(i),
     +                                                 eigval(nvmax + i)
                     else
                        d13(1) = showrj(eigval(i))
                        d13(2) = showrj(eigval(nvmax + i))
                        write (line,1150) d13(1), d13(2)
                        if (eigvals) write (nout,1150) d13(1), d13(2)
                     endif  
                     call table1 (j, line)
                  enddo
                  call table1 (j, 'CLOSE')
                  eigvals = .false.
               else
                  again = .false.
               endif
            enddo
         elseif (numdec.eq.9) then
c
c numdec = 9: select to suppress/restore variables
c **********
c
            call isxedi (isx, ncol, nvar, nxmin)
            ok = .false.
         elseif (numdec.eq.numopt - n2) then
c
c numdec = numopt - 2: review progress
c *******************
c
            call revpro (nout)   
         elseif (numdec.eq.numopt - n1) then
c
c numdec = numopt - 1: help
c *******************
c
             write (text,3000)
             ntext = 20
             numbld(1) = 1
             numbld(15) = 1
             next = .true.
             call tutor1 (icolor, numbld, ntext, 
     +                    text, 
     +                    frame, next, updown)
             numbld(1) = 0
             numbld(15) = 0
             write (text,3100)
             ntext = 20
             next = .true.
             numbld(1) = 1
             numbld(18) = 1
             numbld(20) = 1
             call tutor1 (icolor, numbld, ntext,
     +                    text, 
     +                    frame, next, updown)
             numbld(1) = 0
             numbld(18) = 0
             numbld(20) = 0
             next = .false.
             write (text,3200)
             ntext = 22
             numbld(1) = 1
             numbld(7) = 1
             numbld(11) = 1
             numbld(16) = 1
             numbld(20) = 1
             call tutor1 (icolor, numbld, ntext, 
     +                    text, 
     +                    frame, next, updown)
             numbld(1) = 0
             numbld(7) = 0
             numbld(11) = 0
             numbld(16) = 0
             numbld(20) = 0
             numdec = 2
         
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c ***************
c
            newdat = .false.
            repeet = .false.
         endif
      enddo
c
c store isx then deallocate workspace
c
      do i = 1, min(nisx,nvmax)
         isxsav(i) = isx(i)
      enddo
      deallocate(isx, stat = ierr)
      deallocate(iwk, stat = ierr)
      deallocate(nig, stat = ierr)  
      deallocate(c, stat = ierr) 
      deallocate(d, stat = ierr)  
      deallocate(det, stat = ierr)
      deallocate(eigval, stat = ierr)  
      deallocate(gc, stat = ierr)
      deallocate(gmean, stat = ierr) 
      deallocate(tb, stat = ierr)  
      deallocate(tbtwi, stat = ierr)  
      deallocate(tt, stat = ierr)
      deallocate(tw, stat = ierr)
      deallocate(twi, stat = ierr)
      deallocate(w1, stat = ierr)
      deallocate(x1, stat = ierr)
      deallocate(x2, stat = ierr)
      deallocate(y1, stat = ierr)
      deallocate(y2, stat = ierr)
c
c format statements
c
  100 format (  
     + ' Multivariate Analysis of Variance (MANOVA)'
     +/
     +/' Title for current MANOVA data:'
     +/1x,A
     +/' Variables included:'
     +/1x,A
     +/' Number of groups =',1x,a
     +/' Number of cases =',1x,a
     +/
     +/'Data: New/Edit/Tranform/View'
     +/'All groups: display/file means'
     +/'All groups: test equality of means'
     +/'All groups: test equality of CV'
     +/'Two groups: test equality of means'
     +/'Two groups: test equality of profiles'
     +/'Two groups: test equality of CV'
     +/'B/W/T/W^{-1}/BW^{-1}/eigenvalues'
     +/'Suppress/Restore variables'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit MANOVA options')
  200 format (
     +/' MANOVA analysis number',i3
     +/' -------------------------'
     +/
     +/' File:'
     +/1x,A
     +/' Title:'
     +/1x,A)
  300 format (
     + 'MANOVA H0: all mean vectors are equal'
     +/
     +/'Number of groups       =',1x,a
     +/'Number of variables    =',1x,a
     +/'Number of observations =',1x,a
     +/
     +/'Statistic                   Value    Transform  deg.free.   p')
  310 format (
     + 'Wilks lambda      ',1p,2(1x,e13.5),i5,i5,0p,f8.4,2x,a)
  311 format (
     + 'Wilks lambda      ',2(1x,a13),i5,i5,f8.4,2x,a)   
  320 format (
     + 'Wilks lambda      ',1p,2(1x,e13.5),i10,0p,f8.4,2x,a)
  321 format (
     + 'Wilks lambda      ',1p,2(1x,a13),i10,f8.4,2x,a)   
  330 format (
     + 'Roys largest root ',1p,1x,e13.5)
  331 format (
     + 'Roys largest root ',1x,a)   
  350 format (
     + 'Lawley-Hotelling T',1p,2(1x,e13.5),i5,i5,0p,f8.4,2x,a)
  351 format (
     + 'Lawley-Hotelling T',2(1x,a13),i5,i5,f8.4,2x,a)   
  360 format (
     + 'Lawley-Hotelling T',1p,2(1x,e13.5),i10,0p,f8.4,2x,a)
  361 format (
     + 'Lawley-Hotelling T',2(1x,a13),i10,f8.4,2x,a)   
  370 format (
     + 'Pillais trace     ',1p,1x,e13.5)
  371 format (
     + 'Pillais trace     ',1x,a13)   
  400 format (
     + 'MANOVA H0: all covariance matrices are equal'
     +/
     +/'Number of groups       =',i8
     +/'Number of observations =',i8
     +/'Number of variables    =',i8
     +/'Test statistic C       =',1p,1x,e13.5
     +/'Number of Deg. freedom =',i8
     +/'p = P(chi-sq. >= C)    =',0p,f8.4,1x,a)
  450 format (
     + 'MANOVA H0: all covariance matrices are equal'
     +/
     +/'Number of groups       =',1x,a
     +/'Number of observations =',1x,a
     +/'Number of variables    =',1x,a
     +/'Test statistic C       =',1p,1x,a
     +/'Number of Deg. freedom =',1x,a
     +/'p = P(chi-sq. >= C)    =',f7.4,1x,a)   
  500 format (
     + 'MANOVA H0: selected group means are equal'
     +/
     +/'First group            =',i8,' (',i4,' cases)'
     +/'Second group           =',i8,' (',i4,' cases)'
     +/'Number of observations =',i8,' (to estimate CV)'
     +/'Number of variables    =',i8
     +/'Hotelling T^2          =',1p,1x,e13.5
     +/'Test statistic S       ='   ,1x,e13.5
     +/'Numerator DOF          =',i8
     +/'Denominator DOF        =',i8
     +/'p = P(F >= S)          =',0p,f8.4,1x,a)
  550 format (
     + 'MANOVA H0: selected group means are equal'
     +/
     +/'First group            =',1x,a,' (',i4,' cases)'
     +/'Second group           =',1x,a,' (',i4,' cases)'
     +/'Number of observations =',1x,a,' (to estimate CV)'
     +/'Number of variables    =',1x,a
     +/'Hotelling T^2          =',1x,a
     +/'Test statistic S       =',1x,a
     +/'Numerator DOF          =',1x,a
     +/'Denominator DOF        =',1x,a
     +/'p = P(F >= S)          =',f7.4,1x,a)   
  600 format (
     + 'MANOVA H0: selected group profiles are equal'
     +/
     +/'First group            =',i8,' (',i4,' cases)'
     +/'Second group           =',i8,' (',i4,' cases)'
     +/'Number of observations =',i8,' (to estimate CV)'
     +/'Number of variables    =',i8
     +/'Hotelling T^2          =',1p,1x,e13.5
     +/'Test statistic S       ='   ,1x,e13.5
     +/'Numerator DOF          =',i8
     +/'Denominator DOF        =',i8
     +/'p = P(F >= S)          =',0p,f8.4,1x,a)
  650 format (
     + 'MANOVA H0: selected group profiles are equal'
     +/
     +/'First group            =',1x,a,' (',i4,' cases)'
     +/'Second group           =',1x,a,' (',i4,' cases)'
     +/'Number of observations =',1x,a,' (to estimate CV)'
     +/'Number of variables    =',1x,a
     +/'Hotelling T^2          =',1x,a
     +/'Test statistic S       =',1x,a
     +/'Numerator DOF          =',1x,a
     +/'Denominator DOF        =',1x,a
     +/'p = P(F >= S)          =',f7.4,1x,a)   
  700 format ('Groups:',i4,' (circles),',i4,' (triangles)')
  800 format (
     + 'MANOVA H0: selected group covariance matrices are equal'
     +/
     +/'First group            =',i8,' (',i4,' cases)'
     +/'Second group           =',i8,' (',i4,' cases)'
     +/'Number of observations =',i8,' (to estimate CV)'
     +/'Number of variables    =',i8
     +/'Test statistic C       =',1p,1x,e13.5
     +/'No. Deg. freedom       =',i8
     +/'p = P(chi-sq. >= C)    =',0p,f8.4,2x,a)
  850 format (
     + 'MANOVA H0: selected group covariance matrices are equal'
     +/
     +/'First group            =',1x,a,' (',i4,' cases)'
     +/'Second group           =',1x,a,' (',i4,' cases)'
     +/'Number of observations =',1x,a,' (to estimate CV)'
     +/'Number of variables    =',1x,a
     +/'Test statistic C       =',1x,a
     +/'No. Deg. freedom       =',1x,a
     +/'p = P(chi-sq. >= C)    =',f7.4,2x,a)    
  900 format (
     + 'B ssp matrix'
     +/'W ssp matrix'
     +/'T ssp matrix'
     +/'W^{-1} matrix'
     +/'BW^{-1} matrix'
     +/'BW^{-1} eigenvalues'
     +/'Quit ... Exit these matrix options')
 1000 format ('     Real part    Imaginary part')
 1100 format (1p,1x,e13.5,4x,1x,e13.5)
 1150 format (1x,a13,4x,1x,a)
 3000 format (
     + 'Overview of multivariate analysis of variance (MANOVA)'
     +/
     +/'It is supposed that m variables have been measured for g groups'
     +/'with n_i cases per group, where m > 1, g > 1, n_i >= m, and the'
     +/'data have been formatted as a data file with n rows and m + 1'
     +/'columns, e.g. using Makmat. Note: n = n_1+n_2+...+n_g, column 1'
     +/'must have groups in nondecreasing order, and variables 1 to m'
     +/'must be in columns 2 to m + 1. Test files manova1.tf? show how'
     +/'to format MANOVA data correctly. If possible, all groups should'
     +/'have the same numbers of cases per group.'
     +/'You select variables (columns) to include/exclude then various'
     +/'options are possible to explore the data assuming multivariate'
     +/'normality. Note: most of these only work well when n_i >> m.'
     +/
     +/'All groups: display/file means'
     +/'This option outputs the group means as a matrix with g + 1 rows'
     +/'and m columns, where rows 1 to g are group mean vectors and'
     +/'row g + 1 is the overall mean vector. Standard deviations are'
     +/'not given, as a mulivariate normal distribution is assumed and'
     +/'special techniques are required to test equality of means.')
 3100 format (
     + 'All groups: test equality of means'
     +/'There is no unique best-way to test equality of mean vectors'
     +/'across groups in MANOVA. First the sums of squares and products'
     +/'matrices, B, W and T = B + W are calculated, where'
     +/'B = ssp between groups'
     +/'W = ssp within groups'
     +/'T = ssp total'
     +/
     +/'Then the eigenvalues t_i of B*W^{-1} are calculated and used to'
     +/'form four test statistics:'
     +/'1) Wilks lambda = product of all 1/(1 + t_i)'
     +/'2) Roys largest root = maxmimum t_i'
     +/'3) Lawley-Hotelling trace = sum of all t_i'
     +/'4) Pillai trace = sum of all t_i/(1 + t_i).'
     +/'From these, transforms are calculated which have approximate'
     +/'standard distributions for large sample sizes, so significance'
     +/'levels can be calculated for'
     +/'H0: all mean vectors are equal'
     +/'against the alternative hypothesis'
     +/'H1: at least one mean vector is not equal to the rest.')
 3200 format (
     + 'All groups: test equality of covariance matrices'
     +/'This test forms a likelihood-ratio test statistic from the'
     +/'determinants of the group covariance matrices and the pooled'
     +/'covariance matrix. However, like tests for variance equality,'
     +/'it is very weak and should only be used for large samples.'
     +/
     +/'Two groups: test equality of means'
     +/'You select two groups and a two-sample Hotelling T squared'
     +/'test is done to test for equality of mean vectors.'
     +/
     +/'Two groups: test equality of profiles'
     +/'You select two groups then a vector of pairwise differences'
     +/'of means is calculated and used to test for similar profiles.'
     +/'This is valuable in some repeated measures experiments.'
     +/
     +/'Two groups: test equality of covariance matrices'
     +/'You select two groups then a likelihood-ratio test statistic is'
     +/'calculated to test for equality of covariance matrices.'
     +/
     +/'Suppressing and restoring variables'
     +/'These options allow you to temorarily alter the active columns'
     +/'in the data matrix.')
      end
c
c
