C
C
      SUBROUTINE MANOVD (IDTYPE, ING, M, N, NG, NIG, NCMAX, NIN, NRMAX,
     +                   NXMIN, NYMAX,
     +                   A, Y,
     +                   FNAME, TITLE,
     +                   ABORT, SUPPLY)
C
C ACTION: read in data for MANOVA
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 23/10/2003
C         23/10/2003 derived from ANOVAF
C         17/04/2004 revised and added NXMIN and NYMAX to argument list
C         13/07/2004 revised and corrected formats
C         07/03/2006 added supply to argument list 
C         05/11/2006 edited and added INTENTS
C         09/02/2016 made NYMAX KIND = 7 
C
C         IDTYPE: (input/unchanged)
C                 IDTYPE = 1: 2-way ANOVA/repeated measures data type in Y
C                 IDTYPE = 2: manova data type in A
C            ING: (output) group to which observation belongs
C              M: (input/output) no variables (depending on supply)
C                  If SUPPLY = .TRUE. then M must be full column width on entry
C                  On exit M = number of columns, i.e. variables
C              N: (input/output) no. data points (depending on supply)
C                  If SUPPLY = .TRUE. N must be full row dimension on entry
C                  On exit N = number of rows, i.e. cases
C             NG: (output) no. groups
C            NIG: (output) no. observations per group
C          NCMAX: (input/unchanged) max. col. dimension
C            NIN: (input/unchanged) unconnected data input unit
C          NRMAX: (input/unchanged) max. row dimension
C          NXMIN: (input/unchanged) min. no. variables
C          NYMAX: (input/unchanged) max. Y dimension
C              A: (input/output) data matrix
C              Y: (input/output) workspace for subroutine MATTIN then output
C                  as y-vector if IDTYPE = 1
C          FNAME: (input/output) file name
C          TITLE: (input/output) title
C          ABORT: (output) error flag
C         SUPPLY: (input/unchanged) as follows:
C                 SUPPLY = .TRUE. then supply A with EXACTLY N rows and M columns
C                 SUPPLY = .FALSE. read in A
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER (KIND = 7),  INTENT (IN)    :: NYMAX
      INTEGER,             INTENT (IN)    :: NCMAX, NRMAX 
      INTEGER,             INTENT (IN)    :: IDTYPE, NIN, NXMIN
      INTEGER,             INTENT (INOUT) :: M, N
      INTEGER,             INTENT (OUT)   :: NG  
      INTEGER,             INTENT (OUT)   :: ING(NRMAX), NIG(*)
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,NCMAX), Y(NYMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (IN)    :: SUPPLY 
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER    NCOL, NROW
      INTEGER    ITEMP, JTEMP
      INTEGER    I, J, K, L
      INTEGER    JSEND, N0, N1, N2
      PARAMETER (JSEND = 2, N0 = 0, N1 = 1, N2 = 2)
      CHARACTER  DTYPE*40, LINE*100
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      EXTERNAL   MATTIN, PUTFAT, PUTADV, VU2CHK
      INTRINSIC  NINT
C
C Initialise
C
      ABORT = .TRUE. 
      NG = N0
      IF (IDTYPE.EQ.N1) THEN
         DTYPE = 'the test file anova7.tf1'
      ELSEIF (IDTYPE.EQ.N2) THEN
         DTYPE = 'the manova1.tf? test files'
      ELSE
         LINE = 'IDTYPE out of range in call to MANOVD'
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C Read in the data
C
      IF (SUPPLY) THEN         
C
C M is input as the full column width including group indicators in column 1
C      
         IF (M.LT.2 .OR. M.GT.NCMAX .OR.
     +       N.LT.2 .OR. N.GT.NRMAX) RETURN
         NCOL = M
         NROW = N
      ELSE      
C
C Otherwise try to read in a file 
C      
         WRITE (LINE,100) DTYPE
         CALL PUTADV (LINE)
         CLOSE (UNIT = NIN)
         CALL MATTIN (JSEND, NCMAX, NCOL, NIN, NRMAX, NROW,
     +                A, Y,
     +                FNAME, TITLE,
     +                ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) RETURN
      ENDIF
C
C Re-set M and N
C      
      M = N0
      N = N0
C
C Check overall dimensions
C
      I = NCOL - N1
      IF (NROW.LT.I .OR. I.LT.NXMIN) THEN
         ABORT = .TRUE.
         WRITE (LINE,200) NXMIN
         CALL PUTFAT (LINE)
         CALL VU2CHK (FNAME)
         RETURN
      ENDIF
C
C Check A(1,1)
C
      ITEMP = NINT(A(N1,N1))
      IF (ITEMP.NE.N1) THEN
         ABORT = .TRUE.
         WRITE (LINE,300)
         CALL PUTFAT (LINE)
         CALL VU2CHK (FNAME)
         RETURN
      ENDIF
C
C Assign N and check column 1
C
      N = NROW
      NG = N1
      NIG(1) = N1
      ING(1) = N1
      DO I = N2, N
         JTEMP = NINT(A(I,N1))
         IF (JTEMP.LT.ITEMP) THEN
            ABORT = .TRUE.
            WRITE (LINE,400) I
            CALL PUTFAT (LINE)
            CALL VU2CHK (FNAME)
            RETURN
         ELSEIF (JTEMP.EQ.ITEMP) THEN
            NIG(NG) = NIG(NG) + N1
         ELSEIF (JTEMP.EQ.ITEMP + N1) THEN
            NG = NG + N1
            NIG(NG) = N1
         ELSE
            ABORT = .TRUE.
            WRITE (LINE,500) I
            CALL PUTFAT (LINE)
            CALL VU2CHK (FNAME)
            RETURN
         ENDIF
         ING(I) = NG
         ITEMP = JTEMP
      ENDDO
C
C Assign M then Shuffle the columns
C
      M = NCOL - N1
      DO J = N1, M
         K = J + N1
         DO I = N1, N
            A(I,J) = A(I,K)
         ENDDO
      ENDDO
C
C Special action and checks depending on IDTYPE
C
      IF (IDTYPE.EQ.N1) THEN
C
C Return data in Y
C
         IF (M*N.GT.NYMAX) THEN
            WRITE (LINE,600) NYMAX, M*N
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
         L = N0
         NROW = N1
         DO K = N1, NG
            DO J = N1, M
               NROW = NROW + (K - N1)*NIG(K)
               DO I = NROW, NROW + NIG(K) - N1
                  L = L + N1
                  Y(L) = A(I,J)
               ENDDO
            ENDDO
         ENDDO
         IF (L.NE.M*N) THEN
            WRITE (LINE,700) L, M*N
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
      ELSEIF (IDTYPE.EQ.N2) THEN
C
C Return data in A without the original column 1
C
         K = N0
         DO I = N1, NG
            IF (NIG(I).LT.M) K = K + N1
         ENDDO
         IF (K.GT.N0) THEN
            WRITE (LINE,800) M, K
            CALL PUTADV (LINE)
         ENDIF
      ENDIF
C
C Success so set ABORT = .FALSE.
C
      ABORT = .FALSE.
C
C Format statements
C      
  100 FORMAT ('Input a data files formatted like',1X,A)
  200 FORMAT ('Deficient data ... Must have rows >= variables >=',I3)
  300 FORMAT ('Must have A(1,1) = 1')
  400 FORMAT ('Decreasing order in column 1 at line',I6)
  500 FORMAT ('Group increasing by more than 1 in column 1 at line',I6)
  600 FORMAT ('Max. no. Y allowed =',I6,', no. required =',I6)
  700 FORMAT ('L =',I6,', M*N =', I6)
  800 FORMAT ('No. of groups with less than',I4,' replicates =',I4)
      END
C
C
