c
c
      subroutine manovg (itype, 
     +                   fname,
     +                   newdat)
c
c action: plot MANOVA groups/labels/symbols/dots
c author: w.g.bardsley, university of manchester, u.k., 22/08/2010
c
c |itype| = 1: both variables and scores 
c |itype| = 2: variables only
c |itype| = 3: scores only
c       fname: MANOVA type file
c      newdat: request new data 
c 
c Note: if itype < 0 then the newdat option is not made available
c     
      implicit none
c
c arguments
c      
      integer,             intent (in)  :: itype
      character (len = *), intent (in)  :: fname
      logical,             intent (out) :: newdat
c
c allocatables
c      
      integer,          allocatable :: ing(:), isx(:), nig(:)
      integer,          allocatable :: jsx(:)
      double precision, allocatable :: v(:,:), x(:,:)  
c
c locals
c      
      integer    i, ierr, ios, j, ng, nout
      integer    ncol, nrmax, nrow, nvar
      integer    numdec, numopt, numsta, numtxt
      integer    numdec_sav
      parameter (numsta = 15)
      integer    numbld(30)
      integer    isend, jsend, nwmax
      parameter (isend = 1, jsend = 1, nwmax = 2000)
      double precision temp
      character (len = 40) labels(nwmax)
      character (len = 80) title, legend
      character (len = 100) text(30)
      logical    abort, dots_only, repeet, there
      logical    add_centroids, do_columns, do_newdat, do_scores
      logical    allpos
      parameter (allpos = .false.)
      external   isitmf, putfat, getnou, lstbox, getwrd, eofint, scores,
     +           infofl
      external   grplot, glplot 
      intrinsic  abs, nint
      data       numbld / 30*0 /
      data       numdec_sav / 1 /
c
c initialise then check
c      
      newdat = .false.
      if (itype.lt.0) then
         do_newdat = .false.
      else
         do_newdat = .true.
      endif      
      if (abs(itype).eq.1) then
         do_columns = .true. 
         do_scores = .true.
      elseif (abs(itype).eq.2) then
         do_columns = .true.
         do_scores = .false.
      elseif (abs(itype).eq.3) then
         do_columns = .false. 
         do_scores = .true.
      else
         call putfat ('ITYPE out of range (1,3) in call to MANOVG')
         return   
      endif 
            
      inquire (file = fname, exist = there)
      if (.not.there) then
         call infofl (isend,
     +                fname)
         return
      endif
      
      call isitmf (ncol, nrow,
     +             fname)
      if (ncol.lt.2 .or. nrow.lt.2) then
         call putfat ('Must have at least 2 rows and 3 columns')
         return        
      endif 
c
c allocate
c      
      ierr = 0
      if (allocated(ing)) deallocate(ing, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(isx)) deallocate(isx, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(jsx)) deallocate(jsx, stat = ierr)
      if (ierr.ne.0) return     
      if (allocated(nig)) deallocate(nig, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(v)) deallocate(v, stat = ierr)
      if (ierr.ne.0) return   
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return   


      nrmax = nrow

      allocate(ing(nrow), stat = ierr) 
      if (ierr.ne.0) return
      allocate(isx(ncol - 1), stat = ierr) 
      if (ierr.ne.0) return  
      allocate(jsx(ncol - 1), stat = ierr) 
      if (ierr.ne.0) return    
      allocate(nig(nrow), stat = ierr) 
      if (ierr.ne.0) return
      allocate(v(nrmax,ncol - 1), stat = ierr) 
      if (ierr.ne.0) return  
      allocate(x(nrmax,ncol - 1), stat = ierr) 
      if (ierr.ne.0) return
c
c read in and check the data
c        
      call getnou (nout)
      open (unit = nout, file = fname, iostat = ios)
      if (ios.ne.0) then
         deallocate(ing, stat = ierr) 
         deallocate(isx, stat = ierr) 
         deallocate(jsx, stat = ierr) 
         deallocate(nig, stat = ierr) 
         deallocate(v, stat = ierr) 
         deallocate(x, stat = ierr) 
         return
      endif   
      read (nout,'(a)',iostat=ios) title  
      if (ios.ne.0) then
         close (unit = nout)
         deallocate(ing, stat = ierr) 
         deallocate(isx, stat = ierr) 
         deallocate(jsx, stat = ierr) 
         deallocate(nig, stat = ierr) 
         deallocate(v, stat = ierr) 
         deallocate(x, stat = ierr) 
         return
      endif
      read (nout,*,iostat=ios) nrow, ncol
      if (ios.ne.0) then
         close (unit = nout)
         deallocate(ing, stat = ierr) 
         deallocate(isx, stat = ierr) 
         deallocate(jsx, stat = ierr) 
         deallocate(nig, stat = ierr) 
         deallocate(v, stat = ierr) 
         deallocate(x, stat = ierr) 
         return
      endif 
c
c decrease ncol as column1 is group number not data
c      
      ncol = ncol - 1

      do i = 1, ncol
         isx(i) = 1
         jsx(i) = 1 
      enddo 
      
      do i = 1, nrow   
         read (nout,*,iostat=ios) temp, (x(i,j), j = 1, ncol)
         if (ios.ne.0) then
            close (unit = nout)
            deallocate(ing, stat = ierr) 
            deallocate(isx, stat = ierr) 
            deallocate(jsx, stat = ierr) 
            deallocate(nig, stat = ierr) 
            deallocate(v, stat = ierr) 
            deallocate(x, stat = ierr) 
            return
         endif 
         ing(i) = nint(temp)
         if (ing(i).lt.1 .or. ing(i).gt.nrow) then
            call putfat (
     +'Must have 1 =< value =< number of rows in column 1')
            close (unit = nout)
            deallocate(ing, stat = ierr) 
            deallocate(isx, stat = ierr) 
            deallocate(jsx, stat = ierr) 
            deallocate(nig, stat = ierr) 
            deallocate(v, stat = ierr) 
            deallocate(x, stat = ierr) 
            return
         endif   
      enddo
      close (unit = nout)
      
      do i = 1, nrow
         nig(i) = 0
      enddo
      ng = 0
      do i = 1, nrow    
         j = ing(i)
         nig(j) = nig(j) + 1
         if (j.gt.ng) ng = j
      enddo
c
c get the labels
c      
      call getnou(nout)  
      if (nrow.le.nwmax) call getwrd (isend, ncol, nout, nrow, nwmax,
     +                                fname, labels)
      close (unit = nout)
c
c get the indicators
c      
      call eofint (isx, ncol,
     +             fname,
     +             abort, allpos)  
c
c get the scores 
c

      if (do_scores) then
         call scores (jsend, isx, ncol, nrmax, nrow, nvar,
     +                v, x,
     +                abort)
         if (abort) then
             call putfat ('Scores cannot be calculated')
             do_scores = .false.
         endif   
      endif
      
      if (.not.do_columns .and. .not.do_scores) then  
         deallocate(ing, stat = ierr) 
         deallocate(isx, stat = ierr) 
         deallocate(jsx, stat = ierr) 
         deallocate(nig, stat = ierr) 
         deallocate(v, stat = ierr) 
         deallocate(x, stat = ierr) 
         return
      endif    
c
c main loop
c     
      numdec = 1
      numdec_sav = numdec
      repeet = .true.
      
      do while (repeet)
         write (text,100)
         
         if (do_newdat) then
            numopt = 14
         else
            numopt = 13
         endif
         numtxt = numsta + numopt - 1
         if (.not.do_newdat) text(numtxt) = text(numtxt + 1)
          
         numdec = numdec_sav 
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numdec_sav = numdec
         numbld(1) = 0
c
c pre-process numdec
c
         if (numdec.le.3) then
            add_centroids = .false.
         elseif (numdec.le.6) then
            add_centroids = .true.
            numdec = numdec - 3
         elseif (numdec.le.9) then   
            add_centroids = .false.
            numdec = numdec - 3
         elseif (numdec.le.12) then
            add_centroids = .true.
            numdec = numdec - 6
         endif
c
c check numdec
c                
         if (numdec.le.3 .and. .not.do_columns) then
            numdec = numdec + 3
            call putfat ('Only scores are permitted')
         elseif (numdec.ge.4 .and. numdec.le.6 .and. 
     +           .not.do_scores) then   
            numdec = numdec - 3
            call putfat ('Only variables are permitted') 
         endif   
c
c define legend
c     
         if (numdec.le.3) then
            legend = 'Variable'
         elseif (numdec.le.6) then
            legend = 'Score'
         else
            repeet = .false.   
         endif
         
         if (numdec.eq.1) then 
            call grplot (ing, isx, ncol, ng, nig, nrmax, nrow, 
     +                   x,
     +                   legend, title,
     +                   add_centroids) 
         elseif (numdec.eq.2) then
            dots_only = .true. 
            call glplot (ing, isx, ncol, ng, nig, nrmax, nrow, 
     +                   x,
     +                   labels, legend, title,
     +                   add_centroids, dots_only) 
         elseif (numdec.eq.3) then
            dots_only = .false. 
            call glplot (ing, isx, ncol, ng, nig, nrmax, nrow, 
     +                   x,
     +                   labels, legend, title,
     +                   add_centroids, dots_only) 
         elseif (numdec.eq.4) then 
            call grplot (ing, jsx, nvar, ng, nig, nrmax, nrow, 
     +                   v,
     +                   legend, title, 
     +                   add_centroids) 
         elseif (numdec.eq.5) then
            dots_only = .true. 
            call glplot (ing, jsx, nvar, ng, nig, nrmax, nrow, 
     +                   v,
     +                   labels, legend, title,
     +                   add_centroids, dots_only) 
         elseif (numdec.eq.6) then
            dots_only = .false. 
            call glplot (ing, jsx, nvar, ng, nig, nrmax, nrow, 
     +                   v,
     +                   labels, legend, title,
     +                   add_centroids, dots_only) 
         elseif (numdec.eq.numopt - 1) then
            newdat = .true.
         else
            newdat = .false.
          endif     
      enddo
c
c deallocate
c      
      deallocate(ing, stat = ierr) 
      deallocate(isx, stat = ierr) 
      deallocate(jsx, stat = ierr) 
      deallocate(nig, stat = ierr) 
      deallocate(v, stat = ierr) 
      deallocate(x, stat = ierr) 
c
c format statement
c      
  100 format (
     + 'Plotting multivariate groups as Symbols and/or Labels'
     +/
     +/'Given a n by m matrix formatted as in manova1.tf1, with the'
     +/'group number in column 1 and the data in columns 2 to m,'
     +/'this procedure allows you to plot selected data columns, i.e.' 
     +/'variables as either symbols, labels, or symbols with labels.' 
     +/ 
     +/'Principal component scores can be calculated and PC-scores'
     +/'plotted instead of data using the correlation matrix with'
     +/'scores standardised to unit variance.'
     +/
     +/'Symbols and colours can be set from the Simfit/Simdem/Simplot'
     +/'configuration control, and centroids and spokes can be added.'
     +/
     +/'Data                   `symbols only'
     +/'Data                   `labels only' 
     +/'Data                   `symbols and labels'
     +/'Data and centroids     `symbols and spokes'
     +/'Data and centroids     `labels and spokes'
     +/'Data and centroids     `symbols and labels and spokes'
     +/'PC-Scores              `symbols only'
     +/'PC-Scores              `labels only'
     +/'PC-Scores              `symbols and labels'
     +/'PC-Scores and centroids`symbols and spokes'
     +/'PC-Scores and centroids`labels and spokes'
     +/'PC-Scores and centroids`symbols and labels and spokes'
     +/'New data               ` '
     +/'Quit                   `Exit these plotting options')
     
      end
c
c            